unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, jpeg, StdCtrls, Buttons, ComCtrls, TabNotBk, Clipboard,
  XPMan, ShellAPI, SkinCaption, WinSkinData, ImgList, ParseDialog, ActiveX,
  ComObj;

type
  TMainForm = class(TForm)
    Image1: TImage;
    btnPrev: TBitBtn;
    btnNext: TBitBtn;
    btnExit: TBitBtn;
    PageControl: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    TabSheet5: TTabSheet;
    TabSheet6: TTabSheet;
    TabSheet7: TTabSheet;
    TabSheet8: TTabSheet;
    TabSheet9: TTabSheet;
    TabSheet10: TTabSheet;
    Powerwords: TListBox;
    Smilies: TListBox;
    Guarantees: TListBox;
    Subheads: TListBox;
    PS: TListBox;
    Closes: TListBox;
    Openings: TListBox;
    Bullets: TListBox;
    Headlines: TListBox;
    Bridges: TListBox;
    btnToMemo: TBitBtn;
    XPManifest1: TXPManifest;
    btnAboutUs: TBitBtn;
    Memo: TMemo;
    btnToClip: TBitBtn;
    btnClearMemo: TBitBtn;
    SkinData1: TSkinData;
    SkinCaption1: TSkinCaption;
    ImageList: TImageList;
    btnSaveToWord: TBitBtn;
    procedure btnExitClick(Sender: TObject);
    procedure btnNextClick(Sender: TObject);
    procedure btnPrevClick(Sender: TObject);
    procedure PageControlChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnToMemoClick(Sender: TObject);
    procedure btnAboutUsClick(Sender: TObject);
    procedure btnToClipClick(Sender: TObject);
    procedure btnClearMemoClick(Sender: TObject);
    procedure btnSaveToWordClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

procedure TMainForm.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.btnNextClick(Sender: TObject);
begin
  PageControl.ActivePageIndex := PageControl.ActivePageIndex+1;
  PageControlChange(Sender);
end;

procedure TMainForm.btnPrevClick(Sender: TObject);
begin
  PageControl.ActivePageIndex := PageControl.ActivePageIndex-1;
  PageControlChange(Sender);
end;

procedure TMainForm.PageControlChange(Sender: TObject);
begin
  btnPrev.Enabled := PageControl.ActivePageIndex > 0;
  btnNext.Enabled := PageControl.ActivePageIndex < PageControl.PageCount-1;
end;

procedure TMainForm.FormCreate(Sender: TObject);
const FMaxItemWidth = 8192;
begin
  SendMessage(Powerwords.Handle, LB_SETHORIZONTALEXTENT, FMaxItemWidth, 0);
  SendMessage(Smilies.Handle, LB_SETHORIZONTALEXTENT, FMaxItemWidth, 0);
  SendMessage(Guarantees.Handle, LB_SETHORIZONTALEXTENT, FMaxItemWidth, 0);
  SendMessage(Subheads.Handle, LB_SETHORIZONTALEXTENT, FMaxItemWidth, 0);
  SendMessage(PS.Handle, LB_SETHORIZONTALEXTENT, FMaxItemWidth, 0);
  SendMessage(Closes.Handle, LB_SETHORIZONTALEXTENT, FMaxItemWidth, 0);
  SendMessage(Openings.Handle, LB_SETHORIZONTALEXTENT, FMaxItemWidth, 0);
  SendMessage(Bullets.Handle, LB_SETHORIZONTALEXTENT, FMaxItemWidth, 0);
  SendMessage(Headlines.Handle, LB_SETHORIZONTALEXTENT, FMaxItemWidth, 0);
  SendMessage(Bridges.Handle, LB_SETHORIZONTALEXTENT, FMaxItemWidth, 0);
end;

procedure TMainForm.btnToMemoClick(Sender: TObject);
var Found: Boolean;

function ParseDialog(S: String): String;
var S1: String;
    I: Integer;
begin
  if Pos('_', S) = 0 then
  begin
    Result := S;
    Exit;
  end;
  with TParseDialogForm.Create(Self) do
  try
    TextEdit.Text := S;
    ShowModal;
    if OK then
    begin
      I := 0;
      while Pos('_', S) > 0 do
      begin
        S1 := Copy(S, 1, Pos('_', S)-1);
        Delete(S, 1, Length(S1));
        while ((S<>'') and (S[1]='_')) do
         Delete(S, 1, 1);
        S := S1 + Memo.Lines[I] + S;
        if I < Memo.Lines.Count-1 then
         Inc(I);
      end;
    end;
  finally
    Free;
  end;
  Result := S;
end;

procedure GoRecursive(Comp: TComponent);
var I: Integer;
    Temp: TComponent;
    S: String;
begin
  for I := 0 to Comp.ComponentCount-1 do
  if not Found then
  begin
    Temp := Comp.Components[I];
    if Temp is TListBox then
     if (Temp as TListBox).Parent.Visible then
      if (Temp as TListBox).ItemIndex > -1 then
      begin
        Found := True;
        S := (Temp as TListBox).Items[(Temp as TListBox).ItemIndex];
        S := ParseDialog(S);
        Memo.Lines.Add(S);
        Break;
      end;
    if not Found then
     GoRecursive(Temp);
  end;
end;

begin
  Found := False;
  GoRecursive(MainForm);
  if not Found then
    Application.MessageBox('You have not selected a text yet!', 'Warning', MB_OK+MB_ICONWARNING);
end;

procedure TMainForm.btnAboutUsClick(Sender: TObject);
begin
  ShellExecute(Handle, 'open', 'http://www.simplesalescopy.com/help', '', '', SW_SHOWNORMAL);
end;

procedure TMainForm.btnToClipClick(Sender: TObject);
begin
  StringToClipboard(Memo.Lines.Text);
  Application.MessageBox('Text has been successfully copied to the clipboard!', 'Information', MB_OK+MB_ICONINFORMATION);
end;

procedure TMainForm.btnClearMemoClick(Sender: TObject);
begin
  Memo.Lines.Clear;
end;

procedure TMainForm.btnSaveToWordClick(Sender: TObject);
var
  Range: Variant;
  WordApp: Variant;
begin
  WordApp := CreateOleObject('Word.Application');
  WordApp.Visible := True;
  WordApp.Documents.Add;
  Range := WordApp.Documents.Item(1).Range;
  Range.Text := Memo.Text;
end;

end.
