unit AddNewSite;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons, IdBaseComponent, IdComponent,
  IdTCPConnection, IdTCPClient, IdFTP, Mask, ToolEdit, Spin;

type
  TAddNewSiteWizardForm = class(TForm)
    Image1: TImage;
    Bevel1: TBevel;
    btnNext: TButton;
    btnBack: TButton;
    Notebook: TNotebook;
    Label1: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    FTPGroup: TGroupBox;
    Label38: TLabel;
    Label39: TLabel;
    Label40: TLabel;
    Label41: TLabel;
    Label48: TLabel;
    FTPHostname: TEdit;
    FTPUsername: TEdit;
    FTPPassword: TEdit;
    FTPPort: TEdit;
    FTPPassive: TCheckBox;
    ProxyGroup: TGroupBox;
    Label42: TLabel;
    Label43: TLabel;
    Label44: TLabel;
    Label46: TLabel;
    Label47: TLabel;
    FTPProxyHostname: TEdit;
    FTPProxyUsername: TEdit;
    FTPProxyPassword: TEdit;
    FTPProxyPort: TEdit;
    FTPProxyType: TComboBox;
    FTPUseProxy: TCheckBox;
    btnTest: TBitBtn;
    FTPDirectory: TEdit;
    FTP: TIdFTP;
    Label6: TLabel;
    Label7: TLabel;
    Label3: TLabel;
    WebsiteName: TEdit;
    Label8: TLabel;
    MainKeyword: TEdit;
    Label9: TLabel;
    AdsensePub: TEdit;
    Label10: TLabel;
    ChitikaPub: TEdit;
    Label11: TLabel;
    ChitikaChannel: TEdit;
    Label12: TLabel;
    AffID: TEdit;
    Label13: TLabel;
    SubaffID: TEdit;
    NoSearchResults: TEdit;
    Label14: TLabel;
    chkDisableThumbs: TCheckBox;
    Label16: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    btnClose: TButton;
    Label18: TLabel;
    WebsiteURL: TEdit;
    Label17: TLabel;
    Bevel2: TBevel;
    Label15: TLabel;
    chkMyScrape: TRadioButton;
    chkAutoScrape: TRadioButton;
    KeywordsFile: TFilenameEdit;
    MyKeyword: TEdit;
    Panel1: TPanel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    chkUseOwnArticles: TRadioButton;
    ArticlesFolder: TDirectoryEdit;
    chkAutoGenerateArticles: TRadioButton;
    ArticlesPerKeyword: TSpinEdit;
    WordsPerArticle: TSpinEdit;
    MarkovGranularity: TEdit;
    Label25: TLabel;
    MaxKeywords: TSpinEdit;
    procedure btnTestClick(Sender: TObject);
    procedure FTPUseProxyClick(Sender: TObject);
    procedure btnNextClick(Sender: TObject);
    procedure btnBackClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure btnCloseClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Cancelled: Boolean;
    procedure AssignFTPProperties;
  end;

var
  AddNewSiteWizardForm: TAddNewSiteWizardForm;

implementation

{$R *.dfm}

procedure TAddNewSiteWizardForm.AssignFTPProperties;
begin
  with FTP do
  begin
    Host := FTPHostname.Text;
    try
     Port := StrToInt(FTPPort.Text);
    except
     Port := 21;
    end;
    Username := FTPUsername.Text;
    Password := FTPPassword.Text;
    Passive := FTPPassive.Checked;

    if not FTPUseProxy.Checked then
     ProxySettings.ProxyType := fpcmNone
    else
     case FTPProxyType.ItemIndex of
      0: ProxySettings.ProxyType := fpcmHTTPProxyWithFTP;
      1: ProxySettings.ProxyType := fpcmOpen;
      2: ProxySettings.ProxyType := fpcmSite;
      3: ProxySettings.ProxyType := fpcmTransparent;
      4: ProxySettings.ProxyType := fpcmUserPass;
      5: ProxySettings.ProxyType := fpcmUserSite;
     end; { case }

    ProxySettings.Host := FTPProxyHostname.Text;
    ProxySettings.UserName := FTPProxyUsername.Text;
    ProxySettings.Password := FTPProxyPassword.Text;
    try
     ProxySettings.Port := StrToInt(FTPProxyPort.Text);
    except
     ProxySettings.Port := 0;
    end;
  end;
end;

procedure TAddNewSiteWizardForm.btnTestClick(Sender: TObject);
var DirName: String;
begin
  AssignFTPProperties;
  try
   FTP.Connect();
   DirName := StringReplace(FTPDirectory.Text, '\', '/', [rfReplaceAll]);
   if DirName <> '' then
    FTP.ChangeDir(DirName);
   FTP.Disconnect();
   Application.MessageBox('The connection has been successfully established.', 'Connect OK', MB_OK + MB_ICONINFORMATION);
  except
   on E: Exception do
   begin
     if FTP.Connected then
     try
       FTP.Disconnect();
     except
     end;
     Application.MessageBox(PChar('The connection could not be established due to the following error: '+#13#10#13#10+E.Message), 'Warning', MB_OK + MB_ICONWARNING);
   end;
  end;
end;

procedure TAddNewSiteWizardForm.FTPUseProxyClick(Sender: TObject);
begin
  ProxyGroup.Visible := FTPUseProxy.Checked;
end;

procedure TAddNewSiteWizardForm.btnNextClick(Sender: TObject);
begin
  if Notebook.PageIndex < Notebook.Pages.Count-1 then
  begin
   Notebook.PageIndex := Notebook.PageIndex + 1;
   btnBack.Enabled := True;
  end
  else
  begin
   Cancelled := False;
   Close;
  end;
end;

procedure TAddNewSiteWizardForm.btnBackClick(Sender: TObject);
begin
  if Notebook.PageIndex > 0 then
  begin
   Notebook.PageIndex := Notebook.PageIndex - 1;
   btnBack.Enabled := Notebook.PageIndex > 0;
  end;
end;

procedure TAddNewSiteWizardForm.FormCreate(Sender: TObject);
begin
  Cancelled := True;
end;

procedure TAddNewSiteWizardForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  if not Cancelled then
   CanClose := True
  else
  if Application.MessageBox('Are you sure you want to close the wizard? No site will be added to your project''s list if you choose to do so.', 'Confirm', MB_YESNO+MB_ICONQUESTION) = mrYes then
   CanClose := True
  else
   CanClose := False;
end;

procedure TAddNewSiteWizardForm.btnCloseClick(Sender: TObject);
begin
  Close;
end;

end.
