unit Report;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ImgList, StdCtrls;

type
  TReportForm = class(TForm)
    Listbox: TListBox;
    Label1: TLabel;
    Images: TImageList;
    Button1: TButton;
    Label2: TLabel;
    Memo: TMemo;
    procedure ListboxDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure ListboxClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ReportForm: TReportForm;

implementation

{$R *.dfm}

procedure TReportForm.ListboxDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var
  bitmap : TBitmap;
  alist: TListBox;
  S, S1: String;
begin
 try
  { type-cast the Control object }
  alist := Control as TListBox;

  { get the text of the control }
  S := String(alist.Items.Objects[Index]);
  S1 := alist.Items[Index];

  { get the bitmap from the TStringList object storage }
  bitmap := TBitmap.Create;
  if Pos('0xFFFF', S) > 0 then
   Images.GetBitmap(0, bitmap)
  else
   Images.GetBitmap(1, bitmap);
  { erase the current rectangle -- this MUST be done or you get garbage}
  { from previous drawing, trust me...}
  if Index mod 2 = 0 then
   alist.Canvas.Brush.Color := clWhite
  else
   alist.Canvas.Brush.Color := $00FFF0E1;
  alist.Canvas.FillRect(Rect);

  { draw the bitmap }
  alist.Canvas.Draw(Rect.Left, Rect.Top, bitmap);

  { draw the text }
  alist.Canvas.Font.Style := [fsBold];
  alist.Canvas.Font.Size := 12;
  alist.Canvas.Font.Color := clNavy;
  alist.Canvas.TextOut(Rect.Left + bitmap.Width + 4, Rect.Top + 8, S1);
  alist.Canvas.Font.Style := [];
  alist.Canvas.Font.Size := 9;
  alist.Canvas.Font.Color := clMaroon;
  if Pos('0xFFFF', S) > 0 then
   alist.Canvas.TextOut(Rect.Left + bitmap.Width + 4, Rect.Top + 25, 'An error occured. The site was not built.')
  else
   alist.Canvas.TextOut(Rect.Left + bitmap.Width + 4, Rect.Top + 25, 'Site built successfully.');
 except
 end;
end;

procedure TReportForm.ListboxClick(Sender: TObject);
var S, Item: String;
begin
  if Listbox.ItemIndex < 0 then Exit;
  Item := String(ListBox.Items.Objects[Listbox.ItemIndex]);
  if Pos('0xFFFF', Item) > 0 then
  begin
    S := Item;
    Delete(S, 1, Length('0xFFFF~'));
    Memo.Lines.Text := S;
  end
  else
   Memo.Lines.Text := 'N/A';
end;

procedure TReportForm.Button1Click(Sender: TObject);
begin
  Close;
end;

end.
