unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, XPMan, StdCtrls, Buttons, ComCtrls, ExtCtrls, BigINI, ShellAPI,
  jpeg, ExeMod, Mask, ToolEdit, Progress, SkinCaption, WinSkinData;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Help1: TMenuItem;
    NewProject1: TMenuItem;
    N1: TMenuItem;
    OpenProject1: TMenuItem;
    SaveProject1: TMenuItem;
    SaveProjectAs1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    Compile1: TMenuItem;
    XPManifest1: TXPManifest;
    PageControl: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    TabSheet5: TTabSheet;
    TabSheet6: TTabSheet;
    TabSheet8: TTabSheet;
    TabSheet12: TTabSheet;
    TabSheet14: TTabSheet;
    btnExit: TBitBtn;
    Image1: TImage;
    btnPrev: TBitBtn;
    btnNext: TBitBtn;
    ColorDialog: TColorDialog;
    OpenDialog: TOpenDialog;
    OpenDialog1: TOpenDialog;
    SaveDialog: TSaveDialog;
    SaveDialog1: TSaveDialog;
    Label61: TLabel;
    TabSheet16: TTabSheet;
    Label98: TLabel;
    CheckBox1: TRadioButton;
    CheckBox2: TRadioButton;
    CheckBox3: TRadioButton;
    Label1: TLabel;
    Topic: TEdit;
    Label2: TLabel;
    Experts: TEdit;
    Label3: TLabel;
    Product: TEdit;
    Label4: TLabel;
    Site: TEdit;
    Label5: TLabel;
    Location: TEdit;
    Label6: TLabel;
    practitioners: TEdit;
    Label7: TLabel;
    not_one: TEdit;
    TabSheet7: TTabSheet;
    Label8: TLabel;
    Label9: TLabel;
    Button1: TButton;
    Label10: TLabel;
    not_two: TEdit;
    Label11: TLabel;
    not_three: TEdit;
    Label12: TLabel;
    benefit_one: TEdit;
    Label13: TLabel;
    benefit_two: TEdit;
    Label14: TLabel;
    benefit_three: TEdit;
    Label15: TLabel;
    badadvice: TEdit;
    Label16: TLabel;
    typicalact: TEdit;
    Label17: TLabel;
    badlogic: TEdit;
    Label18: TLabel;
    activity_2: TEdit;
    Label19: TLabel;
    activity_3: TEdit;
    Label20: TLabel;
    success: TEdit;
    Label21: TLabel;
    firstlesson: TEdit;
    Label22: TLabel;
    successful_luck_1: TEdit;
    Label23: TLabel;
    successful_luck_2: TEdit;
    Label24: TLabel;
    methods: TEdit;
    Label25: TLabel;
    five_amazing_secrets: TEdit;
    Label26: TLabel;
    five_more_amazing_secrets: TEdit;
    Label27: TLabel;
    webpage: TEdit;
    Label28: TLabel;
    bonus_1: TEdit;
    Label29: TLabel;
    bonus_2: TEdit;
    Label30: TLabel;
    Label31: TLabel;
    bonus_1_description: TEdit;
    Label32: TLabel;
    bonus_2_description: TEdit;
    Label33: TLabel;
    what_I_was_doing: TEdit;
    Label34: TLabel;
    tool: TEdit;
    Label35: TLabel;
    testimony_letter_name: TEdit;
    Label36: TLabel;
    testimony_letter_location: TEdit;
    Label37: TLabel;
    guarantee: TEdit;
    Label38: TLabel;
    guarantee_2: TEdit;
    Label39: TLabel;
    lesson_2: TEdit;
    Label40: TLabel;
    first_part_lesson_2: TEdit;
    Label41: TLabel;
    first_part_letter_2_explanation: TEdit;
    Label42: TLabel;
    what_average_practitioners_do_wrong: TEdit;
    Label43: TLabel;
    whats_wrong: TEdit;
    Label44: TLabel;
    why_is_it_wrong: TEdit;
    Label45: TLabel;
    what_happens: TEdit;
    Label46: TLabel;
    question_how_to_fix: TEdit;
    Label47: TLabel;
    fundamental_principle: TEdit;
    Label48: TLabel;
    lesson_2_practice: TEdit;
    Label49: TLabel;
    timeframe: TEdit;
    Label50: TLabel;
    number_of_bonuses: TEdit;
    Label51: TLabel;
    badlogic_parts: TMemo;
    Bonuses: TMemo;
    BonusesDescriptions: TMemo;
    Label52: TLabel;
    Label53: TLabel;
    goodlogic: TEdit;
    Label54: TLabel;
    Consequences: TMemo;
    Label55: TLabel;
    Corrections: TMemo;
    Label56: TLabel;
    Facts: TMemo;
    Label57: TLabel;
    Discoveries: TMemo;
    Label58: TLabel;
    Testimonials: TMemo;
    Label59: TLabel;
    TestimonialAuthors: TMemo;
    Label60: TLabel;
    Question1: TEdit;
    Label62: TLabel;
    Question2: TEdit;
    Label63: TLabel;
    Question3: TEdit;
    Label64: TLabel;
    OutputDirectory: TDirectoryEdit;
    Label65: TLabel;
    Label66: TLabel;
    SkinData: TSkinData;
    SkinCaption: TSkinCaption;
    VisitWebsite1: TMenuItem;
    Contents1: TMenuItem;
    Image: TImage;
    Label67: TLabel;
    Image2: TImage;
    Image3: TImage;
    Image4: TImage;
    Image5: TImage;
    Image6: TImage;
    Image7: TImage;
    Image8: TImage;
    Image9: TImage;
    Image10: TImage;
    Image11: TImage;
    procedure btnExitClick(Sender: TObject);
    procedure PageControlChange(Sender: TObject);
    procedure btnNextClick(Sender: TObject);
    procedure btnPrevClick(Sender: TObject);
    procedure btnColorsClick(Sender: TObject);
    procedure NewProject1Click(Sender: TObject);
    procedure OpenProject1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SaveProject1Click(Sender: TObject);
    procedure SaveProjectAs1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Compile1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure TW1Exit(Sender: TObject);
    procedure VisitWebsite1Click(Sender: TObject);
    procedure Contents1Click(Sender: TObject);
  private
    { Private declarations }
    procedure SaveProject(FName: String);
    procedure BuildFile(FName: String);

    function Decode(S: String): String;
    function Encode(S: String): String;
  public
    { Public declarations }
    Untitled: Boolean;
    Project: String;
    function StringReplace(const S, OldPattern, NewPattern: string; Flags: TReplaceFlags): string;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

function TMainForm.StringReplace(const S, OldPattern, NewPattern: string; Flags: TReplaceFlags): string;
var A: String;
begin
  if NewPattern = '' then
   A := ' '
  else
   A := NewPattern;
  SysUtils.StringReplace(S, OldPattern, A, Flags);
end;

function TMainForm.Encode(S: String): String;
begin
  Result := StringReplace(S, #13#10, '~~', [rfReplaceAll]);
end;

function TMainForm.Decode(S: String): String;
begin
  Result := StringReplace(S, '~~', #13#10, [rfReplaceAll]);
end;

procedure TMainForm.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.PageControlChange(Sender: TObject);
begin
  btnPrev.Enabled := PageControl.ActivePageIndex > 0;
  btnNext.Enabled := PageControl.ActivePageIndex < PageControl.PageCount-1;
end;

procedure TMainForm.btnNextClick(Sender: TObject);
begin
  PageControl.ActivePageIndex := PageControl.ActivePageIndex+1;
  PageControlChange(Sender);
end;

procedure TMainForm.btnPrevClick(Sender: TObject);
begin
  PageControl.ActivePageIndex := PageControl.ActivePageIndex-1;
  PageControlChange(Sender);
end;

procedure TMainForm.btnColorsClick(Sender: TObject);
function ColorToHTML(C: TColor): string;
begin
  Result := IntToHex(C, 6);
  Result := {'#' +} Copy(Result, 5, 2) + Copy(Result, 3, 2) + Copy(Result, 1, 2);
end;
begin
end;

procedure TMainForm.NewProject1Click(Sender: TObject);

procedure NewProject;
begin
  Checkbox1.Checked := True;

  OutputDirectory.Text := '';

  Topic.Text := '';
  Experts.Text := '';
  Product.Text := '';
  Site.Text := '';
  Location.Text := '';
  practitioners.Text := '';
  not_one.Text := '';

  not_two.Text := '';
  not_three.Text := '';
  benefit_one.Text := '';
  benefit_two.Text := '';
  benefit_three.Text := '';
  badadvice.Text := '';
  typicalact.Text := '';

  badlogic.Text := '';
  activity_2.Text := '';
  activity_3.Text := '';
  success.Text := '';
  firstlesson.Text := '';
  successful_luck_1.Text := '';
  successful_luck_2.Text := '';

  methods.Text := '';
  five_amazing_secrets.Text := '';
  five_more_amazing_secrets.Text := '';
  webpage.Text := '';
  bonus_1.Text := '';
  bonus_2.Text := '';
  Bonuses.Lines.Text := '';
  BonusesDescriptions.Lines.Text := '';

  bonus_1_description.Text := '';
  bonus_2_description.Text := '';
  what_I_was_doing.Text := '';
  tool.Text := '';
  testimony_letter_name.Text := '';
  testimony_letter_location.Text := '';
  guarantee.Text := '';

  guarantee_2.Text := '';
  lesson_2.Text := '';
  first_part_lesson_2.Text := '';
  first_part_letter_2_explanation.Text := '';
  what_average_practitioners_do_wrong.Text := '';
  whats_wrong.Text := '';
  why_is_it_wrong.Text := '';

  what_happens.Text := '';
  question_how_to_fix.Text := '';
  fundamental_principle.Text := '';
  lesson_2_practice.Text := '';
  timeframe.Text := '';
  number_of_bonuses.Text := '';
  badlogic_parts.Lines.Text := '';

  goodlogic.Text := '';
  Consequences.Lines.Text := '';
  Corrections.Lines.Text := '';
  Facts.Lines.Text := '';

  Discoveries.Lines.Text := '';
  Testimonials.Lines.Text := '';
  TestimonialAuthors.Lines.Text := '';
  Question1.Text := '';
  Question2.Text := '';
  Question3.Text := '';

  Project := '';
  Untitled := True;
  Caption := 'NicheSponder - Untitled';
end;

begin
  if Application.MessageBox('Are you sure you want to create a new project?', 'New Project', MB_YESNO+MB_ICONQUESTION) = mrYes then
   NewProject;
end;

procedure TMainForm.OpenProject1Click(Sender: TObject);

procedure OpenProject(FName: String);
var INI: TBigINIFile;
begin
  INI := TBigINIFile.Create(FName);

  CheckBox1.Checked := INI.ReadBool('Project', 'CB1', True);
  CheckBox2.Checked := INI.ReadBool('Project', 'CB2', False);
  CheckBox3.Checked := INI.ReadBool('Project', 'CB3', False);

  OutputDirectory.Text := INI.ReadString('Project', 'OutputDirectory', '');;

  Topic.Text := INI.ReadString('Project', 'Topic', '');;
  Experts.Text := INI.ReadString('Project', 'Experts', '');
  Product.Text := INI.ReadString('Project', 'Product', '');
  Site.Text := INI.ReadString('Project', 'Site', '');
  Location.Text := INI.ReadString('Project', 'Location', '');
  practitioners.Text := INI.ReadString('Project', 'practitioners', '');
  not_one.Text := INI.ReadString('Project', 'not_one', '');

  not_two.Text := INI.ReadString('Project', 'not_two', '');
  not_three.Text := INI.ReadString('Project', 'not_three', '');
  benefit_one.Text := INI.ReadString('Project', 'benefit_one', '');
  benefit_two.Text := INI.ReadString('Project', 'benefit_two', '');
  benefit_three.Text := INI.ReadString('Project', 'benefit_three', '');
  badadvice.Text := INI.ReadString('Project', 'badadvice', '');
  typicalact.Text := INI.ReadString('Project', 'typicalact', '');

  badlogic.Text := INI.ReadString('Project', 'badlogic', '');
  activity_2.Text := INI.ReadString('Project', 'activity 2', '');
  activity_3.Text := INI.ReadString('Project', 'activity 3', '');
  success.Text := INI.ReadString('Project', 'success', '');
  firstlesson.Text := INI.ReadString('Project', 'firstlesson', '');
  successful_luck_1.Text := INI.ReadString('Project', 'successful_luck_1', '');
  successful_luck_2.Text := INI.ReadString('Project', 'successful_luck_2', '');

  methods.Text := INI.ReadString('Project', 'methods', '');
  five_amazing_secrets.Text := INI.ReadString('Project', 'five_amazing_secrets', '');
  five_more_amazing_secrets.Text := INI.ReadString('Project', 'five_more_amazing_secrets', '');
  webpage.Text := INI.ReadString('Project', 'webpage', '');
  bonus_1.Text := INI.ReadString('Project', 'bonus_1', '');
  bonus_2.Text := INI.ReadString('Project', 'bonus_2', '');
  Bonuses.Lines.Text := Decode(INI.ReadString('Project', 'Bonuses', ''));
  BonusesDescriptions.Lines.Text := Decode(INI.ReadString('Project', 'BonusDescriptions', ''));

  bonus_1_description.Text := INI.ReadString('Project', 'bonus_1_description', '');
  bonus_2_description.Text := INI.ReadString('Project', 'bonus_2_description', '');
  what_I_was_doing.Text := INI.ReadString('Project', 'what_I_was_doing', '');
  tool.Text := INI.ReadString('Project', 'tool', '');
  testimony_letter_name.Text := INI.ReadString('Project', 'testimony_letter_name', '');
  testimony_letter_location.Text := INI.ReadString('Project', 'testimony_letter_location', '');
  guarantee.Text := INI.ReadString('Project', 'guarantee', '');

  guarantee_2.Text := INI.ReadString('Project', 'guarantee_2', '');
  lesson_2.Text := INI.ReadString('Project', 'lesson_2', '');
  first_part_lesson_2.Text := INI.ReadString('Project', 'first_part_lesson_2', '');
  first_part_letter_2_explanation.Text := INI.ReadString('Project', 'first_part_lesson_2_explanation', '');
  what_average_practitioners_do_wrong.Text := INI.ReadString('Project', 'what_average_practitioners_do_wrong', '');
  whats_wrong.Text := INI.ReadString('Project', 'whats_wrong', '');
  why_is_it_wrong.Text := INI.ReadString('Project', 'why_is_it_wrong', '');

  what_happens.Text := INI.ReadString('Project', 'what_happens', '');
  question_how_to_fix.Text := INI.ReadString('Project', 'question_how_to_fix', '');
  fundamental_principle.Text := INI.ReadString('Project', 'fundamental_principle', '');
  lesson_2_practice.Text := INI.ReadString('Project', 'lesson_2_practice', '');
  timeframe.Text := INI.ReadString('Project', 'timeframe', '');
  number_of_bonuses.Text := INI.ReadString('Project', 'number_of_bonuses', '');
  badlogic_parts.Lines.Text := Decode(INI.ReadString('Project', 'badlogic_parts', ''));

  goodlogic.Text := INI.ReadString('Project', 'goodlogic', '');
  Consequences.Lines.Text := Decode(INI.ReadString('Project', 'Consequences', ''));
  Corrections.Lines.Text := Decode(INI.ReadString('Project', 'Corrections', ''));
  Facts.Lines.Text := Decode(INI.ReadString('Project', 'Facts', ''));

  Discoveries.Lines.Text := Decode(INI.ReadString('Project', 'Discoveries', ''));
  Testimonials.Lines.Text := Decode(INI.ReadString('Project', 'Testimonials', ''));
  TestimonialAuthors.Lines.Text := Decode(INI.ReadString('Project', 'TestimonialAuthors', ''));
  Question1.Text := INI.ReadString('Project', 'Question1', '');
  Question2.Text := INI.ReadString('Project', 'Question2', '');
  Question3.Text := INI.ReadString('Project', 'Question3', '');

  INI.Free;

  Project := FName;
  Untitled := False;
  Caption := 'NicheSponder - '+ExtractFileName(FName);
end;

begin
  if Application.MessageBox('Are you sure you want to open a project and lose the changes in the current one?', 'Open Project', MB_YESNO+MB_ICONQUESTION) = mrYes then
   if OpenDialog1.Execute then
    OpenProject(OpenDialog1.FileName);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Untitled := True;
  Project := '';
  PageControl.ActivePageIndex := 0;
end;

procedure TMainForm.SaveProject1Click(Sender: TObject);
begin
  if Untitled then
    SaveProjectAs1Click(Sender)
  else
    SaveProject(Project);
end;

procedure TMainForm.SaveProjectAs1Click(Sender: TObject);
function Process(S: String): String;
begin
  if UpperCase(ExtractFileExt(S))<>'.PRJ' then
   Result := S + '.prj'
  else
   Result := S;
end;
begin
  if SaveDialog.Execute then
   SaveProject(Process(SaveDialog.FileName));
end;

procedure TMainForm.SaveProject(FName: String);
var INI: TBigINIFile;
begin
  INI := TBigINIFile.Create(FName);

  INI.WriteBool('Project', 'CB1', CheckBox1.Checked);
  INI.WriteBool('Project', 'CB2', CheckBox2.Checked);
  INI.WriteBool('Project', 'CB3', CheckBox3.Checked);

  INI.WriteString('Project', 'OutputDirectory', OutputDirectory.Text);;

  INI.WriteString('Project', 'Topic', Topic.Text);;
  INI.WriteString('Project', 'Experts', Experts.Text);
  INI.WriteString('Project', 'Product', Product.Text);
  INI.WriteString('Project', 'Site', Site.Text);
  INI.WriteString('Project', 'Location', Location.Text);
  INI.WriteString('Project', 'practitioners', practitioners.Text);
  INI.WriteString('Project', 'not_one', not_one.Text);

  INI.WriteString('Project', 'not_two', not_two.Text);
  INI.WriteString('Project', 'not_three', not_three.Text);
  INI.WriteString('Project', 'benefit_one', benefit_one.Text);
  INI.WriteString('Project', 'benefit_two', benefit_two.Text);
  INI.WriteString('Project', 'benefit_three', benefit_three.Text);
  INI.WriteString('Project', 'badadvice', badadvice.Text);
  INI.WriteString('Project', 'typicalact', typicalact.Text);

  INI.WriteString('Project', 'badlogic', badlogic.Text);
  INI.WriteString('Project', 'activity 2', activity_2.Text);
  INI.WriteString('Project', 'activity 3', activity_3.Text);
  INI.WriteString('Project', 'success', success.Text);
  INI.WriteString('Project', 'firstlesson', firstlesson.Text);
  INI.WriteString('Project', 'successful_luck_1', successful_luck_1.Text);
  INI.WriteString('Project', 'successful_luck_2', successful_luck_2.Text);

  INI.WriteString('Project', 'methods', methods.Text);
  INI.WriteString('Project', 'five_amazing_secrets', five_amazing_secrets.Text);
  INI.WriteString('Project', 'five_more_amazing_secrets', five_more_amazing_secrets.Text);
  INI.WriteString('Project', 'webpage', webpage.Text);
  INI.WriteString('Project', 'bonus_1', bonus_1.Text);
  INI.WriteString('Project', 'bonus_2', bonus_2.Text);
  INI.WriteString('Project', 'Bonuses', Encode(Bonuses.Lines.Text));
  INI.WriteString('Project', 'BonusDescriptions', Encode(BonusesDescriptions.Lines.Text));

  INI.WriteString('Project', 'bonus_1_description', bonus_1_description.Text);
  INI.WriteString('Project', 'bonus_2_description', bonus_2_description.Text);
  INI.WriteString('Project', 'what_I_was_doing', what_I_was_doing.Text);
  INI.WriteString('Project', 'tool', tool.Text);
  INI.WriteString('Project', 'testimony_letter_name', testimony_letter_name.Text);
  INI.WriteString('Project', 'testimony_letter_location', testimony_letter_location.Text);
  INI.WriteString('Project', 'guarantee', guarantee.Text);

  INI.WriteString('Project', 'guarantee_2', guarantee_2.Text);
  INI.WriteString('Project', 'lesson_2', lesson_2.Text);
  INI.WriteString('Project', 'first_part_lesson_2', first_part_lesson_2.Text);
  INI.WriteString('Project', 'first_part_lesson_2_explanation', first_part_letter_2_explanation.Text);
  INI.WriteString('Project', 'what_average_practitioners_do_wrong', what_average_practitioners_do_wrong.Text);
  INI.WriteString('Project', 'whats_wrong', whats_wrong.Text);
  INI.WriteString('Project', 'why_is_it_wrong', why_is_it_wrong.Text);

  INI.WriteString('Project', 'what_happens', what_happens.Text);
  INI.WriteString('Project', 'question_how_to_fix', question_how_to_fix.Text);
  INI.WriteString('Project', 'fundamental_principle', fundamental_principle.Text);
  INI.WriteString('Project', 'lesson_2_practice', lesson_2_practice.Text);
  INI.WriteString('Project', 'timeframe', timeframe.Text);
  INI.WriteString('Project', 'number_of_bonuses', number_of_bonuses.Text);
  INI.WriteString('Project', 'badlogic_parts', Encode(badlogic_parts.Lines.Text));

  INI.WriteString('Project', 'goodlogic', goodlogic.Text);
  INI.WriteString('Project', 'Consequences', Encode(Consequences.Lines.Text));
  INI.WriteString('Project', 'Corrections', Encode(Corrections.Lines.Text));
  INI.WriteString('Project', 'Facts', Encode(Facts.Lines.Text));

  INI.WriteString('Project', 'Discoveries', Encode(Discoveries.Lines.Text));
  INI.WriteString('Project', 'Testimonials', Encode(Testimonials.Lines.Text));
  INI.WriteString('Project', 'TestimonialAuthors', Encode(TestimonialAuthors.Lines.Text));
  INI.WriteString('Project', 'Question1', Question1.Text);
  INI.WriteString('Project', 'Question2', Question2.Text);
  INI.WriteString('Project', 'Question3', Question3.Text);

  INI.Free;

  Project := FName;
  Untitled := False;
  Caption := 'NicheSponder - '+ExtractFileName(FName);
end;

function ProcessTag(TagName, Value, HTML: String): String;
begin
  Result := SysUtils.StringReplace(HTML, TagName, Value, [rfReplaceAll, rfIgnoreCase]);
end;

procedure TMainForm.BuildFile(FName: String);

function Trim(HTML, Tag, StartTag, EndTag: String): String;
{
  Searches for 'Tag' in the HTML text, and deletes all the text that
  is between 'StartTag' and 'EndTag' and that contains the 'Tag'
}
var StartPos, EndPos, P, I: Integer;
begin
  P := Pos(UpperCase(Tag), UpperCase(HTML));
  StartPos := 0;
  EndPos := 0;
  I := P-1;
  while I > 0 do
  begin
    if UpperCase(StartTag) = UpperCase(Copy(HTML, I, Length(StartTag))) then // found it!
    begin
     StartPos := I;
     Break;
    end;
    Dec(I);
  end;
  I := P+1;
  while I <= Length(HTML) do
  begin
    if UpperCase(EndTag) = UpperCase(Copy(HTML, I, Length(EndTag))) then // found it!
    begin
     EndPos := I+Length(EndTag);
     Break;
    end;
    Inc(I);
  end;
  Delete(HTML, StartPos, EndPos-StartPos);
  Result := HTML;
end;

function RemoveQuotes(S: String): String;
begin
  if S<>'' then
   if S[1]='"' then
    Delete(S, 1, 1);
  if S<>'' then
   if S[Length(S)]='"' then
    Delete(S, Length(S), 1);
  if S<>'' then
   if S[Length(S)]<>'\' then
    S := S+'\';
  Result := S;
end;

function WrapText(const Line, BreakStr: string; const BreakChars: TSysCharSet;
  MaxCol: Integer): string; overload;
const
  QuoteChars = [];
var
  Col, Pos: Integer;
  LinePos, LineLen: Integer;
  BreakLen, BreakPos: Integer;
  QuoteChar, CurChar: Char;
  ExistingBreak: Boolean;
  L: Integer;
begin
  Col := 1;
  Pos := 1;
  LinePos := 1;
  BreakPos := 0;
  QuoteChar := #0;
  ExistingBreak := False;
  LineLen := Length(Line);
  BreakLen := Length(BreakStr);
  Result := '';
  while Pos <= LineLen do
  begin
    CurChar := Line[Pos];
    if CurChar in LeadBytes then
    begin
      L := CharLength(Line, Pos) - 1;
      Inc(Pos, L);
      Inc(Col, L);
    end
    else
    begin
      if CurChar in QuoteChars then
        if QuoteChar = #0 then
          QuoteChar := CurChar
        else if CurChar = QuoteChar then
          QuoteChar := #0;
      if QuoteChar = #0 then   
      begin
        if CurChar = BreakStr[1] then
        begin
          ExistingBreak := StrLComp(Pointer(BreakStr), Pointer(@Line[Pos]), BreakLen) = 0;
          if ExistingBreak then
          begin
            Inc(Pos, BreakLen-1);
            BreakPos := Pos;
          end;
        end;
       
        if not ExistingBreak then
          if CurChar in BreakChars then
            BreakPos := Pos;
      end;
    end;

    Inc(Pos);
    Inc(Col);

    if not (QuoteChar in QuoteChars) and (ExistingBreak or
      ((Col > MaxCol) and (BreakPos > LinePos))) then
    begin
      Col := 1;
      Result := Result + Copy(Line, LinePos, BreakPos - LinePos + 1);
      if not (CurChar in QuoteChars) then
      begin
        while Pos <= LineLen do
        begin
          if Line[Pos] in BreakChars then
          begin
            Inc(Pos);
            ExistingBreak := False;
          end
          else
          begin
            ExistingBreak := StrLComp(Pointer(@Line[Pos]), sLineBreak, Length(sLineBreak)) = 0;
            if ExistingBreak then
              Inc(Pos, Length(sLineBreak))
            else
              Break;
          end;
        end;
      end;
      if (Pos <= LineLen) and not ExistingBreak then
        Result := Result + BreakStr;

      Inc(BreakPos);
      LinePos := BreakPos;
      Pos := LinePos;
      ExistingBreak := False;
    end;
  end;
  Result := Result + Copy(Line, LinePos, MaxInt);
end;

function WrapText(const Line: string; MaxCol: Integer): string; overload;
begin
  Result := WrapText(Line, sLineBreak, [' ', '-', #9], MaxCol); { do not localize }
end;

var FileList: TStringList;
    I, j: Integer;
    S1, S: String;
    PF: TProgressForm;
    HTML: String;
    List: TStringList;
begin
  // begin building
  List := TStringList.Create;
  FileList := TStringList.Create;
  if Checkbox1.Checked or Checkbox2.Checked then
   for I:=1 to 50 do
    FileList.Add(ExtractFilePath(ParamStr(0))+'Templates\Template'+IntToStr(I)+'.html');
  if Checkbox1.Checked or Checkbox3.Checked then
   for I:=1 to 50 do
    FileList.Add(ExtractFilePath(ParamStr(0))+'Templates\Template'+IntToStr(I)+'.txt');

  PF := TProgressForm.Create(Self);
  Enabled := False;
  PF.Show;

  // replace files here
  for I:=0 to FileList.Count-1 do
  begin

  PF.PBar.Position := Round((I+1) * 100 / FileList.Count);
  Application.ProcessMessages;

  List.LoadFromFile(FileList[I]);
  HTML := List.Text; // just the text

  { ***** PROCESSING ***** }
  if LowerCase(ExtractFileExt(FileList[I]))='.txt' then
  begin
  HTML := ProcessTag('<activity>', Topic.Text, HTML);
  HTML := ProcessTag('<experts>', experts.Text, HTML);
  HTML := ProcessTag('<product>', product.Text, HTML);
  HTML := ProcessTag('<name>', site.Text, HTML);
  HTML := ProcessTag('<location>', location.Text, HTML);
  HTML := ProcessTag('<practitioners>', practitioners.Text, HTML);
  HTML := ProcessTag('<practitioner>s', practitioners.Text, HTML);
  HTML := ProcessTag('<not one>', not_one.Text, HTML);
  HTML := ProcessTag('<not two>', not_two.Text, HTML);
  HTML := ProcessTag('<not three>', not_three.Text, HTML);
  HTML := ProcessTag('<benefit one>', benefit_one.Text, HTML);
  HTML := ProcessTag('<benefit two>', benefit_two.Text, HTML);
  HTML := ProcessTag('<benefit three>', benefit_three.Text, HTML);
  HTML := ProcessTag('<badadvice>', badadvice.Text, HTML);
  HTML := ProcessTag('<typicalact>', typicalact.Text, HTML);
  HTML := ProcessTag('<badlogic>', badlogic.Text, HTML);
  HTML := ProcessTag('<activity2>', activity_2.Text, HTML);
  HTML := ProcessTag('<activity 2>', activity_2.Text, HTML);
  HTML := ProcessTag('<activity3>', activity_3.Text, HTML);
  HTML := ProcessTag('<activity 3>', activity_3.Text, HTML);
  HTML := ProcessTag('<success>', success.Text, HTML);
  HTML := ProcessTag('<firstlesson>', firstlesson.Text, HTML);
  HTML := ProcessTag('<successful luck 1>', successful_luck_1.Text, HTML);
  HTML := ProcessTag('<successful luck 2>', successful_luck_2.Text, HTML);
  HTML := ProcessTag('<methods>', methods.Text, HTML);
  HTML := ProcessTag('<five amazing secrets>', five_amazing_secrets.Text, HTML);
  HTML := ProcessTag('<five more amazing secrets>', five_more_amazing_secrets.Text, HTML);
  HTML := ProcessTag('<webpage>', webpage.Text, HTML);
  HTML := ProcessTag('<bonus 1>', bonus_1.Text, HTML);
  HTML := ProcessTag('<bonus 2>', bonus_2.Text, HTML);
  for J:=0 to Bonuses.Lines.Count-1 do
   HTML := ProcessTag('<bonus '+IntToStr(J+1)+'>', Bonuses.Lines[J], HTML);
  HTML := ProcessTag('<bonus 1 description>', bonus_1_description.Text, HTML);
  HTML := ProcessTag('<bonus 2 description>', bonus_2_description.Text, HTML);
  for J:=0 to BonusesDescriptions.Lines.Count-1 do
   HTML := ProcessTag('<bonus '+IntToStr(J+1)+' description>', BonusesDescriptions.Lines[J], HTML);
  HTML := ProcessTag('<what I was doing>', what_I_was_doing.Text, HTML);
  HTML := ProcessTag('<tool>', tool.Text, HTML);
  HTML := ProcessTag('<testimony letter name>', testimony_letter_name.Text, HTML);
  HTML := ProcessTag('<testimony letter location>', testimony_letter_location.Text, HTML);
  HTML := ProcessTag('<guarantee>', guarantee.Text, HTML);
  HTML := ProcessTag('<guarantee 2>', guarantee_2.Text, HTML);
  HTML := ProcessTag('<lesson 2>', lesson_2.Text, HTML);
  HTML := ProcessTag('<first part lesson 2>', first_part_lesson_2.Text, HTML);
  HTML := ProcessTag('<first part lesson 2 explanation>', first_part_letter_2_explanation.Text, HTML);
  HTML := ProcessTag('<what average practitioners do wrong>', what_average_practitioners_do_wrong.Text, HTML);
  HTML := ProcessTag('<what''s wrong>', whats_wrong.Text, HTML);
  HTML := ProcessTag('<why is it wrong>', why_is_it_wrong.Text, HTML);
  HTML := ProcessTag('<what happens>', what_happens.Text, HTML);
  HTML := ProcessTag('<question how to fix>', question_how_to_fix.Text, HTML);
  HTML := ProcessTag('<fundamental principle>', fundamental_principle.Text, HTML);
  HTML := ProcessTag('<lesson 2 practice>', lesson_2_practice.Text, HTML);
  HTML := ProcessTag('<timeframe>', timeframe.Text, HTML);
  HTML := ProcessTag('<number of bonuses>', number_of_bonuses.Text, HTML);
  for J:=0 to BadLogic_Parts.Lines.Count-1 do
    HTML := ProcessTag('<badlogic part '+IntToStr(J+1)+'>', BadLogic_Parts.Lines[J], HTML);
  HTML := ProcessTag('<goodlogic>', goodlogic.Text, HTML);
  for J:=0 to Consequences.Lines.Count-1 do
    HTML := ProcessTag('<badlogic part '+IntToStr(J+1)+' consequence>', Consequences.Lines[J], HTML);
  for J:=0 to Corrections.Lines.Count-1 do
    HTML := ProcessTag('<correction '+IntToStr(J+1)+'>', Corrections.Lines[J], HTML);
  for J:=0 to Facts.Lines.Count-1 do
    HTML := ProcessTag('<fact '+IntToStr(J+1)+'>', Facts.Lines[J], HTML);
  for J:=0 to Discoveries.Lines.Count-1 do
    HTML := ProcessTag('<discovery '+IntToStr(J+1)+'>', Discoveries.Lines[J], HTML);
  for J:=0 to Testimonials.Lines.Count-1 do
    HTML := ProcessTag('<testimonial quote '+IntToStr(J+1)+'>', Testimonials.Lines[J], HTML);
  for J:=0 to TestimonialAuthors.Lines.Count-1 do
    HTML := ProcessTag('<testimonial name '+IntToStr(J+1)+'>', TestimonialAuthors.Lines[J], HTML);
  HTML := ProcessTag('<question 1>', question1.Text, HTML);
  HTML := ProcessTag('<question 2>', question2.Text, HTML);
  HTML := ProcessTag('<question 3>', question3.Text, HTML);
  end
  else
  begin
  // process HTML tags now
  HTML := ProcessTag('&lt;activity&gt;', Topic.Text, HTML);
  HTML := ProcessTag('&lt;experts&gt;', experts.Text, HTML);
  HTML := ProcessTag('&lt;product&gt;', product.Text, HTML);
  HTML := ProcessTag('&lt;name&gt;', site.Text, HTML);
  HTML := ProcessTag('&lt;location&gt;', location.Text, HTML);
  HTML := ProcessTag('&lt;practitioners&gt;', practitioners.Text, HTML);
  HTML := ProcessTag('&lt;practitioner&gt;s', practitioners.Text, HTML);
  HTML := ProcessTag('&lt;not one&gt;', not_one.Text, HTML);
  HTML := ProcessTag('&lt;not two&gt;', not_two.Text, HTML);
  HTML := ProcessTag('&lt;not three&gt;', not_three.Text, HTML);
  HTML := ProcessTag('&lt;benefit one&gt;', benefit_one.Text, HTML);
  HTML := ProcessTag('&lt;benefit two&gt;', benefit_two.Text, HTML);
  HTML := ProcessTag('&lt;benefit three&gt;', benefit_three.Text, HTML);
  HTML := ProcessTag('&lt;badadvice&gt;', badadvice.Text, HTML);
  HTML := ProcessTag('&lt;typicalact&gt;', typicalact.Text, HTML);
  HTML := ProcessTag('&lt;badlogic&gt;', badlogic.Text, HTML);
  HTML := ProcessTag('&lt;activity2&gt;', activity_2.Text, HTML);
  HTML := ProcessTag('&lt;activity 2&gt;', activity_2.Text, HTML);
  HTML := ProcessTag('&lt;activity3&gt;', activity_3.Text, HTML);
  HTML := ProcessTag('&lt;activity 3&gt;', activity_3.Text, HTML);
  HTML := ProcessTag('&lt;success&gt;', success.Text, HTML);
  HTML := ProcessTag('&lt;firstlesson&gt;', firstlesson.Text, HTML);
  HTML := ProcessTag('&lt;successful luck 1&gt;', successful_luck_1.Text, HTML);
  HTML := ProcessTag('&lt;successful luck 2&gt;', successful_luck_2.Text, HTML);
  HTML := ProcessTag('&lt;methods&gt;', methods.Text, HTML);
  HTML := ProcessTag('&lt;five amazing secrets&gt;', five_amazing_secrets.Text, HTML);
  HTML := ProcessTag('&lt;five more amazing secrets&gt;', five_more_amazing_secrets.Text, HTML);
  HTML := ProcessTag('&lt;webpage&gt;', webpage.Text, HTML);
  HTML := ProcessTag('&lt;bonus 1&gt;', bonus_1.Text, HTML);
  HTML := ProcessTag('&lt;bonus 2&gt;', bonus_2.Text, HTML);
  for J:=0 to Bonuses.Lines.Count-1 do
   HTML := ProcessTag('&lt;bonus '+IntToStr(J+1)+'&gt;', Bonuses.Lines[J], HTML);
  HTML := ProcessTag('&lt;bonus 1 description&gt;', bonus_1_description.Text, HTML);
  HTML := ProcessTag('&lt;bonus 2 description&gt;', bonus_2_description.Text, HTML);
  for J:=0 to BonusesDescriptions.Lines.Count-1 do
   HTML := ProcessTag('&lt;bonus '+IntToStr(J+1)+' description&gt;', BonusesDescriptions.Lines[J], HTML);
  HTML := ProcessTag('&lt;what I was doing&gt;', what_I_was_doing.Text, HTML);
  HTML := ProcessTag('&lt;tool&gt;', tool.Text, HTML);
  HTML := ProcessTag('&lt;testimony letter name&gt;', testimony_letter_name.Text, HTML);
  HTML := ProcessTag('&lt;testimony letter location&gt;', testimony_letter_location.Text, HTML);
  HTML := ProcessTag('&lt;guarantee&gt;', guarantee.Text, HTML);
  HTML := ProcessTag('&lt;guarantee 2&gt;', guarantee_2.Text, HTML);
  HTML := ProcessTag('&lt;lesson 2&gt;', lesson_2.Text, HTML);
  HTML := ProcessTag('&lt;first part lesson 2&gt;', first_part_lesson_2.Text, HTML);
  HTML := ProcessTag('&lt;first part lesson 2 explanation&gt;', first_part_letter_2_explanation.Text, HTML);
  HTML := ProcessTag('&lt;what average practitioners do wrong&gt;', what_average_practitioners_do_wrong.Text, HTML);
  HTML := ProcessTag('&lt;what''s wrong&gt;', whats_wrong.Text, HTML);
  HTML := ProcessTag('&lt;why is it wrong&gt;', why_is_it_wrong.Text, HTML);
  HTML := ProcessTag('&lt;what happens&gt;', what_happens.Text, HTML);
  HTML := ProcessTag('&lt;question how to fix&gt;', question_how_to_fix.Text, HTML);
  HTML := ProcessTag('&lt;fundamental principle&gt;', fundamental_principle.Text, HTML);
  HTML := ProcessTag('&lt;lesson 2 practice&gt;', lesson_2_practice.Text, HTML);
  HTML := ProcessTag('&lt;timeframe&gt;', timeframe.Text, HTML);
  HTML := ProcessTag('&lt;number of bonuses&gt;', number_of_bonuses.Text, HTML);
  for J:=0 to BadLogic_Parts.Lines.Count-1 do
    HTML := ProcessTag('&lt;badlogic part '+IntToStr(J+1)+'&gt;', BadLogic_Parts.Lines[J], HTML);
  HTML := ProcessTag('&lt;goodlogic&gt;', goodlogic.Text, HTML);
  for J:=0 to Consequences.Lines.Count-1 do
    HTML := ProcessTag('&lt;badlogic part '+IntToStr(J+1)+' consequence&gt;', Consequences.Lines[J], HTML);
  for J:=0 to Corrections.Lines.Count-1 do
    HTML := ProcessTag('&lt;correction '+IntToStr(J+1)+'&gt;', Corrections.Lines[J], HTML);
  for J:=0 to Facts.Lines.Count-1 do
    HTML := ProcessTag('&lt;fact '+IntToStr(J+1)+'&gt;', Facts.Lines[J], HTML);
  for J:=0 to Discoveries.Lines.Count-1 do
    HTML := ProcessTag('&lt;discovery '+IntToStr(J+1)+'&gt;', Discoveries.Lines[J], HTML);
  for J:=0 to Testimonials.Lines.Count-1 do
    HTML := ProcessTag('&lt;testimonial quote '+IntToStr(J+1)+'&gt;', Testimonials.Lines[J], HTML);
  for J:=0 to TestimonialAuthors.Lines.Count-1 do
    HTML := ProcessTag('&lt;testimonial name '+IntToStr(J+1)+'&gt;', TestimonialAuthors.Lines[J], HTML);
  HTML := ProcessTag('&lt;question 1&gt;', question1.Text, HTML);
  HTML := ProcessTag('&lt;question 2&gt;', question2.Text, HTML);
  HTML := ProcessTag('&lt;question 3&gt;', question3.Text, HTML);
  end;
  (*  HTML := ProcessTag('{@metaauthor@}', FN.Lines.Text, HTML);
  HTML := ProcessTag('{@metasubject@}', SW.Lines.Text, HTML);
  HTML := ProcessTag('{@metadescription@}', WD.Lines.Text, HTML);
  HTML := ProcessTag('{@metakeywords@}', WD.Lines.Text, HTML);
  HTML := ProcessTag('{@metalanguage@}', WL.Lines.Text, HTML);
  HTML := ProcessTag('{@metarobots@}', RS.Lines.Text, HTML);
  HTML := ProcessTag('{@metarating@}', TS.Lines.Text, HTML);
  HTML := ProcessTag('{@metaclass@}', CW.Lines.Text, HTML);

  HTML := ProcessTag('{@pagetitle@}', PT.Lines.Text, HTML);
  HTML := ProcessTag('{@currentdate@}', CD.Lines.Text, HTML);
  HTML := ProcessTag('{@yourfullname@}', YFN.Lines.Text, HTML);
  HTML := ProcessTag('{@support@}', CS.Lines.Text, HTML);
  HTML := ProcessTag('{@pagebackgroundcolor@}', PBC.Lines.Text, HTML);
  HTML := ProcessTag('{@header@}', HG.Lines.Text, HTML);
  HTML := ProcessTag('{@ecover@}', EC.Lines.Text, HTML);

  HTML := ProcessTag('{@orderpullingheadline@}', Headline.Lines.Text, HTML);
  HTML := ProcessTag('{@notice@}', NH.Lines.Text, HTML);
  HTML := ProcessTag('{@subheadline@}', SubHeadline.Lines.Text, HTML);

  HTML := ProcessTag('{@line1@}', IntroLine.Lines.Text, HTML);
  HTML := ProcessTag('{@para1@}', FirstParagraph.Lines.Text, HTML);
  HTML := ProcessTag('{@problem@}', Problem.Lines.Text, HTML);

  HTML := ProcessTag('{@introheadline@}', Introheadline.Lines.Text, HTML);
  HTML := ProcessTag('{@smallreasonwhy@}', FeatureList.Lines.Text, HTML);
  HTML := ProcessTag('{@introtheproduct@}', Introduction.Lines.Text, HTML);

  HTML := ProcessTag('{@featuresummary@}', FeatureSummary.Lines.Text, HTML);

  HTML := ProcessTag('{@TestimonialBackgroundColor@}', TBC.Lines.Text, HTML);
  HTML := ProcessTag('{@MoneyBackGuaranteeBackgroundColor@}', MBC.Lines.Text, HTML);
  HTML := ProcessTag('{@OrderLinkBackgroundColor@}', OLBC.Lines.Text, HTML);

  if (F1.Lines.Text <> '') or (FD1.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@feature1@}', F1.Lines.Text, HTML);
    HTML := ProcessTag('{@featuredescription1@}', FD1.Lines.Text, HTML);
  end
  else
  begin
   HTML := Trim(HTML, '{@feature1@}', '<li>', '</li>');
   HTML := Trim(HTML, '{@featuredescription1@}', '<li>', '</li>');
  end;
  if (F2.Lines.Text <> '') or (FD2.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@feature2@}', F2.Lines.Text, HTML);
    HTML := ProcessTag('{@featuredescription2@}', FD2.Lines.Text, HTML);
  end
  else
  begin
   HTML := Trim(HTML, '{@feature2@}', '<li>', '</li>');
   HTML := Trim(HTML, '{@featuredescription2@}', '<li>', '</li>');
  end;
  if (F3.Lines.Text <> '') or (FD3.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@feature3@}', F3.Lines.Text, HTML);
    HTML := ProcessTag('{@featuredescription3@}', FD3.Lines.Text, HTML);
  end
  else
  begin
   HTML := Trim(HTML, '{@feature3@}', '<li>', '</li>');
   HTML := Trim(HTML, '{@featuredescription3@}', '<li>', '</li>');
  end;
  if (F4.Lines.Text <> '') or (FD4.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@feature4@}', F4.Lines.Text, HTML);
    HTML := ProcessTag('{@featuredescription4@}', FD4.Lines.Text, HTML);
  end
  else
  begin
   HTML := Trim(HTML, '{@feature4@}', '<li>', '</li>');
   HTML := Trim(HTML, '{@featuredescription4@}', '<li>', '</li>');
  end;
  if (F5.Lines.Text <> '') or (FD5.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@feature5@}', F5.Lines.Text, HTML);
    HTML := ProcessTag('{@featuredescription5@}', FD5.Lines.Text, HTML);
  end
  else
  begin
   HTML := Trim(HTML, '{@feature5@}', '<li>', '</li>');
   HTML := Trim(HTML, '{@featuredescription5@}', '<li>', '</li>');
  end;
  if (F6.Lines.Text <> '') or (FD6.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@feature6@}', F6.Lines.Text, HTML);
    HTML := ProcessTag('{@featuredescription6@}', FD6.Lines.Text, HTML);
  end
  else
  begin
   HTML := Trim(HTML, '{@feature6@}', '<li>', '</li>');
   HTML := Trim(HTML, '{@featuredescription6@}', '<li>', '</li>');
  end;
  if (F7.Lines.Text <> '') or (FD7.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@feature7@}', F7.Lines.Text, HTML);
    HTML := ProcessTag('{@featuredescription7@}', FD7.Lines.Text, HTML);
  end
  else
  begin
   HTML := Trim(HTML, '{@feature7@}', '<li>', '</li>');
   HTML := Trim(HTML, '{@featuredescription7@}', '<li>', '</li>');
  end;
  if (F8.Lines.Text <> '') or (FD8.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@feature8@}', F8.Lines.Text, HTML);
    HTML := ProcessTag('{@featuredescription8@}', FD8.Lines.Text, HTML);
  end
  else
  begin
   HTML := Trim(HTML, '{@feature8@}', '<li>', '</li>');
   HTML := Trim(HTML, '{@featuredescription8@}', '<li>', '</li>');
  end;
  if (F9.Lines.Text <> '') or (FD9.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@feature9@}', F9.Lines.Text, HTML);
    HTML := ProcessTag('{@featuredescription9@}', FD9.Lines.Text, HTML);
  end
  else
  begin
   HTML := Trim(HTML, '{@feature9@}', '<li>', '</li>');
   HTML := Trim(HTML, '{@featuredescription9@}', '<li>', '</li>');
  end;

  HTML := ProcessTag('{@introbenefits@}', Benefits.Lines.Text, HTML);
  if Benefit1.Lines.Text <> '' then
   HTML := ProcessTag('{@benefit1@}', Benefit1.Lines.Text, HTML)
  else
   HTML := Trim(HTML, '{@benefit1@}', '<li>', '</li>');
  if Benefit2.Lines.Text <> '' then
   HTML := ProcessTag('{@benefit2@}', Benefit2.Lines.Text, HTML)
  else
   HTML := Trim(HTML, '{@benefit2@}', '<li>', '</li>');
  if Benefit3.Lines.Text <> '' then
   HTML := ProcessTag('{@benefit3@}', Benefit3.Lines.Text, HTML)
  else
   HTML := Trim(HTML, '{@benefit3@}', '<li>', '</li>');
  if Benefit4.Lines.Text <> '' then
   HTML := ProcessTag('{@benefit4@}', Benefit4.Lines.Text, HTML)
  else
   HTML := Trim(HTML, '{@benefit4@}', '<li>', '</li>');
  if Benefit5.Lines.Text <> '' then
   HTML := ProcessTag('{@benefit5@}', Benefit5.Lines.Text, HTML)
  else
   HTML := Trim(HTML, '{@benefit5@}', '<li>', '</li>');

  if (TD1.Lines.Text <> '') or (T1.Lines.Text <> '') or (TN1.Lines.Text <> '') or (TW1.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@TestimonialDescription1@}', TD1.Lines.Text, HTML);
    HTML := ProcessTag('{@Testimonial1@}', T1.Lines.Text, HTML);
    HTML := ProcessTag('{@Testimonial1Name@}', TN1.Lines.Text, HTML);
    HTML := ProcessTag('{@TestimonialURL1@}', TW1.Lines.Text, HTML);
  end
  else
   HTML := Trim(HTML, '{@Testimonial1@}', '<tr>', '</tr>');
  if (TD2.Lines.Text <> '') or (T2.Lines.Text <> '') or (TN2.Lines.Text <> '') or (TW2.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@TestimonialDescription2@}', TD2.Lines.Text, HTML);
    HTML := ProcessTag('{@Testimonial2@}', T2.Lines.Text, HTML);
    HTML := ProcessTag('{@Testimonial2Name@}', TN2.Lines.Text, HTML);
    HTML := ProcessTag('{@TestimonialURL2@}', TW2.Lines.Text, HTML);
  end
  else
   HTML := Trim(HTML, '{@Testimonial2@}', '<tr>', '</tr>');
  if (TD3.Lines.Text <> '') or (T3.Lines.Text <> '') or (TN3.Lines.Text <> '') or (TW3.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@TestimonialDescription3@}', TD3.Lines.Text, HTML);
    HTML := ProcessTag('{@Testimonial3@}', T3.Lines.Text, HTML);
    HTML := ProcessTag('{@Testimonial3Name@}', TN3.Lines.Text, HTML);
    HTML := ProcessTag('{@TestimonialURL3@}', TW3.Lines.Text, HTML);
  end
  else
   HTML := Trim(HTML, '{@Testimonial3@}', '<tr>', '</tr>');
  if (TD4.Lines.Text <> '') or (T4.Lines.Text <> '') or (TN4.Lines.Text <> '') or (TW4.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@TestimonialDescription4@}', TD4.Lines.Text, HTML);
    HTML := ProcessTag('{@Testimonial4@}', T4.Lines.Text, HTML);
    HTML := ProcessTag('{@Testimonial4Name@}', TN4.Lines.Text, HTML);
    HTML := ProcessTag('{@TestimonialURL4@}', TW4.Lines.Text, HTML);
  end
  else
   HTML := Trim(HTML, '{@Testimonial4@}', '<tr>', '</tr>');
  if (TD5.Lines.Text <> '') or (T5.Lines.Text <> '') or (TN5.Lines.Text <> '') or (TW5.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@TestimonialDescription5@}', TD5.Lines.Text, HTML);
    HTML := ProcessTag('{@Testimonial5@}', T5.Lines.Text, HTML);
    HTML := ProcessTag('{@Testimonial5Name@}', TN5.Lines.Text, HTML);
    HTML := ProcessTag('{@TestimonialURL5@}', TW5.Lines.Text, HTML);
  end
  else
   HTML := Trim(HTML, '{@Testimonial5@}', '<tr>', '</tr>');

  HTML := ProcessTag('{@howworks@}', HowItWorks.Lines.Text, HTML);
  HTML := ProcessTag('{@thisprice@}', PriceReason.Lines.Text, HTML);
  HTML := ProcessTag('{@receive@}', Receive.Lines.Text, HTML);

  HTML := ProcessTag('{@introbonus@}', IntroBonus.Lines.Text, HTML);

  if (FG1.Lines.Text <> '') or (FGD1.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@giftprice1@}', FG1.Lines.Text, HTML);
    HTML := ProcessTag('{@pricedesc1@}', FGD1.Lines.Text, HTML);
  end
  else
  begin
   HTML := Trim(HTML, '{@giftprice1@}', '<p', '</p>');
   HTML := Trim(HTML, '{@pricedesc1@}', '<p', '</p>');
  end;
  if (FG2.Lines.Text <> '') or (FGD2.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@giftprice2@}', FG2.Lines.Text, HTML);
    HTML := ProcessTag('{@pricedesc2@}', FGD2.Lines.Text, HTML);
  end
  else
  begin
   HTML := Trim(HTML, '{@giftprice2@}', '<p', '</p>');
   HTML := Trim(HTML, '{@pricedesc2@}', '<p', '</p>');
  end;
  if (FG3.Lines.Text <> '') or (FGD3.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@giftprice3@}', FG3.Lines.Text, HTML);
    HTML := ProcessTag('{@pricedesc3@}', FGD3.Lines.Text, HTML);
  end
  else
  begin
   HTML := Trim(HTML, '{@giftprice3@}', '<p', '</p>');
   HTML := Trim(HTML, '{@pricedesc3@}', '<p', '</p>');
  end;
  if (FG4.Lines.Text <> '') or (FGD4.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@giftprice4@}', FG4.Lines.Text, HTML);
    HTML := ProcessTag('{@pricedesc4@}', FGD4.Lines.Text, HTML);
  end
  else
  begin
   HTML := Trim(HTML, '{@giftprice4@}', '<p', '</p>');
   HTML := Trim(HTML, '{@pricedesc4@}', '<p', '</p>');
  end;
  if (FG5.Lines.Text <> '') or (FGD5.Lines.Text <> '') then
  begin
    HTML := ProcessTag('{@giftprice5@}', FG5.Lines.Text, HTML);
    HTML := ProcessTag('{@pricedesc5@}', FGD5.Lines.Text, HTML);
  end
  else
  begin
   HTML := Trim(HTML, '{@giftprice5@}', '<p', '</p>');
   HTML := Trim(HTML, '{@pricedesc5@}', '<p', '</p>');
  end;

  if (MBG.Lines.Text <> '') or (YG.Lines.Text <> '' ) then
  begin
    HTML := ProcessTag('{@moneybackguarantee@}', MBG.Lines.Text, HTML);
    HTML := ProcessTag('{@yourguarantee@}', YG.Lines.Text, HTML);
  end
  else
  begin
   HTML := Trim(HTML, '{@yourguarantee@}', '<table', '</table>');
  end;

  HTML := ProcessTag('{@close@}', Closing.Lines.Text, HTML);
  HTML := ProcessTag('{@closingstatement@}', ClosingS.Lines.Text, HTML);
  HTML := ProcessTag('{@ps@}', PS.Lines.Text, HTML);

  HTML := ProcessTag('{@firstname@}', N.Lines.Text, HTML);
  HTML := ProcessTag('{@lastname@}', LN.Lines.Text, HTML);
  HTML := ProcessTag('{@businessname@}', BN.Lines.Text, HTML);

  HTML := ProcessTag('{@ezinedescription@}', StringReplace(ED.Lines.Text, #13#10, '<br>', [rfReplaceAll]), HTML);
  HTML := ProcessTag('{@optinaddress@}', EEA.Lines.Text, HTML);
  HTML := ProcessTag('{@optintitle@}', PopT.Lines.Text, HTML);
  HTML := ProcessTag('{@emailsubject@}', ES.Lines.Text, HTML);

  if OH.Lines.Text <> '' then
    HTML := ProcessTag('{@orderheadline@}', OH.Lines.Text, HTML)
  else
    HTML := Trim(HTML, '{@orderheadline@}', '<strong>', '</a>');
  HTML := ProcessTag('{@orderlink@}', Link.Lines.Text, HTML);
  if OR1.Lines.Text <> '' then
   HTML := ProcessTag('{@orderreason1@}', OR1.Lines.Text, HTML)
  else
   HTML := Trim(HTML, '{@orderreason1@}', '<li>', '</li>');
  if OR2.Lines.Text <> '' then
   HTML := ProcessTag('{@orderreason2@}', OR2.Lines.Text, HTML)
  else
   HTML := Trim(HTML, '{@orderreason2@}', '<li>', '</li>');
  if OR3.Lines.Text <> '' then
   HTML := ProcessTag('{@orderreason3@}', OR3.Lines.Text, HTML)
  else
   HTML := Trim(HTML, '{@orderreason3@}', '<li>', '</li>');
  if OR4.Lines.Text <> '' then
   HTML := ProcessTag('{@orderreason4@}', OR4.Lines.Text, HTML)
  else
   HTML := Trim(HTML, '{@orderreason4@}', '<li>', '</li>');
  if OR5.Lines.Text <> '' then
   HTML := ProcessTag('{@orderreason5@}', OR5.Lines.Text, HTML)
  else
   HTML := Trim(HTML, '{@orderreason5@}', '<li>', '</li>');
  HTML := ProcessTag('{@affiliateID@}', AffiliateID.Lines.Text, HTML);*)
  { ***** END OF PROCESSING ***** }

  // changed HTML
  List.Text := HTML;

  // now wrap text!
  if LowerCase(ExtractFileExt(FileList[I]))='.txt' then
  begin
    S := '';
    for J:=0 to List.Count-1 do // we need to parse each line and do the wrap
    begin
      S1 := WrapText(List[J], #13#10, ['.',' ',#9,'-'], 65); // just wrap
      if J > 0 then
       S := S + #13#10 + S1
      else
       S := S1;
    end;
    List.Text := S;
    List.SaveToFile(RemoveQuotes(OutputDirectory.Text)+ExtractFileName(FileList[I]));
  end
  else
  begin
    List.SaveToFile(RemoveQuotes(OutputDirectory.Text)+ExtractFileName(FileList[I]));
(*    J := 0;
    List2 := TStringList.Create;
    while J <= List.Count-1 do
    // we need to parse each line and do the wrap
    begin

      if Pos('<p ', List[J]) = 1 then // we found a paragraph with text
      begin
        S := List[J];
        while Pos('</p>', List[J]) <= 0 do
        begin
          Inc(J);
          S := S + ' ' + List[J];
        end;
        // now we have all the paragraph in string S
        S1 := Copy(S, 1, Pos('>', S)); // begin tag in S1
        S2 := S;
        Delete(S2, 1, Pos('</p>', S2)-1); // end tag in S2
        Delete(S, 1, Length(S1));
        S := Copy(S, 1, Pos('</p>', S)-1);
        S3 := WrapText(S, '<br>', ['.',' ',#9,'-'], 65); // just wrap
        List2.Add(S1+S3+S2);
      end
      else
       List2.Add(List[J]); // just add

      Inc(J); // go to next line
    end;
    List2.SaveToFile(RemoveQuotes(OutputDirectory.Text)+ExtractFileName(FileList[I]));
    List2.Free;*)
  end;

  end;

  PF.Free;
  Enabled := True;

  List.Free;
  FileList.Free;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if Application.MessageBox('Are you sure you want to exit the program? Changes to the current sales letter will not be saved!', 'Quit', MB_YESNO+MB_ICONQUESTION) = mrYes then
   Action := caFree
  else
   Action := caNone;
end;

procedure TMainForm.Compile1Click(Sender: TObject);
function Process(S: String): String;
begin
  if UpperCase(ExtractFileExt(S))<>'.HTML' then
   Result := S + '.html'
  else
   Result := S;
end;
var K: String;
begin
  K := OutputDirectory.Text;
  if ExtractFilePath(K) = '' then
   K := ExtractFilePath(ParamStr(0))+K;
  if not DirectoryExists(K) then
   ForceDirectories(K);
  if not DirectoryExists(K) then
  begin
    ShowMessage('Output directory could not be created!');
    Exit;
  end;
  BuildFile(Process(SaveDialog1.FileName));
  ShowMessage('The sales letters have been successfully produced!');
end;

procedure TMainForm.CheckBox1Click(Sender: TObject);
begin
  CheckBox1.Checked := True;
end;

procedure TMainForm.TW1Exit(Sender: TObject);
begin
  with Sender as TEdit do
   if Pos('HTTP://', UpperCase(Text)) <> 1 then
    Text := 'http://'+Text;
end;

procedure TMainForm.VisitWebsite1Click(Sender: TObject);
begin
  ShellExecute(Handle, 'open', 'http://www.nichesponder.com', '', '', SW_SHOWNORMAL);
end;

procedure TMainForm.Contents1Click(Sender: TObject);
begin
  ShellExecute(Handle, 'open', 'http://www.nichesponder.com/help', '', '', SW_SHOWNORMAL);
end;

end.
