Attribute VB_Name = "modToolbarBuilder"
Option Explicit

Public Const FLASHOBJECT_CODE As String = "<html> <body topmargin=""0"" leftmargin=""0"" marginheight=""0"" marginwidth=""0"" scroll=""no"">[FLASHCODE]</body></html>"

Public Type RECTAPI
    left As Long
    top As Long
    right As Long
    bottom As Long
End Type

Public Type POINTAPI
    x As Long
    y As Long
End Type

Public Declare Function GetWindowRect Lib "user32" (ByVal hwnd As Long, lpRect As RECTAPI) As Long
Public Declare Function CreatePopupMenu Lib "user32" () As Long
Public Declare Function AppendMenu Lib "user32" Alias "AppendMenuA" (ByVal hMenu As Long, ByVal wFlags As Long, ByVal wIDNewItem As Long, ByVal lpNewItem As Any) As Long
Public Declare Function DestroyMenu Lib "user32" (ByVal hMenu As Long) As Long
Public Declare Function TrackPopupMenu Lib "user32" (ByVal hMenu As Long, ByVal wFlags As Long, ByVal x As Long, ByVal y As Long, ByVal nReserved As Long, ByVal hwnd As Long, lprc As Any) As Long

Public Declare Function GetSystemMetrics Lib "user32" (ByVal nIndex As Long) As Long
Public Const SM_CXVSCROLL = 2
Public Const SM_CXBORDER = 5


Public Declare Function StretchBlt Lib "gdi32" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal dwRop As Long) As Long
Public Const SRCCOPY = &HCC0020

Public strWebBrowserUrls(0 To 20) As String

Public Const MF_STRING = &H0&
Public Const MF_POPUP = &H10&
Public Const MF_SEPARATOR = &H800&


' Amount of captions in tlbTools. if 3 then change style
Dim iToolsCaptionsCount As Long

Public iButtonsCount As Long

Public g_strAdWebButtonCode As String

'Rebuild toolbar using options set
Public Sub BuildToolbarFromOptions(toolbarOptions As PropertyBag)
        
    On Error Resume Next
        
    Dim i As Long, j As Long
    Dim strButtonName As String, strMenuItemName As String
    Dim btn As MSComctlLib.Button
    Dim ils As MSComctlLib.ListImage
    Dim btnMenu As MSComctlLib.ButtonMenu
    Dim temp As String
        
    iToolsCaptionsCount = 0
        
    ' Clear all
    frmMain.tlbMain.buttons.Clear
    
    Set frmMain.tlbMain.DisabledImageList = Nothing
    Set frmMain.tlbMain.HotImageList = Nothing
    Set frmMain.tlbMain.ImageList = Nothing
    
    frmMain.ilsToolbar.ListImages.Clear
    frmMain.ilsToolbarHot.ListImages.Clear
            
    ' Unload all toolbars and image lists
    For i = 1 To iButtonsCount
        Unload frmMain.tlbButtons(i)
        Unload frmMain.ilsTlbButtons(i)
        Unload frmMain.ilsTlbButtonsHot(i)
        Unload frmMain.WebBrowser(i)
    Next i

    ' Add logo
    If toolbarOptions.ReadProperty("LogoUsePict") Then
        frmMain.ilsToolbar.ListImages.Add , "logo", toolbarOptions.ReadProperty("LogoPict")
        frmMain.ilsToolbarHot.ListImages.Add , "logo", toolbarOptions.ReadProperty("LogoPictHot")
    Else
        Dim picTemp As Picture
        Set picTemp = TextToPicture( _
            toolbarOptions.ReadProperty("LogoCaption"), _
            toolbarOptions.ReadProperty("LogoFontName"), _
            toolbarOptions.ReadProperty("LogoFontSize"), _
            toolbarOptions.ReadProperty("LogoFontBold"), _
            toolbarOptions.ReadProperty("LogoFontItalic"), _
            toolbarOptions.ReadProperty("LogoFontUnderline"), _
            toolbarOptions.ReadProperty("LogoFontStrikethru"), _
            toolbarOptions.ReadProperty("LogoFontColor"))
        
        frmMain.ilsToolbar.ListImages.Add , "logo", picTemp
        frmMain.ilsToolbarHot.ListImages.Add , "logo", picTemp
    End If
    
    ' Add imagelists
    Set frmMain.tlbMain.DisabledImageList = frmMain.ilsToolbar
    Set frmMain.tlbMain.ImageList = frmMain.ilsToolbar
    Set frmMain.tlbMain.HotImageList = frmMain.ilsToolbarHot

    If toolbarOptions.ReadProperty("LogoMenuItems") = 0 Then
        Set btn = frmMain.tlbMain.buttons.Add(, "logo", "", tbrDefault, "logo")
    Else
        Set btn = frmMain.tlbMain.buttons.Add(, "logo", "", tbrDropdown, "logo")
            
        ' Add popup menu
        For i = 1 To toolbarOptions.ReadProperty("LogoMenuItems")
            If toolbarOptions.ReadProperty("LogoMenuItem" & i & "Link") = "[SEPARATOR]" Then
                btn.ButtonMenus.Add i, "q" & i, "-"
            Else
                btn.ButtonMenus.Add i, "q" & i, toolbarOptions.ReadProperty("LogoMenuItem" & i & "Caption")
            End If
        Next i
        
        ' Add separator and "Clear search history" menu item
        If toolbarOptions.ReadProperty("LogoMenuItems") > 0 Then
            btn.ButtonMenus.Add toolbarOptions.ReadProperty("LogoMenuItems") + 1, "ClearHistorySeparator", "-"
        End If
        
        btn.ButtonMenus.Add toolbarOptions.ReadProperty("LogoMenuItems") + 2, "ClearHistory", "Clear Search History"
        
    End If
    
    If Len(toolbarOptions.ReadProperty("LogoLink")) > 0 Then
        btn.Enabled = True
        btn.ToolTipText = Replace(toolbarOptions.ReadProperty("LogoLink"), "[BRANDID]", toolbarOptions.ReadProperty("BrandId"))
    Else
        btn.Enabled = False
        btn.ToolTipText = ""
    End If

    frmMain.fraLogo.Visible = False

    ' Add search separator
    Set btn = frmMain.tlbMain.buttons.Add(, "textplaceholder", , tbrPlaceholder)
    btn.Width = toolbarOptions.ReadProperty("SearchWidth") + 100


    ' Add search button
    Load frmMain.fraButtons(1)
    Load frmMain.ilsTlbButtons(1)
    Load frmMain.ilsTlbButtonsHot(1)
    Load frmMain.tlbButtons(1)
    
    frmMain.fraButtons(1).Visible = True
    frmMain.tlbButtons(1).Visible = True
    frmMain.tlbButtons(1).ZOrder 0
    
    ' Add pictures to image lists
    frmMain.ilsTlbButtons(1).ListImages.Add , "search", toolbarOptions.ReadProperty("SearchPict")
    frmMain.ilsTlbButtonsHot(1).ListImages.Add , "search", toolbarOptions.ReadProperty("SearchPictHot")
    
    ' Set image lists
    Set frmMain.tlbButtons(1).ImageList = frmMain.ilsTlbButtons(1)
    Set frmMain.tlbButtons(1).HotImageList = frmMain.ilsTlbButtonsHot(1)
    
    ' Add button to new tooblar and correct toolbar size as button size
    temp = toolbarOptions.ReadProperty("SearchCaption")
    If toolbarOptions.ReadProperty("SearchButtonMenuCount") = 0 Then
        Set btn = frmMain.tlbButtons(1).buttons.Add(, "search", temp, tbrDefault, "search")
    Else
        Set btn = frmMain.tlbButtons(1).buttons.Add(, "search", temp, tbrDropdown, "search")
        
        For i = 0 To toolbarOptions.ReadProperty("SearchButtonMenuCount") - 1
            btn.ButtonMenus.Add , "searchbuttonmenu" & i + 1, toolbarOptions.ReadProperty("SearchButtonMenu" & i + 1 & "Caption")
        Next i
    End If
    
    btn.ToolTipText = temp
        
    If temp = "" Then
        frmMain.tlbButtons(1).TextAlignment = tbrTextAlignBottom
    End If
    
    frmMain.tlbButtons(1).Width = btn.Width
    
    ' Add placeholder on big toolbar for new small toolbar and change size.
    Set btn = frmMain.tlbMain.buttons.Add(, "button" & 1 & "placeholder", , tbrPlaceholder)
    btn.Width = frmMain.tlbButtons(1).Width

    iButtonsCount = toolbarOptions.ReadProperty("ButtonsCount", 0)

    ' If we have buttons, add separator
    If iButtonsCount > 0 Then
        frmMain.tlbMain.buttons.Add , "searchsep", , tbrSeparator
    End If

    ' Include search button
    iButtonsCount = iButtonsCount + 1
        
    ' Add buttons
    For i = 2 To iButtonsCount
        
        strButtonName = "Button" & i - 1
        
        If toolbarOptions.ReadProperty(strButtonName & "IsWebButton") Then
            strWebBrowserUrls(i) = toolbarOptions.ReadProperty(strButtonName & "WebCode")
            
            Load frmMain.WebBrowser(i)
            Load frmMain.fraButtons(i)
            
            frmMain.WebBrowser(i).Navigate ("about:blank")
            
                                  
            frmMain.WebBrowser(i).Document.Write Replace(FLASHOBJECT_CODE, "[FLASHCODE]", (toolbarOptions.ReadProperty(strButtonName & "WebCode")))
                        
            Set btn = frmMain.tlbMain.buttons.Add(, "button" & i & "placeholder", , tbrPlaceholder)
            btn.Width = Screen.TwipsPerPixelX * 54 + 100 'btn.Height * 1.5
            Set btn = Nothing
            
             frmMain.WebBrowser(i).Visible = True
             frmMain.WebBrowser(i).ZOrder
        Else
        
            temp = toolbarOptions.ReadProperty(strButtonName & "Caption")
                
            ' Load new toolbar with controls
            Load frmMain.ilsTlbButtons(i)
            Load frmMain.ilsTlbButtonsHot(i)
            Load frmMain.tlbButtons(i)
            Load frmMain.fraButtons(i)
        
            frmMain.fraButtons(i).Visible = True
            frmMain.fraButtons(i).ZOrder
            frmMain.tlbButtons(i).Visible = True
            frmMain.tlbButtons(i).ZOrder
        
        
            ' Form image lists and create toolbar
            frmMain.ilsTlbButtons(i).ListImages.Add , strButtonName, toolbarOptions.ReadProperty(strButtonName & "Pict")
            frmMain.ilsTlbButtonsHot(i).ListImages.Add , strButtonName, toolbarOptions.ReadProperty(strButtonName & "PictHot")
            Set frmMain.tlbButtons(i).ImageList = frmMain.ilsTlbButtons(i)
            Set frmMain.tlbButtons(i).HotImageList = frmMain.ilsTlbButtonsHot(i)
            Set btn = frmMain.tlbButtons(i).buttons.Add(, , temp, tbrDefault, 1)
                       
            ' Set button properties
            btn.ToolTipText = toolbarOptions.ReadProperty(strButtonName & "TooltipText")
            btn.Description = toolbarOptions.ReadProperty(strButtonName & "Description")

            ' If button have not caption, delete text
            If temp = "" Then
                frmMain.tlbButtons(i).TextAlignment = tbrTextAlignBottom
            End If
        
            frmMain.tlbButtons(i).Width = btn.Width
              
            ' Create popup menu
            For j = 1 To toolbarOptions.ReadProperty(strButtonName & "PMICount", 0)
                strMenuItemName = strButtonName & "PMI" & j
                Set btnMenu = btn.ButtonMenus.Add(, strMenuItemName, toolbarOptions.ReadProperty(strMenuItemName & "Caption"))
                btnMenu.Tag = toolbarOptions.ReadProperty(strMenuItemName & "Link")
                Set btnMenu = Nothing
            Next j

            ' Add placeholder & this toolbar to big toolbar
            Set btn = frmMain.tlbMain.buttons.Add(, "button" & i & "placeholder", , tbrPlaceholder)
            btn.Width = frmMain.tlbButtons(i).Width
            frmMain.tlbButtons(i).Visible = True
            frmMain.tlbButtons(i).ZOrder
            Set btn = Nothing
        End If
    Next i


    ' Add advanced features
    Set frmMain.tlbTools.ImageList = Nothing
    Set frmMain.tlbTools.HotImageList = Nothing
    frmMain.ilsTools.ListImages.Clear
    frmMain.ilsToolsHot.ListImages.Clear
    frmMain.tlbTools.buttons.Clear
        
    
    If toolbarOptions.ReadProperty("PopupBlocker") Then
        frmMain.ilsTools.ListImages.Add , "popup", toolbarOptions.ReadProperty("PopupBlockerIconPicture")
        frmMain.ilsToolsHot.ListImages.Add , "popup", toolbarOptions.ReadProperty("PopupBlockerIconOverPicture")
        frmMain.ilsTools.ListImages.Add , "sound", toolbarOptions.ReadProperty("PopupSoundIconPicture")
        frmMain.ilsToolsHot.ListImages.Add , "sound", toolbarOptions.ReadProperty("PopupSoundIconOverPicture")
    End If
    
    If toolbarOptions.ReadProperty("Translate") Then
        frmMain.ilsTools.ListImages.Add , "translate", toolbarOptions.ReadProperty("TranslationIconPicture")
        frmMain.ilsToolsHot.ListImages.Add , "translate", toolbarOptions.ReadProperty("TranslationIconOverPicture")
    End If
    
    If toolbarOptions.ReadProperty("Cleaner") Then
        frmMain.ilsTools.ListImages.Add , "cleaner", toolbarOptions.ReadProperty("CookieCleanerIconPicture")
        frmMain.ilsToolsHot.ListImages.Add , "cleaner", toolbarOptions.ReadProperty("CookieCleanerIconOverPicture")
    End If
    
    Set frmMain.tlbTools.ImageList = frmMain.ilsTools
    Set frmMain.tlbTools.HotImageList = frmMain.ilsToolsHot
    
    ' Add popup blocking part
    If toolbarOptions.ReadProperty("PopupBlocker") Then
        frmMain.tlbTools.buttons.Add , "sep2", , tbrSeparator
    
        Set btn = frmMain.tlbTools.buttons.Add(, "popup", toolbarOptions.ReadProperty("PopupBlockerCaption"), tbrCheck, "popup")
        btn.ToolTipText = "Turn On / Off Blocking PopUps"
        
        If Len(btn.Caption) > 0 Then
            iToolsCaptionsCount = iToolsCaptionsCount + 1
        End If
    
        Set btn = frmMain.tlbTools.buttons.Add(, "sound", toolbarOptions.ReadProperty("PopupSoundCaption"), tbrCheck, "sound")
        btn.ToolTipText = "Turn On / Off  Sound When Popup is Blocked"
    End If
    
    'Add translate part
    If toolbarOptions.ReadProperty("Translate") Then
        frmMain.tlbTools.buttons.Add , "sep3", , tbrSeparator
        Set btn = frmMain.tlbTools.buttons.Add(, "translate", toolbarOptions.ReadProperty("TranslationCaption"), tbrDropdown, "translate")
        btn.ToolTipText = "Translate current Page"
        
        If Len(btn.Caption) > 0 Then
            iToolsCaptionsCount = iToolsCaptionsCount + 1
        End If
    
        btn.ButtonMenus.Add , "translat_en_zh", "English to Chinese"
        btn.ButtonMenus.Add , "translat_en_fr", "English to French"
        btn.ButtonMenus.Add , "translat_en_de", "English to German"
        btn.ButtonMenus.Add , "translat_en_it", "English to Italian"
        btn.ButtonMenus.Add , "translat_en_ja", "English to Japanese"
        btn.ButtonMenus.Add , "translat_en_ko", "English to Korean"
        btn.ButtonMenus.Add , "translat_en_pt", "English to Portuguese"
        btn.ButtonMenus.Add , "translat_en_es", "English to Spanish"
        btn.ButtonMenus.Add , "translat_zh_en", "Chinese to English"
        btn.ButtonMenus.Add , "translat_fr_en", "French to English"
        btn.ButtonMenus.Add , "translat_fr_de", "French to German"
        btn.ButtonMenus.Add , "translat_de_en", "German to English"
        btn.ButtonMenus.Add , "translat_de_fr", "German to French"
        btn.ButtonMenus.Add , "translat_it_en", "Italian to English"
        btn.ButtonMenus.Add , "translat_ja_en", "Japanese to English"
        btn.ButtonMenus.Add , "translat_ko_en", "Korean to English"
        btn.ButtonMenus.Add , "translat_pt_en", "Portuguese to English"
        btn.ButtonMenus.Add , "translat_ru_en", "Russian to English"
        btn.ButtonMenus.Add , "translat_es_en", "Spanish to English"
    End If
    
    If iToolsCaptionsCount = 3 Then
    
    Else
    
    End If
    
    ' Add web cleaning part
    If toolbarOptions.ReadProperty("Cleaner") Then
        frmMain.tlbTools.buttons.Add , "sep4", , tbrSeparator
        Set btn = frmMain.tlbTools.buttons.Add(, "cleaner", toolbarOptions.ReadProperty("CookieCleanerCaption"), tbrDropdown, "cleaner")
        btn.ToolTipText = "Clear cookies and history"
        btn.ButtonMenus.Add , "history", "Clear History"
        btn.ButtonMenus.Add , "cookies", "Clear Cookies"
        
        If Len(btn.Caption) > 0 Then
            iToolsCaptionsCount = iToolsCaptionsCount + 1
        End If
    End If
    
    ' Set aligment for tools buttons
    If iToolsCaptionsCount > 0 Then
        frmMain.tlbTools.TextAlignment = tbrTextAlignRight
    Else
        frmMain.tlbTools.TextAlignment = tbrTextAlignBottom
    End If
        
    ' Add tools toolbar to main toolbar
    If toolbarOptions.ReadProperty("Cleaner") Or toolbarOptions.ReadProperty("PopupBlocker") Or toolbarOptions.ReadProperty("Translate") Then
        Dim iWidth As Long
        iWidth = 0
        For Each btn In frmMain.tlbTools.buttons
            iWidth = iWidth + btn.Width
        Next btn
        Set btn = frmMain.tlbMain.buttons.Add(, "popupplaceholder", , tbrPlaceholder)
        btn.Width = iWidth
        Set btn = Nothing
    End If
    
    ' Add tell a friend button
    If Len(toolbarOptions.ReadProperty("TellAFriendCaption")) > 0 Or Len(toolbarOptions.ReadProperty("TellAFriendImage")) > 0 Then
        'On Error GoTo 0
        frmMain.tlbTellAFriend.buttons.Clear
        Set frmMain.tlbTellAFriend.ImageList = Nothing
        Set frmMain.tlbTellAFriend.HotImageList = Nothing
        frmMain.ilsTellAFriend.ListImages.Clear
        frmMain.ilsTellAFriendHot.ListImages.Clear

        frmMain.ilsTellAFriend.ListImages.Add , , toolbarOptions.ReadProperty("TellAFriendImagePict")
        frmMain.ilsTellAFriendHot.ListImages.Add , , toolbarOptions.ReadProperty("TellAFriendImageOverPict")

        Set frmMain.tlbTellAFriend.ImageList = frmMain.ilsTellAFriend
        Set frmMain.tlbTellAFriend.HotImageList = frmMain.ilsTellAFriendHot
        Set btn = frmMain.tlbTellAFriend.buttons.Add(, "tf", , tbrDefault, 1)
        btn.ToolTipText = toolbarOptions.ReadProperty("TellAFriendCaption")
        btn.Caption = toolbarOptions.ReadProperty("TellAFriendCaption")
        If Len(btn.Caption) > 0 Then
            frmMain.tlbTellAFriend.TextAlignment = tbrTextAlignRight
        Else
            frmMain.tlbTellAFriend.TextAlignment = tbrTextAlignBottom
        End If

        frmMain.tlbMain.buttons.Add , "tfsep", , tbrSeparator
        Set btn = frmMain.tlbMain.buttons.Add(, "tfplaceholder", , tbrPlaceholder)
        btn.Width = frmMain.tlbTellAFriend.buttons(1).Width + 50
        Set btn = Nothing
        
        frmMain.fraTellAFriend.Visible = True
        frmMain.fraTellAFriend.ZOrder
        On Error Resume Next
    Else
        frmMain.fraTellAFriend.Visible = False
        frmMain.fraTellAFriend.ZOrder 1
    End If
    
    ' Add Ad Button
    If toolbarOptions.ReadProperty("Ads") > 0 Or Len(toolbarOptions.ReadProperty("AdsWebButtonCode")) > 0 Then
                        
        frmMain.tlbAds.buttons.Clear
        Set frmMain.tlbAds.ImageList = Nothing
        Set frmMain.tlbAds.HotImageList = Nothing
        frmMain.ilsAds.ListImages.Clear
        frmMain.ilsAdsHot.ListImages.Clear
           
        If toolbarOptions.ReadProperty("AdStatic") Then
           
            frmMain.ilsAds.ListImages.Add , , toolbarOptions.ReadProperty("Ad1ImagePict")
            frmMain.ilsAdsHot.ListImages.Add , , toolbarOptions.ReadProperty("Ad1ImageOverPict")
                
            Set frmMain.tlbAds.ImageList = frmMain.ilsAds
            Set frmMain.tlbAds.HotImageList = frmMain.ilsAdsHot
            Set btn = frmMain.tlbAds.buttons.Add(, "ad", , tbrDefault, 1)
            btn.ToolTipText = toolbarOptions.ReadProperty("Ad1Caption")
            btn.Caption = toolbarOptions.ReadProperty("Ad1Caption")
            If Len(btn.Caption) > 0 Then
                frmMain.tlbAds.TextAlignment = tbrTextAlignRight
            Else
                frmMain.tlbAds.TextAlignment = tbrTextAlignBottom
            End If
    
            frmMain.tlbMain.buttons.Add , "adsep", , tbrSeparator
            Set btn = frmMain.tlbMain.buttons.Add(, "adplaceholder", , tbrPlaceholder)
            btn.Width = frmMain.tlbAds.buttons(1).Width + 50
            Set btn = Nothing
        
            frmMain.tlbAds.Visible = True
            frmMain.wbrAds.Visible = False
            frmMain.tlbAds.ZOrder
        Else
            frmMain.wbrAds.Navigate ("about:blank")
            g_strAdWebButtonCode = toolbarOptions.ReadProperty("AdsWebButtonCode")
                                    
            Set btn = frmMain.tlbMain.buttons.Add(, "adsep", , tbrPlaceholder)
            Set btn = frmMain.tlbMain.buttons.Add(, "adplaceholder", , tbrPlaceholder)
            btn.Width = Screen.TwipsPerPixelX * toolbarOptions.ReadProperty("AdsWebButtonWidth")
            
            Set btn = Nothing
            
            frmMain.wbrAds.Visible = True
            frmMain.tlbAds.Visible = False
            frmMain.wbrAds.ZOrder
        End If
        
        frmMain.fraAds.Visible = True
        frmMain.fraAds.ZOrder
    Else
        frmMain.fraAds.Visible = False
        frmMain.fraAds.ZOrder 1
    End If
    
    ' align logo
    frmMain.fraLogo.left = frmMain.tlbMain.buttons("logoplaceholder").left
    frmMain.fraLogo.top = frmMain.tlbMain.buttons("logoplaceholder").top
    frmMain.fraLogo.Width = frmMain.tlbMain.buttons("logoplaceholder").Width
    frmMain.fraLogo.Height = frmMain.tlbMain.buttons("logoplaceholder").Height
    
    ' Allign tools toolbar
    If toolbarOptions.ReadProperty("Cleaner") Or toolbarOptions.ReadProperty("PopupBlocker") Or toolbarOptions.ReadProperty("Translate") Then
        frmMain.fraButtons(0).Visible = True
        frmMain.tlbTools.ZOrder
    Else
        frmMain.fraButtons(0).Visible = False
        frmMain.tlbTools.ZOrder 1
    End If
       
    frmMain.fraButtons(0).left = frmMain.tlbMain.buttons("popupplaceholder").left
    frmMain.fraButtons(0).Width = frmMain.tlbMain.buttons("popupplaceholder").Width
    frmMain.fraButtons(0).top = frmMain.tlbMain.buttons("popupplaceholder").top
    frmMain.fraButtons(0).Height = frmMain.tlbMain.buttons("popupplaceholder").Height
    
    frmMain.tlbTools.left = frmMain.fraButtons(0).left
    frmMain.tlbTools.Width = frmMain.fraButtons(0).Width
    frmMain.tlbTools.Height = frmMain.fraButtons(0).Height
    frmMain.tlbTools.top = frmMain.fraButtons(0).top + (frmMain.fraButtons(0).Height - frmMain.tlbTools.ButtonHeight) / 2
        
    ' Allign combobox
    frmMain.fraCombo.left = frmMain.tlbMain.buttons("textplaceholder").left + 50
    frmMain.fraCombo.top = frmMain.tlbMain.buttons("textplaceholder").top
    frmMain.fraCombo.Width = frmMain.tlbMain.buttons("textplaceholder").Width
    frmMain.fraCombo.Height = frmMain.tlbMain.buttons("textplaceholder").Height
    
    frmMain.cmbSearch.left = 0
    frmMain.cmbSearch.Width = frmMain.fraCombo.Width - 100
    
    frmMain.cmbSearch.top = (frmMain.fraCombo.Height - frmMain.cmbSearch.Height) / 2
    
    ' Align button toolbars in button frames
    For i = 1 To iButtonsCount
        frmMain.fraButtons(i).left = frmMain.tlbMain.buttons("button" & i & "placeholder").left
        frmMain.fraButtons(i).Width = frmMain.tlbMain.buttons("button" & i & "placeholder").Width
        frmMain.fraButtons(i).top = frmMain.tlbMain.buttons("button" & i & "placeholder").top
        frmMain.fraButtons(i).Height = frmMain.tlbMain.buttons("button" & i & "placeholder").Height
                
        frmMain.tlbButtons(i).left = frmMain.fraButtons(i).left
        frmMain.tlbButtons(i).Width = frmMain.fraButtons(i).Width
        frmMain.tlbButtons(i).Height = frmMain.fraButtons(i).Height
        frmMain.tlbButtons(i).top = frmMain.fraButtons(i).top + (frmMain.fraButtons(i).Height - frmMain.tlbButtons(i).ButtonHeight) / 2
                
        frmMain.WebBrowser(i).left = frmMain.fraButtons(i).left + 50
        frmMain.WebBrowser(i).Width = frmMain.fraButtons(i).Width - 100
        frmMain.WebBrowser(i).Height = frmMain.fraButtons(i).Height
        frmMain.WebBrowser(i).top = frmMain.fraButtons(i).top
    Next i
    
    ' Allign Ad button
    frmMain.fraAds.left = frmMain.tlbMain.buttons("adplaceholder").left
    frmMain.fraAds.top = frmMain.tlbMain.buttons("adplaceholder").top
    frmMain.fraAds.Width = frmMain.tlbMain.buttons("adplaceholder").Width
    frmMain.fraAds.Height = frmMain.tlbMain.buttons("adplaceholder").Height
    
    If toolbarOptions.ReadProperty("AdStatic") Then
        frmMain.tlbAds.left = 50
        frmMain.tlbAds.top = (frmMain.fraAds.Height - frmMain.tlbAds.Height) / 2
        frmMain.tlbAds.Width = frmMain.fraAds.Width
    Else
        frmMain.wbrAds.Width = frmMain.fraAds.Width
        frmMain.wbrAds.Height = frmMain.tlbMain.Height - 10
        frmMain.wbrAds.left = 50
        frmMain.wbrAds.top = (frmMain.fraAds.Height - frmMain.wbrAds.Height) / 2
    End If
    
    ' Allign Tell A Frien button
    frmMain.fraTellAFriend.left = frmMain.tlbMain.buttons("tfplaceholder").left
    frmMain.fraTellAFriend.top = frmMain.tlbMain.buttons("tfplaceholder").top
    frmMain.fraTellAFriend.Width = frmMain.tlbMain.buttons("tfplaceholder").Width + 500
    frmMain.fraTellAFriend.Height = frmMain.tlbMain.buttons("tfplaceholder").Height
    
    frmMain.tlbTellAFriend.left = 0
    frmMain.tlbTellAFriend.top = (frmMain.fraTellAFriend.Height - frmMain.tlbTellAFriend.Height) / 2
    frmMain.tlbTellAFriend.Width = frmMain.fraTellAFriend.Width

End Sub


Public Function TextToPicture(ByVal strCaption As String, ByVal strFontName As String, ByVal iFontSize As Long, ByVal bFontBold As Boolean, ByVal bFontItalic, ByVal bFontUnderline As Boolean, ByVal bFontStrikethru As Boolean, ByVal iFontColor As Long) As Picture
    
    ' Init properties of PictureBox control and setup font
    frmMain.pbxLogo.AutoRedraw = True
    frmMain.pbxLogo.ForeColor = iFontColor
    frmMain.pbxLogo.FontSize = iFontSize
    frmMain.pbxLogo.FontBold = bFontBold
    frmMain.pbxLogo.FontItalic = bFontItalic
    frmMain.pbxLogo.FontStrikethru = bFontStrikethru
    If Len(strFontName) > 0 Then
        frmMain.pbxLogo.FontName = strFontName
    Else
        frmMain.pbxLogo.FontName = "Tahoma"
    End If

    ' Correct control size
    frmMain.pbxLogo.Width = frmMain.pbxLogo.TextWidth(strCaption)
    frmMain.pbxLogo.Height = frmMain.pbxLogo.TextHeight(strCaption)

    ' Clear control and draw text
    frmMain.pbxLogo.Cls
    frmMain.pbxLogo.Print strCaption

    ' Return drawed image
    Set TextToPicture = frmMain.pbxLogo.Image
End Function

Public Sub ImgResize(src As PictureBox, TmpPic As PictureBox, mWidth As Long, mHeight As Long)
    src.AutoRedraw = False
    TmpPic.AutoRedraw = True
    TmpPic.Height = mHeight '   picturebox
    TmpPic.Width = mWidth
    StretchBlt TmpPic.hdc, 0, 0, mWidth, mHeight, src.hdc, 0, 0, src.Width, src.Height, SRCCOPY
    '    
    SavePicture TmpPic.Image, App.Path + "\tempimg.bmp"
    '  picturebox
    src.AutoSize = True
    src.Picture = LoadPicture(App.Path + "\tempimg.bmp")
    '  
    Kill App.Path + "\tempimg.bmp"
    '  picturebox
    TmpPic.Picture = LoadPicture()
End Sub



