// MyClassFactory.cpp: implementation of the IMyClassFactory class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SearchHookObj.h"
#include "constants.h"
#include "resource.h"

// 
extern WORD g_nSrvRefCount;
extern HMODULE g_hThisModule;

const int	BUFFER_SIZE = 4096;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ISearchHook::ISearchHook() {

	HKEY	hKey;
	DWORD	dwType;
	DWORD	dwLen;
	char	buffer[BUFFER_SIZE];

	// Zero reference count
	m_nRefCount = 0;
	
	// Load search URL from registry
	if (ERROR_SUCCESS == RegOpenKeyEx(HKEY_CLASSES_ROOT, TEXT("CLSID\\") SERVER_GUID, 0, KEY_READ, &hKey)) {

		// Read Search URL and convert to UNICODE
		dwType = REG_SZ;
		dwLen = BUFFER_SIZE;
		RegQueryValueEx(hKey, TEXT("Search URL"), NULL, &dwType, (LPBYTE)buffer, &dwLen);
		
		m_strSearchURL = new WCHAR[dwLen + 2];
		ZeroMemory (m_strSearchURL, (dwLen + 2)*sizeof(WCHAR));
		MultiByteToWideChar(CP_THREAD_ACP, 0, buffer, strlen(buffer), m_strSearchURL, dwLen + 1);
	
		// Read Search Text and convert to UNICODE
		dwType = REG_SZ;
		dwLen = BUFFER_SIZE;
		RegQueryValueEx(hKey, TEXT("Search Text"), NULL, &dwType, (LPBYTE)buffer, &dwLen);
		
		m_strSearchText = new WCHAR[dwLen + 2];
		ZeroMemory (m_strSearchText, (dwLen + 2)*sizeof(WCHAR));
		MultiByteToWideChar(CP_THREAD_ACP, 0, buffer, strlen(buffer), m_strSearchText, dwLen + 1);

		RegCloseKey(hKey);
	}	
	
}

ISearchHook::~ISearchHook() {
	ASSERT(!m_nRefCount);

	delete m_strSearchURL;
	delete m_strSearchText;
}

//////////////////////////////////////////////////////////////////////
//  IUnknown
//////////////////////////////////////////////////////////////////////

STDMETHODIMP ISearchHook::QueryInterface(REFIID iid, void ** ppvObject) {
	
	if (!ppvObject)
		return E_INVALIDARG;

	*ppvObject=NULL;

	if (iid == IID_IUnknown)
		*ppvObject = this;
	else if (iid == IID_IURLSearchHook)
		*ppvObject = (IURLSearchHook*)this;

	if (*ppvObject)
	{
		AddRef();
		return S_OK;
	}

	return E_NOINTERFACE;
}

STDMETHODIMP_(ULONG) ISearchHook::AddRef() {
	g_nSrvRefCount++;
	return ++m_nRefCount;
}

STDMETHODIMP_(ULONG) ISearchHook::Release() {
	g_nSrvRefCount--;
	if (!--m_nRefCount) {
		delete this;
		return 0;
	}
	return m_nRefCount;
}

//////////////////////////////////////////////////////////////////////
//  IURLSearchHook
//////////////////////////////////////////////////////////////////////

//   
STDMETHODIMP ISearchHook::Translate(LPWSTR lpwszSearchURL, DWORD cchBufferSize) {

	WCHAR		*pSearchWorld;
	WCHAR		*pTemp;
	WCHAR		param[BUFFER_SIZE];
	WCHAR		buffer[BUFFER_SIZE];
	
	WCHAR		temp[10];

	ZeroMemory(temp, 20);
	
	MultiByteToWideChar(CP_THREAD_ACP, 0, ".", 2, temp, 10);

	// If empty parameter, do not nothing.
	if (!wcslen(lpwszSearchURL))
		return E_FAIL;

	// If registry is empty then not work.
	if (!wcslen(m_strSearchURL))
		return E_FAIL;

	// If there are "." in the string, this is possibly URL
	if (wcsstr(lpwszSearchURL, temp))
		return E_FAIL;

	// Store parameters
	wcscpy(param, lpwszSearchURL);

	// Copy new URL
	wcscpy(lpwszSearchURL, m_strSearchURL);

	pSearchWorld = wcsstr(lpwszSearchURL, m_strSearchText);
	if (pSearchWorld) {

		//TODO: replace SEARCH_TEXT to lpwszSearchURL Content
		pTemp = pSearchWorld;
		pSearchWorld += wcslen(m_strSearchText);
		wcscpy(buffer, pSearchWorld);
		*pTemp = 0;
		wcscat(lpwszSearchURL, param);
		wcscat(lpwszSearchURL, buffer);
		
		return S_OK;
	}

	return E_FAIL;
}
