Attribute VB_Name = "modReg"
Option Explicit

Public Const HKEY_CLASSES_ROOT = &H80000000
Public Const HKEY_CURRENT_USER = &H80000001
Public Const HKEY_LOCAL_MACHINE = &H80000002
Public Const HKEY_USERS = &H80000003
Public Const KEY_ALL_ACCESS = &H3F
Public Const REG_OPTION_NON_VOLATILE = 0&
Public Const REG_CREATED_NEW_KEY = &H1
Public Const REG_OPENED_EXISTING_KEY = &H2
Public Const ERROR_SUCCESS = 0&
Public Const REG_SZ = (1)

Type SECURITY_ATTRIBUTES
    
    nLength As Long
    lpSecurityDescriptor As Long
    bInheritHandle As Boolean

End Type

Public Const SUB_KEY = "SOFTWARE\ETBPB"

Declare Function RegEnumValue Lib "advapi32.dll" Alias "RegEnumValueA" (ByVal hKey As Long, ByVal dwIndex As Long, ByVal lpValueName As String, lpcbValueName As Long, ByVal lpReserved As Long, lpType As Long, ByVal lpData As String, lpcbData As Long) As Long
Declare Function RegOpenKeyEx Lib "advapi32" Alias "RegOpenKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal ulOptions As Long, ByVal samDesired As Long, phkResult As Long) As Long
Declare Function RegSetValueEx Lib "advapi32" Alias "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, ByVal szData As String, ByVal cbData As Long) As Long
Declare Function RegCloseKey Lib "advapi32" (ByVal hKey As Long) As Long
Declare Function RegCreateKeyEx Lib "advapi32" Alias "RegCreateKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal Reserved As Long, ByVal lpClass As String, ByVal dwOptions As Long, ByVal samDesired As Long, lpSecurityAttributes As SECURITY_ATTRIBUTES, phkResult As Long, lpdwDisposition As Long) As Long
Declare Function RegCreateKey Lib "advapi32.dll" Alias "RegCreateKeyA" (ByVal hKey As Long, ByVal lpSubKey As String, phkResult As Long) As Long
Declare Function RegDeleteValue Lib "advapi32.dll" Alias "RegDeleteValueA" (ByVal hKey As Long, ByVal lpValueName As String) As Long
Declare Function RegDeleteKey Lib "advapi32.dll" Alias "RegDeleteKeyA" (ByVal hKey As Long, ByVal lpValueName As String) As Long
Declare Function RegQueryValueEx Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, ByVal lpData As String, lpcbData As Long) As Long


Public Function SetRegistryValue(ByVal sKeyName As String, ByVal sKeyValue As String, Optional sSubKey As String = "") As Boolean
    On Error Resume Next
    Dim phkResult As Long
    Dim lResult As Long
    Dim SA As SECURITY_ATTRIBUTES
    Dim lCreate As Long
    RegCreateKeyEx HKEY_LOCAL_MACHINE, SUB_KEY & sSubKey, 0, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, SA, phkResult, lCreate
    lResult = RegSetValueEx(phkResult, sKeyName, 0, REG_SZ, sKeyValue, CLng(Len(sKeyValue) + 1))
    RegCloseKey phkResult
    SetRegistryValue = (lResult = ERROR_SUCCESS)
End Function



Public Function GetRegistryValue(ByVal hKey As Long, ByVal strKeyName As String, ByVal strValueName As String) As String
    
    Dim phkResult As Long
    Dim szBuffer As String
    Dim dwBufferSize As Long
    Dim lResult As Long
        
    szBuffer = String(255, 0)
    dwBufferSize = Len(szBuffer)

    lResult = RegOpenKeyEx(hKey, strKeyName, 0, 1, phkResult)
    lResult = RegQueryValueEx(phkResult, strValueName, 0, 1, szBuffer, dwBufferSize)
    RegCloseKey phkResult
    szBuffer = Left(szBuffer, dwBufferSize - 1)
    
    GetRegistryValue = szBuffer
End Function



Public Function DelRegistryValue(sSubKey As String, sValueName As String)
    Dim phkResult As Long
    RegCreateKey HKEY_LOCAL_MACHINE, SUB_KEY & sSubKey, phkResult
    RegDeleteValue phkResult, sValueName
    RegCloseKey phkResult
End Function



Public Function DelRegistryKey(ByVal hKey As Long, strSubKey As String, strKeyName As String)
    Dim phkResult As Long
    RegCreateKey hKey, strSubKey, phkResult
    RegDeleteKey phkResult, strKeyName
    RegCloseKey phkResult
End Function



Public Sub GetRegistryValues(List As ListBox, Optional sSubKey As String = "")
    Dim dwIndex As Long
    Dim dwResult As Long
    Dim phkResult As Long
    Dim szBuffer1 As String
    Dim dwBufferSize1 As Long
    Dim szBuffer2 As String
    Dim dwBufferSize2 As Long
    Dim dwReserved As Long
    Dim dwType As Long
    Dim sKeyValue As String
    Dim bFound As Boolean
    
    dwResult = RegOpenKeyEx(HKEY_LOCAL_MACHINE, SUB_KEY & sSubKey, 0, 1, phkResult)
    Do While dwResult = ERROR_SUCCESS And Not (bFound)
        szBuffer1 = Space(255)
        dwBufferSize1 = Len(szBuffer1)
        szBuffer2 = Space(255)
        dwBufferSize2 = Len(szBuffer2)
        dwResult = RegEnumValue(phkResult, dwIndex, szBuffer1, dwBufferSize1, dwReserved, dwType, szBuffer2, dwBufferSize2)
        If dwResult = ERROR_SUCCESS Then
            sKeyValue = Left(szBuffer1, dwBufferSize1)
            List.AddItem sKeyValue
            sKeyValue = Left(szBuffer2, dwBufferSize2 - 1)
            If sKeyValue = "1" Then List.Selected(List.ListCount - 1) = True
        End If
        dwIndex = dwIndex + 1
    Loop
    RegCloseKey phkResult
End Sub
