// MyClassFactory.cpp: implementation of the IMyClassFactory class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MyClassFactory.h"
#include "SearchHookObj.h"
#include "constants.h"

// 
extern WORD g_nSrvRefCount;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

IMyClassFactory::IMyClassFactory()
{
	m_nRefCount=0;
}

IMyClassFactory::~IMyClassFactory()
{
	ASSERT(!m_nRefCount);
}

//////////////////////////////////////////////////////////////////////
//  IUnknown
//////////////////////////////////////////////////////////////////////

STDMETHODIMP IMyClassFactory::QueryInterface(REFIID iid, void ** ppvObject)
{
	if (!ppvObject)
		return E_INVALIDARG;

	*ppvObject=NULL;

	if (iid == IID_IUnknown)
		*ppvObject=(IUnknown*)this;
	else if (iid == IID_IClassFactory)
		*ppvObject=(IClassFactory*)this;

	if (*ppvObject)
	{
		AddRef();
		return S_OK;
	}

	return E_NOINTERFACE;
}

STDMETHODIMP_(ULONG) IMyClassFactory::AddRef()
{
	g_nSrvRefCount++;
	return ++m_nRefCount;
}

STDMETHODIMP_(ULONG) IMyClassFactory::Release()
{
	g_nSrvRefCount--;
	if (!--m_nRefCount)
	{
		delete this;
		return 0;
	}
	return m_nRefCount;
}

//////////////////////////////////////////////////////////////////////
//  IClassFactory
//////////////////////////////////////////////////////////////////////

STDMETHODIMP IMyClassFactory::CreateInstance(IUnknown *pUnkOuter, REFIID riid, void **ppvObject)
{
	if (!ppvObject)
		return E_INVALIDARG;
	if (pUnkOuter)
		return CLASS_E_NOAGGREGATION;

	*ppvObject=NULL;
	HRESULT hr=E_NOINTERFACE;

	ISearchHook *pExt = new ISearchHook();

	if (!pExt)
		return E_OUTOFMEMORY;

	hr=pExt->QueryInterface(riid, ppvObject);
	if (SUCCEEDED(hr))
		return S_OK;

	delete pExt;
	return hr;
}

STDMETHODIMP IMyClassFactory::LockServer(BOOL bLock)
{
	if (bLock)
		g_nSrvRefCount++;
	else
		g_nSrvRefCount--;
	return S_OK;
}