unit mainf;

interface

uses
  Windows, Messages, Graphics, Controls, Forms, Dialogs, StdCtrls, ExtCtrls, ComCtrls,
  Menus,  SysUtils, Classes, IdIntercept, IdBaseComponent, IdComponent, IdTCPConnection,
  IdTCPClient, IdFTP, IdAntiFreezeBase, IdAntiFreeze, IdLogBase, IdLogDebug, IdGlobal,
  IdLogEvent, IdFTPCommon, IdFTPList, ShellAPI, DropSource, ImgList,
  DropTarget, ActiveX, ShlObj, ComObj, XPMan, FileCtrl, SkinCaption,
  WinSkinData;

type
  TMainForm = class(TForm)
    IdFTP1: TIdFTP;
    DebugListBox: TListBox;
    Panel1: TPanel;
    FtpServerEdit: TEdit;
    ConnectButton: TButton;
    Splitter1: TSplitter;
    Label1: TLabel;
    UploadOpenDialog1: TOpenDialog;
    Panel3: TPanel;
    SaveDialog1: TSaveDialog;
    StatusBar1: TStatusBar;
    TraceCheckBox: TCheckBox;
    CommandPanel: TPanel;
    UploadButton: TButton;
    AbortButton: TButton;
    BackButton: TButton;
    DeleteButton: TButton;
    DownloadButton: TButton;
    UserIDEdit: TEdit;
    PasswordEdit: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    IdAntiFreeze1: TIdAntiFreeze;
    ProgressBar1: TProgressBar;
    UsePassive: TCheckBox;
    CurrentDirEdit: TEdit;
    ChDirButton: TButton;
    CreateDirButton: TButton;
    PopupMenu1: TPopupMenu;
    Download1: TMenuItem;
    Upload1: TMenuItem;
    Delete1: TMenuItem;
    N1: TMenuItem;
    Back1: TMenuItem;
    IdLogEvent1: TIdLogEvent;
    DropSource1: TDropFileSource;
    DirectoryListBox: TListView;
    ImageList1: TImageList;
    DropFileTarget1: TDropFileTarget;
    MainMenu: TMainMenu;
    Language1: TMenuItem;
    English1: TMenuItem;
    N2: TMenuItem;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Splitter2: TSplitter;
    Panel2: TPanel;
    Splitter3: TSplitter;
    Panel4: TPanel;
    XPManifest1: TXPManifest;
    Button1: TButton;
    List: TFileListBox;
    Tree: TDirectoryListBox;
    Panel5: TPanel;
    DriveComboBox1: TDriveComboBox;
    Bevel1: TBevel;
    Image1: TImage;
    Image2: TImage;
    ComboBox1: TComboBox;
    Label4: TLabel;
    Panel6: TPanel;
    CommandEdit: TEdit;
    Label5: TLabel;
    N3: TMenuItem;
    CHMOD1: TMenuItem;
    N7771: TMenuItem;
    N7551: TMenuItem;
    N6441: TMenuItem;
    SkinData: TSkinData;
    SkinCaption: TSkinCaption;
    procedure ConnectButtonClick(Sender: TObject);
    procedure UploadButtonClick(Sender: TObject);
    procedure DirectoryListBoxDblClick(Sender: TObject);
    procedure DeleteButtonClick(Sender: TObject);
    procedure IdFTP1Disconnected(Sender: TObject);
    procedure AbortButtonClick(Sender: TObject);
    procedure BackButtonClick(Sender: TObject);
    procedure IdFTP1Status(axSender: TObject; const axStatus: TIdStatus;
      const asStatusText: String);
    procedure TraceCheckBoxClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DirectoryListBoxClick(Sender: TObject);
    procedure IdFTP1Work(Sender: TObject; AWorkMode: TWorkMode;
      const AWorkCount: Integer);
    procedure IdFTP1WorkBegin(Sender: TObject; AWorkMode: TWorkMode;
      const AWorkCountMax: Integer);
    procedure IdFTP1WorkEnd(Sender: TObject; AWorkMode: TWorkMode);
    procedure UsePassiveClick(Sender: TObject);
    procedure ChDirButtonClick(Sender: TObject);
    procedure CreateDirButtonClick(Sender: TObject);
    procedure IdLogEvent1Received(ASender: TComponent; const AText,
      AData: String);
    procedure IdLogEvent1Sent(ASender: TComponent; const AText,
      AData: String);
    procedure DebugListBoxDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure WMDropFiles(var Message: TWMDropFiles); message WM_DROPFILES;
    procedure DirectoryListBoxMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure DirectoryListBoxMouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer);
    procedure DropFileTarget1Drop(Sender: TObject; ShiftState: TShiftState;
      Point: TPoint; var Effect: Integer);
    procedure DropFileTarget1GetDropEffect(Sender: TObject;
      ShiftState: TShiftState; Point: TPoint; var Effect: Integer);
    procedure FormDestroy(Sender: TObject);
    procedure DropSource1Drop(Sender: TObject; DragType: TDragType;
      var ContinueDrop: Boolean);
    procedure Exit1Click(Sender: TObject);
    procedure LanguageChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure CommandEditKeyPress(Sender: TObject; var Key: Char);
    procedure PasswordEditKeyPress(Sender: TObject; var Key: Char);
    procedure N6441Click(Sender: TObject);
    procedure DirectoryListBoxColumnClick(Sender: TObject;
      Column: TListColumn);
    procedure DownloadButtonClick(Sender: TObject);
    procedure ListDblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Aux: TStrings;
    LanguageFile: String;
    DragPoint: TPoint;
    SourcePath: string;

    AbortTransfer: Boolean;
    TransferrignData: Boolean;
    BytesToTransfer: LongWord;
    STime: TDateTime;
    procedure ChangeDir(DirName: String);
    procedure SetFunctionButtons(AValue: Boolean);
    procedure SaveFTPHostInfo(Datatext, header: String);
    function GetHostInfo(header: String): String;
    procedure PutToDebugLog(Operation, S1: String);
    procedure InitLanguage(FileName, Section: String);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

Uses
  IniFiles;

Var
  AverageSpeed: Double = 0;

procedure TMainForm.SetFunctionButtons(AValue: Boolean);
Var
  i: Integer;
begin
  with CommandPanel do
    for i := 0 to ControlCount - 1 do
      if Controls[i].Name <> 'AbortButton' then Controls[i].Enabled := AValue;

  with PopupMenu1 do
    for i := 0 to Items.Count - 1 do Items[i].Enabled := AValue;

  ChDirButton.Enabled := AValue;
  CreateDirButton.Enabled := AValue;
end;

procedure TMainForm.ConnectButtonClick(Sender: TObject);
begin
  ConnectButton.Enabled := false;
  if IdFTP1.Connected then try
    if TransferrignData then IdFTP1.Abort;
    IdFTP1.Quit;
  finally
    CurrentDirEdit.Text := '/';
    DirectoryListBox.Items.BeginUpdate;
    DirectoryListBox.Items.Clear;
    DirectoryListBox.Items.EndUpdate;
    SetFunctionButtons(false);
    ConnectButton.Caption := 'Connect';
    ConnectButton.Enabled := true;
    ConnectButton.Default := true;
  end
  else with IdFTP1 do try
    Username := UserIDEdit.Text;
    Password := PasswordEdit.Text;
    Host := FtpServerEdit.Text;
    Connect;
    Self.ChangeDir(CurrentDirEdit.Text);
    SetFunctionButtons(true);
    SaveFTPHostInfo(FtpServerEdit.Text, 'FTPHOST');
  finally
    ConnectButton.Enabled := true;
    if Connected then begin
      ConnectButton.Caption := 'Disconnect';
      ConnectButton.Default := false;
    end;
  end;
end;

procedure TMainForm.UploadButtonClick(Sender: TObject);
begin
  if IdFTP1.Connected then begin
    if UploadOpenDialog1.Execute then try
      SetFunctionButtons(false);

      IdFTP1.Put(UploadOpenDialog1.FileName, ExtractFileName(UploadOpenDialog1.FileName));
      ChangeDir(idftp1.RetrieveCurrentDir);
    finally
      SetFunctionButtons(true);
    end;
  end;
end;

function Process(S: String): String;
var res: integer;
begin
  res := 0;
  if S[1] = 'r' then res:=res+4;
  if S[2] = 'w' then res:=res+2;
  if S[3] = 'x' then res:=res+1;
  Result := IntToStr(Res);
end;

procedure TMainForm.ChangeDir(DirName: String);
Var
  LS: TStringList;
  I: Integer;
  NewItem: TListItem;
begin
  LS := TStringList.Create;
  try
    SetFunctionButtons(false);
    IdFTP1.ChangeDir(DirName);

    CurrentDirEdit.Text := IdFTP1.RetrieveCurrentDir;

    DirectoryListBox.Items.BeginUpdate;
    DirectoryListBox.Items.Clear;
    DirectoryListBox.Items.EndUpdate;
    IdFTP1.List(LS);

    { we must do this... }
//    DirectoryListBox.Items.Assign(LS);
    { and we do it like this... }
    NewItem := DirectoryListBox.Items.Add;
    NewItem.Caption := '[.]';
    NewItem.SubItems.Add('Directory');
    NewItem.ImageIndex := 1;
    NewItem := DirectoryListBox.Items.Add;
    NewItem.Caption := '[..]';
    NewItem.SubItems.Add('Directory');
    NewItem.ImageIndex := 1;

    for I:=0 to LS.Count-1 do
     with IdFTP1.DirectoryListing.Items[I] do
     if (FileName <> '.') and (Filename <> '..') then
     begin
       NewItem := DirectoryListBox.Items.Add;
       NewItem.Caption := FileName;
       if ItemType = ditDirectory then
         NewItem.SubItems.Add('Directory')
       else
         NewItem.SubItems.Add('File');
       NewItem.SubItems.Add(FloatToStrF(Size, ffNumber, 18, 0));
       NewItem.SubItems.Add(FormatDateTime('mm/dd/yyyy hh:mm', ModifiedDate));
       NewItem.SubItems.Add(GroupName);
       NewItem.SubItems.Add(OwnerName);
       NewItem.SubItems.Add(OwnerPermissions + GroupPermissions + UserPermissions + ' ('+Process(OwnerPermissions)+Process(GroupPermissions)+Process(UserPermissions)+')');
       if IdFTP1.DirectoryListing.Items[I].ItemType = ditDirectory then
        NewItem.ImageIndex := 1
       else
        NewItem.ImageIndex := 0;
     end;

{    if DirectoryListBox.Items.Count > 0 then
      DirectoryListBox.Items.Clear;
      if AnsiPos('total', DirectoryListBox.Items[0]) > 0 then DirectoryListBox.Items.Delete(0);
}  finally
    SetFunctionButtons(true);
    LS.Free;
  end;
end;

procedure TMainForm.DirectoryListBoxDblClick(Sender: TObject);
Var
  Name{, Line}: String; I: Integer;
begin
  if DirectoryListBox.ItemIndex < 0 then
   begin
    ShowMessage('No item selected!');
    Exit;
   end;
  if not IdFTP1.Connected then exit;
  //Line := DirectoryListBox.Items[DirectoryListBox.ItemIndex];

  for I:=0 to DirectoryListBox.Items.Count-1 do
  if DirectoryListBox.Items[I].Selected then
  begin

  Name := DirectoryListBox.Items[I].Caption;//IdFTP1.DirectoryListing.Items[DirectoryListBox.ItemIndex].FileName;
  if Name = '[..]' then
  begin
   BackButtonClick(Self);
   Exit;
  end
  else
  if Name = '[.]' then
  begin
    ChangeDir('.');
    Exit;
  end;

  if {IdFTP1.DirectoryListing.Items[DirectoryListBox.ItemIndex].ItemType = ditDirectory} DirectoryListBox.Selected.SubItems[0] = 'Directory' then begin
    // Change directory
    SetFunctionButtons(false);
    ChangeDir(Name);
    SetFunctionButtons(true);
    Exit;
  end
  else begin
    try
        SetFunctionButtons(false);

        BytesToTransfer := IdFTP1.Size(Name);

        if FileExists(Name) then begin
          case MessageDlg('File "'+Name+'" already exists. Do you want to resume the download operation? Choosing No will retransfer the entire file.',
            mtConfirmation, mbYesNoCancel, 0) of
            mrYes: begin
              BytesToTransfer := BytesToTransfer - FileSizeByName(Name);
              IdFTP1.Get(Name, Tree.Directory+'\'+Name, false, true);
            end;
            mrNo: begin
              IdFTP1.Get(Name, Tree.Directory+'\'+Name, true);
            end;
            mrCancel: begin
              exit;
            end;
          end;
        end
        else begin
          IdFTP1.Get(Name, Tree.Directory+'\'+Name, false);
        end;
//      end;
    finally
      SetFunctionButtons(true);
    end;
  end;
  end;
end;

procedure TMainForm.DeleteButtonClick(Sender: TObject);

procedure DeleteDir(Name: String);
var I: Integer;
    Files, Dirs: TStringList;
begin
  Files := TStringList.Create;
  Dirs := TStringList.Create;

  ChangeDir(Name); // go to this directory

  for I:=0 to DirectoryListBox.Items.Count-1 do
   if DirectoryListBox.Items[I].ImageIndex = 0 then // file
     Files.Add(DirectoryListBox.Items[I].Caption)
   else
    if (DirectoryListBox.Items[I].Caption <> '[.]') and (DirectoryListBox.Items[I].Caption <> '[..]') then // dir
     Dirs.Add(DirectoryListBox.Items[I].Caption);

  for I:=0 to Files.Count-1 do
  begin
    try
      idftp1.Delete(Files[I]);
    except
    end;
    ChangeDir(idFTP1.RetrieveCurrentDir);
  end;
  for I:=0 to Dirs.Count-1 do
    DeleteDir(Dirs[I]); // recursive delete

  ChangeDir('..');
  idFTP1.RemoveDir(Name);
  ChangeDir(idFTP1.RetrieveCurrentDir);

  Files.Free;
  Dirs.Free;
end;

Var
  Name: String;
  DList, FList: TStringList;
  I: Integer;
begin
  try
  if not IdFTP1.Connected then exit;
  if Application.MessageBox(PChar('Are you sure you want to delete selected file(s) ?'), 'Warning',MB_YESNO+MB_ICONQUESTION)=mrNo then Exit;

  FList := TStringList.Create; DList := TStringList.Create;
  for I:=0 to DirectoryListBox.Items.Count-1 do
  if DirectoryListBox.Items[I].Selected then
    if DirectoryListBox.Items[I].SubItems[0] = 'Directory' {IdFTP1.DirectoryListing.Items[DirectoryListBox.ItemIndex].ItemType = ditDirectory} then
      DList.Add(DirectoryListBox.Items[I].Caption)
    else
      FList.Add(DirectoryListBox.Items[I].Caption);

  for I:=0 to DList.Count-1 do
  begin
    Name := DList[I];
    SetFunctionButtons(false);
    DeleteDir(Name);
    SetFunctionButtons(true);
  end;

  for I:=0 to FList.Count-1 do
  begin
    Name := FList[I];
    SetFunctionButtons(false);
    try
     idftp1.Delete(Name);
    except
    end;
    ChangeDir(idftp1.RetrieveCurrentDir);
  end;
  FList.Free;
  DList.Free;
  except
  end;
end;

procedure TMainForm.IdFTP1Disconnected(Sender: TObject);
begin
  StatusBar1.Panels[1].Text := 'Disconnected.';
end;

procedure TMainForm.AbortButtonClick(Sender: TObject);
begin
  AbortTransfer := true;
end;

procedure TMainForm.BackButtonClick(Sender: TObject);
begin
  if not IdFTP1.Connected then exit;
  try
    ChangeDir('..');
  finally end;
end;

procedure TMainForm.IdFTP1Status(axSender: TObject; const axStatus: TIdStatus;
  const asStatusText: String);
begin
  DebugListBox.ItemIndex := DebugListBox.Items.Add(asStatusText);
  StatusBar1.Panels[1].Text := asStatusText;
end;

procedure TMainForm.TraceCheckBoxClick(Sender: TObject);
begin
  if TraceCheckBox.Checked then
    IdFtp1.Intercept := IdLogEvent1
  else
    IdFtp1.Intercept := nil;

  DebugListBox.Visible := TraceCheckBox.Checked;
  if DebugListBox.Visible then Splitter1.Top := DebugListBox.Top + 5;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  SearchRec: TSearchRec;
  Item: TMenuItem;
begin
  { look for *.lng files }
  LanguageFile := 'English.lng';
  if FindFirst(ExtractFilePath(ParamStr(0))+'Language\*.lng', faAnyFile, SearchRec) = 0 then
  try
    repeat
      // listbox1.items.add(searchrec.name);
      if UpperCase(ExtractFileName(SearchRec.Name)) <> UpperCase('English.lng') then
      begin
        Item := TMenuItem.Create(Self);
        try
         Item.Caption := Copy(SearchRec.Name,1,Length(SearchRec.Name)-4);
         Item.RadioItem := True;
         Item.GroupIndex := 10;
         Item.OnClick := LanguageChange;
         Language1.Add(Item);
        except
        end;
      end;
    until
      Findnext(SearchRec) <> 0;
  finally
    FindClose(SearchRec);
  end;

  Aux := TStringList.Create;

  DragAcceptFiles(Handle, True);
  SetFunctionButtons(false);

  IdFtp1.Intercept := IdLogEvent1;

  FtpServerEdit.Text := GetHostInfo('FTPHOST');

  ProgressBar1.Parent := StatusBar1;
  ProgressBar1.Top := 2;
  ProgressBar1.Left := 1;
  ProgressBar1.Align := alClient;
end;

procedure TMainForm.DirectoryListBoxClick(Sender: TObject);
begin
  if not IdFTP1.Connected then exit;
(*  if DirectoryListBox.ItemIndex > -1 then begin
  if DirectoryListBox.Selected.SubItems[0] = 'Directory'{IdFTP1.DirectoryListing.Items[DirectoryListBox.ItemIndex].ItemType = ditDirectory} then DownloadButton.Caption := 'Change dir'
    else DownloadButton.Caption := 'Download';
  end;*)
end;

procedure TMainForm.IdFTP1Work(Sender: TObject; AWorkMode: TWorkMode;
  const AWorkCount: Integer);
Var
  S: String;
  TotalTime: TDateTime;
//  RemainingTime: TDateTime;
  H, M, Sec, MS: Word;
  DLTime: Double;
begin
  TotalTime :=  Now - STime;
  DecodeTime(TotalTime, H, M, Sec, MS);
  Sec := Sec + M * 60 + H * 3600;
  DLTime := Sec + MS / 1000;
  if DLTime > 0 then
    AverageSpeed := {(AverageSpeed + }(AWorkCount / 1024) / DLTime{) / 2};

  if AverageSpeed > 0 then begin
    Sec := Trunc(((ProgressBar1.Max - AWorkCount) / 1024) / AverageSpeed);

    S := Format('%2d:%2d:%2d', [Sec div 3600, (Sec div 60) mod 60, Sec mod 60]);

    S := 'Time remaining ' + S;
  end
  else S := '';

  S := FormatFloat('0.00 KB/s', AverageSpeed) + '; ' + S;
  case AWorkMode of
    wmRead: StatusBar1.Panels[1].Text := 'Download speed ' + S;
    wmWrite: StatusBar1.Panels[1].Text := 'Upload speed ' + S;
  end;

  if AbortTransfer then IdFTP1.Abort;

  ProgressBar1.Position := AWorkCount;
  AbortTransfer := false;
end;

procedure TMainForm.IdFTP1WorkBegin(Sender: TObject; AWorkMode: TWorkMode;
  const AWorkCountMax: Integer);
begin
  TransferrignData := true;
  AbortButton.Visible := true;
  AbortTransfer := false;
  STime := Now;
  if AWorkCountMax > 0 then ProgressBar1.Max := AWorkCountMax
  else ProgressBar1.Max := BytesToTransfer;
  AverageSpeed := 0;
end;

procedure TMainForm.IdFTP1WorkEnd(Sender: TObject; AWorkMode: TWorkMode);
begin
  AbortButton.Visible := false;
  StatusBar1.Panels[1].Text := 'Transfer complete.';
  BytesToTransfer := 0;
  TransferrignData := false;
  ProgressBar1.Position := 0;
  AverageSpeed := 0;
end;

procedure TMainForm.UsePassiveClick(Sender: TObject);
begin
  IdFTP1.Passive := UsePassive.Checked;
end;

procedure TMainForm.ChDirButtonClick(Sender: TObject);
begin
  SetFunctionButtons(false);
  ChangeDir(CurrentDirEdit.Text);
  SetFunctionButtons(true);
end;

procedure TMainForm.CreateDirButtonClick(Sender: TObject);
Var
  S: String;
begin
  S := InputBox('Make new directory', 'Name', '');
  if S <> '' then
    try
      SetFunctionButtons(false);
      IdFTP1.MakeDir(S);
      ChangeDir(CurrentDirEdit.Text);
    finally
      SetFunctionButtons(true);
    end;
end;

procedure TMainForm.SaveFTPHostInfo(Datatext, header: String);
var
  ServerIni: TIniFile;
begin
  ServerIni := TIniFile.Create(ExtractFilePath(ParamStr(0)) + 'FtpHost.ini');
  ServerIni.WriteString('Server', header, Datatext);
  ServerIni.UpdateFile;
  ServerIni.Free;
end;

function TMainForm.GetHostInfo(header: String): String;
var
  ServerName: String;
  ServerIni: TIniFile;
begin
  ServerIni := TIniFile.Create(ExtractFilePath(ParamStr(0)) + 'FtpHost.ini');
  ServerName := ServerIni.ReadString('Server', header, header);

  ServerIni.Free;
  result := ServerName;
end;

procedure TMainForm.PutToDebugLog(Operation, S1: String);
Var
  S: String;
begin
  while Length(S1) > 0 do begin
    if Pos(#13, S1) > 0 then begin
      S := Copy(S1, 1, Pos(#13, S1) - 1);
      Delete(S1, 1, Pos(#13, S1));
      if S1[1] = #10 then Delete(S1, 1, 1);
    end
    else
      S := S1;

    DebugListBox.ItemIndex := DebugListBox.Items.Add(Operation + S);
  end;
end;

procedure TMainForm.IdLogEvent1Received(ASender: TComponent; const AText,
  AData: String);
begin
  PutToDebugLog('<<- ', AData);
end;

procedure TMainForm.IdLogEvent1Sent(ASender: TComponent; const AText,
  AData: String);
begin
  PutToDebugLog('->> ', AData);
end;

procedure TMainForm.DebugListBoxDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
begin
  if Pos('>>', DebugListBox.Items[index]) > 1 then
    DebugListBox.Canvas.Font.Color := clRed
  else
    DebugListBox.Canvas.Font.Color := clBlue;

  if odSelected in State then begin
    DebugListBox.Canvas.Brush.Color := $00895F0A;
    DebugListBox.Canvas.Font.Color := clWhite;
  end
  else
    DebugListBox.Canvas.Brush.Color := clWindow;

  DebugListBox.Canvas.FillRect(Rect);

  DebugListBox.Canvas.TextOut(Rect.Left, Rect.Top, DebugListBox.Items[index]);
end;

procedure TMainForm.WMDropFiles(var Message: TWMDropFiles);
// The WM_DROPFILES message is sent when the user releases the left mouse button
//    while the cursor is in the window of an application that has registered
//    itself as a recipient of dropped files.
var
  FNumFiles: Integer;
  i: Integer;
  BufSize: Integer;
  FFilePath: array of char;
  FFileName: string;

begin
  // How many files were dropped ?
  FNumFiles := DragQueryFile(Message.Drop, $FFFFFFFF, nil, 0);
  // Process all files in the list
  for i := 0 to FNumFiles - 1 do
  begin
    // Get the buffer size to old the filename
    BufSize := DragQueryFile(Message.Drop, i, nil, 0);
    // Get filename. This filename is a null-terminated string.
    SetLength(FFilePath, BufSize + 1);
    DragQueryFile(Message.Drop, i, PChar(FFilePath), BufSize + 1);
    // Check if the dropped file extension can be accepted
    FFileName := PChar(FFilePath);

    // DO WHATEVER YOU NEED
    { Upload each file... }
    if not DirectoryExists(FFileName) then
     if IdFTP1.Connected then begin
      try
        SetFunctionButtons(false);

        IdFTP1.Put(FFileName, ExtractFileName(FFileName));
        ChangeDir(idftp1.RetrieveCurrentDir);
      finally
        SetFunctionButtons(true);
      end;
    end;
   end;
  // The DragFinish function releases memory that Windows allocated for use in
  //    transferring filenames to the application.
  DragFinish(Message.Drop);
end;

procedure TMainForm.DirectoryListBoxMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  DragPoint := Point(X,Y);
end;

//******************* CreateLink *************************
procedure CreateLink(SourceFile, ShortCutName: String);
var
  IUnk: IUnknown;
  ShellLink: IShellLink;
  IPFile: IPersistFile;
  tmpShortCutName: string;
  WideStr: WideString;
  i: integer;
begin
  IUnk := CreateComObject(CLSID_ShellLink);
  ShellLink := IUnk as IShellLink;
  IPFile  := IUnk as IPersistFile;
  with ShellLink do
  begin
    SetPath(PChar(SourceFile));
    SetWorkingDirectory(PChar(ExtractFilePath(SourceFile)));
  end;
  ShortCutName := ChangeFileExt(ShortCutName,'.lnk');
  if fileexists(ShortCutName) then
  begin
    ShortCutName := copy(ShortCutName,1,length(ShortCutName)-4);
    i := 1;
    repeat
      tmpShortCutName := ShortCutName +'(' + inttostr(i)+ ').lnk';
      inc(i);
    until not fileexists(tmpShortCutName);
    WideStr := tmpShortCutName;
  end
  else WideStr := ShortCutName;
  IPFile.Save(PWChar(WideStr),False);
end;

//******************* AddSlash *************************
function AddSlash(path: string): string;
begin
  if (length(path) = 0) or (path[length(path)]='\') then
    result := path
  else result := path +'\';
end;

procedure TMainForm.DirectoryListBoxMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);

function Exists(S: String): Boolean;
var I: Integer;
begin
 for I:=0 to Aux.Count-1 do
  if UpperCase(Aux[I]) = UpperCase(S) then
   begin
    Result := True;
    Exit;
   end;
 Result := False;
end;

var
  i: integer;
  Filename: string;
  Res: TDragResult;
begin
  //Make sure mouse has moved at least 10 pixels before starting drag ...
  if (DragPoint.X = -1) or ((Shift <> [ssLeft]) and (Shift <> [ssRight])) or
     ((abs(DragPoint.X - X) <10) and (abs(DragPoint.Y - Y) <10)) then exit;
  //If no files selected then exit...
  if DirectoryListBox.SelCount = 0 then exit;

  DropSource1.Files.clear;
  //DropSource1.MappedNames.clear;

  //Fill DropSource1.Files with selected files in ListView1
  for i := 0 to DirectoryListBox.items.Count-1 do
    if (DirectoryListBox.items.item[i].Selected) then
    begin
      Filename := IdFTP1.DirectoryListing.Items[I].FileName;
      if IdFTP1.DirectoryListing.Items[I].ItemType <> ditDirectory then
       if not Exists(IdFTP1.DirectoryListing.Items[I].FileName) then
       begin
         Aux.Add(IdFTP1.DirectoryListing.Items[I].FileName);
         DropSource1.Files.Add(ExtractFilePath(Application.ExeName)+'Temp\'+Filename);
         //DropSource1.MappedNames.Add('NewFileName'+inttostr(i+1));
       end;
    end;

  DropFileTarget1.Dragtypes := [];
  if not DirectoryExists(ExtractFilePath(Application.ExeName)+'Temp') then
   MkDir(ExtractFilePath(Application.ExeName)+'Temp');
  //--------------------------
    res := DropSource1.execute;
  //--------------------------
  DropFileTarget1.Dragtypes := [dtMove];
  // delete temporary files
  for I:=0 to Aux.Count-1 do
   DeleteFile(ExtractFilePath(Application.ExeName)+'Temp\'+Aux[I]);
  Aux.Clear;
  RmDir(ExtractFilePath(Application.ExeName)+'Temp');

  //Note:
  //The target is responsible from this point on
  //for the copying/moving/linking of the file
  //but the target feeds back to the source what
  //(should have) happened via the returned value of Execute.

end;

procedure TMainForm.DropFileTarget1Drop(Sender: TObject;
  ShiftState: TShiftState; Point: TPoint; var Effect: Integer);
//var
//  i, SuccessCnt: integer;
//  NewFilename: string;
//  newPath: string;
begin
(*  SuccessCnt := 0;
  NewPath := '';

  //filter out the DROPEFFECT_SCROLL flag if set...
  //(ie: when dropping a file while the target window is scrolling)
  Effect := Effect and not $80000000;
  //Now, 'Effect' should equal one of the following:
  //DROPEFFECT_COPY, DROPEFFECT_MOVE or DROPEFFECT_LINK

  with DropFileTarget1 do
  begin
    for i := 0 to Files.count-1 do
    begin
      //Name mapping occurs when dragging files from Recycled Bin...
      //In most situations Name Mapping can be ignored entirely.
      if i < MappedNames.count then
        NewFilename := NewPath+MappedNames[i] else
        NewFilename := NewPath+ExtractFilename(Files[i]);

{      if (Effect = DROPEFFECT_LINK) then
      begin
        CreateLink(Files[i], NewFilename);
        inc(SuccessCnt);
        continue;
      end;}

      if NewFilename = Files[i] then
      begin
        windows.messagebox(handle,
          'The destination folder is the same as the source!',
          'Warning', mb_iconStop or mb_OK);
        Break;
      end;
      if not fileexists(NewFilename) then
        try
           if (Effect = DROPEFFECT_MOVE) and
              renamefile(PChar(Files[i]),PChar(NewFilename)) then
            inc(SuccessCnt);
        except
        end;
    end; {for loop}

  end;
  Aux.Clear;*)
end;

procedure TMainForm.DropFileTarget1GetDropEffect(Sender: TObject;
  ShiftState: TShiftState; Point: TPoint; var Effect: Integer);
begin
  //Note: The 'Effect' parameter (on event entry) is the
  //set of effects allowed by both the source and target.
  //Use this event when you wish to override the Default behaviour...

  Effect := DROPEFFECT_MOVE;

  //Adding DROPEFFECT_SCROLL to Effect will now
  //automatically scroll the target window.
  if (Point.Y < 15) or (Point.Y > DirectoryListBox.clientheight-15) then
    Effect := Effect or integer(DROPEFFECT_SCROLL);
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  Aux.Free;
end;

procedure TMainForm.DropSource1Drop(Sender: TObject; DragType: TDragType;
  var ContinueDrop: Boolean);
var I: Integer;
begin
  // now download files to TEMP directory!
  for I:=0 to Aux.Count-1 do
   begin
    try
      SetFunctionButtons(false);
      BytesToTransfer := IdFTP1.Size(Aux[I]);
      IdFTP1.Get(Aux[I], ExtractFilePath(Application.ExeName)+'Temp\'+Aux[I], true);
    finally
      SetFunctionButtons(true);
    end;
   end;
end;

procedure TMainForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

{***********************************************************}
procedure TMainForm.InitLanguage(FileName, Section: String);
var Ini: TINIFile;
    X: TMemo;
    I,Nr: Integer;
    K: String;
begin
  Nr := 0;
  X := TMemo.Create(nil);
  X.WordWrap := False;
  X.MaxLength := 0;
  X.Parent := Self;
  X.Visible := False;
  Ini := TINIFile.Create(FileName);
  //----------------------------------------//
  Ini.ReadSection(Section,X.Lines);
  for I:=0 to X.Lines.Count-1 do
  begin
  K := X.Lines[I];
  if Pos('.HINT',UpperCase(K))>0 then
   // we have a hint
  begin
    K := Copy(K,1,Pos('.HINT',UpperCase(K))-1);

    if (FindComponent(K) is TLabel) then
     (FindComponent(K) as TLabel).Hint := Ini.ReadString(Section,X.Lines[I],'')
    else
    if (findcomponent(K) is TButton) then
     (FindComponent(K) as TButton).Hint := ini.readstring(Section,X.Lines[I],'')
    else
    if (findcomponent(K) is TMenuItem) then
     (FindComponent(K) as TMenuItem).Hint := ini.readstring(Section,X.Lines[I],'')
    else
    if (findcomponent(K) is TTabSheet) then
     (FindComponent(K) as TTabSheet).Hint := ini.readstring(Section,X.Lines[I],'')
    else
    if (findcomponent(K) is TCheckBox) then
     (FindComponent(K) as TCheckBox).Hint := ini.readstring(Section,X.Lines[I],'')
    else
    if (findcomponent(K) is TRadioButton) then
     (FindComponent(K) as TRadioButton).Hint := ini.readstring(Section,X.Lines[I],'')
    else
    if (findcomponent(K) is TStaticText) then
     (FindComponent(K) as TStaticText).Hint := ini.readstring(Section,X.Lines[I],'')
    else
    if (findcomponent(K) is TGroupBox) then
     (FindComponent(K) as TGroupBox).Hint := ini.readstring(Section,X.Lines[I],'')
    else
    if (findcomponent(K) is TTabSheet) then
     (FindComponent(K) as TTabSheet).Hint := ini.readstring(Section,X.Lines[I],'')
    else
    if (findcomponent(K) is TPanel) then
     (FindComponent(K) as TPanel).Hint := ini.readstring(Section,X.Lines[I],'');

  end
  else
  begin
   // we must check for the TListView case
   if Pos(UpperCase('.Columns('),UpperCase(K))>0 then
   begin
    K := Copy(K,1,Pos(UpperCase('.Columns('),UpperCase(K))-1); // copy component
    try
     Nr := StrToInt(Copy(X.Lines[I],Pos('(',X.Lines[I])+1,Length(X.Lines[I])-Pos('(',X.Lines[I])-1));
    except
     // don't show error message, simply skip error
     Nr := 0;
    end;
   end;

    if (FindComponent(K) is TListView) then
     (FindComponent(K) as TListView).Columns[Nr].Caption := Ini.ReadString(Section,X.Lines[i],'')
    else
    if (FindComponent(K) is TLabel) then
     (FindComponent(K) as TLabel).Caption := Ini.ReadString(Section,X.Lines[i],'')
    else
    if (findcomponent(x.lines[i]) is TButton) then
     (FindComponent(X.Lines[i]) as TButton).caption := ini.readstring(Section,x.lines[i],'')
    else
    if (findcomponent(x.lines[i]) is TMenuItem) then
     (FindComponent(X.Lines[i]) as TMenuItem).caption := ini.readstring(Section,x.lines[i],'')
    else
    if (findcomponent(K) is TTabSheet) then
     (FindComponent(K) as TTabSheet).Caption := ini.readstring(Section,X.Lines[I],'')
    else
    if (findcomponent(K) is TCheckBox) then
     (FindComponent(K) as TCheckBox).Caption := ini.readstring(Section,X.Lines[I],'')
    else
    if (findcomponent(K) is TRadioButton) then
     (FindComponent(K) as TRadioButton).Caption := ini.readstring(Section,X.Lines[I],'')
    else
    if (findcomponent(K) is TStaticText) then
     (FindComponent(K) as TStaticText).Caption := ini.readstring(Section,X.Lines[I],'')
    else
    if (findcomponent(K) is TGroupBox) then
     (FindComponent(K) as TGroupBox).Caption := ini.readstring(Section,X.Lines[I],'')
    else
    if (findcomponent(x.lines[i]) is TPanel) then
     (FindComponent(X.Lines[i]) as TPanel).caption := ini.readstring(Section,x.lines[i],'');

  end;
  end;
  //----------------------------------------//
  Ini.Free;
  x.free;

  Update;
end;
{***********************************************************}

procedure TMainForm.LanguageChange(Sender: TObject);
var S: String;
begin
  with Sender as TMenuItem do
   begin
     Checked := True;
     S := Caption;
     if Pos('&', S) <> 0 then
      System.Delete(S, Pos('&', S), 1);
     LanguageFile :=ExtractFilePath(Application.ExeName)+'Language\'+S+'.lng';
     InitLanguage(LanguageFile,'Translations');
   end;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
var INI: TINIFile;
    I: Integer;
begin
  // load appropiate language file
  Ini := TINIFile.Create(ExtractFilePath(Application.ExeName)+'Client.ini');
  Ini.WriteString('General','Language',LanguageFile);
  for I:=0 to Language1.Count-1 do
   if Language1.items[I].Checked then
    begin
      Ini.WriteInteger('General','LanguageIndex',I);
      Break;
    end;
  Ini.Free;
end;

procedure TMainForm.FormShow(Sender: TObject);
var
  Ini: TINIFile;
begin
  // load appropiate language file
  Ini := TINIFile.Create(ExtractFilePath(Application.ExeName)+'Client.ini');
  LanguageFile := Ini.ReadString('General','Language',ExtractFilePath(Application.ExeName)+'Language\English.lng');
  InitLanguage(LanguageFile,'Translations');
  Language1.Items[Ini.ReadInteger('General','LanguageIndex',0)].Checked := True;
  Ini.Free;
end;

procedure TMainForm.Button1Click(Sender: TObject);
var I: Integer;

function Add(S: String): String;
begin
  if S<>'' then
   if S[Length(S)]<>'\' then S := S + '\';
  Result := S;
end;

procedure MakeFTPDir(S: String);
begin
  IdFTP1.MakeDir(S);
end;

procedure ChangeFTPDir(S: String);
begin
  ChangeDir(S);
end;

procedure UploadFile(Name: String);
begin
  if IdFTP1.Connected then begin
  try
      SetFunctionButtons(false);
      IdFTP1.Put(Name, ExtractFileName(Name));
      ChangeDir(idftp1.RetrieveCurrentDir);
    finally
      SetFunctionButtons(true);
    end;
  end;
end;

procedure ProcessDir(S: String);
var
  sr: TSearchRec;
  I, FileAttrs: Integer;
  DirList: TStringList;
begin
  DirList := TStringList.Create;

  MakeFTPDir(ExtractFileName(S));
  ChangeFTPDir(ExtractFilename(S));
  S := S + '\';

  // process directory
  FileAttrs := faArchive + faDirectory;
  if FindFirst(S+'*.*', FileAttrs, sr) = 0 then
    begin
      repeat
        if FileExists(S+sr.Name) then
          // upload this file
          UploadFile(S+sr.Name)
        else
        if DirectoryExists(S+sr.Name) and (sr.Name <> '.') and (sr.Name <> '..') then
         DirList.Add(S+sr.Name);
      until FindNext(sr) <> 0;
      FindClose(sr);
    end;

  for I:=0 to DirList.Count-1 do
   ProcessDir(DirList[I]);

  ChangeDir('..');
  DirList.Free;
end;

var DList, FList: TStringList;

function Remove(S: String): String;
begin
  if S <> '' then
   if S[1]='[' then begin Delete(S, 1, 1); Delete(S, Length(S), 1); end;
  Result := S;
end;

function Proceed(S: String): Boolean;
var I: Integer;
begin
  for I:=0 to DirectorylistBox.Items.Count-1 do
   if (UpperCase(S)=UpperCase(DirectoryListBox.Items[I].Caption)) and (DirectoryListBox.Items[I].SubItems[0]<>'Directory') then
    begin
      Result := Application.MessageBox(PChar('Overwrite file "'+S+'" on server?'), 'Warning',MB_YESNO+MB_ICONQUESTION)=mrYes;
      Exit;
    end;
  Result := True;
end;

function ProceedD(S: String): Boolean;
var I: Integer;
begin
  for I:=0 to DirectorylistBox.Items.Count-1 do
   if (UpperCase(S)=UpperCase(DirectoryListBox.Items[I].Caption)) and (DirectoryListBox.Items[I].SubItems[0]='Directory') then
    begin
      Result := Application.MessageBox(PChar('Overwrite directory "'+S+'" on server?'), 'Warning',MB_YESNO+MB_ICONQUESTION)=mrYes;
      Exit;
    end;
  Result := True;
end;

begin
  if AbortTransfer then Exit;
  FList := TStringList.Create;
  DList := TStringList.Create;
  for I:=0 to List.Items.Count-1 do
   if List.Selected[I] then
    if FileExists(Add(Tree.Directory) + List.Items[I]) then
     FList.Add(Add(Tree.Directory) + List.Items[I])
    else
     if DirectoryExists(Add(Tree.Directory) + Remove(List.Items[I])) then
      try
       DList.Add(Add(Tree.Directory) + Remove(List.Items[I]));
      except
      end;

  { Now directories }
  SetFunctionButtons(False);

  { Files first }
  for I:=0 to FList.Count-1 do
   if FileExists(FList[I]) then
    if Proceed(ExtractFileName(FList[I])) then
    begin
      UploadFile(FList[I]);
      if AbortTransfer then Exit;
      Application.ProcessMessages;
      StatusBar1.Panels[1].Text := IntToStr(FList.Count-1-I)+' file(s) remaining out of '+IntToStr(FList.Count);
    end;

  for I:=0 to DList.Count-1 do
   if ProceedD(ExtractFileName(DList[I])) then
    try
      ProcessDir(DList[I]);
      if AbortTransfer then Exit;
    except
    end;

  SetFunctionButtons(True);
  FList.Free;
  DList.Free;
  StatusBar1.Panels[1].Text := '';
end;

procedure TMainForm.ComboBox1Change(Sender: TObject);
begin
  if ComboBox1.ItemIndex = 1 then
  IdFTP1.TransferType := ftBinary else IdFTP1.TransferType := ftASCII;
end;

procedure TMainForm.CommandEditKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
   try
     IdFTP1.Quote(CommandEdit.Text);
     CommandEdit.Text := '';
   except
   end;
end;

procedure TMainForm.PasswordEditKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then ConnectButtonClick(Self);
end;

procedure TMainForm.N6441Click(Sender: TObject);
var S: String; I: Integer;
begin
  try
    with Sender as TMenuItem do
    begin
      S := StringReplace(Caption, '&', '', [rfReplaceAll]);
      for I:=0 to DirectoryListBox.Items.Count-1 do
      if DirectoryListBox.Items[I].Selected then
        IdFTP1.Quote('CHMOD '+S+' '+DirectoryListBox.Items[I].Caption)
    end;
  except
  end;
end;

procedure TMainForm.DirectoryListBoxColumnClick(Sender: TObject;
  Column: TListColumn);
begin
  // sort the files
  if DirectoryListBox.SortType = stNone then
  begin
    DirectoryListBox.SortType := stText;
    DirectoryListBox.AlphaSort;
  end
  else
  begin
    DirectoryListBox.SortType := stNone;
    ChangeDir('.');
  end;
end;

procedure TMainForm.DownloadButtonClick(Sender: TObject);

procedure DownloadFile(Name, DestPath: String);
begin
  IdFTP1.Get(Name, DestPath+'\'+Name, false);
end;

procedure ProcessDir(S: String);
var DirList: TStringList;
    I: Integer;
begin
  DirList := TStringList.Create;

  ChangeDir(S);
  // make this directory on the destination path
  CreateDir(Tree.Directory+'\'+S);
  Tree.Directory := Tree.Directory+'\'+S;

  for I:=0 to DirectoryListBox.Items.Count-1 do
   if (DirectoryListBox.Items[I].SubItems[0] = 'Directory') and (DirectoryListBox.Items[I].Caption <> '.') and (DirectoryListBox.Items[I].Caption <> '..') then
    DirList.Add(DirectoryListBox.Items[I].Caption)
   else
   if (DirectoryListBox.Items[I].SubItems[0] = 'File') then
     DownloadFile(DirectoryListBox.Items[I].Caption, Tree.Directory);

  for I:=0 to DirList.Count-1 do
   ProcessDir(DirList[I]);

  ChangeDir('..');
  Tree.Directory := ExtractFilePath(Tree.Directory);

  DirList.Free;
end;

begin
  if DirectoryListBox.ItemIndex < 0 then Exit;
  if DirectoryListBox.Items[DirectoryListBox.ItemIndex].SubItems[0] = 'Directory' then // download directory
  begin
    SetFunctionButtons(False);
    try
      ProcessDir(DirectoryListBox.Items[DirectoryListBox.ItemIndex].Caption);
    except
    end;
    SetFunctionButtons(True);
  end
  else
   DirectoryListBoxDblClick(Self);
end;

procedure TMainForm.ListDblClick(Sender: TObject);
var Dir: String;
begin
  if List.ItemIndex < 0 then Exit;
  if Pos('[', List.Items[List.ItemIndex]) = 1 then
   begin
     Dir := Copy(List.Items[List.ItemIndex], 2, Length(List.Items[List.ItemIndex])-2);
     List.Directory := List.Directory + '\' + Dir;
   end;
end;

end.

