<?php
/*
Copyright: © 2009 WebSharks, Inc. ( coded in the USA )
<mailto:support@websharks-inc.com> <http://www.websharks-inc.com/>

Released under the terms of the GNU General Public License.
You should have received a copy of the GNU General Public License,
along with this software. In the main directory, see: /licensing/
If not, see: <http://www.gnu.org/licenses/>.
*/
/*
WARNING: This is a system configuration file, please DO NOT EDIT this file directly!
... Instead, use the widget options panel in WordPress® to override these settings.
*/
/*
Direct access denial.
*/
if (realpath (__FILE__) === realpath ($_SERVER["SCRIPT_FILENAME"]))
	exit ("Do not access this file directly.");
/*
Configure important global values for this widget + default values for options.
*/
$GLOBALS["WS_WIDGET__"]["ad_codes"]["c"]["name"] = "Ad Codes";
$GLOBALS["WS_WIDGET__"]["ad_codes"]["c"]["control_w"] = "400"; /* Width of the control box. */
$GLOBALS["WS_WIDGET__"]["ad_codes"]["c"]["description"] = "Supports AdSense®, Javascript, XHTML and PHP code.";
/**/
if (is_multisite () && defined ("MULTISITE_FARM") && MULTISITE_FARM) /* PHP eval() will be disabled here. */
	$GLOBALS["WS_WIDGET__"]["ad_codes"]["c"]["description"] = "Supports AdSense®, Javascript, XHTML, etc.";
/*
Determine the full url to the directory this plugin resides in.
*/
$GLOBALS["WS_WIDGET__"]["ad_codes"]["c"]["dir_url"] = content_url () . preg_replace ("/^(.*?)(\/" . preg_quote (basename (WP_CONTENT_DIR), "/") . ")/", "", preg_replace ("/" . preg_quote (DIRECTORY_SEPARATOR, "/") . "/", "/", dirname (dirname (__FILE__))));
/*
Check if the plugin has been configured *should be set after the first config via options panel*.
*/
$GLOBALS["WS_WIDGET__"]["ad_codes"]["c"]["configured"] = get_option ("ws_widget__ad_codes_configured");
/*
Configure the right menu options panel for this software.
*/
$GLOBALS["WS_WIDGET__"]["ad_codes"]["c"]["menu_pages"] = array ("installation" => false, "tools" => true, "support" => true, "donations" => true);
/*
Configure checksum time for the syscon.inc.php file.
*/
$GLOBALS["WS_WIDGET__"]["ad_codes"]["c"]["checksum"] = filemtime (__FILE__);
/*
Configure & validate all of the widget options; and set their defaults.
*/
if (!function_exists ("ws_widget__ad_codes_configure_options_and_their_defaults"))
	{
		function ws_widget__ad_codes_configure_options_and_their_defaults ($options = FALSE, $per_widget_options = FALSE)
			{
				/*
				Here we build the default options array, which will be merged with the user options.
				It is important to note that sometimes default options may not or should not be pre-filled on an options form.
				These defaults are for the system to use in various ways, we may choose not to pre-fill certain fields.
				In other words, some defaults may be used internally, but to the user, the option will be empty. */
				$default_options = apply_filters ("ws_widget__ad_codes_default_options", array ( /* For filters. */
				/**/
				"options_checksum" => "", /* Used internally to maintain the integrity of all options in the array. */
				/**/
				"options_version" => "1.0", /* Used internally to maintain the integrity of all options in the array. */
				/**/
				"run_deactivation_routines" => "1")); /* Should deactivation routines be processed? */
				/*
				We also build the default widget options array, these get merged on a per-widget basis.
				It is important to note that sometimes default options may not or should not be pre-filled on an options form.
				These defaults are for the system to use in various ways, we may choose not to pre-fill certain fields.
				In other words, some defaults may be used internally, but to the user, the option will be empty. */
				$default_per_widget_options = apply_filters ("ws_widget__ad_codes_default_per_widget_options", array (/**/
				/**/
				"title" => "Ad Codes Widget", /* Ok for this to be empty. */
				/**/
				"code" => '<img src="' . esc_attr ($GLOBALS["WS_WIDGET__"]["ad_codes"]["c"]["dir_url"]) . '/images/300x250.png" style="width:300px; height:250px; border:0px;" alt="Ad Code" />'));
				/*
				Are we dealing with per-widget options here? 
				*/
				if ($per_widget_options !== false): /* If so we need to work differently. */
					/*
					Here they are merged. User options will overwrite some or all defaults. 
					*/
					$WS_WIDGET__per_widget_options = array_merge ($default_per_widget_options, (array)$per_widget_options);
					/*
					Validate each option, possibly reverting back to default if invalid.
					*/
					foreach ($WS_WIDGET__per_widget_options as $key => &$value)
						{
							if (!isset ($default_per_widget_options[$key]) && !preg_match ("/^pro_/", $key))
								unset ($WS_WIDGET__per_widget_options[$key]);
							/**/
							else if ($key === "title" && !is_string ($value))
								$value = $default_per_widget_options[$key];
							/**/
							else if ($key === "code" && (!is_string ($value) || !strlen ($value)))
								$value = $default_per_widget_options[$key];
						}
					/**/
					return apply_filters ("ws_widget__ad_codes_per_widget_options", $WS_WIDGET__per_widget_options);
				/*
				Else we are dealing with the main plugin option configuration or validation. 
				*/
				else: /* We need to validate these while checking to see if options were passed in. */
					/*
					Here they are merged. User options will overwrite some or all defaults. 
					*/
					$GLOBALS["WS_WIDGET__"]["ad_codes"]["o"] = array_merge ($default_options, ( ($options !== false) ? (array)$options : (array)get_option ("ws_widget__ad_codes_options")));
					/*
					This builds an MD5 checksum for the full array of options. This also includes the config checksum and the current set of default options. 
					*/
					$checksum = md5 (($checksum_prefix = $GLOBALS["WS_WIDGET__"]["ad_codes"]["c"]["checksum"] . serialize ($default_options)) . serialize (array_merge ($GLOBALS["WS_WIDGET__"]["ad_codes"]["o"], array ("options_checksum" => 0))));
					/*
					Validate each option, possibly reverting back to default if invalid.
					*/
					if ($options !== false || ($GLOBALS["WS_WIDGET__"]["ad_codes"]["o"]["options_checksum"] !== $checksum && $GLOBALS["WS_WIDGET__"]["ad_codes"]["o"] !== $default_options))
						{
							foreach ($GLOBALS["WS_WIDGET__"]["ad_codes"]["o"] as $key => &$value)
								{
									if (!isset ($default_options[$key]) && !preg_match ("/^pro_/", $key))
										unset ($GLOBALS["WS_WIDGET__"]["ad_codes"]["o"][$key]);
									/**/
									else if ($key === "options_checksum" && (!is_string ($value) || !strlen ($value)))
										$value = $default_options[$key];
									/**/
									else if ($key === "options_version" && (!is_string ($value) || !is_numeric ($value)))
										$value = $default_options[$key];
									/**/
									else if ($key === "run_deactivation_routines" && (!is_string ($value) || !is_numeric ($value)))
										$value = $default_options[$key];
								}
							/**/
							$GLOBALS["WS_WIDGET__"]["ad_codes"]["o"] = apply_filters_ref_array ("ws_widget__ad_codes_options_before_checksum", array (&$GLOBALS["WS_WIDGET__"]["ad_codes"]["o"]));
							/**/
							$GLOBALS["WS_WIDGET__"]["ad_codes"]["o"]["options_checksum"] = md5 ($checksum_prefix . serialize (array_merge ($GLOBALS["WS_WIDGET__"]["ad_codes"]["o"], array ("options_checksum" => 0))));
						}
					/**/
					return apply_filters_ref_array ("ws_widget__ad_codes_options", array (&$GLOBALS["WS_WIDGET__"]["ad_codes"]["o"]));
				/**/
				endif;
			}
	}
?>