unit FTPEdit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, IdFTP;

type
  TFTPEditForm = class(TForm)
    FTPGroup: TGroupBox;
    Label38: TLabel;
    Label39: TLabel;
    Label40: TLabel;
    Label41: TLabel;
    Label48: TLabel;
    FTPHostname: TEdit;
    FTPUsername: TEdit;
    FTPPassword: TEdit;
    FTPPort: TEdit;
    FTPPassive: TCheckBox;
    ProxyGroup: TGroupBox;
    Label42: TLabel;
    Label43: TLabel;
    Label44: TLabel;
    Label46: TLabel;
    Label47: TLabel;
    FTPProxyHostname: TEdit;
    FTPProxyUsername: TEdit;
    FTPProxyPassword: TEdit;
    FTPProxyPort: TEdit;
    FTPProxyType: TComboBox;
    FTPUseProxy: TCheckBox;
    btnTest: TBitBtn;
    FTPDirectory: TEdit;
    btnOK: TBitBtn;
    btnCancel: TBitBtn;
    Label1: TLabel;
    procedure btnTestClick(Sender: TObject);
    procedure FTPUseProxyClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
  private
    { Private declarations }
    procedure AssignFTPProperties;
  public
    { Public declarations }
    procedure AssignBackFTPProperties;
  end;

var
  FTPEditForm: TFTPEditForm;

implementation

{$R *.dfm}

uses Main;

procedure TFTPEditForm.btnTestClick(Sender: TObject);
var DirName: String;
begin
  AssignFTPProperties;
  try
   MainForm.FTP.Connect();
   DirName := StringReplace(FTPDirectory.Text, '\', '/', [rfReplaceAll]);
   if DirName <> '' then
    MainForm.FTP.ChangeDir(DirName);
   MainForm.FTP.Disconnect();
   Application.MessageBox('The connection has been successfully established.', 'Connect OK', MB_OK + MB_ICONINFORMATION);
  except
   on E: Exception do
   begin
     if MainForm.FTP.Connected then
     try
       MainForm.FTP.Disconnect();
     except
     end;
     Application.MessageBox(PChar('The connection could not be established due to the following error: '+#13#10#13#10+E.Message), 'Warning', MB_OK + MB_ICONWARNING);
   end;
  end;
end;

procedure TFTPEditForm.AssignFTPProperties;
begin
  with MainForm.FTP do
  begin
    Host := FTPHostname.Text;
    try
     Port := StrToInt(FTPPort.Text);
    except
     Port := 21;
    end;
    Username := FTPUsername.Text;
    Password := FTPPassword.Text;
    Passive := FTPPassive.Checked;

    if not FTPUseProxy.Checked then
     ProxySettings.ProxyType := fpcmNone
    else
     case FTPProxyType.ItemIndex of
      0: ProxySettings.ProxyType := fpcmOpen;
      1: ProxySettings.ProxyType := fpcmSite;
      2: ProxySettings.ProxyType := fpcmTransparent;
      3: ProxySettings.ProxyType := fpcmUserPass;
      4: ProxySettings.ProxyType := fpcmUserSite;
     end; { case }

    MainForm.FTPDirectory := FTPDirectory.Text;

    ProxySettings.Host := FTPProxyHostname.Text;
    ProxySettings.UserName := FTPProxyUsername.Text;
    ProxySettings.Password := FTPProxyPassword.Text;
    try
     ProxySettings.Port := StrToInt(FTPProxyPort.Text);
    except
     ProxySettings.Port := 0;
    end;
  end;
end;

procedure TFTPEditForm.AssignBackFTPProperties;
begin
  with MainForm.FTP do
  begin
    FTPHostname.Text := Host;
    FTPPort.Text := IntToStr(Port);
    FTPUsername.Text := Username;
    FTPPassword.Text := Password;
    FTPPassive.Checked := Passive;
    FTPDirectory.Text := MainForm.FTPDirectory;

    FTPUseProxy.Checked := not (ProxySettings.ProxyType = fpcmNone);
     case ProxySettings.ProxyType of
      fpcmOpen: FTPProxyType.ItemIndex := 0;
      fpcmSite: FTPProxyType.ItemIndex := 1;
      fpcmTransparent: FTPProxyType.ItemIndex := 2;
      fpcmUserPass: FTPProxyType.ItemIndex := 3;
      fpcmUserSite: FTPProxyType.ItemIndex := 4;
     end; { case }

    FTPProxyHostname.Text := ProxySettings.Host;
    FTPProxyUsername.Text := ProxySettings.UserName;
    FTPProxyPassword.Text := ProxySettings.Password;
    FTPProxyPort.Text := IntToStr(ProxySettings.Port);
  end;
end;

procedure TFTPEditForm.FTPUseProxyClick(Sender: TObject);
begin
  ProxyGroup.Visible := FTPUseProxy.Checked;
end;

procedure TFTPEditForm.btnOKClick(Sender: TObject);
begin
  AssignFTPProperties;
end;

end.
