unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SCapture, Menus, ExtCtrls, ComCtrls, Buttons, ToolWin, ImgList, Second, Registry, RXShell, Placemnt, RxMenus,
  VCLUtils, AppEvent, Struct, ExtDlgs, ErrorDlg, RxHints, Input, Output, Preview, About, Options,
  FormHider, HKHandler, QHelp, Wizard, TB2Dock, TB2Item, TB2Toolbar, TB2ExtItems,
  EffectPreview, Resize, jclGraphics, TB2MDI, XPMan, TextPreview, ImageEditPreview, GraphicsResourceForm, ShellAPI,
  WriteAVIForm, ASGCapture, SkinCaption, WinSkinData;

type InputRecord =
       record
          Hide_On_Capture,
          Beep_On_Capture,
          Use_Tray_Icon: Boolean;
          Enable_Timer: Boolean;
          Timer_Time,
          Repaint_Time: Longint;
          Frequency: Longint;
          Width,
          Height,
          Starting_X,
          Starting_Y: Integer;
          TypeOfFrequency: 0..3;
          { Frequency is in milliseconds }
       end;
      OutputRecord =
        record
           Beep_On_Finish,
           Show_Dialog_Before_Print: Boolean;
           File_Format: MyImageType;
           Ask_Image_Name,
           Fixed_Image_Name,
           Auto_Image_Name: Boolean;
           Fixed_Name,
           Auto_Prefix,
           Output_Folder,
           Catalog_Folder: String;
           Catalog_Ask_Name,
           Catalog_Auto_Name: Boolean;
        end;

      OptionsRecord =
        record
          HotKey,
          HideHotKey,
          RepeatHotKey: TShortCut;
          Save_On_Exit,
          Use_Tray_Icon,
          Write_Date_Time,
          Prompt_for_Comment,
          Auto_Save,
          Sound_On_Hide: Boolean;
        end;
      JPEGRecord = record
          Grayscale: Boolean;
          Progressive: Boolean;
          Quality: 1..100;
        end;


type
  TMainForm = class(TForm)
    StatusBar: TStatusBar;
    FormStorage: TFormStorage;
    FormPlacement: TFormPlacement;
    RxTrayIcon: TRxTrayIcon;
    AppEvents: TAppEvents;
    CaptureTimer: TTimer;
    ScreenCapture: TScreenCapture;
    PrinterSetupDialog: TPrinterSetupDialog;
    FormHider: TFormHider;
    FormHotKeyHandler: TFormHotKeyHandler;
    WinXPBackground: TTBBackground;
    DockBackground: TTBBackground;
    TopDock: TTBDock;
    MenuBar: TTBToolbar;
    Input1: TTBSubmenuItem;
    Desktop1: TTBItem;
    ActiveWindow1: TTBItem;
    FixedRegion1: TTBItem;
    N1: TTBSeparatorItem;
    HotKeyIsActive1: TTBItem;
    N2: TTBSeparatorItem;
    ShowLastCapture1: TTBItem;
    N7: TTBSeparatorItem;
    Properties1: TTBItem;
    Output1: TTBSubmenuItem;
    File1: TTBItem;
    Printer1: TTBItem;
    Clipboard1: TTBItem;
    Catalog1: TTBItem;
    N9: TTBSeparatorItem;
    PreviewWindow1: TTBItem;
    N8: TTBSeparatorItem;
    Properties2: TTBItem;
    Options1: TTBSubmenuItem;
    ProgramPreferences1: TTBItem;
    N3: TTBSeparatorItem;
    SaveAllSettingsNow1: TTBItem;
    Window1: TTBSubmenuItem;
    Tile1: TTBItem;
    Cascade1: TTBItem;
    ArrangeAll1: TTBItem;
    MinimizeAll1: TTBItem;
    N10: TTBSeparatorItem;
    Close1: TTBItem;
    CloseAll1: TTBItem;
    Help1: TTBSubmenuItem;
    QuickHelp2: TTBItem;
    N4: TTBSeparatorItem;
    About3: TTBItem;
    Effects1: TTBSubmenuItem;
    TBItem2: TTBItem;
    TBItem3: TTBItem;
    HotToolbarImages: TImageList;
    Blur1: TTBSubmenuItem;
    Adjust1: TTBSubmenuItem;
    TBItem4: TTBItem;
    TBItem5: TTBItem;
    AddNoise1: TTBSubmenuItem;
    TBItem6: TTBItem;
    TBItem7: TTBItem;
    TBItem1: TTBItem;
    TBItem8: TTBItem;
    TBItem9: TTBItem;
    Light1: TTBSubmenuItem;
    TBItem10: TTBItem;
    TBItem11: TTBItem;
    TBItem12: TTBItem;
    TBItem13: TTBItem;
    TBItem14: TTBItem;
    TBItem15: TTBItem;
    TBItem16: TTBItem;
    TBSeparatorItem7: TTBSeparatorItem;
    TBSeparatorItem8: TTBSeparatorItem;
    TBSeparatorItem9: TTBSeparatorItem;
    TBSeparatorItem10: TTBSeparatorItem;
    TBItem17: TTBItem;
    TBItem18: TTBItem;
    TBItem19: TTBItem;
    TBItem20: TTBItem;
    TBItem21: TTBItem;
    TBToolbar1: TTBToolbar;
    SaveBtn: TTBItem;
    CloseBtn: TTBItem;
    TBSeparatorItem1: TTBSeparatorItem;
    SaveSettingsBtn: TTBItem;
    TBSeparatorItem2: TTBSeparatorItem;
    HotKeyBtn: TTBItem;
    TBSeparatorItem3: TTBSeparatorItem;
    PreviewBtn: TTBItem;
    TBSeparatorItem6: TTBSeparatorItem;
    WizardBtn: TTBItem;
    TBSeparatorItem4: TTBSeparatorItem;
    HelpBtn: TTBItem;
    TBSeparatorItem5: TTBSeparatorItem;
    ExitBtn: TTBItem;
    OpenImage1: TTBItem;
    TBSeparatorItem11: TTBSeparatorItem;
    SaveImage1: TTBItem;
    Tile2: TTBItem;
    RxPopupMenu: TTBPopupMenu;
    Restore1: TTBItem;
    N5: TTBSeparatorItem;
    About1: TTBItem;
    N6: TTBSeparatorItem;
    Exit1: TTBItem;
    OpenDialog: TOpenPictureDialog;
    TBSubmenuItem1: TTBSubmenuItem;
    Resize1: TTBItem;
    Undo1: TTBItem;
    TBSeparatorItem13: TTBSeparatorItem;
    Undo2: TTBItem;
    TBSeparatorItem14: TTBSeparatorItem;
    TBSeparatorItem12: TTBSeparatorItem;
    TBMDIHandler: TTBMDIHandler;
    TBMDIWindowItem1: TTBMDIWindowItem;
    XPManifest: TXPManifest;
    TBItem23: TTBItem;
    TBSeparatorItem15: TTBSeparatorItem;
    TBSeparatorItem16: TTBSeparatorItem;
    InsertText: TTBItem;
    InsertImage1: TTBItem;
    TBSeparatorItem17: TTBSeparatorItem;
    TBSubmenuItem2: TTBSubmenuItem;
    TBItem22: TTBItem;
    TBItem25: TTBItem;
    TBItem26: TTBItem;
    TBSeparatorItem18: TTBSeparatorItem;
    TBItem24: TTBItem;
    ASGScreenCapture: TASGScreenCapture;
    Object1: TTBItem;
    Area1: TTBItem;
    SkinData1: TSkinData;
    SkinCaption1: TSkinCaption;
    procedure InputClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ShowHint(Sender: TObject);
    procedure ScreenCaptureCapture(Sender: TObject);
    procedure RxTrayIconDblClick(Sender: TObject);
    procedure Restore1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure SaveSettingsBtn2Click(Sender: TObject);
    procedure PreviewBtn2Click(Sender: TObject);
    procedure PreviewWindow1Click(Sender: TObject);
    procedure HotKeyIsActive1Click(Sender: TObject);
    procedure HotKeyBtn2Click(Sender: TObject);
    procedure OutputClick(Sender: TObject);
    procedure ExitBtn2Click(Sender: TObject);
    procedure AppEventsException(Sender: TObject; E: Exception);
    procedure CloseBtn2Click(Sender: TObject);
    procedure SaveBtn2Click(Sender: TObject);
    procedure WMDisableButtons(var Message: TMessage); message WM_DISABLEBUTTONS;
    procedure WMAcceptCapture(var Message: TMessage); message WM_ACCEPTCAPTURE;
    procedure Properties1Click(Sender: TObject);
    procedure Properties2Click(Sender: TObject);
    procedure ScreenCaptureBeforeCapture(Sender: TObject);
    procedure About3Click(Sender: TObject);
    procedure ShowLastCapture1Click(Sender: TObject);
    procedure AppEventsMinimize(Sender: TObject);
    procedure ProgramPreferences1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SaveAllSettingsNow1Click(Sender: TObject);
    procedure CaptureTimerTimer(Sender: TObject);
    procedure FormHiderAfterAction(Sender: TObject);
    procedure FormHotKeyHandlerAction(Sender: TObject);
    procedure QuickHelp2Click(Sender: TObject);
    procedure HelpBtn2Click(Sender: TObject);
    procedure Tile1Click(Sender: TObject);
    procedure Cascade1Click(Sender: TObject);
    procedure ArrangeAll1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure CloseAll1Click(Sender: TObject);
    procedure MinimizeAll1Click(Sender: TObject);
    procedure About2Click(Sender: TObject);
    procedure CaptureFixedRegion;
    procedure WizardBtn2Click(Sender: TObject);
    procedure TBItem2Click(Sender: TObject);
    procedure TopDockResize(Sender: TObject);
    procedure OpenImage1Click(Sender: TObject);
    procedure Tile2Click(Sender: TObject);
    procedure TBItem3Click(Sender: TObject);
    procedure TBItem1Click(Sender: TObject);
    procedure TBItem8Click(Sender: TObject);
    procedure TBItem9Click(Sender: TObject);
    procedure TBItem12Click(Sender: TObject);
    procedure TBItem13Click(Sender: TObject);
    procedure TBItem14Click(Sender: TObject);
    procedure TBItem15Click(Sender: TObject);
    procedure TBItem19Click(Sender: TObject);
    procedure TBItem18Click(Sender: TObject);
    procedure TBItem21Click(Sender: TObject);
    procedure TBItem20Click(Sender: TObject);
    procedure TBItem4Click(Sender: TObject);
    procedure TBItem5Click(Sender: TObject);
    procedure TBItem6Click(Sender: TObject);
    procedure TBItem7Click(Sender: TObject);
    procedure TBItem11Click(Sender: TObject);
    procedure TBItem10Click(Sender: TObject);
    procedure TBItem16Click(Sender: TObject);
    procedure TBItem17Click(Sender: TObject);
    procedure Undo1Click(Sender: TObject);
    procedure Resize1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TBItem23Click(Sender: TObject);
    procedure InsertTextClick(Sender: TObject);
    procedure InsertImage1Click(Sender: TObject);
    procedure TBItem22Click(Sender: TObject);
    procedure TBItem26Click(Sender: TObject);
    procedure TBItem25Click(Sender: TObject);
    procedure InsertArrows1Click(Sender: TObject);
    procedure TBItem24Click(Sender: TObject);
  private
    { Private declarations }
    FClientInstance,
      FPrevClientProc: TFarProc;
    Bitmap: TBitmap;
    procedure ClientWndProc(var Message: TMessage);
    procedure AddNewCapture;
    procedure ReadRegistry;
    procedure SaveRegistry;
    procedure EnableButtons;
    function GetItemName: String;
  public
    { Public declarations }
    UntitledNo: Integer;
    InputProperties: InputRecord;
    OutputProperties: OutputRecord;
    OptionsProperties: OptionsRecord;
    JPEGProperties: JPEGRecord;
    procedure ScreenShot(x : integer; y : integer; WidthX : integer; HeightX : integer; bm : TBitMap);
    procedure DisableEffects;
    procedure EnableEffects;
  end;

var
  MainForm: TMainForm;
  INI: TRegINIFile;
  { Capture time }
  X1, X2: Longint;
  { Last capture }
  LastCaptured: Integer;

implementation

{$R *.DFM}

procedure TMainForm.InputClick(Sender: TObject);
var Ind, I: Integer;
begin
 with Sender as TTBItem do
  begin
    Ind := MenuBar.Items[0].IndexOf(Sender as TTBItem);
  end;
 for I:=3 to 7 {there are 5 input options} do
  if I=Ind then
   Input1.Items[I].Checked := True
  else
   Input1.Items[I].Checked := False;

    case Ind of
     3: begin
          ScreenCapture.Desktop := True;
          ScreenCapture.CanCapture := True;
        end;
     4: begin
          ScreenCapture.Desktop := False;
          ScreenCapture.CanCapture := True;
        end;
     5: begin
          ScreenCapture.Desktop := False;
          ScreenCapture.CanCapture := False;
        end;
    end; {case}
  ShowHint(Sender);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Bitmap := TBitmap.Create;
  Bitmap.LoadFromResourceName(HInstance,'MAIN');
  Bitmap.Dormant;
  Bitmap.FreeImage;

  LastCaptured := -1;
  SetHintStyle(hsRectangle,1,False,taCenter);
  {Russ Reese hint}
  SetWindowLong(ClientHandle, GWL_EXSTYLE, WS_EX_CLIENTEDGE);
  SetWindowPos(ClientHandle, HWND_BOTTOM, 0,0,0,0,SWP_NOCOPYBITS);
  {End}
  {To draw client area with a tiled bitmap}
  FClientInstance := MakeObjectInstance(ClientWndProc);
  FPrevClientProc := Pointer(GetWindowLong(ClientHandle, GWL_WNDPROC));
  SetWindowLong(ClientHandle, GWL_WNDPROC, LongInt(FClientInstance));
  {End...}
  DisableEffects;
  ReadRegistry;
  Application.OnHint := ShowHint;
  ShowHint(Sender);
  FormHider.Active := True;
  FormHider.FormIsHidden := False;
  FormHotKeyHandler.Active := True;
  FormHotKeyHandler.IdString := 'repeat last capture';
  with OptionsProperties do
  begin
   FormHider.HotKey := HideHotKey;
   FormHotKeyHandler.HotKey := RepeatHotKey;
  end;
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  if Application.Hint<>'' then
   StatusBar.Panels[1].Text := Application.Hint
  else
   if not HotKeyBtn.Checked then
    StatusBar.Panels[1].Text := 'Hotkey is not active. You cannot capture the '+GetItemName
  else
   if ShortCutToText(ScreenCapture.HotKey)<>'' then
    StatusBar.Panels[1].Text := 'Press '+ShortCutToText(ScreenCapture.HotKey)+' to capture the '+GetItemName
   else
    StatusBar.Panels[1].Text := 'Unable to capture '+GetItemName+' because no hotkey is defined';
end;

function TMainForm.GetItemName: String;
begin
  if Desktop1.Checked then
   GetItemName := 'desktop'
  else
   if ActiveWindow1.Checked then
    GetItemName := 'active window'
   else
    if FixedRegion1.Checked then
     GetItemName := 'fixed region'
    else
     if Area1.Checked then
      GetItemName := 'desktop area'
     else
      GetItemName := 'desktop object';
end;

procedure TMainForm.AddNewCapture;

function GetSelected: Integer;
var I: Integer;
begin
  for I:=0 to 3 do
   if Output1.Items[I].Checked then
    Break;
  Result := I;
end;

begin
  { Show in child window }
  Inc(UntitledNo);
  with TCaptureForm.Create(Self) do
   begin
     DoubleBuffered := True;
     Caption := 'Untitled'+IntToStr(UntitledNo);
     Image.Picture.Bitmap := ScreenCapture.Bitmap;
     Image.Picture.Bitmap.PixelFormat := pf24bit;
     StatusBar.Panels[0].Text := 'Image: '+IntToStr(Image.Picture.Bitmap.Width)+' x '+IntToStr(Image.Picture.Bitmap.Height)+' x 24 bit = '+FloatToStrF(3*Image.Picture.Bitmap.Width*Image.Picture.Bitmap.Height / 1024, ffNumber, 18, 1)+' KB';
   end;
  EnableButtons;
  EnableEffects;

  with OptionsProperties do
   if Auto_Save then
    SendMessage(ActiveMDIChild.Handle,WM_SAVECAPTURE,GetSelected,0);
end;

procedure TMainForm.ScreenCaptureCapture(Sender: TObject);
var R: TRect;
    Size: TSize;
    S: String;
    Old: TColor;

function GetCurrentDateTime: String;
var
  SystemTime: TSystemTime;
  First: TDateTime;
begin
  GetLocalTime(SystemTime);
  First := SystemTimeToDateTime(SystemTime);
  Result := FormatDateTime('hh:mm:ss.zzz AM/PM, dddd, mmmm d, yyyy',First);
end;

function GetSelected: Integer;
var I: Integer;
begin
  for I:=0 to 1 do
   if Input1.Items[I].Checked then
    Break;
  Result := I;
end;

begin
  if not HotKeyBtn.Checked then
   Exit;

  X2 := GetTickCount;

  // ********************************* SPECIAL CAPTURE ***************************************
  if Area1.Checked then
  begin
    // Capture area of screen
    ScreenCapture.Bitmap.Assign(ASGScreenCapture.CaptureSelection);
  end
  else
  if Object1.Checked then
  begin
    // Capture area of screen
    ScreenCapture.Bitmap.Assign(ASGScreenCapture.CaptureObject);
  end
  else
  if FixedRegion1.Checked then
    CaptureFixedRegion;
  // ********************************* END ***************************************

   // Now see if we must write date&time on capture
   // ... and/or prompt for comment
   with OptionsProperties do
    begin
      Old := ScreenCapture.Bitmap.Canvas.Brush.Color;
      ScreenCapture.Bitmap.Canvas.Font.Name := 'Courier New';
      ScreenCapture.Bitmap.Canvas.Font.Size := 9;
      if Write_Date_Time then
       begin
         ScreenCapture.Bitmap.Canvas.Brush.Color := Old;
         GetTextExtentPoint32(ScreenCapture.Bitmap.Canvas.Handle,PChar(GetCurrentDateTime),Length(PChar(GetCurrentDateTime)),Size);
         R := Rect(5,5,Size.cx+5,Size.cy+5);
         DrawText(ScreenCapture.Bitmap.Canvas.Handle,PChar(GetCurrentDateTime), -1, R, DT_CENTER or DT_SINGLELINE);
         ScreenCapture.Bitmap.Canvas.Brush.Color := clBlack;
         // now resize R to create rectangle
         R := Rect(4,4,Size.cx+6,Size.cy+6);
         ScreenCapture.Bitmap.Canvas.FrameRect(R);
         ScreenCapture.Bitmap.Canvas.Brush.Color := Old;
       end;
      if Prompt_For_Comment then
       begin
        S := '';
        if InputQuery('Enter Capture Comment','Comment:',S) then
         if Write_Date_Time then
         // don't overwrite date/time
         begin
           if S<>'' then
           begin
           ScreenCapture.Bitmap.Canvas.Brush.Color := Old;
           GetTextExtentPoint32(ScreenCapture.Bitmap.Canvas.Handle,PChar(S),Length(S),Size);
           R := Rect(5,25,Size.cx+5,Size.cy+25);
           DrawText(ScreenCapture.Bitmap.Canvas.Handle,PChar(S), -1, R, DT_CENTER or DT_SINGLELINE);
           ScreenCapture.Bitmap.Canvas.Brush.Color := clBlack;
           // now resize R to create rectangle
           R := Rect(4,24,Size.cx+6,Size.cy+26);
           ScreenCapture.Bitmap.Canvas.FrameRect(R);
           ScreenCapture.Bitmap.Canvas.Brush.Color := Old;
           end;
         end
         else
         begin
           if S<>'' then
           begin
           ScreenCapture.Bitmap.Canvas.Brush.Color := Old;
           GetTextExtentPoint32(ScreenCapture.Bitmap.Canvas.Handle,PChar(S),Length(S),Size);
           R := Rect(5,5,Size.cx+5,Size.cy+5);
           DrawText(ScreenCapture.Bitmap.Canvas.Handle,PChar(S), -1, R, DT_CENTER or DT_SINGLELINE);
           ScreenCapture.Bitmap.Canvas.Brush.Color := clBlack;
           // now resize R to create rectangle
           R := Rect(4,4,Size.cx+6,Size.cy+6);
           ScreenCapture.Bitmap.Canvas.FrameRect(R);
           ScreenCapture.Bitmap.Canvas.Brush.Color := Old;
           end;
         end;
       end;
    end;

  { Signal capture }
  with OutputProperties do
  if not CaptureTimer.Enabled then
   begin
     if Beep_On_Finish then
      Beep;
     ShowWindow(Application.Handle,SW_SHOW);
     ShowWindow(Application.MainForm.Handle,SW_SHOW);
     Application.Restore;
     Application.BringToFront;
   end;

  if PreviewBtn.Checked then
  begin
   // preview window
   with PreviewForm do
     begin
      PreviewImage.Picture.Bitmap := ScreenCapture.Bitmap;
      StatusBar.Panels[2].Text := 'Capture time: '+IntToStr(X2-X1)+'ms';
      Show;
    end;
   end
   else
   begin
     AddNewCapture;
   end;

  LastCaptured := GetSelected;
end;

procedure TMainForm.RxTrayIconDblClick(Sender: TObject);
begin
  Application.Restore;
  Application.BringToFront;
end;

procedure TMainForm.Restore1Click(Sender: TObject);
begin
  Application.Restore;
  Application.BringToFront;
end;

procedure TMainForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.ReadRegistry;
var X: Longint;

function GetFormat(X: Integer): MyImageType;
begin
  case X of
   0: Result := BMP;
   1: Result := JPG;
   2: Result := TIFF;
  else
   Result := BMP;
  end; {case}
end;

function GetFreq(N: LongInt; X: Byte): LongInt;
begin
  case X of
   0: N := N * 3600 * 1000; {Hours}
   1: N := N * 60 * 1000; {Minutes}
   2: N := N * 1000; {Seconds}
   3: {nothing};
  end; {case}
  Result := N;
end;

procedure SetSelected(N: Integer);
var I: Integer;
begin
 if (N>=0) and (N<=3) then
  for I:=0 to 3 do
   if I=N then
    Output1.Items[I].Checked := True
   else
    Output1.Items[I].Checked := False
 else
  for I:=0 to 3 do
   if I=0 then
    Input1.Items[I].Checked := True
   else
    Input1.Items[I].Checked := False;
end;

begin
  Ini := TRegINIFile.Create;
  Ini.RootKey := REG_TYPE;
  if not Ini.OpenKey(REG_KEY,True) then
   begin
     Application.MessageBox('Could not load settings from the registry.'+#13#13+
     'Another application may be using it.','Registry Error',MB_OK+MB_ICONERROR);
     Ini.Free;
     Exit;
   end;
  Desktop1.Checked := Ini.ReadBool(REG_INPUT,'Desktop',True);
  ActiveWindow1.Checked := Ini.ReadBool(REG_INPUT,'ActiveWindow',False);
  FixedRegion1.Checked := Ini.ReadBool(REG_INPUT,'FixedRegion',False);
  Area1.Checked := Ini.ReadBool(REG_INPUT,'Area',False);
  Object1.Checked := Ini.ReadBool(REG_INPUT,'Object',False);
  SetSelected(Ini.ReadInteger(REG_OUTPUT,'OutputOption',0));
  PreviewBtn.Checked := Ini.ReadBool(REG_GENERAL,'Preview',True);
  HotKeyIsActive1.Checked := Ini.ReadBool(REG_GENERAL,'HotKeyActive',True);
  HotKeyBtn.Checked := HotKeyIsActive1.Checked;
  if Desktop1.Checked and ActiveWindow1.Checked then
   begin
     ActiveWindow1.Checked := False;
     MsgBox('Registry Error','Cannot capture both desktop and active window at a time!'+#13#13+
     'Wrong registry settings!',MB_OK+MB_ICONERROR);
   end;
  if Desktop1.Checked then
   ScreenCapture.Desktop := True
  else
   ScreenCapture.Desktop := False;

  // update record
  with JPEGProperties do
   begin
    Grayscale := Ini.ReadBool(REG_OUTPUT,'JPEGGrayscale',False);
    Progressive := Ini.ReadBool(REG_OUTPUT,'JPEGProgressive',False);
    Quality := Ini.ReadInteger(REG_OUTPUT,'JPEGQuality',90);
   end;

  // update record
  with InputProperties do
   begin
    Width := Ini.ReadInteger(REG_INPUT,'RWidth',0);
    Height := Ini.ReadInteger(REG_INPUT,'RHeight',0);
    Starting_X := Ini.ReadInteger(REG_INPUT,'StartingX',0);
    Starting_Y := Ini.ReadInteger(REG_INPUT,'StartingY',0);
    Hide_On_Capture := Ini.ReadBool(REG_INPUT,'HideOnCapture',False);
    Beep_On_Capture := Ini.ReadBool(REG_INPUT,'BeepOnCapture',False);
    Repaint_Time := Ini.ReadInteger(REG_INPUT,'RepaintTime',20);
    Use_Tray_Icon := Ini.ReadBool(REG_GENERAL,'UseTrayIcon',False);
    RxTrayIcon.Active := Use_Tray_Icon;
    Enable_Timer := Ini.ReadBool(REG_INPUT,'EnableTimer',False);
    Frequency := Ini.ReadInteger(REG_INPUT,'Frequency',0);
    TypeOfFrequency := Ini.ReadInteger(REG_INPUT,'FrequencyType',0);
   end;

  // update record
  with OutputProperties do
   begin
    Beep_On_Finish := Ini.ReadBool(REG_OUTPUT,'BeepOnFinishCapture',False);
    Show_Dialog_Before_Print := Ini.ReadBool(REG_OUTPUT,'ShowPrintDialog',False);
    File_Format := GetFormat(Ini.ReadInteger(REG_OUTPUT,'FileFormat',0));
    Ask_Image_Name := Ini.ReadBool(REG_OUTPUT,'AskImageName',True);
    Fixed_Image_Name := Ini.ReadBool(REG_OUTPUT,'FixedImageName',False);
    Auto_Image_Name := Ini.ReadBool(REG_OUTPUT,'AutoImageName',False);
    Fixed_Name := Ini.ReadString(REG_OUTPUT,'FixedName','SNAP');
    Auto_Prefix := Ini.ReadString(REG_OUTPUT,'Prefix','SNAP-');
    Output_Folder := Ini.ReadString(REG_OUTPUT,'OutputFolder','');
    Catalog_Folder := Ini.ReadString(REG_OUTPUT,'CatalogFolder','');
    Catalog_Ask_Name := Ini.ReadBool(REG_OUTPUT,'AskCatalogName',True);
    Catalog_Auto_Name := Ini.ReadBool(REG_OUTPUT,'AutoCatalogName',False);
   end;

   // update record
   with OptionsProperties do
    begin
     try
      HotKey := TextToShortCut(Ini.ReadString(REG_GENERAL,'HotKey','Alt+F12'));
     except
      HotKey := TextToShortCut('Alt+F12');
      MsgBox('Registry Error','Invalid capture hotkey stored in registry.'+#13#13+
     'Using Alt+F12 as default hotkey.',MB_OK+MB_ICONERROR);
     end;
     ScreenCapture.HotKey := HotKey;
     try
      HideHotKey := TextToShortCut(Ini.ReadString(REG_GENERAL,'HideHotKey','Alt+F11'));
     except
      HideHotKey := TextToShortCut('Alt+F11');
      MsgBox('Registry Error','Invalid hide/unhide hotkey stored in registry.'+#13#13+
     'Using Alt+F11 as default hotkey.',MB_OK+MB_ICONERROR);
     end;
     try
      RepeatHotKey := TextToShortCut(Ini.ReadString(REG_GENERAL,'RepeatHotKey','Shift+Alt+F12'));
     except
      HotKey := TextToShortCut('Shift+Alt+F12');
      MsgBox('Registry Error','Invalid repeat last capture hotkey stored in registry.'+#13#13+
     'Using Shift+Alt+F12 as default hotkey.',MB_OK+MB_ICONERROR);
     end;
     Save_On_Exit := Ini.ReadBool(REG_GENERAL,'SaveOnExit',True);
     Use_Tray_Icon := Ini.ReadBool(REG_GENERAL,'UseTrayIcon',False);
     Write_Date_Time := Ini.ReadBool(REG_GENERAL,'WriteDateTime',False);
     Prompt_For_Comment := Ini.ReadBool(REG_GENERAL,'PromptForComment',False);
     Sound_On_Hide := Ini.ReadBool(REG_GENERAL,'SoundOnHideUnhide',False);
     Auto_Save := Ini.ReadBool(REG_GENERAL,'AutoSave',False);
    end;

  Ini.Free;

   // now we must check if Timer is activated
   with InputProperties do
    begin
     if Enable_Timer then
      begin
        X := Frequency;
        CaptureTimer.Interval := GetFreq(X,TypeOfFrequency);
        ScreenCapture.TimerActivated := True;
        CaptureTimer.Enabled := True;
        with InputProperties do
         if Beep_On_Capture then
          Beep;
      end;
    end;
end;

procedure TMainForm.SaveSettingsBtn2Click(Sender: TObject);
begin
  SaveRegistry;
end;

procedure TMainForm.SaveRegistry;

function GetInteger(X: MyImageType): Integer;
begin
  case X of
   BMP: Result := 0;
   JPG: Result := 1;
   TIFF: Result := 2;
   else
    Result := 0;
  end;
end;

function GetSelected: Integer;
var I: Integer;
begin
 for I:=0 to 3 do
  if Output1.Items[I].Checked then
    Break;
 Result := I;
end;

begin
  Ini := TRegINIFile.Create;
  Ini.RootKey := HKEY_LOCAL_MACHINE;
  if not Ini.OpenKey('Software\Pungila Ciprian-Petrisor\SnapVideoPro',True) then
   begin
     Application.MessageBox('Could not open registry key.'+#13#13+
     'Another application may be using the registry.','Registry Error',MB_OK+MB_ICONERROR);
     Ini.Free;
     Exit;
   end;
  Ini.WriteBool(REG_INPUT,'Desktop',Desktop1.Checked);
  Ini.WriteBool(REG_INPUT,'ActiveWindow',ActiveWindow1.Checked);
  Ini.WriteBool(REG_INPUT,'FixedRegion',FixedRegion1.Checked);
  Ini.WriteBool(REG_INPUT,'Area',Area1.Checked);
  Ini.WriteBool(REG_INPUT,'Object',Object1.Checked);
  Ini.WriteInteger(REG_OUTPUT,'OutputOption',GetSelected);
  Ini.WriteBool(REG_GENERAL,'Preview',PreviewBtn.Checked);
  Ini.WriteBool(REG_GENERAL,'HotKeyActive',HotKeyBtn.Checked);

  // update record
  with InputProperties do
   begin
    Ini.WriteInteger(REG_INPUT,'RWidth',Width);
    Ini.WriteInteger(REG_INPUT,'RHeight',Height);
    Ini.WriteInteger(REG_INPUT,'StartingX',Starting_X);
    Ini.WriteInteger(REG_INPUT,'StartingY',Starting_Y);
    Ini.WriteBool(REG_INPUT,'HideOnCapture',Hide_On_Capture);
    Ini.WriteBool(REG_INPUT,'BeepOnCapture',Beep_On_Capture);
    Ini.WriteBool(REG_INPUT,'UseTrayIcon',Use_Tray_Icon);
    Ini.WriteBool(REG_INPUT,'EnableTimer',Enable_Timer);
    Ini.WriteInteger(REG_INPUT,'RepaintTime',Repaint_Time);
    Ini.WriteInteger(REG_INPUT,'Frequency',Frequency);
    Ini.WriteInteger(REG_INPUT,'FrequencyType',TypeOfFrequency);
   end;

  with OutputProperties do
   begin
    Ini.WriteBool(REG_OUTPUT,'BeepOnFinishCapture',Beep_On_Finish);
    Ini.WriteBool(REG_OUTPUT,'ShowPrintDialog',Show_Dialog_Before_Print);
    Ini.WriteInteger(REG_OUTPUT,'FileFormat',GetInteger(File_Format));
    Ini.WriteBool(REG_OUTPUT,'AskImageName',Ask_Image_Name);
    Ini.WriteBool(REG_OUTPUT,'FixedImageName',Fixed_Image_Name);
    Ini.WriteString(REG_OUTPUT,'FixedName',Fixed_Name);
    Ini.WriteBool(REG_OUTPUT,'AutoImageName',Auto_Image_Name);
    Ini.WriteString(REG_OUTPUT,'Prefix',Auto_Prefix);
    Ini.WriteString(REG_OUTPUT,'OutputFolder',Output_Folder);
    Ini.WriteString(REG_OUTPUT,'CatalogFolder',Catalog_Folder);
    Ini.WriteBool(REG_OUTPUT,'AskCatalogName',Catalog_Ask_Name);
    Ini.WriteBool(REG_OUTPUT,'AutoCatalogName',Catalog_Auto_Name);
   end;

   with OptionsProperties do
    begin
     Ini.WriteString(REG_GENERAL,'HotKey',ShortCutToText(HotKey));
     Ini.WriteString(REG_GENERAL,'HideHotKey',ShortCutToText(HideHotKey));
     Ini.WriteString(REG_GENERAL,'RepeatHotKey',ShortCutToText(RepeatHotKey));
     Ini.WriteBool(REG_GENERAL,'SaveOnExit',Save_On_Exit);
     Ini.WriteBool(REG_GENERAL,'UseTrayIcon',Use_Tray_Icon);
     Ini.WriteBool(REG_GENERAL,'WriteDateTime',Write_Date_Time);
     Ini.WriteBool(REG_GENERAL,'PromptForComment',Prompt_For_Comment);
     Ini.WriteBool(REG_GENERAL,'SoundOnHideUnhide',Sound_On_Hide);
     Ini.WriteBool(REG_GENERAL,'AutoSave',Auto_Save);
    end;

  with JPEGProperties do
   begin
    Ini.WriteBool(REG_OUTPUT,'JPEGGrayscale',Grayscale);
    Ini.WriteBool(REG_OUTPUT,'JPEGProgressive',Progressive);
    Ini.WriteInteger(REG_OUTPUT,'JPEGQuality',Quality);
   end;

  Ini.Free;
end;

procedure TMainForm.PreviewBtn2Click(Sender: TObject);
begin
  PreviewBtn.Checked := not PreviewBtn.Checked;
  if PreviewBtn.Checked then
   begin
     PreviewWindow1.Checked := True;
   end
  else
   begin
     PreviewWindow1.Checked := False;
   end;
end;

procedure TMainForm.PreviewWindow1Click(Sender: TObject);
begin
  PreviewWindow1.Checked := not PreviewWindow1.Checked;
  PreviewBtn.Checked := PreviewWindow1.Checked;
end;

procedure TMainForm.EnableButtons;
begin
  SaveBtn.Enabled := True;
  CloseBtn.Enabled := True;
  Tile1.Enabled := True;
  Tile2.Enabled := True;
  Cascade1.Enabled := True;
  ArrangeAll1.Enabled := True;
  Close1.Enabled := True;
  CloseAll1.Enabled := True;
  SaveImage1.Enabled := True;
  MinimizeAll1.Enabled := True;
  Resize1.Enabled := True;
  InsertText.Enabled := True;
  InsertImage1.Enabled := True;
  Undo1.Enabled := (ActiveMDIChild as TCaptureForm).UndoBitmap <> nil;
  Undo2.Enabled := Undo1.Enabled;
end;

procedure TMainForm.HotKeyIsActive1Click(Sender: TObject);
begin
  HotKeyIsActive1.Checked := not HotKeyIsActive1.Checked;
  HotKeyBtn.Checked := HotKeyIsActive1.Checked;
  ScreenCapture.Active := HotKeyBtn.Checked;
end;

procedure TMainForm.HotKeyBtn2Click(Sender: TObject);
begin
  HotKeyBtn.Checked := not HotKeyBtn.Checked;
  if HotKeyBtn.Checked then
   begin
     HotKeyIsActive1.Checked := True;
   end
  else
   begin
     HotKeyIsActive1.Checked := False;
   end;
  ScreenCapture.Active := HotKeyBtn.Checked;
end;

procedure TMainForm.OutputClick(Sender: TObject);
var Ind, I: Integer;
begin
  with Sender as TTBItem do
   begin
    Ind := MenuBar.Items[1].IndexOf(Sender as TTBItem);
   end;
  for I:=0 to 3 {there are 4 output options} do
   if I=Ind then
    Output1.Items[I].Checked := True
   else
    Output1.Items[I].Checked := False;
end;


procedure TMainForm.ExitBtn2Click(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.AppEventsException(Sender: TObject; E: Exception);
begin
  RxErrorDialog.ShowException(Sender,E);
end;

procedure TMainForm.CloseBtn2Click(Sender: TObject);
begin
  ActiveMDIChild.Close;
  { Note: Using a direct call to
          MDIChildCount does not return the
          correct value of MDI child windows. }
  if Application.MainForm.MDIChildCount=0 then
   begin
     SaveBtn.Enabled := False;
     CloseBtn.Enabled := False;
   end;
end;

procedure TMainForm.SaveBtn2Click(Sender: TObject);

function GetSelected: Integer;
var I: Integer;
begin
  for I:=0 to 3 do
   if Output1.Items[I].Checked then
    Break;
  Result := I;
end;

begin
  SendMessage(ActiveMDIChild.Handle,WM_SAVECAPTURE,GetSelected,0);
end;

procedure TMainForm.WMDisableButtons(var Message: TMessage);
begin
  InsertText.Enabled := False;
  InsertImage1.Enabled := False;
  SaveBtn.Enabled := False;
  CloseBtn.Enabled := False;
  Tile1.Enabled := False;
  Tile2.Enabled := False;
  Cascade1.Enabled := False;
  ArrangeAll1.Enabled := False;
  Close1.Enabled := False;
  CloseAll1.Enabled := False;
  MinimizeAll1.Enabled := False;
  SaveImage1.Enabled := False;
  Resize1.Enabled := False;
  Undo1.Enabled := False;
  Undo2.Enabled := Undo1.Enabled;
  DisableEffects;
end;

procedure TMainForm.WMAcceptCapture(var Message: TMessage);
begin
  AddNewCapture;
end;

procedure TMainForm.Properties1Click(Sender: TObject);
var X: LongInt;

function GetFreq(N: LongInt; X: Byte): LongInt;
begin
  case X of
   0: N := N * 3600 * 1000; {Hours}
   1: N := N * 60 * 1000; {Minutes}
   2: N := N * 1000; {Seconds}
   3: {nothing};
  end; {case}
  Result := N;
end;

begin
  { Disable hotkey if case!!!!!!! }

  with TInputForm.Create(Self) do
   try
   ShowModal;
  finally
   Free;
  end;

   ShowHint(Sender);

   // now we must check if Timer is activated
   with InputProperties do
    begin
     if Enable_Timer then
      begin
        X := Frequency;
        CaptureTimer.Interval := GetFreq(X,TypeOfFrequency);
        ScreenCapture.TimerActivated := True;
        CaptureTimer.Enabled := True;
        with InputProperties do
         if Beep_On_Capture then
          Beep;
      end;
    end;
end;

procedure TMainForm.Properties2Click(Sender: TObject);
begin
  with TOutputForm.Create(Self) do
   try
   ShowModal;
  finally
   Free;
  end;
end;

procedure TMainForm.ScreenCaptureBeforeCapture(Sender: TObject);
begin
  ShowLastCapture1.Enabled := True;

  with InputProperties do
  begin
   if Hide_On_Capture then
   begin
    ShowWindow(Application.Handle,SW_HIDE);
    ShowWindow(Application.MainForm.Handle,SW_HIDE);
   end;
   if not CaptureTimer.Enabled then
    if Beep_On_Capture then
     Beep;
   {
    Here goes nothing:
    Because the window is hidden too fast, we must allow
    a delay to repaint all desktop windows.
   }
   if not (Area1.Checked or Object1.Checked) then
     Delay(Repaint_Time)
   else
     ASGScreenCapture.Delay := Repaint_Time;
  end;

  X1 := GetTickCount;
end;

procedure TMainForm.About3Click(Sender: TObject);
begin
  with TAboutForm.Create(Self) do
   try
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.ShowLastCapture1Click(Sender: TObject);
begin
  if PreviewBtn.Checked then
  begin
   with PreviewForm do
    begin
     PreviewImage.Picture.Bitmap := ScreenCapture.Bitmap;
     Show;
    end;
  end
  else
   begin
     AddNewCapture;
   end;
end;

procedure TMainForm.AppEventsMinimize(Sender: TObject);
begin
  if RxTrayIcon.Active then
   ShowWindow(Application.Handle,SW_HIDE);
end;

procedure TMainForm.ProgramPreferences1Click(Sender: TObject);
begin
  with TOptionsForm.Create(Self) do
   try
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if OptionsProperties.Save_On_Exit then
   SaveSettingsBtn2Click(Sender);
end;

procedure TMainForm.SaveAllSettingsNow1Click(Sender: TObject);
begin
  SaveSettingsBtn2Click(Sender);
end;

procedure TMainForm.CaptureTimerTimer(Sender: TObject);
begin
  if not ScreenCapture.TimerActivated then
   begin
     CaptureTimer.Enabled := False;
     InputProperties.Enable_Timer := False;
     { Beep }
     with OutputProperties do
      if Beep_On_Finish then
       Beep;
     { Now show window }
     ShowWindow(Application.Handle,SW_SHOW);
     ShowWindow(Application.MainForm.Handle,SW_SHOW);
     Application.Restore;
     Application.BringToFront;
     Exit;
   end;
  ScreenCapture.Capture;
end;

procedure TMainForm.FormHiderAfterAction(Sender: TObject);
begin
  with OptionsProperties do
    if Sound_On_Hide then
     Beep;
end;

procedure TMainForm.FormHotKeyHandlerAction(Sender: TObject);
var Old1: TShortCut;
begin
  // test to see what type of capture we should perform
  

  if LastCaptured<0 then
   begin
     Old1 := FormHotKeyHandler.HotKey;
     FormHotKeyHandler.HotKey := TextToShortCut('');
     MsgBox('No Capture Perfomed',
     'No capture has been performed yet.  In order to use this '+
     'feature, you must perform a capture.'+#13#13+
     'Press the capture hotkey to start a capture.',MB_OK+MB_ICONINFORMATION);
     FormHotKeyHandler.HotKey := Old1;
     Exit;
   end;
  if LastCaptured=0 then
   ScreenCapture.Desktop := True
  else
   ScreenCapture.Desktop := False;

  ScreenCapture.OnBeforeCapture(Sender);
  ScreenCapture.OnCapture(Sender);
end;

procedure TMainForm.QuickHelp2Click(Sender: TObject);
begin
  with TQuickHelpForm.Create(Self) do
   try
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.HelpBtn2Click(Sender: TObject);
begin
  QuickHelp2Click(Sender);
end;

procedure TMainForm.Tile1Click(Sender: TObject);
begin
  TileMode := tbVertical;
  Tile;
end;

procedure TMainForm.Cascade1Click(Sender: TObject);
begin
  Cascade;
end;

procedure TMainForm.ArrangeAll1Click(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TMainForm.Close1Click(Sender: TObject);
begin
  CloseBtn2Click(Sender);
end;

procedure TMainForm.CloseAll1Click(Sender: TObject);
var I: Integer;
begin
  for I:=Application.MainForm.MDIChildCount-1 downto 0 do
   MDIChildren[I].Close;
end;

procedure TMainForm.MinimizeAll1Click(Sender: TObject);
var I: Integer;
begin
  for I:=MDIChildCount-1 downto 0 do
   MDIChildren[I].WindowState := wsMinimized;
end;

procedure TMainForm.About2Click(Sender: TObject);
begin
  About3Click(Sender);
end;

procedure TMainForm.ScreenShot(x : integer; y : integer; WidthX : integer; HeightX : integer; bm : TBitMap);
var
 dc: HDC;
 lpPal : PLOGPALETTE;
begin
 {test width and height}
 if ((WidthX = 0) OR (HeightX = 0)) then exit;
 bm.Width := WidthX;
 bm.Height := HeightX;
 {get the screen dc}
 dc := GetDc(0);
 if (dc = 0) then exit;
 {do we have a palette device?}
 if (GetDeviceCaps(dc, RASTERCAPS) AND RC_PALETTE = RC_PALETTE)
 then begin
  {allocate memory for a logical palette}
  GetMem(lpPal, sizeof(TLOGPALETTE) + (255 * sizeof(TPALETTEENTRY)));
  {zero it out to be neat}
  FillChar(lpPal^, sizeof(TLOGPALETTE) + (255 * sizeof(TPALETTEENTRY)),#0);
  {fill in the palette version}
  lpPal^.palVersion := $300;
  {grab the system palette entries}
  lpPal^.palNumEntries := GetSystemPaletteEntries(dc, 0, 256,
  lpPal^.palPalEntry);
  if (lpPal^.PalNumEntries <> 0) then begin
  {create the palette}
   bm.Palette := CreatePalette(lpPal^);
  end;
  FreeMem(lpPal, sizeof(TLOGPALETTE) + (255 * sizeof(TPALETTEENTRY)));
 end;
 {copy from the screen to the bitmap}
 BitBlt(bm.Canvas.Handle, 0, 0, WidthX, HeightX, Dc, x, y, SRCCOPY);
 {release the screen dc}
 ReleaseDc(0, dc);
end;

procedure TMainForm.CaptureFixedRegion;
begin
  ScreenCapture.CanCapture := False;
  Ini := TRegINIFile.Create;
  Ini.RootKey := REG_TYPE;
  if not Ini.OpenKey(REG_KEY,True) then
   begin
     Application.MessageBox('Could not load settings from the registry.'+#13#13+
     'Another application may be using it.','Registry Error',MB_OK+MB_ICONERROR);
     Ini.Free;
     Exit;
   end;
  with InputProperties do
   ScreenShot(Starting_X,Starting_Y,Width,Height,ScreenCapture.Bitmap);
  Ini.Free;
end;

procedure TMainForm.WizardBtn2Click(Sender: TObject);
begin
  with TWizardForm.Create(Self) do
   try
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem2Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etAntialias;
    Caption := 'Effect Browser - Antialias';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TopDockResize(Sender: TObject);
Var
 Bitmap: TBitmap;
begin
{ If Assigned(TBSkin) and Not (TBSkin.SkinType = tbsWindowsXP) Then
  Exit;}

 Bitmap := TBitmap.Create;
 Bitmap.Width := TopDock.Width;
 Bitmap.Height := TopDock.Height;

 SetStretchBltMode(Bitmap.Canvas.Handle,HALFTONE);
 StretchBlt(Bitmap.Canvas.Handle,
            0, 0, Bitmap.Width, Bitmap.Height +5,
            WinXPBackground.Bitmap.Canvas.Handle, 0, 0,
            WinXPBackground.Bitmap.Width,
            WinXPBackground.Bitmap.Height,
            SRCCOPY);

 DockBackground.Bitmap.Assign(Bitmap);
 Bitmap.Free;
end;

procedure TMainForm.OpenImage1Click(Sender: TObject);
begin
  { Show in child window }
  if OpenDialog.Execute then
  begin
    Inc(UntitledNo);
    with TCaptureForm.Create(Self) do
     begin
       DoubleBuffered := True;
       Caption := 'Untitled'+IntToStr(UntitledNo);
       Image.Picture.Bitmap.LoadFromFile(OpenDialog.FileName);
       Image.Picture.Bitmap.PixelFormat := pf24bit;
     end;
    EnableButtons;
    EnableEffects;
  end;
end;

procedure TMainForm.DisableEffects;
var I: Word;
begin
  for I:=0 to MenuBar.Items[4].Count-1 do
   MenuBar.Items[4].Items[I].Enabled := False;
end;

procedure TMainForm.EnableEffects;
var I: Word;
begin
  for I:=0 to MenuBar.Items[4].Count-1 do
   MenuBar.Items[4].Items[I].Enabled := True;
end;

procedure TMainForm.Tile2Click(Sender: TObject);
begin
  TileMode := tbHorizontal;
  Tile;
end;

procedure TMainForm.TBItem3Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etFisheye;
    Caption := 'Image Effect - Fisheye';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem1Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etMosaic;
    Caption := 'Image Effect - Mosaic';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem8Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etTwist;
    Caption := 'Image Effect - Twist';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem9Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etTile;
    Caption := 'Image Effect - Tile';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem12Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etTrace;
    Caption := 'Image Effect - Trace';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem13Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etEmboss;
    Caption := 'Image Effect - Emboss';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem14Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etSolorize;
    Caption := 'Image Effect - Solorize';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem15Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etPosterize;
    Caption := 'Image Effect - Posterize';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem19Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etContrast;
    Caption := 'Image Effect - Contrast';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem18Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etLightness;
    Caption := 'Image Effect - Lightness';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem21Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etDarkness;
    Caption := 'Image Effect - Darkness';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem20Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etSaturation;
    Caption := 'Image Effect - Saturation';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem4Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etGaussianBlur;
    Caption := 'Image Effect - Gaussian Blur';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem5Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etSplitBlur;
    Caption := 'Image Effect - Split Blur';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem6Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etAddColorNoise;
    Caption := 'Image Effect - Add Color Noise';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem7Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etAddMonoNoise;
    Caption := 'Image Effect - Add Mono Noise';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem11Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etSplitLight;
    Caption := 'Image Effect - Split Light';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem10Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etSpotLight;
    Caption := 'Image Effect - Spot Light';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem16Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etGrayscale;
    TrackBar.Visible := False;
    TrackBar.Value := TrackBar.MaxValue;
    lblPos.Visible := False;
    Caption := 'Image Effect - Grayscale';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.TBItem17Click(Sender: TObject);
begin
  if ActiveMDIChild = nil then
   Exit;
  with TEffectForm.Create(Self) do
   try
    Effect := etInvert;
    TrackBar.Visible := False;
    TrackBar.Value := TrackBar.MaxValue;
    lblPos.Visible := False;
    Caption := 'Image Effect - Invert';
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.Undo1Click(Sender: TObject);
var Aux: TBitmap;
begin
  if ActiveMDIChild <> nil then
  with (ActiveMDIChild as TCaptureForm) do
   if UndoBitmap <> nil then
    begin
      Aux := TBitmap.Create;
      Aux.Assign(UndoBitmap);
      UndoBitmap.Assign(Image.Picture.Bitmap);
      Image.Picture.Assign(Aux);
      Aux.Free;
      ImageNotSaved := True;
      OnResize(Sender);
    end;
end;

procedure TMainForm.Resize1Click(Sender: TObject);
var Filter: TResamplingFilter;
    Aux: TBitmap;
begin
  if ActiveMDIChild <> nil then
  with TResizeForm.Create(Self) do
   try
    W1 := (MainForm.ActiveMDIChild as TCaptureForm).Image.Picture.Bitmap.Width;
    H1 := (MainForm.ActiveMDIChild as TCaptureForm).Image.Picture.Bitmap.Height;
    Percent.Value := 100;
    W.MaxValue := Round(11 * W1);
    H.MaxValue := Round(11 * H1);
    W.MaxLength := Length(IntToStr(Round(W.MaxValue)));
    H.MaxLength := Length(IntToStr(Round(H.MaxValue)));
    W.Text := IntToStr(W1);
    H.Text := IntToStr(H1);
    ShowModal;
   finally

    if OK then { User pressed OK button }
    begin
      Filter := rfBox;
      case Resample.ItemIndex of
       0: Filter := rfBox;
       1: Filter := rfTriangle;
       2: Filter := rfHermite;
       3: Filter := rfBell;
       4: Filter := rfSpline;
       5: Filter := rfLanczos3;
       6: Filter := rfMitchell;
      end;
      with (MainForm.ActiveMDIChild as TCaptureForm) do
      begin
        if UndoBitmap = nil then
         UndoBitmap := TBitmap.Create;
        UndoBitmap.Assign(Image.Picture.Bitmap);
        Aux := TBitmap.Create;
        Aux.Assign(Image.Picture.Bitmap);
        jclGraphics.Stretch(W.AsInteger, H.AsInteger, Filter, Radius.Position, Aux, Image.Picture.Bitmap);
        Aux.Free;
        Image.Invalidate;
        ImageNotSaved := True;
      end;
      Undo1.Enabled := True;
      Undo2.Enabled := Undo1.Enabled;
    end;

    Free;
   end;
end;

procedure TMainForm.ClientWndProc(var Message: TMessage);
var
  MyDC: hDC;
  Ro, Co: Word;
begin
  with Message do
    case Msg of
      WM_ERASEBKGND:
        begin
          MyDC := TWMEraseBkGnd(Message).DC;
          for Ro := 0 to ClientHeight div Bitmap.Height do
            for Co := 0 to ClientWIDTH div Bitmap.Width do
              BitBlt(MyDC, Co * Bitmap.Width, Ro * Bitmap.Height,
                Bitmap.Width,
                Bitmap.Height, Bitmap.Canvas.Handle, 0, 0,
                  SRCCOPY);
          Result := 1;
        end;
    else
      Result := CallWindowProc(FPrevClientProc, ClientHandle, Msg, wParam, lParam);
    end;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  Bitmap.ReleaseHandle;
  Bitmap.Free;
  if (FPrevClientProc <> nil) then
  begin
    FClientInstance := Pointer(GetWindowLong(ClientHandle, GWL_WNDPROC));
    SetWindowLong(ClientHandle, GWL_WNDPROC, Longint(FPrevClientProc));
    FreeObjectInstance(FClientInstance);
  end;
end;

procedure TMainForm.TBItem23Click(Sender: TObject);
begin
  // help contents
//  Application.HelpJump('Contents');
  ShellExecute(Handle, 'open', PChar(ExtractFilePath(ParamStr(0))+'SnapVideoPro.pdf'), '', '', SW_SHOWNORMAL);
end;

procedure TMainForm.InsertTextClick(Sender: TObject);
begin
  with TTextEffectForm.Create(Self) do
   try
    ShowModal;
   finally
    Free;
   end;
end;

procedure TMainForm.InsertImage1Click(Sender: TObject);
begin
   with TfmGraphicsResource.Create(Self) do
    try
     ShowModal;
    finally
     Free;
   end;
end;

procedure TMainForm.TBItem22Click(Sender: TObject);
begin
  ShellExecute(Handle, 'open', 'www.snapvideopro.com', '', '', SW_SHOWNORMAL);
end;

procedure TMainForm.TBItem26Click(Sender: TObject);
begin
  ShellExecute(Handle, 'open', 'http://www.snapvideopro.com/help', '', '', SW_SHOWNORMAL);
end;

procedure TMainForm.TBItem25Click(Sender: TObject);
begin
  ShellExecute(Handle, 'open', 'http://www.snapvideopro.com/help', '', '', SW_SHOWNORMAL);
end;

procedure TMainForm.InsertArrows1Click(Sender: TObject);
begin
  with TImageEditForm.Create(Self) do
   try
     ShowModal;
   finally
     Free;
   end;
end;

procedure TMainForm.TBItem24Click(Sender: TObject);
begin
  with TWriteForm.Create(Self) do
   try
    ShowModal;
   finally
    Free;
   end;
end;

end.
