unit Options;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Menus;

type
  TOptionsForm = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    GroupBox1: TGroupBox;
    CTRL1: TCheckBox;
    Label1: TLabel;
    Label2: TLabel;
    SHIFT1: TCheckBox;
    ALT1: TCheckBox;
    Label3: TLabel;
    HotKey1: TComboBox;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    CTRL2: TCheckBox;
    SHIFT2: TCheckBox;
    ALT2: TCheckBox;
    HotKey2: TComboBox;
    GroupBox3: TGroupBox;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    CTRL3: TCheckBox;
    SHIFT3: TCheckBox;
    ALT3: TCheckBox;
    HotKey3: TComboBox;
    OKBtn: TButton;
    CancelBtn: TButton;
    ApplyBtn: TButton;
    GroupBox4: TGroupBox;
    AlwaysSaveSettings: TCheckBox;
    UseTrayIcon: TCheckBox;
    GroupBox5: TGroupBox;
    WriteDateTime: TCheckBox;
    PromptForComment: TCheckBox;
    GroupBox6: TGroupBox;
    HideUnhide: TCheckBox;
    AutoSave: TCheckBox;
    Label10: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ApplyBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure ApplyChanges;
    procedure HotKeyTo(Hot: TShortCut; Index: Integer);
    procedure HotKey1Change(Sender: TObject);
    procedure HotKey2Change(Sender: TObject);
    procedure HotKey3Change(Sender: TObject);
    procedure OptionsChanged(Sender: TObject);
    procedure UseTrayIconClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  OptionsForm: TOptionsForm;

implementation

{$R *.DFM}

uses Main;

procedure TOptionsForm.HotKeyTo(Hot: TShortCut; Index: Integer);
var S: String;                     {1..3}
    I: Integer;
begin
 S := ShortCutToText(Hot);
 case Index of
  1: begin
      CTRL1.Checked := Pos('Ctrl+',S)>0;
      SHIFT1.Checked := Pos('Shift+',S)>0;
      ALT1.Checked := Pos('Alt+',S)>0;
      for I:=Length(S) downto 1 do
       if S[I]='+' then
         Break;
      S := Copy(S,I+1,Length(S)-I);
      HotKey1.ItemIndex := HotKey1.Items.IndexOf(S);
     end;
  2: begin
      CTRL2.Checked := Pos('Ctrl+',S)>0;
      SHIFT2.Checked := Pos('Shift+',S)>0;
      ALT2.Checked := Pos('Alt+',S)>0;
      for I:=Length(S) downto 1 do
       if S[I]='+' then
         Break;
      S := Copy(S,I+1,Length(S)-I);
      HotKey2.ItemIndex := HotKey2.Items.IndexOf(S);
     end;
  3: begin
      CTRL3.Checked := Pos('Ctrl+',S)>0;
      SHIFT3.Checked := Pos('Shift+',S)>0;
      ALT3.Checked := Pos('Alt+',S)>0;
      for I:=Length(S) downto 1 do
       if S[I]='+' then
         Break;
      S := Copy(S,I+1,Length(S)-I);
      HotKey3.ItemIndex := HotKey3.Items.IndexOf(S);
     end;
  end; {case}
end;

procedure TOptionsForm.FormCreate(Sender: TObject);
begin
  with MainForm.OptionsProperties do
   begin
     HotKeyTo(HotKey,1);
     HotKey1Change(Sender);
     HotKeyTo(HideHotKey,2);
     HotKey2Change(Sender);
     HotKeyTo(RepeatHotKey,3);
     HotKey3Change(Sender);
     AlwaysSaveSettings.Checked := Save_On_Exit;
     UseTrayIcon.Checked := Use_Tray_Icon;
     WriteDateTime.Checked := Write_Date_Time;
     PromptForComment.Checked := Prompt_for_Comment;
     HideUnhide.Checked := Sound_On_Hide;
     AutoSave.Checked := Auto_Save;
   end;
  ApplyBtn.Enabled := False;
end;

procedure TOptionsForm.ApplyBtnClick(Sender: TObject);
begin
  ApplyBtn.Enabled := False;
  ApplyChanges;
end;

procedure TOptionsForm.OKBtnClick(Sender: TObject);
begin
  ApplyChanges;
end;

procedure TOptionsForm.ApplyChanges;

function GetHot(Ctrl,Shift,Alt: Boolean; Key: String): TShortCut;
var S: String;
begin
  S := '';
  if Ctrl then
   S := S + 'Ctrl+';
  if Shift then
   S := S + 'Shift+';
  if Alt then
   S := S + 'Alt+';
  S := S + Key;
  Result := TextToShortCut(S);
end;

begin
  with MainForm.OptionsProperties do
   begin
     HotKey := GetHot(CTRL1.Checked,SHIFT1.Checked,ALT1.Checked,HotKey1.Text);
     HideHotKey := GetHot(CTRL2.Checked,SHIFT2.Checked,ALT2.Checked,HotKey2.Text);
     RepeatHotKey := GetHot(CTRL3.Checked,SHIFT3.Checked,ALT3.Checked,HotKey3.Text);
     with MainForm do
     begin
       ScreenCapture.HotKey := HotKey;
       FormHider.HotKey := HideHotKey;
       FormHotKeyHandler.HotKey := RepeatHotKey;
     end;
     AlwaysSaveSettings.Checked := Save_On_Exit;
     Use_Tray_Icon := UseTrayIcon.Checked;
     Write_Date_Time := WriteDateTime.Checked;
     Prompt_for_Comment := PromptForComment.Checked;
     Sound_On_Hide := HideUnhide.Checked;
     Auto_Save := AutoSave.Checked;
     { If key could not be registered,
       restore previous configuration }
     HotKeyTo(MainForm.ScreenCapture.HotKey,1);
     { But if the key could not be registered on startup,
       then it will become NIL now, so we must check, but this
       is already done in ShowHint... }
   end;
   MainForm.ShowHint(Self);
end;

procedure TOptionsForm.OptionsChanged(Sender: TObject);
begin
  ApplyBtn.Enabled := True;
end;

procedure TOptionsForm.HotKey1Change(Sender: TObject);
begin
  if HotKey1.ItemIndex>HotKey1.Items.Count-3 then
   {Deactivate CTRL on CapsLock and NumLock}
    begin
      Ctrl1.Checked := False;
      Ctrl1.Enabled := False;
      Shift1.Enabled := True;
      Label1.Enabled := False;
      Label2.Enabled := True;
    end
   else
    if HotKey1.ItemIndex>HotKey1.Items.Count-5 then
    begin
      Shift1.Checked := False;
      Shift1.Enabled := False;
      Ctrl1.Enabled := True;
      Label1.Enabled := True;
      Label2.Enabled := False;
    end
   else
    begin
      Ctrl1.Enabled := True;
      Label1.Enabled := True;
      Shift1.Enabled := True;
      Label2.Enabled := True;
    end;
   OptionsChanged(Sender);
end;

procedure TOptionsForm.HotKey2Change(Sender: TObject);
begin
  if HotKey2.ItemIndex>HotKey2.Items.Count-3 then
   {Deactivate CTRL on CapsLock and NumLock}
    begin
      Ctrl2.Checked := False;
      Ctrl2.Enabled := False;
      Shift2.Enabled := True;
      Label4.Enabled := False;
      Label5.Enabled := True;
    end
   else
    if HotKey2.ItemIndex>HotKey2.Items.Count-5 then
    begin
      Shift2.Checked := False;
      Shift2.Enabled := False;
      Ctrl2.Enabled := True;
      Label4.Enabled := True;
      Label5.Enabled := False;
    end
   else
    begin
      Ctrl2.Enabled := True;
      Label4.Enabled := True;
      Shift2.Enabled := True;
      Label5.Enabled := True;
    end;
   OptionsChanged(Sender);
end;

procedure TOptionsForm.HotKey3Change(Sender: TObject);
begin
  if HotKey3.ItemIndex>HotKey3.Items.Count-3 then
   {Deactivate CTRL on CapsLock and NumLock}
    begin
      Ctrl3.Checked := False;
      Ctrl3.Enabled := False;
      Shift3.Enabled := True;
      Label7.Enabled := False;
      Label8.Enabled := True;
    end
   else
    if HotKey3.ItemIndex>HotKey3.Items.Count-5 then
    begin
      Shift3.Checked := False;
      Shift3.Enabled := False;
      Ctrl3.Enabled := True;
      Label7.Enabled := True;
      Label8.Enabled := False;
    end
   else
    begin
      Ctrl3.Enabled := True;
      Label7.Enabled := True;
      Shift3.Enabled := True;
      Label8.Enabled := True;
    end;
   OptionsChanged(Sender);
end;

procedure TOptionsForm.UseTrayIconClick(Sender: TObject);
begin
  MainForm.RxTrayIcon.Active := UseTrayIcon.Checked;
  OptionsChanged(Sender);
end;

end.
