unit Output;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Mask, ToolEdit, Struct, FileCtrl, VCLUtils,
  JPEGProp;

type
  TOutputForm = class(TForm)
    PageControl1: TPageControl;
    OKBtn: TButton;
    CancelBtn: TButton;
    ApplyBtn: TButton;
    TabSheet1: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    GroupBox1: TGroupBox;
    BeepOnFinish: TCheckBox;
    GroupBox2: TGroupBox;
    ShowPrintDialog: TCheckBox;
    PrintSetupBtn: TButton;
    Label1: TLabel;
    GroupBox3: TGroupBox;
    FileFormat: TListBox;
    OptionsBtn: TButton;
    GroupBox4: TGroupBox;
    AskForName: TRadioButton;
    FixedName: TRadioButton;
    Label2: TLabel;
    FixedFileName: TEdit;
    Label3: TLabel;
    AutoName: TRadioButton;
    Label4: TLabel;
    Prefix: TEdit;
    Label5: TLabel;
    OutputFolder: TDirectoryEdit;
    Label6: TLabel;
    CatalogFolder: TDirectoryEdit;
    Label7: TLabel;
    GroupBox5: TGroupBox;
    Catalog_AutoName: TRadioButton;
    Catalog_AskName: TRadioButton;
    PrinterSetupDialog: TPrinterSetupDialog;
    procedure PrintSetupBtnClick(Sender: TObject);
    procedure ApplyBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure ApplyChanges;
    procedure FormCreate(Sender: TObject);
    procedure FileFormatClick(Sender: TObject);
    procedure AskForNameClick(Sender: TObject);
    procedure FixedNameClick(Sender: TObject);
    procedure AutoNameClick(Sender: TObject);
    procedure OutputChanged(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CancelBtnClick(Sender: TObject);
    procedure OptionsBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  OutputForm: TOutputForm;
  CanExit: Boolean = False;

implementation

{$R *.DFM}

uses Main;

procedure TOutputForm.PrintSetupBtnClick(Sender: TObject);
begin
  MainForm.PrinterSetupDialog.Execute;
end;

procedure TOutputForm.ApplyBtnClick(Sender: TObject);
begin
  ApplyChanges;
  if CanExit then
  // all was OK
  ApplyBtn.Enabled := False;
end;

procedure TOutputForm.OutputChanged(Sender: TObject);
begin
  ApplyBtn.Enabled := True;
end;

procedure TOutputForm.OKBtnClick(Sender: TObject);
begin
  ApplyChanges;
end;

procedure TOutputForm.ApplyChanges;

function GetFormat(X: Integer): MyImageType;
begin
  case X of
   0: Result := BMP;
   1: Result := JPG;
   2: Result := TIFF;
  else
   Result := None;
  end; {case}
end;

function CreateDirectory_Ex(StringX: String): Boolean;
var lastPos: Integer;
    Path,SubStr: String;
begin
  SubStr:=StringX;
  Path := Copy(SubStr,1,Pos(':\',SubStr));
  Delete(SubStr,1,Pos(':\',SubStr)+1);
  lastPos := 1;
  repeat
    Path := Path + '\' + Copy(SubStr, 1, Pos('\',SubStr)-1);
    if not DirectoryExists(Path) then
    if not CreateDirectory(pchar(Path),nil) then
     begin
       Result := False;
       Exit;
     end;

    lastPos := Pos('\',SubStr);
    SubStr := Copy(SubStr, lastPos+1,Length(SubStr)-lastPos);
  until Pos('\',SubStr)=0;

  if not
  CreateDirectory(pchar(StringX),nil)
  then
  Result := False
  else
  Result := True;
end;

begin
  CanExit := True;

  if OutputFolder.Text<>'' then
  if not DirectoryExists(OutputFolder.Text) then
   case MsgBox('Create Folder','Output folder does not exists.'+#13#13+
   'Would you like to create it now?',MB_YESNOCANCEL+MB_ICONQUESTION) of
    mrYes: begin
              if not CreateDirectory_Ex(OutputFolder.Text) then
               begin
                 CanExit := False;
                 MsgBox('Error','Unable to create output folder.',MB_OK+MB_ICONERROR);
                 Exit;
               end;
           end;
    mrNo, mrCancel:
           begin
           CanExit := False;
           Exit;
          end;
   end; {case}
  if CatalogFolder.Text<>'' then
  if not DirectoryExists(CatalogFolder.Text) then
   case MsgBox('Create Folder','Catalog folder does not exists.'+#13#13+
   'Would you like to create it now?',MB_YESNOCANCEL+MB_ICONQUESTION) of
    mrYes: begin
              if not CreateDirectory_Ex(CatalogFolder.Text) then
               begin
                 CanExit := False;
                 MsgBox('Error','Unable to create catalog folder.',MB_OK+MB_ICONERROR);
                 Exit;
               end;
           end;
    mrNo, mrCancel:
           begin
           CanExit := False;
           Exit;
          end;
   end; {case}
  with MainForm.OutputProperties do
   begin
     Beep_On_Finish := BeepOnFinish.Checked;
     Show_Dialog_Before_Print := ShowPrintDialog.Checked;
     File_Format := GetFormat(FileFormat.ItemIndex);
     { Should never occur }
     if File_Format=None then
       File_Format := BMP;
     Ask_Image_Name := AskForName.Checked;
     Fixed_Image_Name := FixedName.Checked;
     Fixed_Name := FixedFileName.Text;
     Auto_Image_Name := AutoName.Checked;
     Auto_Prefix := Prefix.Text;
     Output_Folder := OutputFolder.Text;
     Catalog_Folder := CatalogFolder.Text;
     Catalog_Auto_Name := Catalog_AutoName.Checked;
     Catalog_Ask_Name := Catalog_AskName.Checked;
   end;
end;

procedure TOutputForm.FormCreate(Sender: TObject);

function GetInteger(X: MyImageType): Integer;
begin
  case X of
   BMP: Result := 0;
   JPG: Result := 1;
   TIFF: Result := 2;
  else
   Result := 0;
  end;
end;

begin
  FileFormat.ItemIndex := 0;
  with MainForm.OutputProperties do
   begin
     BeepOnFinish.Checked := Beep_On_Finish;
     ShowPrintDialog.Checked := Show_Dialog_Before_Print;
     if GetInteger(File_Format) < FileFormat.Items.Count then
      FileFormat.ItemIndex := GetInteger(File_Format);
     FileFormatClick(Sender);
     AskForName.Checked := Ask_Image_Name;
     FixedName.Checked := Fixed_Image_Name;
     AutoName.Checked := Auto_Image_Name;
     OutputFolder.Text := Output_Folder;
     CatalogFolder.Text := Catalog_Folder;
     Catalog_AutoName.Checked := Catalog_Auto_Name;
     Catalog_AskName.Checked := Catalog_Ask_Name;
   end;

   if AskForName.Checked then
    AskForNameClick(Sender);
   if FixedName.Checked then
    FixedNameClick(Sender);
   if AutoName.Checked then
    AutoNameClick(Sender);
   ApplyBtn.Enabled := False;
end;

procedure TOutputForm.FileFormatClick(Sender: TObject);

procedure SetName(S: String);
begin
  Label3.Caption := '.'+S;
  Label5.Caption := '####.'+S;
  Catalog_AutoName.Caption := '&Automatic file name (IMAGE-xxxx.'+S+')';
end;

begin
  case FileFormat.ItemIndex of
   0: begin
       SetName('BMP');
       OptionsBtn.Enabled := False;
      end;
   1: begin
       SetName('JPG');
       OptionsBtn.Enabled := True;
      end;
   2: begin
       SetName('TIF');
       OptionsBtn.Enabled := False;
      end;
   end; {case}
   OutputChanged(Sender);
end;

procedure TOutputForm.AskForNameClick(Sender: TObject);
begin
  Label2.Enabled := False;
  FixedFileName.Enabled := False;
  FixedFileName.Color := clBtnFace;
  FixedFileName.Font.Color := clGrayText;
  Label3.Enabled := False;
  Label4.Enabled := False;
  Prefix.Enabled := False;
  Prefix.Color := clBtnFace;
  Prefix.Font.Color := clGrayText;
  Label5.Enabled := False;
  OutputChanged(Sender);
end;

procedure TOutputForm.FixedNameClick(Sender: TObject);
begin
  Label2.Enabled := True;
  FixedFileName.Enabled := True;
  FixedFileName.Color := clWindow;
  FixedFileName.Font.Color := clWindowText;
  Label3.Enabled := True;
  Label4.Enabled := False;
  Prefix.Enabled := False;
  Prefix.Color := clBtnFace;
  Prefix.Font.Color := clGrayText;
  Label5.Enabled := False;
  OutputChanged(Sender);
end;

procedure TOutputForm.AutoNameClick(Sender: TObject);
begin
  Label2.Enabled := False;
  FixedFileName.Enabled := False;
  FixedFileName.Color := clBtnFace;
  FixedFileName.Font.Color := clGrayText;
  Label3.Enabled := False;
  Label4.Enabled := True;
  Prefix.Enabled := True;
  Prefix.Color := clWindow;
  Prefix.Font.Color := clWindowText;
  Label5.Enabled := True;
  OutputChanged(Sender);
end;

procedure TOutputForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if CanExit then
   Action := caFree
  else
   Action := caNone;
end;

procedure TOutputForm.CancelBtnClick(Sender: TObject);
begin
  CanExit := True;
end;

procedure TOutputForm.OptionsBtnClick(Sender: TObject);
begin
  case FileFormat.ItemIndex of
   1: begin {JPEG}
        with TJPEGForm.Create(Self) do
         try
          ShowModal;
         finally
          Free;
         end;
      end;
  end; {case}
end;

end.
