unit Reminder;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, mxProtector;

type
  TfmReminder = class(TForm)
    Label1: TLabel;
    Image1: TImage;
    Label2: TLabel;
    btnContinue: TButton;
    btnQuit: TButton;
    Label3: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    lblDaysLeft: TLabel;
    Label4: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    mxProtector: TmxProtector;
    Label8: TLabel;
    Bevel4: TBevel;
    Bevel5: TBevel;
    Label5: TLabel;
    procedure mxProtectorDayTrial(Sender: TObject; DaysRemained: Integer);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnQuitClick(Sender: TObject);
    procedure mxProtectorExpiration(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Match: String;
  end;

const
  Target = 'reset';

var
  fmReminder: TfmReminder;

implementation

{$R *.dfm}

procedure TfmReminder.mxProtectorDayTrial(Sender: TObject;
  DaysRemained: Integer);
begin
  lblDaysLeft.Caption := IntToStr(DaysRemained);
  if DaysRemained <= 2 then
   lblDaysLeft.Font.Color := clRed;
end;

procedure TfmReminder.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if not btnContinue.Enabled then
    PostMessage(Application.Handle, WM_QUIT, 0, 0);
end;

procedure TfmReminder.btnQuitClick(Sender: TObject);
begin
  PostMessage(Application.Handle, WM_QUIT, 0, 0);
end;

procedure TfmReminder.mxProtectorExpiration(Sender: TObject);
begin
  btnContinue.Visible := False;
  lblDaysLeft.Font.Color := clRed;
  lblDaysLeft.Caption := '0';
  Label4.Font.Color := clRed;
  Label4.Caption := 'Your evaluation period has expired. Please order the full version.';
end;

procedure TfmReminder.FormKeyPress(Sender: TObject; var Key: Char);
begin
{  Match := Match + Key;
  if Pos(Match, Target) <> 1 then
    Match := ''
  else
   if Match = Target then
    mxProtector.Reset;}
end;

procedure TfmReminder.FormCreate(Sender: TObject);
begin
  Match := '';
end;

end.
