unit Resize;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Spin, RXSpin, ExtCtrls, Placemnt;

type
  TResizeForm = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    TrackBar1: TTrackBar;
    Label3: TLabel;
    OKBtn: TButton;
    CancelBtn: TButton;
    Percent: TRxSpinEdit;
    W: TRxSpinEdit;
    H: TRxSpinEdit;
    GroupBox2: TGroupBox;
    KeepRatio: TCheckBox;
    Resample: TRadioGroup;
    FormStorage: TFormStorage;
    Label4: TLabel;
    Radius: TTrackBar;
    lblPos: TLabel;
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure PercentChange(Sender: TObject);
    procedure WChange(Sender: TObject);
    procedure HChange(Sender: TObject);
    procedure KeepRatioClick(Sender: TObject);
    procedure RadiusChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    OK: Boolean;
    W1,H1: Integer;
  end;

var
  ResizeForm: TResizeForm;

implementation

{$R *.DFM}

procedure TResizeForm.OKBtnClick(Sender: TObject);
begin
  OK := True;
  Close;
end;

procedure TResizeForm.CancelBtnClick(Sender: TObject);
begin
  OK := False;
  Close;
end;

procedure TResizeForm.TrackBar1Change(Sender: TObject);
begin
  if TrackBar1.Position < TrackBar1.Max div 2 then
   Percent.Value := TrackBar1.Position
  else
   Percent.Value := (TrackBar1.Position - 100) * 10 + 100;
end;

procedure TResizeForm.PercentChange(Sender: TObject);
begin
  try
   W.Value := Round(W1 * (Percent.AsInteger / 100));
   H.Value := Round(H1 * (Percent.AsInteger / 100));
  if Percent.AsInteger <= 100 then
   TrackBar1.Position := Percent.AsInteger
  else
   TrackBar1.Position := Round((Percent.AsInteger - 100)/10 + 100);
  except
  end;
end;

procedure TResizeForm.WChange(Sender: TObject);
begin
  if KeepRatio.Checked then
    H.AsInteger := Round((W.AsInteger * H1) / W1);
end;

procedure TResizeForm.HChange(Sender: TObject);
begin
  if KeepRatio.Checked then
    W.AsInteger := Round((H.AsInteger * W1) / H1);
end;

procedure TResizeForm.KeepRatioClick(Sender: TObject);
begin
  if KeepRatio.Checked then
  begin
   H.AsInteger := Round((W.AsInteger * H1) / W1);
   TrackBar1.Enabled := True;
   Percent.Enabled := True;
   Percent.Color := clWindow;
   Label3.Font.Color := clWindowText;
  end
  else
  begin
    TrackBar1.Enabled := False;
    Percent.Enabled := False;
    Percent.Color := clBtnFace;
    Label3.Font.Color := clInactiveCaption;
  end;
end;

procedure TResizeForm.RadiusChange(Sender: TObject);
begin
  lblPos.Caption := IntToStr(Radius.Position);
end;

end.
