unit SInfo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SystemInfo, StdCtrls, RXCtrls;

type
  TSysInfoForm = class(TForm)
    OKBtn: TButton;
    Status: TMemo;
    CopyBtn: TButton;
    procedure FormCreate(Sender: TObject);
    procedure CopyBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SysInfoForm: TSysInfoForm;
  MyInfo : TSysInfo;

implementation

{$R *.DFM}

const
  CRLF = #13#10;

procedure TSysInfoForm.FormCreate(Sender: TObject);
var
  strDaylightSaving : string;
  MyDriveList : TDriveList;
  I : Integer;
  strTotal : string;
  strFree : string;
begin
  MyInfo := TSysInfo.Create(Self);
  with Status do
  begin
  Lines.Clear;

  Lines.Add('If you find any bugs, problems, etc. within');
  Lines.Add('SnapVideoPro, please report them to me, sending the');
  Lines.Add('information displayed herein also, so that I can');
  Lines.Add('detect the source of the problem.  Thanks!');
  Lines.Add('');
  Lines.Add('*** Processor info ***');
  Lines.Add('        Processor Type: ' + MyInfo.ProcessorType);
  Lines.Add('        Processor architecture: '+ MyInfo.ProcessorArchitecture);
  Lines.Add('        Operating system: ' + MyInfo.OperatingSystem);
  Lines.Add('        Number of processors: ' + IntToStr(MyInfo.NumberOfProcessors));
  Lines.Add('        CPU Speed: ' + Format('%.1f MHz', [MyInfo.cpuSpeed]));
  Lines.Add('');
  Lines.Add('*** Operating System info ***');
  Lines.Add('        Operating system Version: ' + IntToStr(MyInfo.OSVerMajor) +
    '.' + IntToStr(MyInfo.OSVerMinor));
  Lines.Add('        Build number: ' + IntToStr(MyInfo.BuildNo));
  Lines.Add('        Service Pack: ' + MyInfo.ServicePack);
  Lines.Add('        Windows directory: ' + MyInfo.WindowsDir);
  Lines.Add('        Windows system directory: ' + MyInfo.WinSysDir);

  Lines.Add('');
  Lines.Add('*** Battery Status info ***');
  Lines.Add('        AC Line Status: ' + MyInfo.ACLineStatus);
  Lines.Add('        Battery Status: ' + MyInfo.BatteryStatus);
  Lines.Add('        Battery Life Percent: ' + IntToStr(MyInfo.BatteryLifePercent));
  Lines.Add('        Battery Life: ' + IntToStr(MyInfo.BatteryLife));
  Lines.Add('        Battery Full Time: ' + IntToStr(MyInfo.BatteryFullTime));

  Lines.Add('');
  Lines.Add('*** Memory info ***');
  Lines.Add('        Physical Memory Available: ' + IntToStr(MyInfo.MemAvailPhysical));
  Lines.Add('        Total Memory Available: ' + IntToStr(MyInfo.MemAvailTotal));
  Lines.Add('        Total Page File Size: ' + IntToStr(MyInfo.PageFileTotal));
  Lines.Add('        Page File Available: ' + IntToStr(MyInfo.PageFileAvail));
  Lines.Add('        Total Virtual Memory: ' + IntToStr(MyInfo.MemVirtualTotal));
  Lines.Add('        Virtual Memory Available: ' + IntToStr(MyInfo.MemVirtualAvail));

  Lines.Add('');
  Lines.Add('*** Time Zone info ***');
  if myInfo.DaylightSaving then
    strDaylightSaving := 'Yes'
  else
    strDaylightSaving := 'No';

  //Day in month format.
  if MyInfo.DaylightDate = 0 then
    Lines.Add('        Daylight savings date: ' + MyInfo.DaylightDayNo + ' ' +
      MyInfo.DaylightDay + ' in ' + MyInfo.DaylightMonth +
      ' at ' + FormatDateTime('hh:nn:ss', MyInfo.DaylightHour))
  else
    //Absolute format.
    Lines.Add(FormatDateTime('dd mmmm', MyInfo.DaylightDate));

  //Day in month format
  if MyInfo.StandardDate = 0 then
    Lines.Add('        Standard date: ' + MyInfo.StandardDayNo + ' ' +
     MyInfo.StandardDay + ' in ' + MyInfo.StandardMonth +
     ' at ' + FormatDateTime('hh:nn:ss', MyInfo.StandardHour))
  else
    //Absolute format
    Lines.Add('        Standard date: ' +
      FormatDateTime('dd mmmm', MyInfo.StandardDate));

  Lines.Add('        Daylight saving: ' + strDaylightSaving);
  Lines.Add('        Daylight time zone: ' + MyInfo.DaylightTimeZone);
  Lines.Add('        Time Zone: ' +  MyInfo.TimeZone);
  Lines.Add('        Bias: ' + IntToStr(MyInfo.Bias));
  Lines.Add('        Daylight saving offset: ' + IntToStr(MyInfo.DaylightBias));

  Lines.Add('');
  Lines.Add('*** Video info ***');
  Lines.Add('        Resolution: ' + MyInfo.VideoResolution);
  Lines.Add('        Number of colours: ' + FloatToStr(MyInfo.NumberOfColours));

  Lines.Add('');
  Lines.Add('*** Disk Info - Drive C:***') ;
  Lines.Add('        Free space on C: ' + IntToStr(MyInfo.DiskFree));
  Lines.Add('        Free clusters: ' + IntToStr(MyInfo.FreeClusters));
  Lines.Add('        Sectors per cluster: ' + IntToStr(MyInfo.SectorsPerCluster));
  Lines.Add('        Bytes per sector: ' + IntToStr(MyInfo.BytesPerSector));
  Lines.Add('        Total clusters: ' + IntToStr(MyInfo.TotalClusters));

  Lines.Add('');
  Lines.Add('*** Disk Info - All Drives ***');

  //Create and free are handled by the component.
  MyDriveList := MyInfo.GetDiskDrives;
  For I := 0 to MyDriveList.Count -1 do
  begin
    strTotal := FormatFloat('##########0,', MyDriveList.TotalSpace(I))
      + ' Total KBytes, ';
    strFree := FormatFloat('#########0,', MyDriveList.FreeSpace(I))
      + ' KBytes free';
    Lines.Add('        --- '+MyDriveList.DriveName(I) + ': [' +
       MyDriveList.DriveType(I) + ']  ---');{ +
       strTotal + strFree + ', ' + MyDriveList.FSName(I) + ', '
       + 's/n: ' + IntToStr(MyDriveList.SerialNo(I)) +
       ', ' + MyDriveList.VolName(I));}
    Lines.Add('              ' + strTotal);
    Lines.Add('              ' + strFree);
    Lines.Add('              ' + MyDriveList.FSName(I));
    Lines.Add('              s/n: ' + IntToStr(MyDriveList.SerialNo(I)));
    Lines.Add('              ' + MyDriveList.VolName(I));
  end;

  Lines.Add('*** Network Info ***');
  Lines.Add('        Computer Name: '+ MyInfo.ComputerName);
  Lines.Add('        User name: ' + MyInfo.UserName);
  Lines.Add('        Host name: ' + MyInfo.HostName);

  Lines.Add('');
  Lines.Add('*** Registered User ***');
  Lines.Add('        Registered user: ' + MyInfo.RegisteredUser);
  Lines.Add('        Registered company: ' + MyInfo.RegisteredCompany);
  Lines.Add('        CD Number: ' + MyInfo.CDNumber);
  end;
end;

procedure TSysInfoForm.CopyBtnClick(Sender: TObject);
begin
  Status.SelectAll;
  Status.CopyToClipboard;
  Status.SelLength := 0;
  Application.MessageBox('Please remember to send this information to the '+
  'author if you find any problems,'+#13#10+
  'plus a brief description of how to reproduce the problem.'+#13#10#13#10+
  'Thank you!','Support',MB_OK+MB_ICONINFORMATION);
end;

end.
