unit EffectPreview;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ProEffectImage, StdCtrls, ComCtrls, janTracker,
  Struct, Second, RXSlider, Placemnt, My_ScrollBox;

type
  TEffectForm = class(TForm)
    Panel1: TPanel;
    TrackBar: TRxSlider;
    lblPos: TLabel;
    Panel2: TPanel;
    ApplyBtn: TButton;
    CancelBtn: TButton;
    FormStorage: TFormStorage;
    FormPlacement: TFormPlacement;
    ScrollBox: TMyScrollBox;
    ProEffectImage: TProEffectImage;
    procedure FormCreate(Sender: TObject);
    procedure EffectsListClick(Sender: TObject);
    procedure ApplyBtn_Click(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure TrackBarChange(Sender: TObject);
    procedure ApplyBtnClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Effect: TEffectType;
  end;

var
  EffectForm: TEffectForm;

implementation

uses Main;

{$R *.DFM}

{ FORM CREATION }
//------------------------------------------------------------------------------
procedure TEffectForm.FormCreate(Sender: TObject);
begin
  ScrollBox.BackBitmap.LoadFromResourceName(HInstance, 'BACK');
  ProEffectImage.Picture.Assign((MainForm.ActiveMDIChild as TCaptureForm).Image.Picture);
end;
//------------------------------------------------------------------------------



{ EFFECT LISTBOX ACTIONS }
//------------------------------------------------------------------------------
procedure TEffectForm.EffectsListClick(Sender: TObject);
begin

 {Start}
 ProEffectImage.Picture.Assign((MainForm.ActiveMDIChild as TCaptureForm).Image.Picture);
 TrackBar.Enabled     := True;
 TrackBar.Value    := 1;

end;
//------------------------------------------------------------------------------



{ APPLY BUTTON ACTIONS }
//------------------------------------------------------------------------------
procedure TEffectForm.ApplyBtn_Click(Sender: TObject);
Var i  : Integer; {For Loop}
begin

  Screen.Cursor := crHourGlass;
  ProEffectImage.Picture.Assign((MainForm.ActiveMDIChild as TCaptureForm).Image.Picture);

  { E F F E C T S }
     Case Effect of

           etGaussianBlur:    ProEffectImage.Effect_GaussianBlur   (TrackBar.Value);
           etSplitBlur:       ProEffectImage.Effect_SplitBlur      (TrackBar.Value);
           etAddColorNoise:   ProEffectImage.Effect_AddColorNoise  (TrackBar.Value * 3);
           etAddMonoNoise:    ProEffectImage.Effect_AddMonoNoise   (TrackBar.Value * 3);
           etAntialias:       for i:=1 to TrackBar.Value do
                               ProEffectImage.Effect_AntiAlias;
           etContrast:        ProEffectImage.Effect_Contrast       (TrackBar.Value * 3);
           etFisheye:         ProEffectImage.Effect_FishEye        (TrackBar.Value div 10+1);
           etLightness:       ProEffectImage.Effect_Lightness      (TrackBar.Value * 2);
           etDarkness:        ProEffectImage.Effect_Darkness       (TrackBar.Value * 2);
           etSaturation:      ProEffectImage.Effect_Saturation     (255-((TrackBar.Value * 255) div 100));
           etMosaic:          ProEffectImage.Effect_Mosaic         (TrackBar.Value div 2);
           etTwist:           ProEffectImage.Effect_Twist          (200-(TrackBar.Value * 2)+1);
           etSplitLight:      ProEffectImage.Effect_Splitlight     (TrackBar.Value div 20);
           etTile:            ProEffectImage.Effect_Tile           (TrackBar.Value div 10);
           etSpotLight:       ProEffectImage.Effect_SpotLight      (TrackBar.Value ,
                                                    Rect (TrackBar.Value ,
                                                    TrackBar.Value ,
                                                    TrackBar.Value +TrackBar.Value*2,
                                                    TrackBar.Value +TrackBar.Value*2));
           etTrace: ProEffectImage.Effect_Trace          (TrackBar.Value div 10);
           etEmboss: For i:=1 to TrackBar.Value do
              ProEffectImage.Effect_Emboss;
           etSolorize: ProEffectImage.Effect_Solorize       (255-((TrackBar.Value * 255) div 100));
           etPosterize: ProEffectImage.Effect_Posterize      (((TrackBar.Value * 255) div 100)+1);
           etGrayscale: ProEffectImage.Effect_Grayscale;
           etInvert: ProEffectImage.Effect_Invert;

     end;{Case}


  Screen.Cursor := crDefault;

end;
//------------------------------------------------------------------------------



procedure TEffectForm.CancelBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TEffectForm.TrackBarChange(Sender: TObject);
begin
 lblPos.Caption := Inttostr(TrackBar.Value) + '%';
 ApplyBtn_Click(Sender);
end;

procedure TEffectForm.ApplyBtnClick(Sender: TObject);
begin
  with (MainForm.ActiveMDIChild as TCaptureForm) do
  begin
   if UndoBitmap = nil then
    UndoBitmap := TBitmap.Create;
   UndoBitmap.Assign(Image.Picture.Bitmap);
   Image.Picture.Assign(ProEffectImage.Picture);
   MainForm.Undo1.Enabled := True;
   MainForm.Undo2.Enabled := MainForm.Undo1.Enabled;
   ImageNotSaved := True;
  end;
  Close;
end;

procedure TEffectForm.FormResize(Sender: TObject);
begin
  if (ScrollBox.Width - ProEffectImage.Picture.Width) div 2 > 0 then
   ProEffectImage.Left := (ScrollBox.Width - ProEffectImage.Picture.Width) div 2
  else
   ProEffectImage.Left := 0;
  if (ScrollBox.Height - ProEffectImage.Picture.Height) div 2 > 0 then
   ProEffectImage.Top := (ScrollBox.Height - ProEffectImage.Picture.Height) div 2
  else
   ProEffectImage.Top := 0;
end;

end.
