unit ImageEditPreview;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ProEffectImage, StdCtrls, ComCtrls, janTracker,
  Struct, Second, RXSlider, Placemnt, My_ScrollBox, Spin, viArrow;

type
  TImageEditForm = class(TForm)
    FormStorage: TFormStorage;
    FormPlacement: TFormPlacement;
    ScrollBox: TMyScrollBox;
    ProEffectImage: TProEffectImage;
    Panel1: TPanel;
    Panel2: TPanel;
    ApplyBtn: TButton;
    CancelBtn: TButton;
    viArrowEx1: TviArrowEx;
    procedure FormCreate(Sender: TObject);
    procedure EffectsListClick(Sender: TObject);
    procedure ApplyBtn_Click(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure ApplyBtnClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure lblTextMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ProEffectImageMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ScrollBoxMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ScrollBoxMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ScrollBoxMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    Effect: TEffectType;
    fLockClientUpdateCount: Integer;
    procedure LockClientUpdate;
    procedure UnlockClientUpdate;
  end;

var
  Shape: TviArrowEx;
  ImageEditForm: TImageEditForm;
  MouseIsDown: Boolean = False;

implementation

uses Main;

{$R *.DFM}

{ FORM CREATION }
//------------------------------------------------------------------------------
procedure TImageEditForm.FormCreate(Sender: TObject);
begin
  ScrollBox.BackBitmap.LoadFromResourceName(HInstance, 'BACK');
  ProEffectImage.Picture.Assign((MainForm.ActiveMDIChild as TCaptureForm).Image.Picture);
end;
//------------------------------------------------------------------------------



{ EFFECT LISTBOX ACTIONS }
//------------------------------------------------------------------------------
procedure TImageEditForm.EffectsListClick(Sender: TObject);
begin

 {Start}
 ProEffectImage.Picture.Assign((MainForm.ActiveMDIChild as TCaptureForm).Image.Picture);

end;
//------------------------------------------------------------------------------



{ APPLY BUTTON ACTIONS }
//------------------------------------------------------------------------------
procedure TImageEditForm.ApplyBtn_Click(Sender: TObject);
begin
 // apply changes
end;
//------------------------------------------------------------------------------



procedure TImageEditForm.CancelBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TImageEditForm.ApplyBtnClick(Sender: TObject);
var
  LogFont: TLogFont;
begin
  with (MainForm.ActiveMDIChild as TCaptureForm) do
  begin
   if UndoBitmap = nil then
    UndoBitmap := TBitmap.Create;
   UndoBitmap.Assign(Image.Picture.Bitmap);
   Image.Picture.Assign(ProEffectImage.Picture);
   MainForm.Undo1.Enabled := True;
   MainForm.Undo2.Enabled := MainForm.Undo1.Enabled;
   ImageNotSaved := True;
  end;
  Close;
end;

procedure TImageEditForm.FormResize(Sender: TObject);
var OLeft, OTop: Integer;
begin
  if (ScrollBox.Width - ProEffectImage.Picture.Width) div 2 > 0 then
   ProEffectImage.Left := (ScrollBox.Width - ProEffectImage.Picture.Width) div 2
  else
   ProEffectImage.Left := 0;
  if (ScrollBox.Height - ProEffectImage.Picture.Height) div 2 > 0 then
   ProEffectImage.Top := (ScrollBox.Height - ProEffectImage.Picture.Height) div 2
  else
   ProEffectImage.Top := 0;
end;

procedure TImageEditForm.lblTextMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  TempPanel: TPanel;
  Control: TControl;
begin
  {Release the MOUSEDOWN status}
  ReleaseCapture;
  {If the component is a TWinControl, just move it directly}
  if Sender is TWinControl then
    TWinControl(Sender).Perform(WM_SysCommand, $F012, 0)
  else
  try
    Control := TControl(Sender);
    TempPanel := TPanel.Create(Self);
    TempPanel.Color := clWhite;
    with TempPanel do
    begin
      {Replace the component with TempPanel}
      Caption := '';
      BevelOuter := bvLowered;
      SetBounds(Control.Left, Control.Top, Control.Width, Control.Height);
      Parent := Control.Parent;
      {Put our control in TempPanel}
      Width := Control.Width;
      Height := Control.Height;
      Control.Parent := TempPanel;
      Control.Left := 0;
      Control.Top := 0;
      Control.Visible := True;
      Control.Update;
      {Move TempPanel with control inside of it}
      Perform(WM_SysCommand, $F012, 0);
      {Put the component where the panel was dropped}
      Control.Parent := Parent;
      Control.Left := Left;
      Control.Top := Top;
    end;
  finally
    TempPanel.Free;
  end;
end;

procedure TImageEditForm.ProEffectImageMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  // start drawing
  Shape := TviArrowEx.Create(Self);
  Shape.Parent := ScrollBox;
  Shape.Left := X;
  Shape.Top := Y;
  Shape.Width := 1;
  Shape.Height := 1;
  MouseIsDown := True;
end;

procedure TImageEditForm.LockClientUpdate;
begin
 try
  if fLockClientUpdateCount = 0 then
    SendMessage(ClientHandle, WM_SETREDRAW, 0, 0);
  Inc(fLockClientUpdateCount);
 except
 end;
end;

procedure TImageEditForm.UnlockClientUpdate;
begin
 try
  Dec(fLockClientUpdateCount);
  if fLockClientUpdateCount = 0 then
  begin
    SendMessage(ClientHandle, WM_SETREDRAW, 1, 0);
    RedrawWindow(ClientHandle, nil, 0, RDW_FRAME or RDW_INVALIDATE or
      RDW_ALLCHILDREN or RDW_NOINTERNALPAINT)
  end;
 except
 end;
end;

procedure TImageEditForm.ScrollBoxMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  MouseIsDown := False;
end;

procedure TImageEditForm.ScrollBoxMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  // start drawing
  Shape := TviArrowEx.Create(Self);
  Shape.Parent := ScrollBox;
  Shape.Left := X;
  Shape.Top := Y;
  Shape.Width := 1;
  Shape.Height := 1;
  MouseIsDown := True;
end;

procedure TImageEditForm.ScrollBoxMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if MouseIsDown then
   with Shape do begin
     Width := X - Left;
     Height := Y - Top;
   end;
end;

end.
