unit Input;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Menus;

type
  TInputForm = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    OKBtn: TButton;
    CancelBtn: TButton;
    ApplyBtn: TButton;
    GroupBox1: TGroupBox;
    HideOnCapture: TCheckBox;
    BeepOnCapture: TCheckBox;
    EnableTimer: TCheckBox;
    Label3: TLabel;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    CaptureTime: TEdit;
    Hours: TRadioButton;
    Minutes: TRadioButton;
    Seconds: TRadioButton;
    Milliseconds: TRadioButton;
    DefaultsBtn: TButton;
    GroupBox3: TGroupBox;
    RepaintTime: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    TabSheet3: TTabSheet;
    GroupBox4: TGroupBox;
    Label5: TLabel;
    RWidth: TEdit;
    RHeight: TEdit;
    Label6: TLabel;
    Label7: TLabel;
    StartingX: TEdit;
    Label8: TLabel;
    StartingY: TEdit;
    procedure EnableTimerClick(Sender: TObject);
    procedure CaptureTimeKeyPress(Sender: TObject; var Key: Char);
    procedure CaptureTimeExit(Sender: TObject);
    procedure DefaultsBtnClick(Sender: TObject);
    procedure ApplyBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure ApplyChanges;
    procedure FormCreate(Sender: TObject);
    procedure InputChanged(Sender: TObject);
    procedure RepaintTimeKeyPress(Sender: TObject; var Key: Char);
    procedure RWidthKeyPress(Sender: TObject; var Key: Char);
    procedure RWidthExit(Sender: TObject);
    procedure RHeightExit(Sender: TObject);
    procedure StartingXExit(Sender: TObject);
    procedure StartingYExit(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  InputForm: TInputForm;

implementation

{$R *.DFM}

uses Main;

procedure TInputForm.EnableTimerClick(Sender: TObject);
begin
  Label3.Enabled := EnableTimer.Checked;
  InputChanged(Sender);
end;

procedure TInputForm.CaptureTimeKeyPress(Sender: TObject; var Key: Char);
begin
  if not (Key in ['0'..'9',#8]) then
   Key := #0;
end;

procedure TInputForm.CaptureTimeExit(Sender: TObject);
begin
  if (CaptureTime.Text = '') then
   CaptureTime.Text := '0';
end;

procedure TInputForm.DefaultsBtnClick(Sender: TObject);
begin
  HideOnCapture.Checked := False;
  BeepOnCapture.Checked := False;
  InputChanged(Sender);
end;

procedure TInputForm.ApplyBtnClick(Sender: TObject);
begin
  ApplyBtn.Enabled := False;
  ApplyChanges;
end;

procedure TInputForm.InputChanged(Sender: TObject);
begin
  ApplyBtn.Enabled := True;
end;

procedure TInputForm.OKBtnClick(Sender: TObject);
begin
  ApplyChanges;
end;

procedure TInputForm.ApplyChanges;

function GetType: Integer;
begin
  if Hours.Checked then
   Result := 0
  else
   if Minutes.Checked then
    Result := 1
   else
    if Seconds.Checked then
     Result := 2
    else
     Result := 3;
end;

begin
  with MainForm.InputProperties do
   begin
     Hide_On_Capture := HideOnCapture.Checked;
     Beep_On_Capture := BeepOnCapture.Checked;
     Width := StrToInt(RWidth.Text);
     Height := StrToInt(RHeight.Text);
     Starting_X := StrToInt(StartingX.Text);
     Starting_Y := StrToInt(StartingY.Text);
     if RepaintTime.Text = '' then
      RepaintTime.Text := '0';
     Repaint_Time := StrToInt(RepaintTime.Text);
     Enable_Timer := EnableTimer.Checked;
     Frequency := StrToInt(CaptureTime.Text);
     TypeOfFrequency := GetType;
   end;
end;

procedure TInputForm.FormCreate(Sender: TObject);
begin
  with MainForm.InputProperties do
   begin
     RWidth.Text := IntToStr(Width);
     RHeight.Text := IntToStr(Height);
     StartingX.Text := IntToStr(Starting_X);
     StartingY.Text := IntToStr(Starting_Y);
     HideOnCapture.Checked := Hide_On_Capture;
     BeepOnCapture.Checked := Beep_On_Capture;
     RepaintTime.Text := IntToStr(Repaint_Time);
     CaptureTime.Text := IntToStr(Frequency);
     EnableTimer.Checked := Enable_Timer;
     Hours.Checked := False;
     Minutes.Checked := False;
     Seconds.Checked := False;
     Milliseconds.Checked := False;
     case TypeOfFrequency of
      0: Hours.Checked := True;
      1: Minutes.Checked := True;
      2: Seconds.Checked := True;
      3: Milliseconds.Checked := True;
     else
      Milliseconds.Checked := True;
     end; {case}
   end;
   ApplyBtn.Enabled := False;
end;

procedure TInputForm.RepaintTimeKeyPress(Sender: TObject; var Key: Char);
begin
  if not (Key in ['0'..'9',#8]) then
   Key := #0;
end;

procedure TInputForm.RWidthKeyPress(Sender: TObject; var Key: Char);
begin
  if not (Key in ['0'..'9',#8]) then
   Key := #0;
end;

procedure TInputForm.RWidthExit(Sender: TObject);
begin
  if RWidth.Text='' then
   RWidth.Text := '0';
  if StrToInt(RWidth.Text)>Screen.Width then
  begin
    Application.MessageBox(PChar('You must enter a value between 0-'+IntToStr(Screen.Width)+'!'),'Warning',MB_OK+MB_ICONWARNING);
    RWidth.SetFocus;
  end;
end;

procedure TInputForm.RHeightExit(Sender: TObject);
begin
  if RHeight.Text='' then
   RHeight.Text := '0';
  if StrToInt(RHeight.Text)>Screen.Height then
  begin
    Application.MessageBox(PChar('You must enter a value between 0-'+IntToStr(Screen.Height)+'!'),'Warning',MB_OK+MB_ICONWARNING);
    RHeight.SetFocus;
  end;
end;

procedure TInputForm.StartingXExit(Sender: TObject);
begin
  if StartingX.Text='' then
   StartingX.Text := '0';
  if StrToInt(StartingX.Text)>Screen.Width then
  begin
    Application.MessageBox(PChar('You must enter a value between 0-'+IntToStr(Screen.Width)+'!'),'Warning',MB_OK+MB_ICONWARNING);
    StartingX.SetFocus;
  end;
end;

procedure TInputForm.StartingYExit(Sender: TObject);
begin
  if StartingY.Text='' then
   StartingY.Text := '0';
  if StrToInt(StartingY.Text)>Screen.Height then
  begin
    Application.MessageBox(PChar('You must enter a value between 0-'+IntToStr(Screen.Height)+'!'),'Warning',MB_OK+MB_ICONWARNING);
    StartingY.SetFocus;
  end;
end;

end.
