unit Preview;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, Buttons, ToolWin, ExtCtrls, Placemnt,
  Struct, VCLUtils, dfsToolBar,  {JCLGraphics, }Menus, ImgList,
  TB2Item, TB2Toolbar, My_ScrollBox, TB2Dock{!!!!!!!!!!!!!!!!};

type
  TPreviewForm = class(TForm)
    FormStorage: TFormStorage;
    FormPlacement: TFormPlacement;
    StatusBar: TStatusBar;
    TopDock: TTBDock;
    TBToolbar1: TTBToolbar;
    AcceptBtn: TTBItem;
    DontAcceptBtn: TTBItem;
    HotToolbarImages: TImageList;
    TBSeparatorItem7: TTBSeparatorItem;
    DockBackground: TTBBackground;
    WinXPBackground: TTBBackground;
    ScrollBox: TMyScrollBox;
    PreviewImage: TImage;
    procedure AcceptBtnClick(Sender: TObject);
    procedure DontAcceptBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure InfoBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PreviewForm: TPreviewForm;

implementation

{$R *.DFM}

procedure TPreviewForm.AcceptBtnClick(Sender: TObject);
begin
  SendMessage(Application.MainForm.Handle,WM_ACCEPTCAPTURE,0,0);
  Hide;
end;

procedure TPreviewForm.DontAcceptBtnClick(Sender: TObject);
begin
  Hide;
end;

function GetBitsPerPixel(Bitmap: TBITMAP): String;
var Bit_Map: Windows.TBitmap;
begin
  if Bitmap.Handle <> 0 then
    GetObject(Bitmap.Handle, SizeOf(Bit_Map), @Bit_Map);
    case Bit_Map.bmBitsPixel * Bit_Map.bmPlanes of
      1: Result := 'Monochrome';
      4: Result := '16 colors';
      8: Result := '256 colors';
      16: Result := 'HighColor 16-bit';
      24: Result := 'TrueColor 24-bit';
      32: Result := 'TrueColor 32-bit';
   else
    Result := 'Unknown '+IntToStr(Bit_Map.bmBitsPixel * Bit_Map.bmPlanes)+'-bit';
    end; {case}
end;

procedure TPreviewForm.FormShow(Sender: TObject);
begin
  StatusBar.Panels[0].Text := IntToStr(PreviewImage.Picture.Bitmap.Width)+'x'+IntToStr(PreviewImage.Picture.Bitmap.Height) + ' pixels';
  StatusBar.Panels[1].Text := GetBitsPerPixel(PreviewImage.Picture.Bitmap);
//  { This might change sometimes and may also work }
//  StatusBar.Panels[1].Text := IntToStr(GetDeviceCaps(GetDC(Application.Handle),BITSPIXEL)) + 'bpp';
end;

procedure TPreviewForm.InfoBtnClick(Sender: TObject);
var Bit_Map: Windows.TBitmap;
    Out1: String;
begin
  if Windows.GetObject(PreviewImage.Picture.Bitmap.Handle,SizeOf(Bit_Map),@Bit_Map) = 0 then
   begin
     MsgBox('Image Error','Could not retrieve image information.',MB_OK+MB_ICONERROR);
   end
  else
  begin
    FmtStr(Out1,'Width:'+#9#9+'%d'+#13+
    'Height:'+#9#9+'%d'+#13+
    'Bytes/scan line:'+#9+'%d'+#13+
    'Color planes:'+#9+'%d'+#13+
    'Image type:'+#9+'%s',
    [Bit_Map.bmWidth,Bit_Map.bmHeight,Bit_Map.bmWidthBytes,Bit_Map.bmPlanes,GetBitsPerPixel(PreviewImage.Picture.Bitmap)]);
    MsgBox('Image Information',Out1,MB_OK+MB_ICONINFORMATION);
  end;
end;

procedure TPreviewForm.FormCreate(Sender: TObject);
begin
  ScrollBox.BackBitmap.LoadFromResourceName(HInstance, 'BACK');
end;

procedure TPreviewForm.FormResize(Sender: TObject);
begin
  if (ScrollBox.Width - PreviewImage.Picture.Width) div 2 > 0 then
   PreviewImage.Left := (ScrollBox.Width - PreviewImage.Picture.Width) div 2
  else
   PreviewImage.Left := 0;
  if (ScrollBox.Height - PreviewImage.Picture.Height) div 2 > 0 then
   PreviewImage.Top := (ScrollBox.Height - PreviewImage.Picture.Height) div 2
  else
   PreviewImage.Top := 0;
end;

end.
