unit TextPreview;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ProEffectImage, StdCtrls, ComCtrls, janTracker,
  Struct, Second, RXSlider, Placemnt, My_ScrollBox, Spin;

type
  TTextEffectForm = class(TForm)
    FormStorage: TFormStorage;
    FormPlacement: TFormPlacement;
    ScrollBox: TMyScrollBox;
    ProEffectImage: TProEffectImage;
    Panel1: TPanel;
    Panel2: TPanel;
    ApplyBtn: TButton;
    CancelBtn: TButton;
    lblText: TLabel;
    Panel3: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    Bevel1: TBevel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Bevel2: TBevel;
    Label7: TLabel;
    FontName: TComboBox;
    FontSize: TSpinEdit;
    Panel4: TPanel;
    TextColor: TShape;
    chkBold: TCheckBox;
    chkItalic: TCheckBox;
    chkUnderline: TCheckBox;
    chkStrikeout: TCheckBox;
    TextEdit: TEdit;
    ColorDialog: TColorDialog;
    procedure FormCreate(Sender: TObject);
    procedure EffectsListClick(Sender: TObject);
    procedure ApplyBtn_Click(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure ApplyBtnClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure lblTextMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TextEditChange(Sender: TObject);
    procedure TextColorMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure chkBoldClick(Sender: TObject);
    procedure FontSizeChange(Sender: TObject);
    procedure FontNameChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Effect: TEffectType;
  end;

var
  TextEffectForm: TTextEffectForm;

implementation

uses Main;

{$R *.DFM}

{ FORM CREATION }
//------------------------------------------------------------------------------
procedure TTextEffectForm.FormCreate(Sender: TObject);
begin
  ScrollBox.BackBitmap.LoadFromResourceName(HInstance, 'BACK');
  ProEffectImage.Picture.Assign((MainForm.ActiveMDIChild as TCaptureForm).Image.Picture);

  FontName.Items.Assign(Screen.Fonts);
  FontName.ItemIndex := FontName.Items.IndexOf(lblText.Font.Name);  
end;
//------------------------------------------------------------------------------



{ EFFECT LISTBOX ACTIONS }
//------------------------------------------------------------------------------
procedure TTextEffectForm.EffectsListClick(Sender: TObject);
begin

 {Start}
 ProEffectImage.Picture.Assign((MainForm.ActiveMDIChild as TCaptureForm).Image.Picture);

end;
//------------------------------------------------------------------------------



{ APPLY BUTTON ACTIONS }
//------------------------------------------------------------------------------
procedure TTextEffectForm.ApplyBtn_Click(Sender: TObject);
begin
 // apply changes
end;
//------------------------------------------------------------------------------



procedure TTextEffectForm.CancelBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TTextEffectForm.ApplyBtnClick(Sender: TObject);
var
  LogFont: TLogFont;
begin
  with (MainForm.ActiveMDIChild as TCaptureForm) do
  begin
   ProEffectImage.Picture.Bitmap.Canvas.Font := lblText.Font;
   GetObject(ProEffectImage.Picture.Bitmap.Canvas.Font.Handle, SizeOf(LogFont), @LogFont);
   LogFont.lfQuality := ANTIALIASED_QUALITY; // antialised quality
   ProEffectImage.Picture.Bitmap.Canvas.Font.Handle := CreateFontIndirect(LogFont);
   ProEffectImage.Picture.Bitmap.Canvas.Brush.Style := bsClear;
   ProEffectImage.Picture.Bitmap.Canvas.TextOut(lblText.Left - ProEffectImage.Left, lblText.Top - ProEffectImage.Top, lblText.Caption);

   if UndoBitmap = nil then
    UndoBitmap := TBitmap.Create;
   UndoBitmap.Assign(Image.Picture.Bitmap);
   Image.Picture.Assign(ProEffectImage.Picture);
   MainForm.Undo1.Enabled := True;
   MainForm.Undo2.Enabled := MainForm.Undo1.Enabled;
   ImageNotSaved := True;
  end;
  Close;
end;

procedure TTextEffectForm.FormResize(Sender: TObject);
var OLeft, OTop: Integer;
begin
  OLeft := lblText.Left - ProEffectImage.Left;
  OTop := lblText.Top - ProEffectImage.Top;

  if (ScrollBox.Width - ProEffectImage.Picture.Width) div 2 > 0 then
   ProEffectImage.Left := (ScrollBox.Width - ProEffectImage.Picture.Width) div 2
  else
   ProEffectImage.Left := 0;
  if (ScrollBox.Height - ProEffectImage.Picture.Height) div 2 > 0 then
   ProEffectImage.Top := (ScrollBox.Height - ProEffectImage.Picture.Height) div 2
  else
   ProEffectImage.Top := 0;

  lblText.Left := ProEffectImage.Left + OLeft;
  lblText.Top := ProEffectImage.Top + OTop;
end;

procedure TTextEffectForm.lblTextMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  TempPanel: TPanel;
  Control: TControl;
begin
  {Release the MOUSEDOWN status}
  ReleaseCapture;
  {If the component is a TWinControl, just move it directly}
  if Sender is TWinControl then
    TWinControl(Sender).Perform(WM_SysCommand, $F012, 0)
  else
  try
    Control := TControl(Sender);
    TempPanel := TPanel.Create(Self);
    TempPanel.Color := clWhite;
    with TempPanel do
    begin
      {Replace the component with TempPanel}
      Caption := '';
      BevelOuter := bvLowered;
      SetBounds(Control.Left, Control.Top, Control.Width, Control.Height);
      Parent := Control.Parent;
      {Put our control in TempPanel}
      Width := Control.Width;
      Height := Control.Height;
      Control.Parent := TempPanel;
      Control.Left := 0;
      Control.Top := 0;
      Control.Visible := True;
      Control.Update;
      {Move TempPanel with control inside of it}
      Perform(WM_SysCommand, $F012, 0);
      {Put the component where the panel was dropped}
      Control.Parent := Parent;
      Control.Left := Left;
      Control.Top := Top;
    end;
  finally
    TempPanel.Free;
  end;
end;

procedure TTextEffectForm.TextEditChange(Sender: TObject);
begin
  lblText.Caption := TextEdit.Text;
end;

procedure TTextEffectForm.TextColorMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if ColorDialog.Execute then
  begin
    TextColor.Brush.Color := ColorDialog.Color;
    lblText.Font.Color := ColorDialog.Color;
  end;
end;

procedure TTextEffectForm.chkBoldClick(Sender: TObject);
begin
  if chkBold.Checked then
   lblText.Font.Style := lblText.Font.Style + [fsBold]
  else
   lblText.Font.Style := lblText.Font.Style - [fsBold];
  if chkItalic.Checked then
   lblText.Font.Style := lblText.Font.Style + [fsItalic]
  else
   lblText.Font.Style := lblText.Font.Style - [fsItalic];
  if chkUnderline.Checked then
   lblText.Font.Style := lblText.Font.Style + [fsUnderline]
  else
   lblText.Font.Style := lblText.Font.Style - [fsUnderline];
  if chkStrikeout.Checked then
   lblText.Font.Style := lblText.Font.Style + [fsStrikeout]
  else
   lblText.Font.Style := lblText.Font.Style - [fsStrikeout];
end;

procedure TTextEffectForm.FontSizeChange(Sender: TObject);
begin
  lblText.Font.Size := FontSize.Value;
end;

procedure TTextEffectForm.FontNameChange(Sender: TObject);
begin
  lblText.Font.Name := FontName.Text;
end;

end.
