unit Wizard;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,
  Menus, Options, BorBtns;

type
  TWizardForm = class(TForm)
    Image1: TImage;
    BackBtn: TButton;
    NextBtn: TButton;
    CancelBtn: TButton;
    Notebook: TNotebook;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Image2: TImage;
    Image3: TImage;
    Image4: TImage;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Screen1: TBorRadio;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Image5: TImage;
    MoreInfo1Btn: TButton;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Image6: TImage;
    lblHotKey: TLabel;
    MoreInfo2Btn: TButton;
    ChgHotkeyBtn: TButton;
    Label18: TLabel;
    Label19: TLabel;
    Image7: TImage;
    MoreInfo3Btn: TButton;
    Bevel1: TBevel;
    ActiveWindow1: TBorRadio;
    Region1: TBorRadio;
    Bevel2: TBevel;
    Printer1: TBorRadio;
    GraphicsFile1: TBorRadio;
    CatalogFolder1: TBorRadio;
    procedure NextBtnClick(Sender: TObject);
    procedure BackBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ChgHotkeyBtnClick(Sender: TObject);
    procedure MoreInfo2BtnClick(Sender: TObject);
    procedure MoreInfo3BtnClick(Sender: TObject);
    procedure MoreInfo1BtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  WizardForm: TWizardForm;

implementation

uses Main;

{$R *.DFM}

procedure TWizardForm.NextBtnClick(Sender: TObject);
var I: Byte;
begin
  if Notebook.PageIndex = Notebook.Pages.Count-1 then
   begin
     // input
     for I:=0 to 2 {there are 3 innput options} do
      MainForm.Input1.Items[I].Checked := False;
     if Screen1.Checked then
      MainForm.Input1.Items[0].Checked := True
     else
     if ActiveWindow1.Checked then
      MainForm.Input1.Items[1].Checked := True
     else
     if Region1.Checked then
      MainForm.Input1.Items[2].Checked := True;
     // output
     for I:=0 to 3 {there are 4 output options} do
      MainForm.Output1.Items[I].Checked := False;
     if Printer1.Checked then
      MainForm.Output1.Items[1].Checked := True
     else
     if GraphicsFile1.Checked then
      MainForm.Output1.Items[0].Checked := True
     else
     if CatalogFolder1.Checked then
      MainForm.Output1.Items[3].Checked := True;
     Close;
   end;
  BackBtn.Enabled := True;
  Notebook.PageIndex := Notebook.PageIndex + 1;
  if Notebook.PageIndex = Notebook.Pages.Count-1 then
   NextBtn.Caption := '&Finish';
end;

procedure TWizardForm.BackBtnClick(Sender: TObject);
begin
  if Notebook.PageIndex=1 then
   BackBtn.Enabled := False;
  Notebook.PageIndex := Notebook.PageIndex-1;
  if Notebook.PageIndex = Notebook.Pages.Count-2 then
   NextBtn.Caption := '&Next >';
end;

procedure TWizardForm.FormCreate(Sender: TObject);
begin
  lblHotKey.Caption := ShortCutToText(MainForm.ScreenCapture.HotKey);
end;

procedure TWizardForm.ChgHotkeyBtnClick(Sender: TObject);
begin
  with TOptionsForm.Create(Self) do
   try
    ShowModal;
   finally
    Free;
    lblHotKey.Caption := ShortCutToText(MainForm.ScreenCapture.HotKey);
   end;
end;

procedure TWizardForm.MoreInfo2BtnClick(Sender: TObject);
const X = #13#10;
begin
  Application.MessageBox(
  'You can use several combinations of keys'+X+
  'to define your capture hotkey. There are also'+X+
  'available hotkeys for hiding/unhiding SnapVideoPro'+X+
  'and also to repeat the last capture performed.'+X+X+
  'Press the Change Hotkey button to modify these'+X+
  'hotkeys.','More Information',MB_OK);
end;

procedure TWizardForm.MoreInfo3BtnClick(Sender: TObject);
const X = #13#10;
begin
  Application.MessageBox(
  'You can find out more about the program from'+X+
  'the help file that comes as plain text. However,'+X+
  'you can also click the Program Information item'+X+
  'in the Help menu for support.'+X+X+
  'The Help menu offers help to those that are new'+X+
  'to using SnapVideoPro. Be sure to check it out.','More Information',MB_OK);
end;

procedure TWizardForm.MoreInfo1BtnClick(Sender: TObject);
const X = #13#10;
begin
  Application.MessageBox(
  'You can also store the capture in the clipboard.'+X+
  'To do so, click on the Clipboard item in the'+X+
  'Output menu of the program.'+X+X+
  'To customize output options, click the Properties'+X+
  'item from the Options menu.','More Information',MB_OK);
end;

end.
