unit AIFrameUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TframeAdvancedInterface = class(TFrame)
    chkOnTop: TCheckBox;
    chkDeleteConfirm: TCheckBox;
    chkCloseMinimize: TCheckBox;
    chkDoubleClickDelay: TCheckBox;
    chkMinimizeTray: TCheckBox;
    chkPasswordProtect: TCheckBox;
    edPassword: TEdit;
    chkShowViewed: TCheckBox;
    chkMultilineAccounts: TCheckBox;
    chkAdvInfo: TCheckBox;
    chkHideViewed: TCheckBox;
    lblTrayIcon: TLabel;
    cmbCheckingIcon: TComboBox;
    edAdvInfoDelay: TEdit;
    lblAdvInfoDelay: TLabel;
    chkShowSplash: TCheckBox;
    procedure OptionsChange(Sender: TObject);
    procedure HelpMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  end;

implementation

uses MainFormUnit, GlobalToolsUnit, UtilsUnit;

{$R *.dfm}

constructor TframeAdvancedInterface.Create(AOwner: TComponent);
var
  i : integer;
begin
  inherited;
  Options.Busy := True;
  SpamLearnerMainForm.TranslateFrame(self);
  for i := 0 to cmbCheckingIcon.Items.Count-1 do
    cmbCheckingIcon.Items[i] := SpamLearnerMainForm.Translate(cmbCheckingIcon.Items[i]);
  // options to screen
  chkShowViewed.Checked := Options.ShowViewed;
  chkCloseMinimize.Checked := Options.CloseMinimize;
  chkDoubleClickDelay.Checked := Options.DoubleClickDelay;
  chkMinimizeTray.Checked := Options.MinimizeTray;
  chkMultilineAccounts.Checked := Options.MultilineAccounts;
  chkDeleteConfirm.Checked := Options.DeleteConfirm;
  chkPasswordProtect.Checked := Options.PasswordProtect;
  edPassword.Text := Options.Password;
  chkOnTop.Checked := Options.OnTop;
  chkAdvInfo.Checked := Options.AdvInfo;
  edAdvInfoDelay.Text := IntToStr(Options.AdvInfoDelay);
  chkHideViewed.Checked := Options.HideViewed;
  cmbCheckingIcon.ItemIndex := Options.CheckingIcon;
  chkShowSplash.Checked := Options.ShowSplashScreen;
  // autosize
  AutoSizeAllCheckBox(Self);
  edPassword.Left := chkPasswordProtect.Left + chkPasswordProtect.Width + 4;
  edAdvInfoDelay.Left := chkAdvInfo.Left + chkAdvInfo.Width + 2;
  lblAdvInfoDelay.Left := edAdvInfoDelay.Left + edAdvInfoDelay.Width + 2;
  cmbCheckingIcon.Left := lblTrayIcon.Left + lblTrayIcon.Width + 4;

  Options.Busy := False;
end;

procedure TframeAdvancedInterface.OptionsChange(Sender: TObject);
begin
  // show password box
  EnableControl(edPassword,chkPasswordProtect.Checked);
  EnableControl(edAdvInfoDelay,chkAdvInfo.Checked);
  lblAdvInfoDelay.Enabled := chkAdvInfo.Checked;
  if not Options.Busy then
  begin
    // screen to options
    Options.ShowViewed := chkShowViewed.Checked;
    Options.CloseMinimize := chkCloseMinimize.Checked;
    Options.DoubleClickDelay := chkDoubleClickDelay.Checked;
    Options.MinimizeTray := chkMinimizeTray.Checked;
    Options.MultilineAccounts := chkMultilineAccounts.Checked;
    Options.DeleteConfirm := chkDeleteConfirm.Checked;
    Options.PasswordProtect := chkPasswordProtect.Checked;
    Options.Password := edPassword.Text;
    Options.OnTop := chkOnTop.Checked;
    Options.AdvInfo := chkAdvInfo.Checked;
    Options.AdvInfoDelay := StrToIntDef(edAdvInfoDelay.Text,0);
    Options.HideViewed := chkHideViewed.Checked;
    Options.CheckingIcon := cmbCheckingIcon.ItemIndex;
    Options.ShowSplashScreen := chkShowSplash.Checked;
    // enable buttons
    SpamLearnerMainForm.btnSaveOptions.Enabled := True;
    SpamLearnerMainForm.btnCancel.Enabled := True;
    // focus password
    if (Sender = chkPasswordProtect) and edPassword.Enabled and Self.Visible then
      edPassword.SetFocus;
  end;
end;

procedure TframeAdvancedInterface.HelpMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  SpamLearnerMainForm.QuickHelp(Sender, Button, Shift, X, Y);
end;

end.
