unit MainFormUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ImgList, ComCtrls, ToolWin, ExtCtrls, Menus, CheckLst,
  CommCtrl, Registry, TypInfo, uxTheme, MailToolsUnit,
  IdGlobal, IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient, IdPOP3,
  IdMessageClient, IdMessage, IdException, IdAntiFreezeBase, IdAntiFreeze,
  ActnList, ActnMan, ActnCtrls, ActnPopupCtrl, XPStyleActnCtrls,
  CoolTrayIcon, GlobalToolsUnit, PluginSupportUnit, POP3ProtocolUnit, Misc, SetupWizardUnit, IdTCPServer,
  IdSMTPServer, IdSMTP, URLMon, ShDocVw, IdMultipartFormData, IdHTTP,
  BayesianFilter, SkinCaption, WinSkinData;

const
  // --- version info ---
  MajorVersion = '2';
  MinorVersion = '0';
  ReleaseVersion = '0';
  BetaVersion = '0';
  ReleaseCandidate = '';

const
  sdAsc = 1;
  sdDesc = -1;
  UM_ACTIVATE = WM_USER + 10;
  UM_ACTION = WM_USER + 11;
  UM_QUIT = WM_USER + 12;
  colID = 4;
  UseDefaultSound = '[Use Default Sound]';
  UseDefaultProgram = '[Use Default Program]';
  NOSORT = -1;

type
  TMouseCommand = (mcClick,mcRClick,mcDblClick,mcMClick);

  TLangDirection = (ToEnglish,FromEnglish);

  TIconType = (itNormal,itChecking,itDeleting,itError);

  TWhiteBlack = (wbWhite, wbBlack);

  TSpamLearnerMainForm = class(TForm)
    PageControl: TPageControl;
    tsMail: TTabSheet;
    tsOptions: TTabSheet;
    tsRules: TTabSheet;
    tabMail: TTabControl;
    AntiFrze: TidAntiFreeze;
    panRulesButtons: TPanel;
    panMailButtons: TPanel;
    btnStartProgram: TBitBtn;
    btnCheckAll: TBitBtn;
    btnToTray: TBitBtn;
    panMailLeftSpacer: TPanel;
    panMailRightSpacer: TPanel;
    panRulesButtonsRight: TPanel;
    tsAccounts: TTabSheet;
    panAccounts: TPanel;
    tabAccounts: TTabControl;
    panOptionButtons: TPanel;
    panOptionButtonsRight: TPanel;
    btnSaveOptions: TBitBtn;
    btnCancel: TBitBtn;
    btnHelpRules: TBitBtn;
    btnHelpOptions: TBitBtn;
    TrayIcon: TCoolTrayIcon;
    panAccountsButtons: TPanel;
    btnHelpAccounts: TBitBtn;
    btnSave: TBitBtn;
    btnCancelAccount: TBitBtn;
    btnHintHelp: TSpeedButton;
    ActionManager: TActionManager;
    actPreview: TAction;
    actDelete: TAction;
    actNewMail: TAction;
    MailToolBar: TActionToolBar;
    lvMail: TListView;
    StatusBar: TStatusBar;
    panOptionPage: TPanel;
    tvOptions: TTreeView;
    panOptions: TPanel;
    panOptSpacer: TPanel;
    panOptionsTitle: TPanel;
    imgOptionTitle: TImage;
    actReply: TAction;
    actRuleFrom: TAction;
    actNoSort: TAction;
    actCheck: TAction;
    panProgress: TPanel;
    btnStop: TSpeedButton;
    Progress: TProgressBar;
    actAddAccount: TAction;
    actDeleteAccount: TAction;
    AccountsToolbar: TActionToolBar;
    actRuleAdd: TAction;
    actRuleDelete: TAction;
    actShowMessages: TAction;
    actCheckAll: TAction;
    actStartProgram: TAction;
    actAutoCheck: TAction;
    actOptions: TAction;
    actRules: TAction;
    actAbout: TAction;
    actHelp: TAction;
    actQuit: TAction;
    actToTray: TAction;
    actCustomize: TAction;
    panRulesTop: TPanel;
    RulesToolbar: TActionToolBar;
    lstRules: TCheckListBox;
    ScrollBox1: TScrollBox;
    panRuleDetail: TPanel;
    gbActions: TGroupBox;
    btnEdRuleWav: TSpeedButton;
    btnEdRuleEXE: TSpeedButton;
    btnRuleSoundTest: TSpeedButton;
    chkRuleWav: TCheckBox;
    chkRuleDelete: TCheckBox;
    chkRuleIgnore: TCheckBox;
    edRuleWav: TEdit;
    chkRuleEXE: TCheckBox;
    edRuleEXE: TEdit;
    chkRuleImportant: TCheckBox;
    gbRule: TGroupBox;
    Label10: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    edRuleName: TEdit;
    chkRuleEnabled: TCheckBox;
    cmbRuleArea: TComboBox;
    cmbRuleComp: TComboBox;
    edRuleText: TEdit;
    chkRuleNew: TCheckBox;
    cmbRuleAccount: TComboBox;
    spltRules: TSplitter;
    chkRuleLog: TCheckBox;
    actRulesImport: TAction;
    spltOptions: TSplitter;
    actHideViewed: TAction;
    actAddWhiteList: TAction;
    actAddBlackList: TAction;
    actMarkViewed: TAction;
    actMarkSpam: TAction;
    actDeleteSpam: TAction;
    chkRuleSpam: TCheckBox;
    actRuleToMarkSpam: TAction;
    actUnmarkSpam: TAction;
    actSelectSpam: TAction;
    actSuspendSound: TAction;
    ScrollBox2: TScrollBox;
    panServer: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label14: TLabel;
    btnEdSound: TSpeedButton;
    btnAccountSoundTest: TSpeedButton;
    Label19: TLabel;
    btnEdAccountProgram: TSpeedButton;
    btnAccountProgramTest: TSpeedButton;
    Label6: TLabel;
    Label7: TLabel;
    edLogin: TEdit;
    edPassword: TEdit;
    edName: TEdit;
    chkAccEnabled: TCheckBox;
    colAccount: TColorBox;
    panIntervalAccount: TPanel;
    btnNeverAccount: TSpeedButton;
    Label16: TLabel;
    Label17: TLabel;
    edIntervalAccount: TEdit;
    UpDownAccount: TUpDown;
    edSound: TEdit;
    edAccountProgram: TEdit;
    edServer: TEdit;
    cmbProtocol: TComboBox;
    edPort: TEdit;
    lblOptionTitle: TLabel;
    actSpam: TAction;
    chkRuleProtect: TCheckBox;
    actTestAccount: TAction;
    tsLists: TTabSheet;
    Panel1: TPanel;
    Panel2: TPanel;
    imgLists: TImage;
    Shape: TShape;
    Label8: TLabel;
    btnWizard: TBitBtn;
    panelAutorespond: TPanel;
    Label9: TLabel;
    editSubject: TEdit;
    Label13: TLabel;
    memoMessage: TMemo;
    Label18: TLabel;
    editID: TEdit;
    btnSaveSettings: TBitBtn;
    Panel3: TPanel;
    btnHelpCS: TSpeedButton;
    Panel4: TPanel;
    btnSaveLists: TBitBtn;
    btnCancelLists: TBitBtn;
    btnHelpLists: TBitBtn;
    lblSMTP: TLabel;
    edSMTP: TEdit;
    Label20: TLabel;
    edSMTPPort: TEdit;
    imgTray: TImage;
    Image1: TImage;
    Panel5: TPanel;
    btnSpam: TSpeedButton;
    btnAccounts: TSpeedButton;
    btnSettings: TSpeedButton;
    btnLists: TSpeedButton;
    btnImport: TBitBtn;
    btnAddressBook: TBitBtn;
    HTTP: TIdHTTP;
    actTrainSpamFilter: TAction;
    btnSpamMail: TSpeedButton;
    Splitter2: TSplitter;
    Panel6: TPanel;
    Panel7: TPanel;
    Panel8: TPanel;
    SpamList: TListView;
    SpamToolbar: TActionToolBar;
    actPreviewSpam: TAction;
    act_DeleteSpam: TAction;
    act_UnmarkSpam: TAction;
    actEmpty: TAction;
    actMarkSpamAsViewed: TAction;
    Panel9: TPanel;
    btnSaveRules: TBitBtn;
    btnCancelRule: TBitBtn;
    SkinData: TSkinData;
    SkinCaption: TSkinCaption;
    procedure FormCreate(Sender: TObject);
    procedure lblHomepageMouseEnter(Sender: TObject);
    procedure lblHomepageMouseLeave(Sender: TObject);
    procedure lblHomepageClick(Sender: TObject);
    procedure btnSaveOptionsClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure tabMailChange(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure lvMailDblClick(Sender: TObject);
    procedure OptionsChange(Sender: TObject);
    procedure lvMailColumnClick(Sender: TObject; Column: TListColumn);
    procedure lvMailCompare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure chkRuleWavClick(Sender: TObject);
    procedure edRuleNameChange(Sender: TObject);
    procedure chkRuleEnabledClick(Sender: TObject);
    procedure cmbRuleAreaChange(Sender: TObject);
    procedure edRuleTextChange(Sender: TObject);
    procedure edRuleWavChange(Sender: TObject);
    procedure chkRuleDeleteClick(Sender: TObject);
    procedure btnSaveRulesClick(Sender: TObject);
    procedure btnCancelRuleClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure tabAccountsChange(Sender: TObject);
    procedure edAccChange(Sender: TObject);
    procedure tabAccountsChanging(Sender: TObject; var AllowChange: Boolean);
    procedure lblEMailClick(Sender: TObject);
    procedure lvMailSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);
    procedure chkRuleIgnoreClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure NoSort1Click(Sender: TObject);
    procedure PageControlChange(Sender: TObject);
    procedure chkTimerAccountClick(Sender: TObject);
    procedure btnNeverAccountClick(Sender: TObject);
    procedure lblCheckUpdateClick(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnHelpRulesClick(Sender: TObject);
    procedure btnHelpAccountsClick(Sender: TObject);
    procedure btnHelpClick(Sender: TObject);
    procedure lvMailInfoTip(Sender: TObject; Item: TListItem;
      var InfoTip: String);
    procedure btnEdSoundClick(Sender: TObject);
    procedure btnEdRuleWavClick(Sender: TObject);
    procedure chkRuleEXEClick(Sender: TObject);
    procedure edRuleEXEChange(Sender: TObject);
    procedure btnEdRuleEXEClick(Sender: TObject);
    procedure TrayIconClick(Sender: TObject);
    procedure TrayIconDblClick(Sender: TObject);
    procedure TrayIconMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure StatusBarResize(Sender: TObject);
    procedure cmbRuleCompChange(Sender: TObject);
    procedure lvMailColumnRightClick(Sender: TObject; Column: TListColumn;
      Point: TPoint);
    procedure btnAccountSoundTestClick(Sender: TObject);
    procedure btnRuleSoundTestClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure btnCancelAccountClick(Sender: TObject);
    procedure PageControlChanging(Sender: TObject;
      var AllowChange: Boolean);
    procedure edSoundEnter(Sender: TObject);
    procedure edSoundExit(Sender: TObject);
    procedure btnEdAccountProgramClick(Sender: TObject);
    procedure btnAccountProgramTestClick(Sender: TObject);
    procedure edAccountProgramEnter(Sender: TObject);
    procedure edAccountProgramExit(Sender: TObject);
    procedure chkRuleImportantClick(Sender: TObject);
    procedure chkRuleNewClick(Sender: TObject);
    procedure cmbRuleAccountChange(Sender: TObject);
    procedure btnHintHelpClick(Sender: TObject);
    procedure actDeleteExecute(Sender: TObject);
    procedure actPreviewExecute(Sender: TObject);
    procedure actNewMailExecute(Sender: TObject);
    procedure tvOptionsChange(Sender: TObject; Node: TTreeNode);
    procedure HelpMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure actReplyExecute(Sender: TObject);
    procedure actRuleFromExecute(Sender: TObject);
    procedure actNoSortExecute(Sender: TObject);
    procedure actCheckExecute(Sender: TObject);
    procedure actAddAccountExecute(Sender: TObject);
    procedure actDeleteAccountExecute(Sender: TObject);
    procedure actRuleAddExecute(Sender: TObject);
    procedure actRuleDeleteExecute(Sender: TObject);
    procedure actCheckAllExecute(Sender: TObject);
    procedure actStartProgramExecute(Sender: TObject);
    procedure actAutoCheckExecute(Sender: TObject);
    procedure actOptionsExecute(Sender: TObject);
    procedure actRulesExecute(Sender: TObject);
    procedure actShowMessagesExecute(Sender: TObject);
    procedure actAboutExecute(Sender: TObject);
    procedure actHelpExecute(Sender: TObject);
    procedure actToTrayExecute(Sender: TObject);
    procedure actQuitExecute(Sender: TObject);
    procedure actCustomizeExecute(Sender: TObject);
    procedure lstRulesClick(Sender: TObject);
    procedure lstRulesClickCheck(Sender: TObject);
    procedure chkRuleLogClick(Sender: TObject);
    procedure actRulesImportExecute(Sender: TObject);
    procedure lvAdvancedOptionsSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure lvOptionsSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure actHideViewedExecute(Sender: TObject);
    procedure cmbProtocolChange(Sender: TObject);
    procedure actAddWhiteListExecute(Sender: TObject);
    procedure actAddBlackListExecute(Sender: TObject);
    procedure actMarkViewedExecute(Sender: TObject);
    procedure actMarkSpamExecute(Sender: TObject);
    procedure actDeleteSpamExecute(Sender: TObject);
    procedure MouseMoveReset(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure chkRuleSpamClick(Sender: TObject);
    procedure actRuleToMarkSpamExecute(Sender: TObject);
    procedure lvMailKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure actUnmarkSpamExecute(Sender: TObject);
    procedure actSelectSpamExecute(Sender: TObject);
    procedure imgLogoClick(Sender: TObject);
    procedure tvOptionsMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lvMailMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure DragMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure tabDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure lstRulesDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure actSuspendSoundExecute(Sender: TObject);
    procedure panMailButtonsResize(Sender: TObject);
    procedure lstRulesDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure tabMailDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure lstRulesKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure actSpamExecute(Sender: TObject);
    procedure MailToolBarGetControlClass(Sender: TCustomActionBar;
      AnItem: TActionClient; var ControlClass: TCustomActionControlClass);
    procedure lstRulesKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure chkRuleProtectClick(Sender: TObject);
    procedure lvMailCustomDrawItem(Sender: TCustomListView;
      Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
    procedure actTestAccountExecute(Sender: TObject);
    procedure tabMailChanging(Sender: TObject; var AllowChange: Boolean);
    procedure lvVolunteersChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure btnWizardClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure memoMessageChange(Sender: TObject);
    procedure btnSaveSettingsClick(Sender: TObject);
    procedure btnCancelListsClick(Sender: TObject);
    procedure btnSaveListsClick(Sender: TObject);
    procedure btnSpamClick(Sender: TObject);
    procedure btnAccountsClick(Sender: TObject);
    procedure btnSettingsClick(Sender: TObject);
    procedure btnListsClick(Sender: TObject);
    procedure edNameKeyPress(Sender: TObject; var Key: Char);
    procedure btnImportClick(Sender: TObject);
    procedure btnAddressBookClick(Sender: TObject);
    procedure actTrainSpamFilterExecute(Sender: TObject);
    procedure SpamListInfoTip(Sender: TObject; Item: TListItem;
      var InfoTip: String);
    procedure SpamListColumnClick(Sender: TObject; Column: TListColumn);
    procedure SpamListCompare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure SpamListDblClick(Sender: TObject);
    procedure actPreviewSpamExecute(Sender: TObject);
    procedure SpamListClick(Sender: TObject);
    procedure act_DeleteSpamExecute(Sender: TObject);
    procedure act_UnmarkSpamExecute(Sender: TObject);
    procedure actEmptyExecute(Sender: TObject);
    procedure SpamListCustomDrawItem(Sender: TCustomListView;
      Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
    procedure actMarkSpamAsViewedExecute(Sender: TObject);
  public
    { Registration details }
    UserName, RegKey: String;
    IsRegistered: Boolean;
    DaysLeft, TimesRun: Integer;
    { Public declarations }
    FShowingInfo : boolean;
    FListsChanged : boolean;
    FMinimized : Boolean;
    FHintWindow : THintWindow;
    NewEmails: TStringList; // new blocked e-mails
    UpdateNotRequired: Boolean;
    procedure ShowForm;
    procedure HideForm;
    procedure ShowIcon(num : integer; IconType : TIconType);
    function ExecuteProgram(num : integer = -1) : boolean;
    procedure CheckAllMail;
    function CheckMail(num : integer; Notify : Boolean=True) : integer;
    procedure ShowMail(num : integer);
    procedure SendMail(const ToAddress,Subject,Body : string);
    function TranslateToEnglish(phrase : string) : string;
    function Translate(english : string) : string;
    procedure TranslateFrame(frame : TFrame);
    procedure TranslateForm(form : TForm);
    function TranslateDlg(const Msg: string; DlgType: TMsgDlgType;
                          Buttons: TMsgDlgButtons; HelpCtx: Longint): Integer;
    function TranslateMsg(const Msg: string; DlgType: TMsgDlgType;
                          Buttons: TMsgDlgButtons; HelpCtx: Longint) : TForm;
    function DeleteMail(num,msgnum : integer; UID : string='') : boolean;
    procedure RefreshLanguages;
    procedure QuickHelp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure RefreshProtocols;
    function AllowAutoCheck : boolean;
    procedure SetSortColumn(ColNum : integer);
    procedure SetSortColumn2(ColNum : integer);
    { Registration }
    function ValidRegistration(UserName, RegCode: String): Boolean;
    { Check for expiration }
    procedure Check_It;
  public
    { Public declarations }
    NumAccounts : integer;
    StartWizard : Boolean; { Start wizard on first run ? }
    IniName : TFileName;
    ShowSplash : Boolean;
    FAccChanged : Boolean;
  private
    { Private declarations }
    AlreadyStarted: Boolean;
    StartingWithMail: Integer;

    FNotified : Boolean;
    FNotifyWav : TFileName;
    RuleName : TFileName;
    HelpFileName : TFileName;
    LogRuleName : TFileName;
    ToolbarName : TFileName;
    IniPath : TFileName;
    FNumRules : integer;
    FMsgSize,FMsgRead : integer;
    FPreview : Boolean;
    FSortColumn : integer;
    FSortDirection : integer;
    FSortColumn2 : integer;
    FSortDirection2 : integer;
    FMsgsToDelete : array of integer;
    FNumToDelete : integer;
    MsgHeader : TIdMessage;
    FShownRules : Boolean;
    FShutDown : Boolean;
    FQueue : TUniqueQueue;
    FBusy : boolean;
    FTotalNew : integer;
    FDoubleClicked : boolean;
    FDeleting : boolean;
    FRuleChanged : boolean;
    FStop : boolean;
    FLastCheck : string;
    FAccountWithMail : integer;
    FTranslateStrings : TStringList;
    FLastLanguage : integer;
    FImportant : boolean;
    FFirstWaitTimer : TTimer;
    FShiftClick : boolean;
    FNewAccount : boolean;
    FSpamAction : TAction;
    FInfoForm : TForm;
    // save account info
    procedure SaveAccountInfo(num: Integer);
    // windows message handlers
    procedure WMQueryEndSession(var Message : TWMQueryEndSession); message WM_QUERYENDSESSION;
    procedure WMSYSCommand(var m : TMessage); message WM_SYSCOMMAND;
    procedure WMDropFiles(var msg: TWMDROPFILES); message WM_DROPFILES;
    procedure WMHotkey( Var msg: TWMHotkey ); message WM_HOTKEY;
    procedure UMActivate(var msg: TMessage );  message UM_ACTIVATE;
    procedure UMAction(var msg: TMessage );  message UM_ACTION;
    procedure UMQuit(var msg: TMessage );  message UM_QUIT;
    // autorespond settings
    procedure LoadAutorespondSettings;
    // ini files
    procedure LoadOptionsINI;
    procedure SaveOptionsINI;
    function LoadAccountINI(num : integer) : boolean;
    procedure SaveAccountINI(num : integer);
    procedure SaveAccountNum(num : integer);
    procedure ShowAccount(num : integer);
    procedure LoadRulesINI;
    procedure SaveRulesINI;
    procedure LoadPosINI;
    procedure SavePosINI;
    procedure LoadViewedMessageIDs(num : integer);
    procedure SaveViewedMessageIDs;
    function AccountChanged(tab : integer) : boolean;
    // mail messages
    procedure Preview(num : integer);
    procedure ProcessMessage(AMsg: TIdMessage; const AStream: TStream; AHeaderOnly: Boolean = False);
    procedure DeleteMultipleMail(num: integer; msgnums : array of integer);
    function GetUIDs(num : integer; var UIDLs : TStringList) : boolean;
    function GetUID(num,msgnum : integer) : string;
    function CheckUID(num,msgnum : integer; UID : string='') : boolean;
    procedure MarkViewed(num : integer = -1);
    function HasAttachment : boolean;
    function CountUnviewed(num : integer) : integer;
    function CountNew(num : integer) : integer;
    function CountAllNew : integer;
    function CountSpam(num : integer) : integer;
    function CountIgnored(num : integer) : integer;
    function SelectedMailItem(Item : TListItem = nil) : TMailItem;
    function GetMessageHeader(num,msgnum : integer) : boolean;
    procedure RefreshAccountStatus(num : integer);
    // visual
    procedure UpdateTrayIcon;
    procedure ClearTrayIcon;
    procedure PlayNotify(num : integer);
    procedure EnableFields(EnableIt : Boolean);

    procedure SetColumnMenuCheckMarks;
    procedure Balloon(head,info : string; IconType : TBalloonHintIcon; TimeoutSecs : integer);
    procedure ShowInfo(ShowOnlyWithMail : boolean = False);
    procedure ShowMessages;
    procedure DrawTheIcon(NewCount : integer; CircleColor : TColor);
    procedure DrawCheckingIcon(num : integer);
    procedure ResetToolbar;
    function GetStatusIcon(MailItem : TMailItem) : integer;
    procedure ErrorMsg(num : integer; Heading,Msg : string; IgnoreError : boolean);
    // rules
    function CheckRule(area : string; comp : TRuleCompare; text : string) : boolean;
    function GetRuleAreaText(RuleArea : TRuleArea) : string;
    procedure CheckRules(num,msgnum : integer);
    procedure ShowRule(selected : integer);
    procedure DeleteRule(rulenum : integer);
    procedure LogRule(Action,Name,From,Subject,Account : string);
    procedure EnableRuleButtons;
    procedure FillRuleAccounts;
    function AddToWhiteBlackList(WhiteBlack : TWhiteBlack) : boolean;
    function InWhiteBlackList(WhiteBlack : TWhiteBlack; email : string) : boolean;
    // procedural
    procedure Quit;
    procedure ConnectAccount(num : integer);
    function GetDefaultEmail : string;
    procedure SwitchTimer;
    procedure RunQueue;
    procedure RegisterTheHotKeys;
    procedure UnRegisterTheHotKeys;
    procedure DoMouseCommand(MouseCommand : TMouseCommand);
    procedure DoHKCommand(HotKeyNum : integer);
    procedure DoCommand(Command : TCommand);
    procedure CheckAndShow;
    procedure CheckAndInfo;
    procedure PopupAtCursor;
    procedure DeleteAccount(num : integer);
    function FirstAccountWithError : integer;
    procedure DeleteSpam(num : integer; confirm : boolean);
    procedure SetSpamAction(act : TAction);
    // translation
    function TranslateDir(st : string; LangDirection : TLangDirection) : string;
    procedure TranslateFormDir(form : TForm; LangDirection : TLangDirection);
    procedure TranslateFrameDir(frame : TFrame; LangDirection : TLangDirection);
    procedure ReadTranslateStrings;
    procedure SetProp(obj : TObject; PropName : string; ToEnglish : boolean=False);
    procedure GetLanguages;
    // plug-ins
    procedure SetProtocol(num : integer);
    procedure NotifyPluginExecute(MailCount,UnviewedCount,NewCount : integer; ResetTray : boolean);
    procedure NotifyPluginMessage(MsgFrom,MsgTo,MsgSubject : string; MsgDate : TDateTime; Viewed,New,Important,Spam : boolean);
    procedure NotifyPluginMsgBody(MsgHeader,MsgBody : string);
    // private events
    procedure OnAccountTimer(Sender: TObject);
    procedure OnFirstWait(Sender: TObject);
    procedure OnHint(Sender : TObject);
    procedure OnProtWork(const AWorkCount: Integer);
    procedure OnProcessWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer); virtual;
    procedure OnCloseFree(Sender: TObject; var Action: TCloseAction);
    procedure OnClickClose(Sender: TObject);
    // set viewed
    procedure SetViewed(num: Integer; Item: TListItem);
    function GetViewed(num: Integer; Item: TListItem): Boolean;
  end;

var
  SpamLearnerMainForm: TSpamLearnerMainForm;
  Accounts : TAccountItems;

implementation

{$R *.DFM}

uses
  PreviewEmailUnit, UtilsUnit, PasswordFormUnit, GeneralDataUnit, InfoFormUnit, AddressBookImportUnit,
  IntervalFrameUnit, GeneralFrameUnit, GOFrameUnit, AOFrameUnit,
  AIFrameUnit, AMFrameUnit,
  MBFrameUnit, HKFrameUnit, WBFrameUnit, PluginsFrameUnit,
  IniFiles,  ShellAPI,  StrUtils, IdResourceStrings, OutlookFormUnit, WelcomeDialogUnit,
  About, RegisterFormUnit, EncryptionUnit, Base64;

var
  frame : TFrame;
  Rules : TRuleItems;
  HintSep : string = ' -- ';

function TSpamLearnerMainForm.GetViewed(num: Integer; Item: TListItem): Boolean;
var P: TUnknownMsg;
begin
  P := Accounts[num].UnknownMessages;
  if P = nil then Exit;
  if (P^.Account.From = Item.Caption) and (P^.Account.MailTo = Item.SubItems[0]) and
    (P^.Account.Subject = Item.SubItems[1]) {and (P^.Account.Date = StrToDate(Item.SubItems[2]))} and
    (IntToStr(P^.Account.Size)+' '+Translate('KB') = Item.SubItems[3]) and (UpperCase(P^.Account.Path) = UpperCase(Item.SubItems[6])) then
    begin // this is it!!!
      Result := P^.Account.Viewed;
    end
  else
  if P^.Next <> nil then
  begin
    while (P^.Next <> nil) and (P^.Next^.Account.From <> Item.Caption) and (P^.Next^.Account.MailTo <> Item.SubItems[0]) and
          (P^.Next^.Account.Subject <> Item.SubItems[1]) and {(P^.Next^.Account.Date <> StrToDate(Item.SubItems[2])) and}
          (IntToStr(P^.Next^.Account.Size)+' '+Translate('KB') <> Item.SubItems[3]) and (UpperCase(P^.Account.Path) <> UpperCase(Item.SubItems[6])) do
      P := P^.Next;
    if P^.Next <> nil then  // found it !!!
    begin
      Result := P^.Next^.Account.Viewed;
    end;
  end;
end;

procedure TSpamLearnerMainForm.SetViewed(num: Integer; Item: TListItem);
var P: TUnknownMsg;
begin
  P := Accounts[num].UnknownMessages;
  if P = nil then Exit;
  if (P^.Account.From = Item.Caption) and (P^.Account.MailTo = Item.SubItems[0]) and
    (P^.Account.Subject = Item.SubItems[1]) {and (P^.Account.Date = StrToDate(Item.SubItems[2]))} and
    (IntToStr(P^.Account.Size)+' '+Translate('KB') = Item.SubItems[3]) and (UpperCase(P^.Account.Path) = UpperCase(Item.SubItems[6])) then
    begin // this is it!!!
      P^.Account.Viewed := True;
    end
  else
  if P^.Next <> nil then
  begin
    while (P^.Next <> nil) and (P^.Next^.Account.From <> Item.Caption) and (P^.Next^.Account.MailTo <> Item.SubItems[0]) and
          (P^.Next^.Account.Subject <> Item.SubItems[1]) and {(P^.Next^.Account.Date <> StrToDate(Item.SubItems[2])) and}
          (IntToStr(P^.Next^.Account.Size)+' '+Translate('KB') <> Item.SubItems[3]) and (UpperCase(P^.Account.Path) <> UpperCase(Item.SubItems[6])) do
      P := P^.Next;
    if P^.Next <> nil then  // found it !!!
    begin
      P^.Next^.Account.Viewed := True;
    end;
  end;
end;

function NumOnly(st : string) : integer;
var
  i : integer;
  s : string;
begin
  s := '';
  for i := 1 to Length(st) do
    if st[i] in ['0'..'9'] then
      s := s + st[i];
  Result := StrToInt(s);
end;

function CompareInt(st1,st2 : string) : integer;
begin
  if NumOnly(st1) = NumOnly(st2) then
    Result := 0
  else begin
    if NumOnly(st1) > NumOnly(st2) then
      Result := 1
    else
      Result := -1;
  end;
end;

function CompareDate(st1,st2 : string) : integer;
begin
  if StrToDateTimeDef(st1,now) = StrToDateTimeDef(st2,now) then
    Result := 0
  else begin
    if StrToDateTimeDef(st1,now) > StrToDateTimeDef(st2,now) then
      Result := 1
    else
      Result := -1;
  end;
end;

function StripSubjectPrefix(const st : string) : string;
var
  ipos : integer;
begin
  Result := st;
  ipos := Pos(':',st);
  if ipos in [3..4] then
     Delete(Result,1,ipos+1);
end;

function StringToColorDef(st : string; DefColor : TColor) : TColor;
begin
  try
    Result := StringToColor(st);
  except
    Result := DefColor;
  end;
end;

function StringToColorDef2(st : string; DefColor : TColor) : TColor;
begin
  try
    // fix bug with using clLime in tray
    if st = 'clLime' then st := '$0000F900';
    Result := StringToColor(st);
  except
    Result := DefColor;
  end;
end;

function ColorToString2(Color : TColor) : string;
begin
  if Color = $0000F900 then // fix bug with using clLime in tray
    Result := 'clLime'
  else
    Result := ColorToString(Color);
end;

function DarkColor(col : TColor) : Boolean;
var
  r,g,b : integer;
begin
  if (col = clBlack) or (col = clNavy) or (col = clBlue) or
     (col = clMaroon) or (col = clRed) or (col = clGreen) or
     (col = clPurple) or (col = clTeal) or (col = clGray) or
     (col = clOlive) or (col = clFuchsia) then //dark colors
  begin
    Result := True;
  end
  else begin
    if (col = clWhite) or (col = clYellow) or (col = clSilver) or
       (col = clAqua) or (col = $0000F900) then // light colors
    begin
      Result := False
    end
    else begin
      //try it with RGB
      GetRGB(col,r,g,b);
      Result := ((r+g+b) div 3) < 128;
    end;
  end;
end;

function MixColors(col1,col2 : TColor) : TColor;
var
  r,g,b : integer;
  r1,g1,b1 : integer;
  r2,g2,b2 : integer;
begin
  GetRGB(col1,r1,g1,b1);
  GetRGB(col2,r2,g2,b2);
  r := (r1+r2) div 2;
  g := (g1+g2) div 2;
  b := (b1+b2) div 2;
  Result := (b shl 16) + (g shl 8) + r;
end;

procedure ClearImpairedCode(var str : string);
////////////////////////////////////////////////////////////////////////////////
// Clear half completed %hh values from end of string (BG: 12.09.2002)
var
   indLastPercent : integer;
begin
   indLastPercent := LastDelimiter('%', str);
   if ( indLastPercent > 0 ) and ( Length(str) < indLastPercent + 2 ) then
        str := LeftStr(str, indLastPercent - 1);
end;

function RuleAreaToStr(rulearea : TRuleArea) : string;
begin
  case rulearea of
    raHeader     : Result := 'Header';
    raFrom       : Result := 'From';
    raSubject    : Result := 'Subject';
    raTo         : Result := 'To';
    raCC         : Result := 'CC';
    raFromName   : Result := 'From (name)';
    raFromAddress: Result := 'From (address)';
    raBody       : Result := 'Body';
  else
    Result := '';
  end;
end;

function StrToRuleCompare(st : string) : TRuleCompare;
begin
  st := LowerCase(st);
  if st = 'contains' then Result := rcContains
  else if st = 'equals' then Result := rcEquals
  else if st = 'wildcard' then Result := rcWildcard
  else if st = 'empty' then Result := rcEmpty
  else if st = 'not contains' then Result := rcNotContains
  else Result := rcContains;
end;

function RuleCompareToStr(rulecompare : TRuleCompare) : string;
begin
  case rulecompare of
    rcContains    : Result := 'Contains';
    rcEquals      : Result := 'Equals';
    rcWildcard    : Result := 'Wildcard';
    rcEmpty       : Result := 'Empty';
    rcNotContains : Result := 'NOT Contains';
  else
    Result := '';
  end;
end;

procedure SetColumnImage(lv : TListView; ColumnIndex,ImageIndex : integer);
var
  Column : TLVColumn;
begin
  // set image on right of text
  with Column do
  begin
    mask := LVCF_FMT or LVCF_IMAGE;
    fmt := LVCFMT_IMAGE or LVCFMT_BITMAP_ON_RIGHT or LVCFMT_COL_HAS_IMAGES;
    if lv.Columns[ColumnIndex].Alignment = taRightJustify then
      fmt := fmt or LVCFMT_RIGHT;
    iImage := ImageIndex;
  end;
  lv.Columns[ColumnIndex].ImageIndex := ImageIndex;
  if ImageIndex <> -1 then
    ListView_SetColumn(lv.Handle, ColumnIndex, Column);
end;

procedure ExecuteAccelAction(ToolBar : TActionToolbar; Key : word);
var
  i : integer;
begin
  if Assigned(ToolBar.ActionClient) then
    for i := 0 to ToolBar.ActionClient.Items.Count-1 do
      if IsAccel(Key,ToolBar.ActionClient.Items[i].Control.Caption) then
        ToolBar.ActionClient.Items[i].Control.Action.Execute;
end;

//------------------------------------------------------------------------------
// Public
//------------------------------------------------------------------------------

procedure TSpamLearnerMainForm.ShowForm;
////////////////////////////////////////////////////////////////////////////////
// Show the main form
begin
  if Options.PasswordProtect and FMinimized then
  begin
    // if already a password window the focus that one
    if Assigned(frmPassword) then
    begin
      SetForegroundWindow(FindWindow(nil,'SpamLearner - Password'));
      Exit;
    end;
    // ask for password
    //frmPassword := TfrmPassword.Create(Self);
    SetForegroundWindow(Handle);
    Application.CreateForm(TfrmPassword,frmPassword);
    try
      TranslateForm(frmPassword);
      if not ((frmPassword.ShowModal = mrOK) and
             (frmPassword.edPass.Text = Options.Password)) then
        Exit;
    finally
      FreeAndNil(frmPassword);
    end;
  end;
  // show window
  SetForegroundWindow(Handle);
  Application.Restore;
  ShowWindow(Application.Handle, SW_RESTORE);
  FMinimized := False;
  Visible := True;
  // clear the tray
  if (PageControl.ActivePageIndex = 0) then
    MarkViewed;
end;

procedure TSpamLearnerMainForm.HideForm;
////////////////////////////////////////////////////////////////////////////////
// Hide the main form
begin
  Application.Minimize;
  FMinimized := True;
  if Options.MinimizeTray then
  begin
    ShowWindow(Application.Handle, SW_HIDE);
    Visible := False;
  end;
end;

procedure TSpamLearnerMainForm.ShowIcon(num: integer; IconType : TIconType);
////////////////////////////////////////////////////////////////////////////////
// Show the correct icon in tabs and tray
var
  mailcount : integer;
begin
  if (num<=0) or (num>NumAccounts) then Exit;
  // reset name (without mailcount)
  tabAccounts.Tabs[num-1] := Accounts[num-1].Name;
  tabMail.Tabs[num-1] := Accounts[num-1].Name;
  // --tab icon--
  if IconType=itChecking then
  begin
    // checking
    dm.ReplaceBitmap(dm.imlTabs,num-1, dm.imlPopTrueColor,popBusy);
  end
  else if (Accounts[num-1].Error) then
  begin
    // error
    dm.ReplaceBitmap(dm.imlTabs,num-1, dm.imlPopTrueColor,popError);
  end
  else if not(Accounts[num-1].Enabled) then
  begin
    // disabled
    dm.ReplaceBitmap(dm.imlTabs,num-1, dm.imlPopTrueColor,popDisabled);
  end
  else begin
    if Options.HideViewed then
      mailcount := CountUnviewed(num)
    else
      mailcount := Accounts[num-1].Mail.Count;
    if mailcount = 0 then
    begin
      // closed
      dm.ReplaceBitmap(dm.imlTabs,num-1, dm.imlPopTrueColor,popClosed);
    end
    else begin
      // open
      if CountUnviewed(num)>0 then
        dm.ReplaceBitmap(dm.imlTabs,num-1, dm.imlPopTrueColor,popNew)
      else
        dm.ReplaceBitmap(dm.imlTabs,num-1, dm.imlPopTrueColor,popOpen);
    end;
    // message count
    if ((mailcount>0) or Options.HideViewed) and (Accounts[num-1].Mail.Count > 0) then
    begin
      tabMail.Tabs[num-1] := Accounts[num-1].Name + ' - ' + IntToStr(mailcount);
      if Options.HideViewed then
        tabMail.Tabs[num-1] := tabMail.Tabs[num-1] + '/' + IntToStr(Accounts[num-1].Mail.Count);
    end;
  end;
  // --tray icon--
  if IconType=itChecking then
  begin
    DrawCheckingIcon(num);
    TrayIcon.Refresh;
    TrayIcon.Hint := 'SpamLearner v.3.0.1'+#13#10+Translate('Checking')+' '+Accounts[num-1].Name+' ...';
  end
  else if IconType=itDeleting then
  begin
    dm.ReplaceBitmap(dm.imlTray,0, dm.imlPop,popTrash);
    dm.imlTray.GetIcon(0,TrayIcon.Icon);
    TrayIcon.CycleIcons := False;
    TrayIcon.Refresh;
  end
  {else if (FError>0) then
  begin
    dm.ReplaceBitmap(dm.imlTray,0, dm.imlPop,popError);
    dm.imlTray.GetIcon(0,TrayIcon.Icon);
    TrayIcon.CycleIcons := False;
    TrayIcon.Refresh;
  end}
  else begin
    // tray icon
    UpdateTrayIcon;
  end;
  Application.ProcessMessages;
end;

function TSpamLearnerMainForm.ExecuteProgram(num : integer = -1) : boolean;
////////////////////////////////////////////////////////////////////////////////
// Run the e-mail client
var
  MailProgram,ExeName,Params : string;
begin
  // determine mail program
  if num <= 0 then
    MailProgram := Options.MailProgram
  else begin
    if Accounts[num-1].MailProgram <> '' then
      MailProgram := Accounts[num-1].MailProgram
    else
      MailProgram := Options.MailProgram;
  end;
  // run it
  if MailProgram = '' then
  begin
    TranslateDlg(Translate('No E-Mail Client specified'),mtError,[mbOK],0);
    Result := false;
  end
  else begin
    SplitExeParams(MailProgram,ExeName,Params);
    Result := ExecuteFile(ExeName,Params,'',SW_NORMAL) > 32;
  end;
end;

procedure TSpamLearnerMainForm.CheckAllMail;
////////////////////////////////////////////////////////////////////////////////
// Check all accounts for mail
var
  num, i : integer;
  Path, S: String;
  Lines: TStringList;

function Process(S: String): String;
begin
  Delete(S, 1, Pos('>', S));
  Result := Copy(S, 1, Pos('<', S)-1);
end;

procedure Block(EMail: String);
var I: Integer; Found: Boolean;
begin
  Found := False;
  for I:=0 to Options.BlackList.Count-1 do
   if UpperCase(EMail)=UpperCase(Options.BlackList[I]) then
    begin
      Found := True;
      Break;
    end;
  if not Found then
  begin
   NewEmails.Add(EMail);
   Options.BlackList.Add(EMail);
  end;
end;

begin
  // check if busy
  if FBusy then
  begin
    if not Options.NoError then
      Balloon('SpamLearner',Translate('Error:')+' '+Translate('Still Busy Checking'),bitError,15);
    Exit;
  end;
  // check if online
  if Options.Online then
  begin
    if not IsConnectedToInternet then Exit;
  end;
  // check all enabled accounts
  FAccountWithMail := -1;
  FNotified := False;
  for num := 1 to NumAccounts do
  begin
    if Accounts[num-1].Enabled then
    begin
      ShowIcon(num,itChecking);
      CheckMail(num,not FNotified);
      ShowIcon(num,itNormal);
      if tabMail.TabIndex+1=num then
        ShowMail(tabMail.TabIndex+1);
    end;
  end;

  // show balloon
  if Options.Balloon and (CountAllNew > 0) then
    ShowInfo(True);

  if Options.UpdateBlockList then
  begin
  // now download the latest XML with the updates necessary for the block lists
  if DirectoryExists(ExtractFilePath(Application.ExeName)+'Junk') then
   Path := ExtractFilePath(Application.ExeName)+'Junk'
  else
   Path := ExtractFilePath(Application.ExeName);
  if URLDownloadToFile(nil, 'http://wrm.modwest.com/spamdown/update_loader.xml', PChar(Path + '\Update.xml'), 0, nil) = 0 then
   { Successfull download }
   begin
     Lines := TStringList.Create;
     try
      Lines.LoadFromFile(Path + '\Update.xml');
     except
     end;
     DeleteFile(Path + '\Update.xml');
     for I:=0 to Lines.Count-1 do
     if Pos(UpperCase('<email>'), UpperCase(Lines[I]))>0 then
      begin
        S := Process(Lines[I]);
        Block(S);
      end;
     { Now free the list, it isn't needed }
     Lines.Free;
     { Update and save lists }
     UpdateNotRequired := True;
     btnSaveListsClick(Self);
     UpdateNotRequired := False;
     if btnLists.Down then
      btnListsClick(Self);
   end;
   end;
end;

function TSpamLearnerMainForm.CheckMail(num: integer; Notify : Boolean=True): integer;
////////////////////////////////////////////////////////////////////////////////
// Check for mail on 1 account
var
  i : integer;
  mailcount : integer;
  UIDLs : TStringList;
  quickchecking : boolean;
  MailItem : TMailItem;
  msgnum : integer;
  UID : string;
  BalloonText : string;
begin
  StartingWithMail := 1;

  Result := 0;
  // check if online
  if Options.Online then
  begin
    if not IsConnectedToInternet then
    begin
      Accounts[num-1].Status := Translate('Not On-Line');
      Exit;
    end;
  end;
  // inits
  FNotified := not Notify;
  FNotifyWav := '';
  FNumToDelete := 0;
  FImportant := False;
  SetLength(FMsgsToDelete,0);
  if FBusy and Notify then
  begin
    ErrorMsg(num,'Error:',Translate('Still busy checking'),True);
    Exit;
  end;
  if not Assigned(Accounts[num-1].Prot) then
  begin
    ErrorMsg(num,'Error:',Translate('No protocol defined for account')+' '+Accounts[num-1].Name,False);
    Exit;
  end;
  FBusy := True;
  FStop := False;
  try
    // progress
    panProgress.Visible := True;
    Progress.Position := 0;
    Application.ProcessMessages;
    // check connected
    if Accounts[num-1].Prot.Connected then
    begin
      Accounts[num-1].Status := Translate('Error:')+' '+Translate('Already Connected');
      Accounts[num-1].Prot.Disconnect;
      Accounts[num-1].Error := True;
      Exit;
    end;
    try
      Screen.Cursor := crHourGlass;
      // connect
      ConnectAccount(num);
      try
        // clear visual list
        if tabMail.TabIndex = num-1 then
        begin
          lvMail.Items.Clear;
          SpamList.Items.Clear;
        end;
        // quick check
        quickchecking := false;
        if Options.QuickCheck and not FShiftClick then
        begin
          UIDLs := TStringList.Create;
          try
            quickchecking := GetUIDs(num,UIDLs);
            if quickchecking then
            begin
              // clear all msgnums
              Accounts[num-1].Mail.SetAllMsgNum(-1);
              Accounts[num-1].Mail.SetAllNew(false);
              // assign new nums
              for i := 0 to UIDLs.Count-1 do
              begin
                msgnum := StrToInt(StrBefore(UIDLs[i],' '));
                UID := StrAfter(UIDLs[i],' ');
                MailItem := Accounts[num-1].Mail.FindUIDWithDuplicates(UID);
                if MailItem <> nil then
                begin
                  MailItem.MsgNum := msgnum;
                  UIDLs[i] := '';
                end;
              end;
              // delete the mailitems no longer on server
              Accounts[num-1].Mail.DeleteAllMsgNum(-1);
              // go fetch the new messages
              Progress.Max := UIDLs.Count;
              for i := 0 to UIDLs.Count-1 do
              begin
                if UIDLs[i] <> '' then
                begin
                  msgnum := StrToInt(StrBefore(UIDLs[i],' '));
                  if not GetMessageHeader(num,msgnum) then
                  begin
                    Result := -1;
                    Break;
                  end;
                end;
                // progress
                Progress.Position := i;
                Application.ProcessMessages;
              end;
            end;
          finally
            UIDLs.Free;
          end;
        end;
        if not quickchecking then
        begin
          // normal check (non-quick)
          mailcount := Accounts[num-1].Prot.CheckMessages;
          Accounts[num-1].Mail.Clear;
          Progress.Max := mailcount;
          for i := 1 to mailcount do
          begin
            if not GetMessageHeader(num,i) then
            begin
              Result := -1;
              Break;
            end;
            // progress
            Progress.Position := i;
            Application.ProcessMessages;
          end;
        end;
        // refresh account
        RefreshAccountStatus(num);
        // show status
        if (not FStop) and (Result>=0) then
        begin
          if Notify then
          begin
            if quickchecking then
              Accounts[num-1].Status := Translate('Quick Checked:')+' '+DateTimeToStr(Now)
            else
              Accounts[num-1].Status := Translate('Checked:')+' '+DateTimeToStr(Now);
          end;
          Accounts[num-1].Error := False;
        end;
      finally
        Screen.Cursor := crDefault;
        ResetToolbar;
        if Accounts[num-1].Prot.Connected then
          Accounts[num-1].Prot.Disconnect;
        // deleted by rules
        if FNumToDelete > 0 then
        begin
          if FNotifyWav <> '' then
            PlayNotify(num);
          DeleteMultipleMail(num,FMsgsToDelete);
          CheckMail(num,False);
        end;
        // important messages balloon
        if FImportant then
        begin
          for i := 0 to Accounts[num-1].Mail.Count-1 do
            if Accounts[num-1].Mail[i].Important and Accounts[num-1].Mail[i].New then
              BalloonText := BalloonText + ForceWidth(Accounts[num-1].Mail[i].From,100) + #9 + ReduceWidth(Accounts[num-1].Mail[i].Subject,170) + #13#10;
          Balloon('Important',BalloonText,bitInfo,30);
        end;
      end; //finally
    except
      on e : EIdException do
        begin
          Screen.Cursor := crDefault;
          if FStop then
            Accounts[num-1].Status := Translate('User Aborted.')+HintSep+DateTimeToStr(Now)
          else
            ErrorMsg(num,'Connect Error:',e.Message,Options.NoError);
          Accounts[num-1].Error := True;
          Result := -1;
        end;
      else begin
        Screen.Cursor := crDefault;
        raise;
      end;
    end;  // except
    panProgress.Visible := False;
    // play sound?
    if Notify and
      (Accounts[num-1].Mail.Count > 0 ) and
       (CountNew(num) > 0) then
       //(MsgIDs <> Accounts[num-1].MsgIDs) then
    begin
      PlayNotify(num);
    end;

    if Result >= 0 then
      Result := Accounts[num-1].Mail.Count;
  finally
    FLastCheck := DateTimeToStr(Now);
    FBusy := False;
  end;

  SaveAccountInfo(num);
end;

procedure TSpamLearnerMainForm.ShowMail(num: integer);
////////////////////////////////////////////////////////////////////////////////
// Show mail stored in array on the list view
var
  mailcount,ignorecount : integer;
  st,kb : string;
  P: TUnknownMsg;
  MsgCount: Integer;
begin
  if (num<=0) or (num>NumAccounts) then Exit;
  // show icon count
  ShowIcon(num,itNormal);
  // listview items
  lvMail.Clear;
  SpamList.Clear;
  kb := Translate('KB');
  Msgcount := 0;

  { Let's show bulk mail first! }
  P := Accounts[num-1].UnknownMessages;
  while (P <> nil) do
  begin
    if P^.Account.Spam then
      with SpamList.Items.Add do
      begin
        // icon
        ImageIndex := 18; { SPAM }
        StateIndex := 1;
        // listview info
        Caption := P^.Account.From;
        SubItems.Add(P^.Account.MailTo);
        SubItems.Add(P^.Account.Subject);
        SubItems.Add(DateToStr(P^.Account.Date));
        SubItems.Add(IntToStr(P^.Account.Size) + ' ' + kb);
        SubItems.Add(IntToStr(MsgCount));
        Inc(MsgCount);
        SubItems.Add(IntToStr(MsgCount)); //colID
//        SubItems.Add(IntToStr(Accounts[num-1].Mail[i].MsgNum)); //colID
        SubItems.Add(P^.Account.Path); // SubItems[6]
      end
    else
      with lvMail.Items.Add do
      begin
        // icon
        ImageIndex := 18; { SPAM }
        StateIndex := 1;
        // listview info
        Caption := P^.Account.From;
        SubItems.Add(P^.Account.MailTo);
        SubItems.Add(P^.Account.Subject);
        SubItems.Add(DateToStr(P^.Account.Date));
        SubItems.Add(IntToStr(P^.Account.Size) + ' ' + kb);
        SubItems.Add(IntToStr(MsgCount));
        Inc(MsgCount);
        SubItems.Add(IntToStr(MsgCount)); //colID
//        SubItems.Add(IntToStr(Accounts[num-1].Mail[i].MsgNum)); //colID
        SubItems.Add(P^.Account.Path); // SubItems[6]
      end;
      P := P^.Next;
  end;

  { Next show regular mail }
{  for i := 0 to Accounts[num-1].Mail.Count-1 do
  begin
    if (not( Options.HideViewed and Accounts[num-1].Mail[i].Viewed ))
       and (not Accounts[num-1].Mail[i].IsInWhiteList) then
    begin
      with lvMail.Items.Add do
      begin
        // icon
        ImageIndex := GetStatusIcon(Accounts[num-1].Mail[i]);
        if Accounts[num-1].Mail[i].Viewed then
          StateIndex := -1
        else
          StateIndex := 1;
        // listview info
        Caption := Accounts[num-1].Mail[i].From;
        SubItems.Add(Accounts[num-1].Mail[i].MailTo);
        SubItems.Add(Accounts[num-1].Mail[i].Subject);
        SubItems.Add(Accounts[num-1].Mail[i].Date);
        SubItems.Add(IntToStr(Accounts[num-1].Mail[i].Size) + ' ' + kb);
        SubItems.Add(IntToStr(Accounts[num-1].Mail[i].MsgNum)); //colID
      end;
    end;
  end;}
  if FSortColumn <> NOSORT then lvMail.AlphaSort;
  if FSortColumn2 <> NOSORT then SpamList.AlphaSort;
  // del spam button
  actDeleteSpam.Enabled := CountSpam(num) > 0;
  actSelectSpam.Enabled := actDeleteSpam.Enabled;
  actSpam.Enabled := actDeleteSpam.Enabled or actMarkSpam.Enabled or actUnmarkSpam.Enabled;
  // show statusbar
  StatusBar.Panels[0].Text := ' '+Accounts[num-1].Status;
  if StatusBar.Canvas.TextWidth(Accounts[num-1].Status) > StatusBar.Panels[0].Width then
    StatusBar.Hint := Accounts[num-1].Status
  else
    StatusBar.Hint := '';
  if Options.HideViewed then
    mailcount := CountUnviewed(num)
  else
    mailcount := Accounts[num-1].Mail.Count;
  ignorecount := CountIgnored(num);
  if ignorecount > 0 then
  begin
    if mailcount = 1 then
      st := Translate('msg.')
    else
      st := Translate('msgs.');
    StatusBar.Panels[1].Text := IntToStr(mailcount)+ ' ' + st;
    StatusBar.Panels[1].Text := StatusBar.Panels[1].Text + ' (' +
                                IntToStr(ignorecount)+ ' '+Translate('ignored')+')';
  end
  else begin
    if mailcount = 1 then
      st := Translate('message.')
    else
      st := Translate('messages.');
    StatusBar.Panels[1].Text := IntToStr(mailcount)+ ' ' + st;
  end;
  StatusBar.Panels[2].Text := IntTostr(Accounts[num-1].Size) + ' ' + kb;
  // clear icon
  if not FMinimized and (PageControl.ActivePageIndex = 0) then
  begin
    MarkViewed;
  end;
end;

procedure TSpamLearnerMainForm.SendMail(const ToAddress, Subject, Body: string);
////////////////////////////////////////////////////////////////////////////////
// Send EMAIL using either MAPI or "mailto:"
const
  CharsToConvert : TSetOfChar = ([' ','&','%','=','?','"']);
var
  email,subj,mailbody : string;
  mailto : string;
begin
  // local vars work, params not
  email := ToAddress;
  subj := Subject;
  mailbody := Body;
  if Options.UseMAPI then
  begin
    // MAPI
    MAPISendMessage(Application.Handle,email,subj,mailbody);
  end
  else begin
    // mailto
    if mailbody <> '' then
    begin
      // convert invalid chars to the hex values
      email := CharsToHex(email,CharsToConvert);
      subj := CharsToHex(subj,CharsToConvert);
      mailbody := CharsToHex(mailbody,CharsToConvert+[#13,#10]);

      mailto := 'mailto:'+email+'?subject='+subj+'&body=';
      // limit mailto link to 2023 chars (Outlook and Outlook Express limit)
      mailbody := Copy(mailbody,1,2023-length(mailto));                         // mod BG: 12.09.2002
      ClearImpairedCode(mailbody);                                       		    // add BG: 12.09.2002
      mailto := mailto + mailbody;
      ExecuteFile(mailto,'','',SW_RESTORE);
    end
    else begin
      if subj <> '' then
      begin
        subj := CharsToHex(subj,CharsToConvert);
        ExecuteFile('mailto:'+email+'?subject='+subj,'','',SW_RESTORE)
      end
      else
        ExecuteFile('mailto:'+email,'','',SW_RESTORE)
    end;
  end;
end;

function TSpamLearnerMainForm.TranslateToEnglish(phrase: string): string;
var
  i,P : integer;
  S : string;
begin
  phrase := AnsiReplaceStr(phrase,'&','');
  Result := phrase;
  if (phrase = '') or (not(Assigned(FTranslateStrings))) then Exit;
  for i := 0 to FTranslateStrings.Count-1 do
  begin
    S := FTranslateStrings[i];
    P := AnsiPos('=', S);
    if (P <> 0) and (AnsiCompareText(Copy(S, P+1, Length(S)), phrase) = 0) then
    begin
      Result := FTranslateStrings.Names[i];
      Exit;
    end;
  end;
end;

function TSpamLearnerMainForm.Translate(english: string): string;
var
  lookup : string;
begin
  // if english then do nothing
  if Options.Language = 0 then
    Result := english
  else begin
    // otherwise translate it
    if not Assigned(FTranslateStrings) or (english='') then
      Result := english
    else begin
      lookup := AnsiReplaceStr(english,'&','');
      lookup := AnsiReplaceStr(lookup,#13#10,'~');
      Result := FTranslateStrings.Values[lookup];
      Result := AnsiReplaceStr(Result,'~',#13#10);
      if Result = '' then Result := english
    end;
  end;
end;

procedure TSpamLearnerMainForm.TranslateFrame(frame : TFrame);
begin
  if FLastLanguage <> 0 then
    TranslateFrameDir(frame,ToEnglish);
  if Options.Language <> 0 then
  begin
    ReadTranslateStrings;
    TranslateFrameDir(frame,FromEnglish);
  end;
end;

procedure TSpamLearnerMainForm.TranslateForm(form : TForm);
begin
  if (FLastLanguage <> Options.Language) or (form <> Self) then
  begin
    if FLastLanguage <> 0 then
      TranslateFormDir(form,ToEnglish);
    if Options.Language <> 0 then
    begin
      ReadTranslateStrings;
      TranslateFormDir(form,FromEnglish);
    end;
  end;
end;

function TSpamLearnerMainForm.TranslateDlg(const Msg: string; DlgType: TMsgDlgType;
                                  Buttons: TMsgDlgButtons; HelpCtx: Integer): Integer;
var
  dlg : TForm;
begin
  dlg := CreateMessageDialog(Msg, DlgType, Buttons);
  with dlg do
  begin
    try
      HelpContext := HelpCtx;
      Position := poScreenCenter;
      TranslateForm(dlg);
      Caption := Translate(Caption);
      Result := ShowModal;
    finally
      Free;
    end;
  end;
end;

function TSpamLearnerMainForm.TranslateMsg(const Msg: string; DlgType: TMsgDlgType;
                                  Buttons: TMsgDlgButtons; HelpCtx: Integer) : TForm;
////////////////////////////////////////////////////////////////////////////////
// Non-Modal message.
var
  i : integer;
begin
  Result := CreateMessageDialog(Msg, DlgType, Buttons);
  with Result do
  begin
    HelpContext := HelpCtx;
    Position := poScreenCenter;
    FormStyle := fsStayOnTop;
    TranslateForm(Result);
    Caption := Translate(Caption);
    OnClose := OnCloseFree;
    for i := 0 to Result.ComponentCount-1 do
      if (Result.Components[i] is TButton) then
        (Result.Components[i] as TButton).OnClick := OnClickClose;
    Show;
    SetForegroundWindow(Handle);
  end;
end;

function TSpamLearnerMainForm.DeleteMail(num, msgnum: integer; UID : string='') : boolean;
////////////////////////////////////////////////////////////////////////////////
// Delete one message
begin
  FDeleting := True;
  try
    with Accounts[num-1].Prot do
    begin
      ConnectAccount(num);
      try
        if CheckUID(num,msgnum,UID) then
        begin
          Delete(msgnum);
          Accounts[num-1].Status := Translate('1 message deleted.');
          Result := True;
        end
        else
          Result := False;
      finally
        Disconnect;
      end;
    end;
  finally
    FDeleting := False;
  end;
end;

procedure TSpamLearnerMainForm.RefreshLanguages;
begin
  GetLanguages;
  // translate it
  FLastLanguage := -1;
  TranslateForm(self);
end;

procedure TSpamLearnerMainForm.QuickHelp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  P : TPoint;
  R : TRect;
begin
  if Screen.Cursor = crHelp then
  begin
    if (Sender as TControl).Hint <> '' then
    begin
      FHintWindow := THintWindow.Create(self);
      FHintWindow.Color := Application.HintColor;
      P :=  (Sender as TControl).ClientToScreen(Point(X,Y+20));
      R := FHintWindow.CalcHintRect(500,(Sender as TControl).Hint,nil);
      OffsetRect(R,P.X,P.Y);
      FHintWindow.ActivateHint(R,(Sender as TControl).Hint);
      if Options.OnTop then
        SetWindowPos(FHintWindow.Handle, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE or SWP_NOSIZE or SWP_NOACTIVATE);
    end;

    Screen.Cursor := crDefault;
    Abort;
  end;
end;

procedure TSpamLearnerMainForm.RefreshProtocols;
var
  sl : TStringList;
  st : string;
  i,j : integer;
begin
  // clear all protocols (except POP3)
  SetLength(Protocols,1);
  cmbProtocol.Items.Text := 'POP3';
  // new list of protocols
  sl := TStringList.Create;
  try
    for i := Low(Plugins) to High(Plugins) do
    begin
      if Plugins[i].Enabled and (Plugins[i] is TPluginProtocol) then
      begin
        sl.Clear;
        CommaSeparatedToStringList(sl,(Plugins[i] as TPluginProtocol).Protocols);
        for j := 0 to sl.Count-1 do
        begin
          SetLength(Protocols,Length(Protocols)+1);
          st := StrBefore(sl[j],':');
          Protocols[Length(Protocols)-1].Name := st;
          Protocols[Length(Protocols)-1].Port := StrToIntDef(StrAfter(sl[j],':'),-1);
          Protocols[Length(Protocols)-1].Prot := (Plugins[i] as TPluginProtocol);
          cmbProtocol.Items.Add(st);
        end;
      end;
    end;
  finally
    sl.Free;
  end;
end;

function BetweenTimes : boolean;
begin
  if Options.DontCheckEnd < Options.DontCheckStart then
  begin
    // times across midnight
    Result := (GetTime >= frac(Options.DontCheckStart)) or (GetTime <= frac(Options.DontCheckEnd));
  end
  else begin
    // normal times
    Result := (GetTime >= frac(Options.DontCheckStart)) and (GetTime <= frac(Options.DontCheckEnd));
  end;
end;

function TSpamLearnerMainForm.AllowAutoCheck: boolean;
begin
  Result := dm.mnuAutoCheck.Checked and
            (not Options.CheckWhileMinimized or
             (Options.CheckWhileMinimized and FMinimized)
            ) and
            (not Options.DontCheckTimes or
             (Options.DontCheckTimes and not BetweenTimes)
            );
end;


procedure TSpamLearnerMainForm.SetSortColumn(ColNum : integer);
////////////////////////////////////////////////////////////////////////////////
// Set the column to sort by
begin
  // remove sort indicator
  if FSortColumn >= 0 then
    SetColumnImage(lvMail,FSortColumn,-1);
  // new col
  FSortColumn := ColNum;
  // sort column
  lvMail.AlphaSort;
  // add sort indicator
  if ColNum >= 0 then
  begin
    if FSortDirection = sdAsc then
      SetColumnImage(lvMail,FSortColumn,mSortAsc)
    else
      SetColumnImage(lvMail,FSortColumn,mSortDesc);
  end;
end;


//------------------------------------------------------------------------------
// Private
//------------------------------------------------------------------------------


//------------------------------------------------- windows message handlers ---

procedure TSpamLearnerMainForm.WMQueryEndSession(var Message: TWMQueryEndSession);
////////////////////////////////////////////////////////////////////////////////
// Save stuff when shutdown
begin
  SavePosINI;
  SaveViewedMessageIDs;
  FShutDown := True;
  Message.Result := 0;
  inherited;
end;

procedure TSpamLearnerMainForm.WMSYSCommand(var m: TMessage);
////////////////////////////////////////////////////////////////////////////////
// Hide instead of Minimize
begin
  if M.wParam <> SC_MINIMIZE then
    inherited
  else
    HideForm;
end;

procedure TSpamLearnerMainForm.WMDropFiles(var msg: TWMDROPFILES);
////////////////////////////////////////////////////////////////////////////////
// When you drop a file, open MAPI client with file attached
var
  NumFiles : longint;
  i : integer;
  buffer : array[0..1024] of char;
  FileNames : array of string;
begin
  NumFiles := DragQueryFile(msg.Drop, $FFFFFFFF, nil, 0);
  SetLength(FileNames,NumFiles);
  for i := 0 to (NumFiles - 1) do begin
    DragQueryFile(msg.Drop, i, @buffer,sizeof(buffer));
    FileNames[i] := buffer;
  end;
  MAPISendFile(Application.Handle, FileNames);
  DragFinish(msg.Drop);
end;

procedure TSpamLearnerMainForm.WMHotkey(var msg: TWMHotkey);
begin
  DoHKCommand(msg.HotKey);
end;

procedure TSpamLearnerMainForm.UMActivate(var msg: TMessage );
begin
  ShowForm;
end;

procedure TSpamLearnerMainForm.UMAction(var msg: TMessage );
begin
  DoCommand(TCommand(msg.WParam));
end;

procedure TSpamLearnerMainForm.UMQuit(var msg: TMessage);
////////////////////////////////////////////////////////////////////////////////
// Quit Message from installer
begin
  SavePosINI;
  SaveViewedMessageIDs;
  Application.Terminate;
end;

//---------------------------------------------------------------- ini files ---

procedure TSpamLearnerMainForm.LoadOptionsINI;
////////////////////////////////////////////////////////////////////////////////
// Read options from INI file
var
  Ini : TIniFile;
  Interval,NewMail : string;
  i : integer;
  langCount,pluginCount : integer;
  ThePluginType : TPluginType;
  fInterfaceVersion : function : integer; stdcall;
begin
  StartWizard := False;
  // load options from INI
  Ini := TIniFile.Create(IniName);
  try
    // interval
    Interval := Ini.ReadString('Options','Interval','2');
    Options.Interval := StrToIntDef(Interval,2);
    Options.TimerAccount := Ini.ReadBool('Options','TimerAccount',FALSE);
    // program
    Options.MailProgram := Ini.ReadString('Options','Program',GetDefaultEMail);
    // sound
    NewMail := ExtractFilePath(Application.ExeName)+'SpamLearner_newmail_lo.wav';
    if not FileExists(NewMail) then
      NewMail := '';
    Options.DefSound := Ini.ReadString('Options','Sound',NewMail);

    // options
    with Options do
    begin
      // general options
      BayesianFilterActive := Ini.ReadBool('Options','BayesianFilterActive',FALSE);
      ShowSplashScreen := Ini.ReadBool('Options','ShowSplash',TRUE);
      ShowSplash := ShowSplashScreen;
      Startup := Ini.ReadBool('Options','CheckStartup',FALSE);
      UpdateBlockList := Ini.ReadBool('Options','AutoUpdate',TRUE);
      Minimized := Ini.ReadBool('Options','Minimized',FALSE);
      Animated := Ini.ReadBool('Options','AnimatedTray',FALSE);
      ResetTray := Ini.ReadBool('Options','ResetTray',FALSE);
      RotateIcon := Ini.ReadBool('Options','RotateIcon',FALSE);
      ShowForm := Ini.ReadBool('Options','ShowForm',FALSE);
      Balloon := Ini.ReadBool('Options','Balloon',FALSE);
      FirstWait := Ini.ReadInteger('Options','FirstWait',0);
      // advanced - connection
      TimeOut := Ini.ReadInteger('Options','TimeOut',120);
      QuickCheck := Ini.ReadBool('Options','QuickCheck',TRUE);
      CheckWhileMinimized := Ini.ReadBool('Options','CheckWhileMinimized',FALSE);
      IgnoreRetrieveErrors := Ini.ReadBool('Options','IgnoreRetrieveErrors',FALSE);
      Online := Ini.ReadBool('Options','CheckOnline',FALSE);
      TopLines := Ini.ReadInteger('Options','TopLines',0);
      GetBody := Ini.ReadBool('Options','GetBody',FALSE);
      GetBodyLines := Ini.ReadInteger('Options','GetBodyLines',0);
      GetBodySize := Ini.ReadInteger('Options','GetBodySize',0);
      // advanced - interface
      CheckingIcon := Ini.ReadInteger('Options','CheckingIcon',ciAnimatedStar);
      ShowViewed := Ini.ReadBool('Options','ShowViewed',TRUE);
      CloseMinimize := Ini.ReadBool('Options','CloseMinimize',TRUE);
      MinimizeTray := Ini.ReadBool('Options','MinimizeTray',TRUE);
      NoError := Ini.ReadBool('Options','NoError',FALSE);
      MultilineAccounts := Ini.ReadBool('Options','MultilineAccounts',FALSE);
      DeleteConfirm := Ini.ReadBool('Options','DeleteConfirm',TRUE);
      OnTop := Ini.ReadBool('Options','OnTop',FALSE);
      AdvInfo := Ini.ReadBool('Options','AdvInfo',TRUE);
      AdvInfoDelay := Ini.ReadInteger('Options','AdvInfoDelay',20);
      HideViewed := Ini.ReadBool('Options','HideViewed',FALSE);
      actHideViewed.Checked := HideViewed;
      DoubleClickDelay := Ini.ReadBool('Options','DoubleClickDelay',TRUE);
      // advanced - misc
      UseMAPI := Ini.ReadBool('Options','UseMAPI',FALSE);
      LogRules := Ini.ReadBool('Options','LogRules',FALSE);
      SafeDelete := Ini.ReadBool('Options','SafeDelete',TRUE);
      RememberViewed := Ini.ReadBool('Options','RememberViewed',FALSE);
      BlackListSpam := Ini.ReadBool('Options','BlackListSpam',FALSE);
      DontCheckTimes := Ini.ReadBool('Options','DontCheckTimes',FALSE);
      DontCheckStart := Ini.ReadTime('Options','DontCheckStart',StrToTime('20:00'));
      DontCheckEnd := Ini.ReadTime('Options','DontCheckEnd',StrToTime('08:00'));
    end;

    // password
    Options.PasswordProtect := Ini.ReadBool('Options','PasswordProtect',FALSE);
    Options.Password := Decrypt(Ini.ReadString('Options','Password',''));

    // mouse button actions
    Options.LeftClick := Ini.ReadInteger('MouseButtons','Left',1);
    Options.RightClick := Ini.ReadInteger('MouseButtons','Right',2);
    Options.MiddleClick := Ini.ReadInteger('MouseButtons','Middle',3);
    Options.DblClick := Ini.ReadInteger('MouseButtons','Double',4);
    Options.ShiftLeftClick := Ini.ReadInteger('MouseButtons','ShiftLeft',0);
    Options.ShiftRightClick := Ini.ReadInteger('MouseButtons','ShiftRight',0);
    Options.ShiftMiddleClick := Ini.ReadInteger('MouseButtons','ShiftMiddle',0);

    // hotkey actions
    Options.Action1 := Ini.ReadInteger('HotKeys','HotKeyAction1',1);
    Options.Action2 := Ini.ReadInteger('HotKeys','HotKeyAction2',2);
    Options.Action3 := Ini.ReadInteger('HotKeys','HotKeyAction3',3);
    Options.Action4 := Ini.ReadInteger('HotKeys','HotKeyAction4',4);

    // hot-keys
    Options.HotKey1 := Ini.ReadInteger('HotKeys','HotKey1',0);
    Options.HotKey2 := Ini.ReadInteger('HotKeys','HotKey2',0);
    Options.HotKey3 := Ini.ReadInteger('HotKeys','HotKey3',0);
    Options.HotKey4 := Ini.ReadInteger('HotKeys','HotKey4',0);

    // languages
    langCount := Ini.ReadInteger('Languages','Count',0);
    if langCount = 0 then
      GetLanguages
    else begin
      SetLength(Options.Languages,langCount+1);
      Options.Languages[0] := 'English';
      for i := 1 to langCount do
        Options.Languages[i] := Ini.ReadString('Languages','Language'+IntToStr(i),'');
    end;
    Options.Language := Ini.ReadInteger('Languages','Active',0);

    // plug-ins
    pluginCount := Ini.ReadInteger('Plug-ins','Count',0);
    SetLength(Plugins,pluginCount);
    for i := 0 to pluginCount-1 do
    begin
      ThePluginType := TPluginType(Ini.ReadInteger('Plug-ins','PluginType'+IntToStr(i+1),0));
      case ThePluginType of
        piNotify   : Plugins[i] := TPluginNotify.Create;
        piProtocol : Plugins[i] := TPluginProtocol.Create;
      end;
      Plugins[i].Name := Ini.ReadString('Plug-ins','PluginName'+IntToStr(i+1),'');
      Plugins[i].DLLName := Ini.ReadString('Plug-ins','PluginDLLName'+IntToStr(i+1),'');
      Plugins[i].PluginType := TPluginType(Ini.ReadInteger('Plug-ins','PluginType'+IntToStr(i+1),0));
      Plugins[i].Enabled := Ini.ReadBool('Plug-ins','PluginEnabled'+IntToStr(i+1),False);
      if Plugins[i].Enabled then
      begin
        Plugins[i].hPlugin := LoadLibrary(PAnsiChar(ExtractFilePath(Application.ExeName)+'plugins\'+Plugins[i].DLLName));
        if Plugins[i].hPlugin = 0 then
          Continue;
        // skip old interface version
        fInterfaceVersion := GetProcAddress(Plugins[i].hPlugin, 'InterfaceVersion');
        if (@fInterfaceVersion=nil) or (fInterfaceVersion<INTERFACE_VERSION) then
        begin
          TranslateMsg(SpamLearnerMainForm.Translate('Incompatible Plugin:')+'  '+Plugins[i].DLLName,mtWarning,[mbOk],0);
          FreeLibrary(Plugins[i].hPlugin);
          Continue;
        end;
        Plugins[i].FInit := GetProcAddress(Plugins[i].hPlugin,'Init');
        Plugins[i].FFreePChar := GetProcAddress(Plugins[i].hPlugin,'FreePChar');
        Plugins[i].FUnload := GetProcAddress(Plugins[i].hPlugin,'Unload');
        // notify
        if (Plugins[i] is TPluginNotify) then
        begin
          (Plugins[i] as TPluginNotify).FNotify := GetProcAddress(Plugins[i].hPlugin,'Notify');
          (Plugins[i] as TPluginNotify).FMessageCheck := GetProcAddress(Plugins[i].hPlugin,'MessageCheck');
          (Plugins[i] as TPluginNotify).FMessageBody := GetProcAddress(Plugins[i].hPlugin,'MessageBody');
        end;
        // protocol
        if (Plugins[i] is TPluginProtocol) then
        begin
          (Plugins[i] as TPluginProtocol).FProtocols := GetProcAddress(Plugins[i].hPlugin,'Protocols');
          (Plugins[i] as TPluginProtocol).FConnect := GetProcAddress(Plugins[i].hPlugin,'Connect');
          (Plugins[i] as TPluginProtocol).FDisconnect := GetProcAddress(Plugins[i].hPlugin,'Disconnect');
          (Plugins[i] as TPluginProtocol).FConnected := GetProcAddress(Plugins[i].hPlugin,'Connected');
          (Plugins[i] as TPluginProtocol).FCheckMessages := GetProcAddress(Plugins[i].hPlugin,'CheckMessages');
          (Plugins[i] as TPluginProtocol).FRetrieveHeader := GetProcAddress(Plugins[i].hPlugin,'RetrieveHeader');
          (Plugins[i] as TPluginProtocol).FRetrieveRaw := GetProcAddress(Plugins[i].hPlugin,'RetrieveRaw');
          (Plugins[i] as TPluginProtocol).FRetrieveTop := GetProcAddress(Plugins[i].hPlugin,'RetrieveTop');
          (Plugins[i] as TPluginProtocol).FRetrieveMsgSize := GetProcAddress(Plugins[i].hPlugin,'RetrieveMsgSize');
          (Plugins[i] as TPluginProtocol).FUIDL := GetProcAddress(Plugins[i].hPlugin,'UIDL');
          (Plugins[i] as TPluginProtocol).FDelete := GetProcAddress(Plugins[i].hPlugin,'Delete');
          (Plugins[i] as TPluginProtocol).FSetOnWork := GetProcAddress(Plugins[i].hPlugin,'SetOnWork');
          (Plugins[i] as TPluginProtocol).FLastErrorMsg := GetProcAddress(Plugins[i].hPlugin,'LastErrorMsg');
        end;
        Plugins[i].Init;
      end;
    end;
    // load into array and combo
    RefreshProtocols;

    // num accounts
    NumAccounts := Ini.ReadInteger('Options','NumAccounts',0);

    // is this the first run?
    if NumAccounts = 0 then
      StartWizard := True;
  finally
     Ini.Free;
  end;
  // show it
  if Assigned(frame) then
    tvOptionsChange(tvOptions,tvOptions.Selected);
  // load e-mail client icon
  GetBitmapFromFileIcon(Options.MailProgram,btnStartProgram.Glyph,True);
  dm.imlActions.ReplaceMasked(actStartProgram.ImageIndex,btnStartProgram.Glyph,clBtnFace);
  // multiline account tabs
  tabMail.MultiLine := Options.MultilineAccounts;
  tabAccounts.MultiLine := Options.MultilineAccounts;
  // set interval
  dm.Timer.Interval := Options.Interval * 60000;
  panIntervalAccount.Visible := Options.TimerAccount;
  // rule areas
  if Options.GetBody then
    cmbRuleArea.Items.Add(RuleAreaToStr(raBody));
  // disable buttons
  btnSaveOptions.Enabled := False;
  btnCancel.Enabled := False;
  Application.ProcessMessages;
end;

procedure TSpamLearnerMainForm.SaveOptionsINI;
var
  Ini : TIniFile;
  i : integer;
begin
  Ini := TIniFile.Create(IniName);
  try
    // interval
    Ini.WriteInteger('Options','Interval',Options.Interval);
    Ini.WriteBool('Options','TimerAccount',Options.TimerAccount);
    // defaults
    Ini.WriteString('Options','Program',Options.MailProgram);
    Ini.WriteString('Options','Sound',Options.DefSound);

    // options
    with Options do
    begin
      // general options
      Ini.WriteBool('Options','BayesianFilterActive',BayesianFilterActive);

      Ini.WriteBool('Options','ShowSplash',ShowSplashScreen);

      Ini.WriteBool('Options','AutoUpdate',UpdateBlockList);

      Ini.WriteBool('Options','CheckStartup',Startup);
      Ini.WriteBool('Options','Minimized',Minimized);
      Ini.WriteBool('Options','AnimatedTray',Animated);
      Ini.WriteBool('Options','ResetTray',ResetTray);
      Ini.WriteBool('Options','RotateIcon',RotateIcon);
      Ini.WriteBool('Options','ShowForm',ShowForm);
      Ini.WriteBool('Options','Balloon',Balloon);
      Ini.WriteInteger('Options','FirstWait',FirstWait);
      // advanced - connection
      Ini.WriteInteger('Options','TimeOut',TimeOut);
      Ini.WriteBool('Options','QuickCheck',QuickCheck);
      Ini.WriteBool('Options','CheckWhileMinimized',CheckWhileMinimized);
      Ini.WriteBool('Options','IgnoreRetrieveErrors',IgnoreRetrieveErrors);
      Ini.WriteBool('Options','CheckOnline',Online);
      Ini.WriteInteger('Options','TopLines',TopLines);
      Ini.WriteBool('Options','GetBody',GetBody);
      Ini.WriteInteger('Options','GetBodyLines',GetBodyLines);
      Ini.WriteInteger('Options','GetBodySize',GetBodySize);
      // advanced - interface
      Ini.WriteInteger('Options','CheckingIcon',CheckingIcon);
      Ini.WriteBool('Options','ShowViewed',ShowViewed);
      Ini.WriteBool('Options','CloseMinimize',CloseMinimize);
      Ini.WriteBool('Options','MinimizeTray',MinimizeTray);
      Ini.WriteBool('Options','NoError',NoError);
      Ini.WriteBool('Options','MultilineAccounts',MultilineAccounts);
      Ini.WriteBool('Options','DeleteConfirm',DeleteConfirm);
      Ini.WriteBool('Options','OnTop',OnTop);
      Ini.WriteBool('Options','AdvInfo',AdvInfo);
      Ini.WriteInteger('Options','AdvInfoDelay',AdvInfoDelay);
      Ini.WriteBool('Options','HideViewed',HideViewed);
      Ini.WriteBool('Options','DoubleClickDelay',DoubleClickDelay);
      // advanced - misc
      Ini.WriteBool('Options','UseMAPI',UseMAPI);
      Ini.WriteBool('Options','LogRules',LogRules);
      Ini.WriteBool('Options','SafeDelete',SafeDelete);
      Ini.WriteBool('Options','RememberViewed',RememberViewed);
      Ini.WriteBool('Options','BlackListSpam',BlackListSpam);
      Ini.WriteBool('Options','DontCheckTimes',DontCheckTimes);
      Ini.WriteTime('Options','DontCheckStart',DontCheckStart);
      Ini.WriteTime('Options','DontCheckEnd',DontCheckEnd);
    end;

    // password
    Ini.WriteBool('Options','PasswordProtect',Options.PasswordProtect);
    Ini.WriteString('Options','Password',Encrypt(Options.Password));

    // mouse button actions
    Ini.WriteInteger('MouseButtons','Left',Options.LeftClick);
    Ini.WriteInteger('MouseButtons','Right',Options.RightClick);
    Ini.WriteInteger('MouseButtons','Middle',Options.MiddleClick);
    Ini.WriteInteger('MouseButtons','Double',Options.DblClick);
    Ini.WriteInteger('MouseButtons','ShiftLeft',Options.ShiftLeftClick);
    Ini.WriteInteger('MouseButtons','ShiftRight',Options.ShiftRightClick);
    Ini.WriteInteger('MouseButtons','ShiftMiddle',Options.ShiftMiddleClick);

    // hotkey actions
    Ini.WriteInteger('HotKeys','HotKeyAction1',Options.Action1);
    Ini.WriteInteger('HotKeys','HotKeyAction2',Options.Action2);
    Ini.WriteInteger('HotKeys','HotKeyAction3',Options.Action3);
    Ini.WriteInteger('HotKeys','HotKeyAction4',Options.Action4);

    // hot-keys
    Ini.WriteInteger('HotKeys','HotKey1',Options.HotKey1);
    Ini.WriteInteger('HotKeys','HotKey2',Options.HotKey2);
    Ini.WriteInteger('HotKeys','HotKey3',Options.HotKey3);
    Ini.WriteInteger('HotKeys','HotKey4',Options.HotKey4);

    // languages
    Ini.WriteInteger('Languages','Active',Options.Language);
    Ini.WriteInteger('Languages','Count',Length(Options.Languages)-1);
    for i := 1 to Length(Options.Languages)-1 do
      Ini.WriteString('Languages','Language'+IntToStr(i),TranslateToEnglish(Options.Languages[i]));

    // plug-ins
    Ini.WriteInteger('Plug-ins','Count',Length(Plugins));
    for i := 0 to Length(Plugins)-1 do
    begin
      Ini.WriteString('Plug-ins','PluginName'+IntToStr(i+1),Plugins[i].Name);
      Ini.WriteString('Plug-ins','PluginDLLName'+IntToStr(i+1),Plugins[i].DLLName);
      Ini.WriteBool('Plug-ins','PluginEnabled'+IntToStr(i+1),Plugins[i].Enabled);
      Ini.WriteInteger('Plug-ins','PluginType'+IntToStr(i+1),Integer(Plugins[i].PluginType));
    end;
  finally
     Ini.Free;
  end;
  SwitchTimer;
  // multiline account tabs
  tabMail.MultiLine := Options.MultilineAccounts;
  tabAccounts.MultiLine := Options.MultilineAccounts;
  // register hot-keys
  UnRegisterTheHotKeys;
  RegisterTheHotKeys;
  // translate
  TranslateForm(self);
  // disable buttons
  btnSaveOptions.Enabled := False;
  btnCancel.Enabled := False;
end;

function TSpamLearnerMainForm.LoadAccountINI(num : integer) : boolean;
////////////////////////////////////////////////////////////////////////////////
// Get 1 account from INI
var
  Ini : TIniFile;
  section,PortStr : string;
begin
  Ini := TIniFile.Create(IniName);
  try
    section := 'Account'+IntToStr(num);
    Accounts[num-1].Name := Ini.ReadString(Section,'Name','NoName');
    Accounts[num-1].Server := Ini.ReadString(Section,'Server','');
    Accounts[num-1].SMTPServer := Ini.ReadString(Section,'SMTPServer','');
    Accounts[num-1].Port := Ini.ReadInteger(Section,'Port',110);
    Accounts[num-1].SMTPPort := Ini.ReadInteger(Section,'SMTPPort',25);
    Accounts[num-1].Protocol := Ini.ReadString(Section,'Protocol','POP3');
    Accounts[num-1].Login := Ini.ReadString(Section,'Login','');
    Accounts[num-1].MailProgram := Ini.ReadString(Section,'MailProgram','');
    Accounts[num-1].Password := Decrypt(Ini.ReadString(Section,'Password',''));
    Accounts[num-1].Sound := Ini.ReadString(Section,'Sound','');
    Accounts[num-1].Color := Ini.ReadString(Section,'Color','');
    Accounts[num-1].Enabled := Ini.ReadBool(Section,'Enabled',True);
    Accounts[num-1].Interval := Ini.ReadInteger(Section,'Interval',2);
    Accounts[num-1].ViewedMsgIDs := TStringList.Create;
    Accounts[num-1].Mail := TMailItems.Create;
    LoadViewedMessageIDs(num);
    Result := Ini.ReadString(Section,'Name','accnoname') <> 'accnoname';
    // backwards compatible port
    PortStr := StrAfter(Accounts[num-1].Server,':');
    if PortStr <> '' then
    begin
      Accounts[num-1].Server := StrBefore(Accounts[num-1].Server,':');
      Accounts[num-1].Port := StrToIntDef(PortStr,110);
    end;
    // protocol
    SetProtocol(num);
  finally
     Ini.Free;
  end;
end;

procedure TSpamLearnerMainForm.SaveAccountINI(num : integer);
////////////////////////////////////////////////////////////////////////////////
// Save 1 account to INI
var
  Ini : TMemIniFile;
  section : string;
begin
  // write to ini
  Ini := TMemIniFile.Create(IniName);
  try
    section := 'Account'+IntToStr(num);
    Ini.WriteString(Section,'Name',Accounts[num-1].Name);
    Ini.WriteString(Section,'Server',Accounts[num-1].Server);
    Ini.WriteString(Section,'SMTPServer',Accounts[num-1].SMTPServer);
    Ini.WriteInteger(Section,'Port',Accounts[num-1].Port);
    Ini.WriteInteger(Section,'SMTPPort',Accounts[num-1].SMTPPort);
    Ini.WriteString(Section,'Protocol',Accounts[num-1].Protocol);
    Ini.WriteString(Section,'Login',Accounts[num-1].Login);
    Ini.WriteString(Section,'Password',Encrypt(Accounts[num-1].Password));
    Ini.WriteString(Section,'MailProgram',Accounts[num-1].MailProgram);
    Ini.WriteString(Section,'Sound',Accounts[num-1].Sound);
    Ini.WriteString(Section,'Color',Accounts[num-1].Color);
    Ini.WriteBool(Section,'Enabled',Accounts[num-1].Enabled);
    Ini.WriteInteger(Section,'Interval',Accounts[num-1].Interval);
    Ini.WriteInteger('Options','NumAccounts',NumAccounts);
    Ini.UpdateFile;
  finally
     Ini.Free;
  end;
end;

procedure TSpamLearnerMainForm.SaveAccountNum(num : integer);
////////////////////////////////////////////////////////////////////////////////
// Save Account info to array

function Process(S: String): String;
{ Just make sure we get a correct filename }
const NO : array[1..9] of char = ('/','\',':','*','?','"','<','>','|');
var I: Byte;
begin
  for I:=1 to 9 do
    while Pos(NO[I], S) > 0 do
     Delete(S, Pos(NO[I], S), 1);
  Result := S;
end;

begin
  // replace old MAIL file
  if FileExists(Application.ExeName+'Accounts\'+Process(Accounts[num-1].Name)+'.dat') then
   RenameFile(Application.ExeName+'Accounts\'+Process(Accounts[num-1].Name)+'.dat',
              Application.ExeName+'Accounts\'+Process(edName.Text)+'.dat');

  // store account info in array
  Accounts[num-1].Name := edName.Text;
  Accounts[num-1].Server := edServer.Text;
  Accounts[num-1].SMTPServer := edSMTP.Text;
  Accounts[num-1].Port := StrToIntDef(edPort.Text,-1);
  Accounts[num-1].SMTPPort := StrToIntDef(edSMTPPort.Text,-1);
  Accounts[num-1].Protocol := cmbProtocol.Text;
  Accounts[num-1].Login := edLogin.Text;
  Accounts[num-1].Password := edPassword.Text;
  if edAccountProgram.Text = Translate(UseDefaultProgram) then
    Accounts[num-1].MailProgram := ''
  else
    Accounts[num-1].MailProgram := edAccountProgram.Text;
  if edSound.Text = Translate(UseDefaultSound) then
    Accounts[num-1].Sound := ''
  else
    Accounts[num-1].Sound := edSound.Text;
  Accounts[num-1].Color := ColorToString2(colAccount.Selected);
  Accounts[num-1].Enabled := chkAccEnabled.Checked;
  Accounts[num-1].Interval := UpDownAccount.Position;
  Accounts[num-1].Error := False;
  Accounts[num-1].UIDLSupported := True;
  // objects
  if not Assigned(Accounts[num-1].ViewedMsgIDs) then
    Accounts[num-1].ViewedMsgIDs := TStringList.Create;
  if not Assigned(Accounts[num-1].Mail) then
    Accounts[num-1].Mail := TMailItems.Create;
  SetProtocol(num);
  // global
  FNewAccount := False;
  SwitchTimer;
end;

procedure TSpamLearnerMainForm.ShowAccount(num: integer);
////////////////////////////////////////////////////////////////////////////////
// Show the account info in the edit boxes
begin
  if (num<=0) or (num>NumAccounts) then Exit;
  // main params
  edName.Text := Accounts[num-1].Name;
  edServer.Text := Accounts[num-1].Server;
  edSMTP.Text := Accounts[num-1].SMTPServer;
  edPort.Text := IntToStr(Accounts[num-1].Port);
  edSMTPPort.Text := IntToStr(Accounts[num-1].SMTPPort);
  cmbProtocol.ItemIndex := cmbProtocol.Items.IndexOf(Accounts[num-1].Protocol);
  edLogin.Text := Accounts[num-1].Login;
  edPassword.Text := Accounts[num-1].Password;
  // mail program
  if Accounts[num-1].MailProgram <> '' then
  begin
    edAccountProgram.Text := Accounts[num-1].MailProgram;
    edAccountProgram.Font.Color := clWindowText;
    GetBitmapFromFileIcon(edAccountProgram.Text,btnAccountProgramTest.Glyph,True);
  end
  else begin
    edAccountProgram.Text := Translate(UseDefaultProgram);
    edAccountProgram.Font.Color := clGrayText;
    btnAccountProgramTest.Glyph.Assign(btnStartProgram.Glyph);
  end;
  // sound
  if Accounts[num-1].Sound <> '' then
  begin
    edSound.Text := Accounts[num-1].Sound;
    edSound.Font.Color := clWindowText;
  end
  else begin
    edSound.Text := Translate(UseDefaultSound);
    edSound.Font.Color := clGrayText;
  end;
  colAccount.Selected := StringToColorDef(Accounts[num-1].Color,clGray);
  chkAccEnabled.Checked := Accounts[num-1].Enabled;
  UpDownAccount.Position := Accounts[num-1].Interval;
  // server/port disable
  if Accounts[num-1].Port < 0 then
  begin
    edPort.Text := '';
    EnableControl(edPort,false);
    edServer.Text := '';
    EnableControl(edServer,false);
  end
  else begin
    EnableControl(edPort,true);
    EnableControl(edServer,true);
  end;
  // buttons
  FAccChanged := False;
  btnSave.Enabled := False;
  btnCancelAccount.Enabled := False;
end;


function StrToRuleArea(st : string) : TRuleArea;
begin
  st := LowerCase(st);
  if st = 'header' then Result := raHeader
  else if st = 'from' then Result := raFrom
  else if st = 'subject' then Result := raSubject
  else if st = 'to' then Result := raTo
  else if st = 'cc' then Result := raCC
  else if st = 'from (name)' then Result := raFromName
  else if st = 'from (address)' then Result := raFromAddress
  else if st = 'body' then Result := raBody
  else Result := raHeader;
end;

procedure TSpamLearnerMainForm.LoadRulesINI;
////////////////////////////////////////////////////////////////////////////////
// Get the rules from INI file.
// If Rules.ini doesn't exist read from SpamLearner.ini
var
  Ini : TMemIniFile;
  i : integer;
  section : string;
  NewRules : boolean;
begin
  NewRules := FileExists(RuleName);
  if NewRules then
    Ini := TMemIniFile.Create(RuleName)
  else
    Ini := TMemIniFile.Create(IniName);
  try
    lstRules.Items.BeginUpdate;
    try
      lstRules.Clear;
      FNumRules := Ini.ReadInteger('Options','NumRules',0);
      Rules.Clear;
      while Rules.Count < FNumRules do
        Rules.Add;
      for i := 0 to FNumRules-1 do
      begin
        section := 'Rule'+IntToStr(i+1);
        Rules[i].Name := Ini.ReadString(Section,'Name','NoName');
        Rules[i].Account := Ini.ReadInteger(Section,'Account',0);
        Rules[i].Area := StrToRuleArea(Ini.ReadString(Section,'Area','Header'));
        Rules[i].Compare := StrToRuleCompare(Ini.ReadString(Section,'Func','Contains'));
        Rules[i].Text := Ini.ReadString(Section,'Text','');
        Rules[i].Wav := Ini.ReadString(Section,'Wav','');
        Rules[i].EXE := Ini.ReadString(Section,'EXE','');
        if NewRules then
        begin
          Rules[i].Enabled := Ini.ReadBool(Section,'Enabled',False);
          Rules[i].New := Ini.ReadBool(Section,'New',False);
          Rules[i].Delete := Ini.ReadBool(Section,'Delete',False);
          Rules[i].Ignore := Ini.ReadBool(Section,'Ignore',False);
          Rules[i].Important := Ini.ReadBool(Section,'Important',False);
          Rules[i].Spam := Ini.ReadBool(Section,'Spam',False);
          Rules[i].Protect := Ini.ReadBool(Section,'Protect',False);
          Rules[i].Log := Ini.ReadBool(Section,'Log',True);
        end
        else begin
          Rules[i].Enabled := Ini.ReadString(Section,'Enabled','No') = 'Yes';
          Rules[i].New := Ini.ReadString(Section,'New','No') = 'Yes';
          Rules[i].Delete := Ini.ReadString(Section,'Delete','No') = 'Yes';
          Rules[i].Ignore := Ini.ReadString(Section,'Ignore','No') = 'Yes';
          Rules[i].Important := Ini.ReadString(Section,'Important','No') = 'Yes';
          Rules[i].Spam := False;
          Rules[i].Protect := False;
          Rules[i].Log := True;
        end;
        // list box
        lstRules.Items.Add(Rules[i].Name);
        lstRules.Checked[i] := Rules[i].Enabled;
      end;
    finally
      lstRules.Items.EndUpdate;
    end;
  finally
     Ini.Free;
  end;
  btnSaveRules.Enabled := not NewRules;
  btnCancelRule.Enabled := not NewRules;
end;

procedure TSpamLearnerMainForm.SaveRulesINI;
////////////////////////////////////////////////////////////////////////////////
// Save all the rules to INI file
var
  Ini : TMemIniFile;
  i,numrules : integer;
  section : string;
begin
  if not FileExists(RuleName) then
  begin
    // delete from SpamLearner.ini
    Ini := TMemIniFile.Create(IniName);
    try
      numrules := Ini.ReadInteger('Options','NumRules',0);
      for i := 1 to numrules do
        Ini.EraseSection('Rule'+IntToStr(i));
      Ini.DeleteKey('Options','NumRules');
      Ini.UpdateFile;
    finally
      Ini.Free;
    end;
  end;
  // save to rules.ini
  Ini := TMemIniFile.Create(RuleName);
  try
    Ini.WriteInteger('Options','NumRules',FNumRules);
    for i := 0 to Rules.Count-1 do
    begin
      section := 'Rule'+IntToStr(i+1);
      Ini.WriteString(Section,'Name',Rules[i].Name);
      Ini.WriteBool(Section,'Enabled',Rules[i].Enabled);
      Ini.WriteBool(Section,'New',Rules[i].New);
      Ini.WriteInteger(Section,'Account',Rules[i].Account);
      Ini.WriteString(Section,'Area',RuleAreaToStr(Rules[i].Area));
      Ini.WriteString(Section,'Func',RuleCompareToStr(Rules[i].Compare));
      Ini.WriteString(Section,'Text',Rules[i].Text);
      Ini.WriteString(Section,'Wav',Rules[i].Wav);
      Ini.WriteBool(Section,'Delete',Rules[i].Delete);
      Ini.WriteBool(Section,'Ignore',Rules[i].Ignore);
      Ini.WriteString(Section,'EXE',Rules[i].EXE);
      Ini.WriteBool(Section,'Important',Rules[i].Important);
      Ini.WriteBool(Section,'Spam',Rules[i].Spam);
      Ini.WriteBool(Section,'Protect',Rules[i].Protect);
      Ini.WriteBool(Section,'Log',Rules[i].Log);
    end;
    Ini.UpdateFile;
  finally
     Ini.Free;
  end;
  btnSaveRules.Enabled := False;
  btnCancelRule.Enabled := False;
end;

procedure TSpamLearnerMainForm.LoadPosINI;
////////////////////////////////////////////////////////////////////////////////
// Get window position,window size adn column widths from INI
var
  Ini : TIniFile;
  i,ColWidth,SortCol : integer;
begin
  Ini := TIniFile.Create(IniName);
  try
    // form

    lvMail.Height := INI.ReadInteger('Position','MailListHeight',lvMail.Height);

    Self.Width := Ini.ReadInteger('Position','Width',Self.Width);
    Self.Height := Ini.ReadInteger('Position','Height',Self.Height);
    Self.Left := Ini.ReadInteger('Position','Left',Screen.WorkAreaWidth-Self.Width);
    Self.Top := Ini.ReadInteger('Position','Top',Screen.WorkAreaHeight-Self.Height);
    panMailButtonsResize(panMailButtons);
    // columns
    SortCol := Ini.ReadInteger('Position','SortColumn',-1);
    FSortDirection := Ini.ReadInteger('Position','SortDirection',FSortDirection);
    SortCol := Ini.ReadInteger('Position','SortColumn',-1);
    FSortDirection2 := FSortDirection;
    for i := 0 to 4 do
    begin
      ColWidth := Ini.ReadInteger('Position','Column'+IntToStr(i+1),lvMail.Columns[i].Width);
      if ColWidth = 0 then
      begin
        lvMail.Columns[i].MinWidth := 0;
        SpamList.Columns[i].MinWidth := 0;
      end;
      lvMail.Columns[i].Width := ColWidth;
      SpamList.Columns[i].Width := ColWidth;
    end;
    SetSortColumn(SortCol);
    SetSortColumn2(SortCol);
    // tree widths
    tvOptions.Width := Ini.ReadInteger('Position','OptionTree',145);
    lstRules.Width := Ini.ReadInteger('Position','RuleList',100);
    // on screen?
    if self.Left < 0 then self.Left := 0;
    if self.top < 0 then self.Top := 0;
    if self.Left > Screen.WorkAreaWidth then
      self.Left := Screen.WorkAreaWidth - Self.Width;
    if self.Top > Screen.WorkAreaHeight then
      self.Top := Screen.WorkAreaHeight - Self.Height;
    // info
    Options.InfoTab := Ini.ReadInteger('Info','Tab',0);
    Options.InfoCol1 := Ini.ReadInteger('Info','Column1',70);
    Options.InfoCol2 := Ini.ReadInteger('Info','Column2',85);
    Options.InfoCol3 := Ini.ReadInteger('Info','Column3',120);
    Options.InfoCol4 := Ini.ReadInteger('Info','Column4',50);
  finally
     Ini.Free;
  end;
end;

procedure TSpamLearnerMainForm.SavePosINI;
////////////////////////////////////////////////////////////////////////////////
// Save window position,window size adn column widths to INI
var
  Ini : TMemIniFile;
begin
  Ini := TMemIniFile.Create(IniName);
  try
    Ini.WriteInteger('Position','MailListHeight',lvMail.Height);
    // form position
    Ini.WriteInteger('Position','Left',Self.Left);
    Ini.WriteInteger('Position','Top',Self.Top);
    Ini.WriteInteger('Position','Width',Self.Width);
    Ini.WriteInteger('Position','Height',Self.Height);
    // columns
    Ini.WriteInteger('Position','SortColumn',FSortColumn);
    Ini.WriteInteger('Position','SortDirection',FSortDirection);
    Ini.WriteInteger('Position','SortColumn',FSortColumn2);
    Ini.WriteInteger('Position','SortDirection',FSortDirection2);
    Ini.WriteInteger('Position','Column1',lvMail.Columns[0].Width);
    Ini.WriteInteger('Position','Column2',lvMail.Columns[1].Width);
    Ini.WriteInteger('Position','Column3',lvMail.Columns[2].Width);
    Ini.WriteInteger('Position','Column4',lvMail.Columns[3].Width);
    Ini.WriteInteger('Position','Column5',lvMail.Columns[4].Width);
    // list widths
    Ini.WriteInteger('Position','OptionTree',tvOptions.Width);
    Ini.WriteInteger('Position','RuleList',lstRules.Width);
    // info
    Ini.WriteInteger('Info','Tab',Options.InfoTab);
    Ini.WriteInteger('Info','Column1',Options.InfoCol1);
    Ini.WriteInteger('Info','Column2',Options.InfoCol2);
    Ini.WriteInteger('Info','Column3',Options.InfoCol3);
    Ini.WriteInteger('Info','Column4',Options.InfoCol4);
    try
      Ini.UpdateFile;
    except
      on E:Exception do MessageDlg(E.Message,mtError,[mbOK],0);
    end;
  finally
     Ini.Free;
  end;
end;

procedure TSpamLearnerMainForm.LoadViewedMessageIDs(num : integer);
////////////////////////////////////////////////////////////////////////////////
// Load viewed message ids from file
var
  filename : string;
begin
  if Options.RememberViewed then
  begin
    filename := ExtractFilePath(IniName)+'Account_'+IntToStr(num)+'.ids';
    if FileExists(filename) then
      Accounts[num-1].ViewedMsgIDs.LoadFromFile(filename);
  end;
end;

procedure TSpamLearnerMainForm.SaveViewedMessageIDs;
////////////////////////////////////////////////////////////////////////////////
// Save viewed message ids to file
var
  num : integer;
  filename : string;
begin
  if Options.RememberViewed then
  begin
    try
      for num := 1 to NumAccounts do
      begin
        filename := ExtractFilePath(IniName)+'Account_'+IntToStr(num)+'.ids';
        if Accounts[num-1].ViewedMsgIDs.Count > 0 then
          Accounts[num-1].ViewedMsgIDs.SaveToFile(filename);
      end;
    except
      on E:Exception do MessageDlg(E.Message,mtError,[mbOK],0);
    end;
  end;
end;

function TSpamLearnerMainForm.AccountChanged(tab: integer): boolean;
////////////////////////////////////////////////////////////////////////////////
// Check if any of the fields have changed since last save
var
  sound,mailprogram : string;
begin
  if edSound.Text = Translate(UseDefaultSound) then
    sound := ''
  else
    sound := edSound.Text;
  if edAccountProgram.Text = Translate(UseDefaultProgram) then
    mailprogram := ''
  else
    mailprogram := edAccountProgram.Text;
  if tab < 0 then
    Result := False
  else
    Result := (Accounts[tab].Name <> edName.Text) or
              (Accounts[tab].Server <> edServer.Text) or
              (Accounts[tab].SMTPServer <> edSMTP.Text) or
              (Accounts[tab].Port <> StrToIntDef(edPort.Text,110)) or
              (Accounts[tab].SMTPPort <> StrToIntDef(edSMTPPort.Text,25)) or
              (Accounts[tab].Protocol <> cmbProtocol.Text) or
              (Accounts[tab].Login <> edLogin.Text) or
              (Accounts[tab].Password <> edPassword.Text) or
              (Accounts[tab].Color <> ColorToString2(colAccount.Selected)) or
              (Accounts[tab].Enabled <> chkAccEnabled.Checked) or
              (Accounts[tab].Sound <> sound) or
              (Accounts[tab].MailProgram <> mailprogram) or
              (Accounts[tab].Interval <> UpDownAccount.Position);
end;


// ----------------------------------------------------------- mail messages ---

procedure TSpamLearnerMainForm.Preview(num: integer);
////////////////////////////////////////////////////////////////////////////////
// Open preview window and download the message
var
  msgnum,i : integer;
  RawMsg : TStringList;
  TmpStream : TMemoryStream;
  pRawMsg : PChar;
  MailItem : TMailItem;
begin
  msgnum := StrToInt(lvMail.Selected.SubItems[colID]);
  MailItem := Accounts[num-1].Mail.FindMessage(msgnum);
  with Accounts[num-1].Prot do
  begin
    SetOnWork(OnProtWork);
    // connect
    if Connected then Disconnect;
    Screen.Cursor := crHourGlass;
    ConnectAccount(num);
    Screen.Cursor := crDefault;
    try
      // show window
      frmPreview := TfrmPreview.Create(Application);
      frmPreview.IniName := IniName;
      frmPreview.GetINI;
      frmPreview.FAccountNum := num;
      frmPreview.FMsgNum := msgnum;
      frmPreview.btnOK.Enabled := False;
      if (MailItem.UID <> '') and (Copy(MailItem.UID,1,5) <> 'Error') and
         Options.SafeDelete then
      begin
        frmPreview.actDelete.Enabled := True;
        frmPreview.actDelete.Hint := Translate('Delete this message from the list');
        frmPreview.FUID := MailItem.UID;
      end
      else begin
        frmPreview.actDelete.Enabled := False;
        frmPreview.actDelete.Hint := Translate('Delete Button only available when using Safe Delete option');
      end;
      if Options.OnTop then
        frmPreview.FormStyle := fsStayOnTop;
      TranslateForm(frmPreview);
      frmPreview.Caption := Translate('Preview') + ' - SpamLearner';
      frmPreview.Show;
      Application.ProcessMessages;
      // progress
      frmPreview.FStop := False;
      FPreview := True;
      frmPreview.panProgress.Visible := True;
      frmPreview.Progress.Position := 0;
      // get message
      try
        FMsgSize := RetrieveMsgSize(msgnum);
        frmPreview.Progress.Max := FMsgSize;
        RawMsg := TStringList.Create;
        try
          frmPreview.lblProgress.Caption := Translate('Downloading...');
          if Options.TopLines>0 then
            RetrieveTop(msgnum,Options.TopLines,pRawMsg)
          else
            RetrieveRaw(msgnum,pRawMsg);
          RawMsg.SetText(pRawMsg);
          FreePChar(pRawMsg);
          frmPreview.FRawMsg := RawMsg.Text;
          RawMsg.Add('.');
          // process message
          TmpStream := TMemoryStream.Create;
          try
            frmPreview.lblProgress.Caption := Translate('Processing...');
            RawMsg.SaveToStream(TmpStream);
            TmpStream.Position := 0;
            try
              frmPreview.Msg.MIMEBoundary.Push('somejunk'); // bug in Indy when no boundary and "--" in body.
              ProcessMessage(frmPreview.Msg,TmpStream,Options.TopLines>0);
            except
              on E: Exception do
              begin
                if E.Message = RSUnevenSizeInDecodeStream then
                begin
                  // TODO delete files
                  frmPreview.lblProgress.Caption := Translate('Re-Processing...');
                  // remove #13 from end of lines
                  for i := 0 to RawMsg.Count-1 do
                    if RightStr(RawMsg[i],1) = #13 then
                      RawMsg[i] := Copy(RawMsg[i],1,Length(RawMsg[i])-1);
                  TmpStream.Position := 0;
                  RawMsg.SaveToStream(TmpStream);
                  TmpStream.Position := 0;
                  // try again
                  frmPreview.Msg.Clear;
                  ProcessMessage(frmPreview.Msg,TmpStream,Options.TopLines>0);
                end
                else begin
                  if not (E is EAbort) and not Options.IgnoreRetrieveErrors  then
                    TranslateDlg(Translate('Unable to Retrieve message.')+#13#10#13#10+
                                 Translate(E.Message), mtError, [mbOK], 0);
                end;
              end;
            end;
          finally
            TmpStream.Free;
          end;
        finally
          RawMsg.Free;
        end;
      except
        on E : Exception do
        begin
          frmPreview.btnOK.Enabled := True;
          frmPreview.btnOK.SetFocus;
          if frmPreview.FStop then
          begin
            frmPreview.Close;
            FreeAndNil(frmPreview);
          end
          else begin
            if not Options.IgnoreRetrieveErrors then
            begin
              TranslateDlg(Translate('Unable to Retrieve message.')+#13#10#13#10+
                           Translate(E.Message), mtError, [mbOK], 0);
              frmPreview.Close;
              FreeAndNil(frmPreview);
            end
            else begin
              frmPreview.panProgress.Hide;
            end;
          end;
          Exit;
        end;
      end;
      // show contents
      try
        frmPreview.ShowMsg;
      finally
        FPreview := False;
      end;
    finally
      Screen.Cursor := crDefault;
      if Connected then Disconnect;
    end;
  end;
end;

procedure TSpamLearnerMainForm.ProcessMessage(AMsg: TIdMessage; const AStream: TStream; AHeaderOnly: Boolean);
var
  MessageClient : TIdMessageClient;
begin
  MessageClient := TIdMessageClient.Create(nil);
  MessageClient.OnWork := OnProcessWork;
  try
    MessageClient.ProcessMessage(AMsg,AStream,AHeaderOnly);
  finally
    MessageClient.Free;
  end;
end;

procedure TSpamLearnerMainForm.DeleteMultipleMail(num: integer; msgnums : array of integer);
////////////////////////////////////////////////////////////////////////////////
// Delete multiple messages
var
  i,delcount : integer;
begin
  FDeleting := True;
  try
    with Accounts[num-1].Prot do
    begin
      ConnectAccount(num);
      try
        delcount := 0;
        for i := Low(msgnums) to High(msgnums) do
        begin
          if CheckUID(num,msgnums[i]) then
          begin
            Delete(msgnums[i]);
            Inc(delcount);
          end;
        end;
        Accounts[num-1].Status := IntToStr(delcount)+' '+
          Translate('message(s) deleted.');
      finally
        Disconnect;
      end;
    end;
  finally
    FDeleting := False;
  end;
end;

function TSpamLearnerMainForm.GetUIDs(num: integer; var UIDLs : TStringList): boolean;
var
  pUIDL : PChar;
begin
  try
    if Accounts[num-1].UIDLSupported then
    begin
      Result := Accounts[num-1].Prot.UIDL(pUIDL);
      UIDLs.SetText(pUIDL);
      Accounts[num-1].Prot.FreePChar(pUIDL);
      if not Result then Accounts[num-1].UIDLSupported := False;
    end
    else begin
      Result := False;
    end;
  except
    // server doesn't support UIDL
    Result := False;
  end;
end;


function TSpamLearnerMainForm.GetUID(num,msgnum: integer): string;
////////////////////////////////////////////////////////////////////////////////
// Get UID from server.  Must be connected
var
  UIDLs : TStringList;
  res : boolean;
  pUIDL : PChar;
begin
  UIDLs := TStringList.Create;
  try
    try
      if Accounts[num-1].UIDLSupported then
      begin
        res := Accounts[num-1].Prot.UIDL(pUIDL,msgnum);
        if res then
          UIDLs.SetText(pUIDL)
        else
          Accounts[num-1].UIDLSupported := False;
        Accounts[num-1].Prot.FreePChar(pUIDL);
      end
      else begin
        res := False;
      end;
    except
      res := False;
    end;
    if (UIDLs.Count > 0) and res then
      Result := StrAfter(UIDLs[0],' ')
    else
      Result := 'Error'+IntToStr(Random(10000));
  finally
    UIDLs.Free;
  end;
end;

function TSpamLearnerMainForm.CheckUID(num, msgnum: integer; UID : string=''): boolean;
////////////////////////////////////////////////////////////////////////////////
// Check if current UID and stored UID is the same.  Must be connected
var
  MailItem : TMailItem;
begin
  MailItem := Accounts[num-1].Mail.FindMessage(msgnum);
  // default param
  if UID='' then UID := MailItem.UID;
  // compare UID
  Result := not(Options.SafeDelete) or not(Accounts[num-1].UIDLSupported) or
            (Options.SafeDelete and (GetUID(num,msgnum) = UID));
  if not Result then
  begin
    // safe delete failed
    ErrorMsg(num,'Error:',Translate('Message identifiers don''t match.'+#13#10+'The Safe Delete option prevented deletion of this message.'),Options.NoError);
  end;
end;

procedure TSpamLearnerMainForm.MarkViewed(num : integer = -1);
////////////////////////////////////////////////////////////////////////////////
// Mark all messages as viewed
var
  i : integer;
begin
  // viewed e-mails
  if (num = -1) and (tabMail.Tabs.Count>0) then num := tabMail.TabIndex+1;
  if num < 0 then Exit;
  if Accounts[num-1].Mail.Count = 0 then Exit;
  Accounts[num-1].ViewedMsgIDs.Clear;
  for i := 0 to Accounts[num-1].Mail.Count-1 do
  begin
    Accounts[num-1].Mail[i].Viewed := True;
    Accounts[num-1].ViewedMsgIDs.Add(Accounts[num-1].Mail[i].MsgID);
  end;
  // redraw the icon
  UpdateTrayIcon;
end;

function TSpamLearnerMainForm.HasAttachment : boolean;
begin
   Result := AnsiContainsText(MsgHeader.ContentType,'multipart/mixed') or
             AnsiContainsText(MsgHeader.ContentType,'multipart/related');
end;

function TSpamLearnerMainForm.CountUnviewed(num: integer): integer;
var
  i : integer;
begin
  Result := 0;
  for i := 0 to Accounts[num-1].Mail.Count-1 do
    if not Accounts[num-1].Mail[i].Viewed and not Accounts[num-1].Mail[i].Ignored then
      Inc(Result);
end;

function TSpamLearnerMainForm.CountNew(num: integer): integer;
var
  i : integer;
begin
  Result := 0;
  for i := 0 to Accounts[num-1].Mail.Count-1 do
    if Accounts[num-1].Mail[i].New and not Accounts[num-1].Mail[i].Ignored then
      Inc(Result);
end;

function TSpamLearnerMainForm.CountAllNew: integer;
var
  num : integer;
begin
  Result := 0;
  for num := 1 to NumAccounts do
    Result := Result + CountNew(num);
end;

function TSpamLearnerMainForm.CountSpam(num: integer): integer;
var
  i : integer;
begin
  Result := 0;
  for i := 0 to Accounts[num-1].Mail.Count-1 do
    if Accounts[num-1].Mail[i].Spam then
      Inc(Result);
end;

function TSpamLearnerMainForm.CountIgnored(num: integer): integer;
var
  i : integer;
begin
  Result := 0;
  for i := 0 to Accounts[num-1].Mail.Count-1 do
    if Accounts[num-1].Mail[i].Ignored and
       (not Options.HideViewed or
        (Options.HideViewed and not Accounts[num-1].Mail[i].Viewed)) then
    begin
      Inc(Result);
    end;
end;

function TSpamLearnerMainForm.SelectedMailItem(Item : TListItem = nil): TMailItem;
begin
  if Item = nil then Item := lvMail.Selected;
  if Item = nil then
    Result := nil
  else
    Result := Accounts[tabMail.TabIndex].Mail.FindMessage(StrToInt(Item.SubItems[colID]));
end;

function TSpamLearnerMainForm.GetMessageHeader(num, msgnum: integer) : boolean;
var
  MsgSize : integer;
  MsgID : string;
  pHeader : PChar;
  MailItem : TMailItem;
  ret : boolean;
  split : cardinal;
begin
  MsgHeader.Clear;
  // check for stop
  if FStop then
  begin
    Accounts[num-1].Status := Translate('User Aborted.')+HintSep+DateTimeToStr(Now);;
    Accounts[num-1].Error := True;
    Result := false;
    Exit;
  end;
  // get size
  MsgSize := Accounts[num-1].Prot.RetrieveMsgSize(msgnum) div 1024 +1;

  // get headers/body
  if Options.GetBody then
  begin
    // get body
    if (Options.GetBodySize>0) and (MsgSize<=Options.GetBodySize) then
      ret := Accounts[num-1].Prot.RetrieveRaw(msgnum,pHeader)
    else begin
      if Options.GetBodyLines>0 then
        ret := Accounts[num-1].Prot.RetrieveTop(msgnum,Options.GetBodyLines,pHeader)
      else
        if Options.GetBodySize=0 then
          ret := Accounts[num-1].Prot.RetrieveRaw(msgnum,pHeader)
        else
          ret := Accounts[num-1].Prot.RetrieveHeader(msgnum,pHeader);
    end;
  end
  else begin
    // get headers
    ret := Accounts[num-1].Prot.RetrieveHeader(msgnum,pHeader);
  end;
  if not ret then
  begin
    // error in retrieve.
    if not Options.IgnoreRetrieveErrors then
    begin
      ErrorMsg(num,'Retrieve Error:',Translate('Unable to Retrieve Message'),Options.IgnoreRetrieveErrors);
      Result := false;
      Exit;
    end;
  end;
  if Options.GetBody then
  begin
    split := Pos(#13#10#13#10,pHeader);
    if split>0 then
    begin
      MsgHeader.Headers.Text := Copy(pHeader,1,split);
      MsgHeader.Body.Text := Copy(pHeader,split+4,StrLen(pHeader)-split-4);
    end
    else begin
      MsgHeader.Headers.SetText(pHeader);
      MsgHeader.Headers.Text := RemoveBlankLines(MsgHeader.Headers.Text);
    end;
  end
  else begin
    MsgHeader.Headers.SetText(pHeader);
    // remove blank lines (shouldn't be any)
    MsgHeader.Headers.Text := RemoveBlankLines(MsgHeader.Headers.Text);
  end;
  Accounts[num-1].Prot.FreePChar(pHeader);
  try
    MsgHeader.ProcessHeaders;
  except
    on e : Exception do
    begin
      if not Options.IgnoreRetrieveErrors then
      begin
        ErrorMsg(num,'Retrieve Error:',e.Message,Options.IgnoreRetrieveErrors);
        Result := false;
        Exit;
      end;
      MsgHeader.From.Name := MsgHeader.Headers.Values['From'];
      MsgHeader.Subject := MsgHeader.Headers.Values['Subject'];
    end;
  end;

  MsgID := FloatToStr(MsgHeader.Date) + MsgHeader.MsgID;

  // store header details in mail item
  MailItem := Accounts[num-1].Mail.Add;
  MailItem.MsgNum := msgnum;
  if MsgHeader.From.Name = '' then
    MailItem.From := MsgHeader.From.Text
  else
    MailItem.From := MsgHeader.From.Name;
  MailItem.Address := MsgHeader.From.Address;
  if MsgHeader.ReplyTo.Count>0 then
    MailItem.ReplyTo := MsgHeader.ReplyTo[0].Address;
  MailItem.MailTo := MsgHeader.Recipients.EMailAddresses;
  MailItem.Subject := MsgHeader.Subject;
  if int(MsgHeader.Date)=0 then
    MailItem.Date := Copy(MsgHeader.Headers.Values['Date'],1,16)
  else
    MailItem.Date := DateTimeToStr(MsgHeader.Date);
  MailItem.Size := MsgSize;
  if integer(MsgHeader.Priority) = 255 then
    MailItem.Priority := mpNormal
  else
    MailItem.Priority := TMessagePriority(MsgHeader.Priority);
  MailItem.HasAttachment := HasAttachment;
  MailItem.MsgID := MsgID;
  if Options.SafeDelete then
    MailItem.UID := GetUID(num,msgnum);
  MailItem.Viewed := Accounts[num-1].ViewedMsgIDs.IndexOf(MsgID) >= 0;
  MailItem.New := not MailItem.Viewed and not AnsiContainsStr(Accounts[num-1].MsgIDs,MsgID);
  MailItem.Important := False;
  MailItem.Spam := False;
  // rules
  CheckRules(num,msgnum);
  // notifiy plugin
  with MailItem do
  begin
    NotifyPluginMessage(From,MailTo,Subject,MsgHeader.Date,Viewed,New,Important,Spam);
    NotifyPluginMsgBody(MsgHeader.Headers.Text,MsgHeader.Body.Text);
  end;
  // success
  Result := True;
end;

procedure TSpamLearnerMainForm.RefreshAccountStatus(num: integer);
var
  i : integer;
begin
  Accounts[num-1].MsgIDs := '';
  Accounts[num-1].Size := 0;
  Accounts[num-1].IgnoreCount := 0;
  for i := 0 to Accounts[num-1].Mail.Count-1 do
  begin
    Accounts[num-1].MsgIDs := Accounts[num-1].MsgIDs + Accounts[num-1].Mail[i].MsgID;
    Accounts[num-1].Size := Accounts[num-1].Size + Accounts[num-1].Mail[i].Size;
    if (Accounts[num-1].Mail[i].Ignored) then Inc(Accounts[num-1].IgnoreCount);
  end;
end;


//------------------------------------------------------------------- visual ---

procedure TSpamLearnerMainForm.UpdateTrayIcon;
////////////////////////////////////////////////////////////////////////////////
// Calc number of messages and show in in the tray
var
  AccCnt : integer;
  AccName : string;
  Acc1,Acc2 : integer;
  NewCount : integer;
  MailCount,UnviewedCount : integer;
  CircleColor : TColor;
  num : integer;
  AccountWithError : integer;
  NewHint : string;
begin
  // auto check off
  if not dm.mnuAutoCheck.Checked then
  begin
    dm.imlTray.Clear;
    dm.AddBitmap(dm.imlTray, dm.imlPop,popDisabled);
    dm.imlTray.GetIcon(0,TrayIcon.Icon);
    TrayIcon.CycleIcons := False;
    TrayIcon.Hint := 'SpamLearner v.3.0.1'+#13#10+'SpamLearner '+Translate('AutoCheck disabled');
    TrayIcon.Refresh;
    Exit;
  end;
  // total emails
  MailCount := 0;
  UnviewedCount := 0;
  NewCount := 0;
  for num := 1 to NumAccounts do
  begin
    MailCount := MailCount + Accounts[num-1].Mail.Count - Accounts[num-1].IgnoreCount;
    UnviewedCount := UnviewedCount + CountUnviewed(num);
    NewCount := NewCount + CountNew(num);
  end;
  // plug-in notify
  NotifyPluginExecute(MailCount, UnviewedCount, NewCount, Options.ResetTray);

  // count number of accounts with mail
  AccCnt := 0;
  Acc1 := -1;
  Acc2 := -1;
  for num := 1 to NumAccounts do
  begin
    if (Options.ResetTray and (CountUnviewed(num) > 0)) or
       (not Options.ResetTray and ((Accounts[num-1].Mail.Count - Accounts[num-1].IgnoreCount) > 0)) then
    begin
      Inc(AccCnt);
      AccName := Accounts[num-1].Name;
      if Acc1 = -1 then
        Acc1 := num
      else
        Acc2 := num;
    end;
  end;
  FAccountWithMail := Acc1;

  //update FTotalNew
  if Options.ResetTray then
    FTotalNew := UnviewedCount
  else
    FTotalNew := MailCount;

  // draw tray icon
  AccountWithError := FirstAccountWithError;
  if (FTotalNew > 0) then
  begin
    // check for animated option
    if Options.RotateIcon then
    begin
      // rotating icon
      dm.imlTray.Clear;
      for num := 1 to NumAccounts do
      begin
        if Accounts[num-1].Error and not Options.NoError then
        begin
          dm.AddBitmap(dm.imlTray,dm.imlPop,popError);
        end
        else begin
          NewCount := Accounts[num-1].Mail.Count - Accounts[num-1].IgnoreCount;
          if Options.ResetTray then
            NewCount := CountUnviewed(num);
          if NewCount > 0 then
          begin
            CircleColor := StringToColorDef2(Accounts[num-1].Color,clGray);
            DrawTheIcon(NewCount,CircleColor);
            dm.imlTray.AddMasked(imgTray.Picture.Bitmap,clLime);
          end;
        end;
      end;
      // animated and rotating with 1 account
      if Options.Animated and (dm.imlTray.Count = 1) then
      begin
        dm.AddBitmap(dm.imlTray, dm.imlPop,popOpen)
      end;
      // set cycle
      TrayIcon.CycleInterval := 1500;
      TrayIcon.CycleIcons := dm.imlTray.Count > 1;
      if not TrayIcon.CycleIcons then
        dm.imlTray.GetIcon(0,TrayIcon.Icon);
    end
    else begin // not rotating
      // circle color
      if AccCnt=1 then
        CircleColor := StringToColorDef2(Accounts[Acc1-1].Color,clGray)
      else begin
        if dm.imlPop = dm.imlPopTrueColor then
          CircleColor := MixColors(StringToColorDef2(Accounts[Acc1-1].Color,clGray),
                                   StringToColorDef2(Accounts[Acc2-1].Color,clGray))
        else
          CircleColor := clBlack;
      end;
      if Options.Animated then
      begin
        // animated
        dm.imlTray.Clear;
        if (AccountWithError>0) and not Options.NoError then
          dm.AddBitmap(dm.imlTray,dm.imlPop,popError)
        else begin
          DrawTheIcon(FTotalNew,CircleColor);
          dm.imlTray.AddMasked(imgTray.Picture.Bitmap,clLime);
        end;
        dm.AddBitmap(dm.imlTray, dm.imlPop,popOpen);
        TrayIcon.CycleInterval := 1500;
        TrayIcon.CycleIcons := True;
      end
      else begin
        // not animated
        dm.imlTray.Clear;
        if (AccountWithError>0) and not Options.NoError then
          dm.AddBitmap(dm.imlTray,dm.imlPop,popError)
        else begin
          DrawTheIcon(FTotalNew,CircleColor);
          dm.imlTray.AddMasked(imgTray.Picture.Bitmap,clLime);
        end;
        dm.imlTray.GetIcon(0,TrayIcon.Icon);
        TrayIcon.CycleIcons := False;
      end;
    end;
    if FTotalNew=1 then
      NewHint := IntToStr(FTotalNew) + ' '+Translate('message')
    else
      NewHint := IntToStr(FTotalNew) + ' '+Translate('messages');
    if AccCnt=1 then
      NewHint := NewHint + ' '+Translate('in')+' ' + AccName
    else
      NewHint := NewHint + ' '+Translate('in')+' ' +
                 IntToStr(AccCnt) + ' '+Translate('accounts.');
  end
  else begin
    // no emails tray
    dm.imlTray.Clear;
    if (AccountWithError>0) and not Options.NoError then
      dm.AddBitmap(dm.imlTray,dm.imlPop,popError)
    else
      dm.AddBitmap(dm.imlTray, dm.imlPop,popClosed);
    dm.imlTray.GetIcon(0,TrayIcon.Icon);
    TrayIcon.CycleIcons := False;
    NewHint := Translate('No new mail');
  end;
  // set hint
  if AccountWithError>0 then
    TrayIcon.Hint := Accounts[AccountWithError-1].Status
  else
    TrayIcon.Hint := NewHint + HintSep + Translate('Checked:')+' '+ FLastCheck;
  TrayIcon.Refresh;
end;

procedure TSpamLearnerMainForm.ClearTrayIcon;
////////////////////////////////////////////////////////////////////////////////
// Clear the number of messages in the tray icon
begin
  dm.imlTray.Clear;
  dm.AddBitmap(dm.imlTray, dm.imlPop,popClosed);
  dm.imlTray.GetIcon(0,TrayIcon.Icon);
  TrayIcon.CycleIcons := False;
  TrayIcon.Refresh;
end;

procedure TSpamLearnerMainForm.PlayNotify(num: integer);
begin
  if (Accounts[num-1].Mail.Count > Accounts[num-1].IgnoreCount) and
     not(actSuspendSound.Checked) then
  begin
    // play wave
    if FNotifyWav <> '' then
      PlayWav(FNotifyWav)
    else begin
      if Accounts[num-1].Sound <> '' then
        PlayWav(Accounts[num-1].Sound)
      else
        PlayWav(Options.DefSound);
    end;
    // show form if option set
    if Options.ShowForm then
    begin
      PageControl.ActivePageIndex := 0;
      ShowForm;
    end;
  end;
  FNotified := True;
end;

procedure TSpamLearnerMainForm.EnableFields(EnableIt: Boolean);
////////////////////////////////////////////////////////////////////////////////
// Enable / Disable the fields
begin
  EnableControl(edName,EnableIt);
  EnableControl(edServer,EnableIt);
  EnableControl(edSMTPPort,EnableIt);
  EnableControl(edSMTP,EnableIt);
  EnableControl(cmbProtocol,EnableIt);
  EnableControl(edPort,EnableIt);
  EnableControl(edLogin,EnableIt);
  EnableControl(edPassword,EnableIt);
  EnableControl(edAccountProgram,EnableIt);
  EnableControl(edSound,EnableIt);
  EnableControl(colAccount,EnableIt);
  chkAccEnabled.Enabled := EnableIt; 
end;

procedure TSpamLearnerMainForm.SetColumnMenuCheckMarks;
begin
  // visible columns
  dm.mnuColFrom.Checked := lvMail.Columns[0].Width <> 0;
  dm.mnuColTo.Checked := lvMail.Columns[1].Width <> 0;
  dm.mnuColSubject.Checked := lvMail.Columns[2].Width <> 0;
  dm.mnuColDate.Checked := lvMail.Columns[3].Width <> 0;
  dm.mnuColSize.Checked := lvMail.Columns[4].Width <> 0;
  // sort column
  dm.mnuSortMessageStatus.Checked := FSortColumn = -2;
  dm.mnuSortFrom.Checked := FSortColumn = 0;
  dm.mnuSortTo.Checked := FSortColumn = 1;
  dm.mnuSortSubject.Checked := FSortColumn = 2;
  dm.mnuSortDate.Checked := FSortColumn = 3;
  dm.mnuSortSize.Checked := FSortColumn = 4;
  dm.mnuSortNoSort.Checked := FSortColumn = -1;
  actNoSort.Checked := FSortColumn = -1;
end;

procedure TSpamLearnerMainForm.Balloon(head,info: string; IconType : TBalloonHintIcon; TimeoutSecs : integer);
begin
  if (Win32MajorVersion >= 5)  // win2000 & winXP
     or ((Win32Platform <> VER_PLATFORM_WIN32_NT) and (Win32MajorVersion = 4) and (Win32MinorVersion >= 90))  // winME
  then
  begin
    // balloon info
    if length(info) > 255 then info := copy(info,1,250) + ' ...';
    if Copy(head,1,7)='SpamLearner' then
      head := Translate(head)
    else
      head := 'SpamLearner - '+Translate(head);
    TrayIcon.ShowBalloonHint(head,info,IconType,TimeoutSecs);
  end
  else begin
    // msgbox info
    //if not FMinimized then
    begin
      SetForegroundWindow(Handle);
      if Assigned(FInfoForm) then
        FInfoForm.Close;
      FInfoForm := TranslateMsg(info,mtInformation,[mbOK],0);
    end;
  end;
end;

procedure TSpamLearnerMainForm.ShowInfo(ShowOnlyWithMail : boolean = False);
var
  info,kb : string;
  num,i : integer;
begin
  if not Assigned(Accounts[0].Mail) then
    Exit;
  kb := Translate('KB');
  if Options.AdvInfo then
  begin
    // advanced info form
    if not FShowingInfo then
    begin
      frmInfo := TfrmInfo.Create(self);
      FShowingInfo := True;
    end;
    // populate with new messages
    frmInfo.lvInfoNew.Clear;
    for num := 1 to NumAccounts do
    begin
      for i := 0 to Accounts[num-1].Mail.Count-1 do
      begin
        if Accounts[num-1].Mail[i].New then
        begin
          with frmInfo.lvInfoNew.Items.Add do
          begin
            Caption := Accounts[num-1].Name;
            SubItems.Add(Accounts[num-1].Mail[i].From);
            SubItems.Add(Accounts[num-1].Mail[i].Subject);
            SubItems.Add(IntToStr(Accounts[num-1].Mail[i].Size) + ' ' + kb);
            ImageIndex := GetStatusIcon(Accounts[num-1].Mail[i]);
          end;
        end;
      end;
    end;
    // summary
    frmInfo.lvInfoSummary.Clear;
    for num := 1 to NumAccounts do
    begin
      if (Accounts[num-1].Enabled) and
         (not ShowOnlyWithMail or (Accounts[num-1].Mail.Count > 0)) then
      begin
        with frmInfo.lvInfoSummary.Items.Add do
        begin
          Caption := Accounts[num-1].Name;
          SubItems.Add(IntToStr(Accounts[num-1].Mail.Count));
          SubItems.Add(IntToStr(CountNew(num)));
          SubItems.Add(IntToStr(Accounts[num-1].Size)+ ' ' + kb);
          ImageIndex := num-1;
        end;
      end;
    end;
    TranslateForm(frmInfo);
    // show info form
    frmInfo.Left := Screen.WorkAreaLeft + Screen.WorkAreaWidth - frmInfo.Width - 16;
    frmInfo.Top := Screen.WorkAreaTop + Screen.WorkAreaHeight - frmInfo.Height - 4;
    frmInfo.AlphaBlendValue := 0;
    //ShowWindow(frmInfo.Handle, SW_SHOWNOACTIVATE);
    //frmInfo.Visible := True;
    frmInfo.Show;
    // blend it in
    i := 0;
    while i <= 255 do
    begin
      frmInfo.AlphaBlendValue := i;
      Inc(i,10);
      Application.ProcessMessages;
    end;
    frmInfo.AlphaBlendValue := 255;
  end
  else begin
    // normal info
    info := '';
    for num := 1 to NumAccounts do
    begin
      if (Accounts[num-1].Enabled) and
          (not ShowOnlyWithMail or (Accounts[num-1].Mail.Count > 0)) then
      begin
        info := info + ExpandWidth(Accounts[num-1].Name,75) + #9;
        info := info + IntToStr(Accounts[num-1].Mail.Count) + ' '+Translate('msgs.') + #9;
        info := info + ' (' + IntToStr(CountNew(num)) + ' ' + Translate('new') + ') ' + #9;
        info := info + IntToStr(Accounts[num-1].Size) + ' ' + kb + #13#10;
      end;
    end;
    Balloon('Mail Info',info,bitInfo,30);
  end;
end;

procedure TSpamLearnerMainForm.ShowMessages;
begin
  PageControl.ActivePageIndex := 0;
  ShowForm;
end;

procedure TSpamLearnerMainForm.DrawTheIcon(NewCount: integer; CircleColor: TColor);
var
  i : integer;
begin
  with imgTray.Canvas do
  begin
    Brush.Style := bsSolid;
    Brush.Color := clLime;
    Pen.Color := Brush.Color;
    Rectangle(ClipRect);
    // envelope
    dm.imlPop.Draw(imgTray.Canvas, 0,0, popOpen, dsTransparent,itImage);
    // draw circle or rectangle
    Brush.Style := bsSolid;
    Brush.Color := CircleColor;
    Pen.Color := Brush.Color;
    if NewCount > 9 then
      Rectangle(3,1,15,12)  //Rectangle(2,0,16,13)
    else
      Ellipse(3,1,15,12);
    // font
    Font.Name := 'Arial';
    Font.Style := [fsBold];
    if DarkColor(Brush.Color) then
      Font.Color := clWhite
    else
      Font.Color := clBlack;
    Font.Size := 7;
    Brush.Style := bsClear;
    // number
    i := TextWidth(IntToStr(NewCount)) div 2;
    TextOut(9 - i,1,IntToStr(NewCount));
  end;
end;

procedure TSpamLearnerMainForm.DrawCheckingIcon(num : integer);
var
  CircleColor,TransColor : TColor;
  bmp : TBitmap;
begin
  // none
  if (Options.CheckingIcon = ciNone) then
    Exit;
  // lightning bolt
  if (Options.CheckingIcon = ciLightning) then
  begin
    dm.imlPop.GetIcon(popBusy,TrayIcon.Icon);
    TrayIcon.CycleIcons := False;
    Exit;
  end;
  // star
  if (Options.CheckingIcon = ciStar) or (Options.CheckingIcon = ciAnimatedStar) then
  begin
    bmp := TBitmap.Create;
    bmp.Transparent := True;
    CircleColor := StringToColorDef2(Accounts[num-1].Color,clGray);
    TransColor := clLime;
    with imgTray.Canvas do
    begin
      Brush.Style := bsSolid;
      Brush.Color := TransColor;
      Pen.Color := Brush.Color;
      dm.imlTray.Clear;
      // busy 1
      Rectangle(ClipRect);
      dm.imlPop.Draw(imgTray.Canvas, 0,0, popClosed, dsTransparent,itImage);
      dm.imlPop.GetBitmap(popBusy1,bmp);
      RecolorBitmap(bmp,CircleColor);
      imgTray.Canvas.Draw(0,0,bmp);
      dm.imlTray.AddMasked(imgTray.Picture.Bitmap,TransColor);
      dm.imlTray.GetIcon(0,TrayIcon.Icon);
      TrayIcon.CycleIcons := False;
      // animated star
      if (Options.CheckingIcon = ciAnimatedStar) then
      begin
        // busy 2
        Rectangle(ClipRect);
        dm.imlPop.Draw(imgTray.Canvas, 0,0, popClosed, dsTransparent,itImage);
        dm.imlPop.GetBitmap(popBusy2,bmp);
        RecolorBitmap(bmp,CircleColor);
        imgTray.Canvas.Draw(0,0,bmp);
        dm.imlTray.AddMasked(imgTray.Picture.Bitmap,TransColor);
        // busy 3
        Rectangle(ClipRect);
        dm.imlPop.Draw(imgTray.Canvas, 0,0, popClosed, dsTransparent,itImage);
        dm.imlPop.GetBitmap(popBusy3,bmp);
        RecolorBitmap(bmp,CircleColor);
        imgTray.Canvas.Draw(0,0,bmp);
        dm.imlTray.AddMasked(imgTray.Picture.Bitmap,TransColor);
        // tray animation settings
        TrayIcon.CycleInterval := 100;
        TrayIcon.CycleIcons := True;
      end;
    end; //with
    bmp.Free;
  end;
end;

procedure TSpamLearnerMainForm.ResetToolbar;
var
  i : integer;
begin
  if Assigned(MailToolBar.ActionClient) then
    for i := 0 to MailToolBar.ActionClient.Items.Count-1 do
      MailToolBar.ActionClient.Items[i].Control.Perform(CM_MOUSELEAVE, 0, 0);
end;

function TSpamLearnerMainForm.GetStatusIcon(MailItem: TMailItem): integer;
begin
  Result := Ord(MailItem.Priority);
  if MailItem.HasAttachment then Result := mAttachment;
  if MailItem.New then Result := mNew;
  if MailItem.New and MailItem.HasAttachment then Result := mNewAttach;
  if MailItem.Protect then
  begin
    if MailItem.HasAttachment then
       if MailItem.New then
         Result := mProtectNewAttach
       else
         Result := mProtectAttach
    else if MailItem.New then
      Result := mProtectNew
    else
      Result := mProtect;
  end;
  if MailItem.Ignored and not MailItem.Protect then Result := mIgnored;
  if MailItem.Important then Result := mImportant;
  if MailItem.Spam then Result := mSpam;
end;

procedure TSpamLearnerMainForm.ErrorMsg(num: integer; Heading,Msg: string; IgnoreError : boolean);
begin
  Accounts[num-1].Error := True;
  Accounts[num-1].Status := Translate(Heading)+' '+Trim(Msg)+HintSep+DateTimeToStr(Now);
  ShowIcon(num,itError);
  if not IgnoreError then
  begin
    if not FMinimized then
      TranslateDlg(Translate(Heading)+#13#10#13#10+Trim(Msg), mtError, [mbOK], 0)
    else
      Balloon(Translate(Heading),Trim(msg),bitError,15);
  end;
end;

//-------------------------------------------------------------------- rules ---

function TSpamLearnerMainForm.CheckRule(area : string; comp : TRuleCompare; text : string) : boolean;
////////////////////////////////////////////////////////////////////////////////
//  Check if a specific rule compares
begin
  case comp of
    rcContains    : Result := AnsiContainsText(area,text);
    rcEquals      : Result := AnsiSameText(area,text);
    rcWildcard    : Result := CheckWildCard(area,text);
    rcEmpty       : Result := area = '';
    rcNotContains : Result := not AnsiContainsText(area,text);
  else
    Result := false;
  end;
end;

function TSpamLearnerMainForm.GetRuleAreaText(RuleArea : TRuleArea) : string;
begin
  case RuleArea of
      raFrom        : Result := MsgHeader.From.Text;
      raSubject     : Result := MsgHeader.Subject;
      raTo          : Result := MsgHeader.Headers.Values['To']; //Msg.Recipients.EMailAddresses
      raCC          : Result := MsgHeader.CCList.EMailAddresses;
      raFromName    : Result := MsgHeader.From.Name;
      raFromAddress : Result := MsgHeader.From.Address;
      raBody        : Result := MsgHeader.Body.Text;
    else
      Result := MsgHeader.Headers.Text;
    end;
end;

procedure TSpamLearnerMainForm.CheckRules(num,msgnum : integer);
////////////////////////////////////////////////////////////////////////////////
// Check all the rules and perform action
var FileSavedTo: String;

function Replace(S: String): String;
var K: Integer;
begin
  { Replace %NAME with name of sender }
  while Pos(UpperCase('%name'), UpperCase(S)) > 0 do
  begin
    K := Pos(UpperCase('%name'), UpperCase(S));
    Delete(S, K, Length('%name'));
    Insert(Accounts[num-1].Name, S, K);
  end;
  { Replace %NUMBER with ID }
  while Pos(UpperCase('%number'), UpperCase(S)) > 0 do
  begin
    K := Pos(UpperCase('%number'), UpperCase(S));
    Delete(S, K, Length('%number'));
    Insert(editID.Text, S, K);
  end;
  Result := S;
end;

procedure SendSMTPMail(SendToAddress, Subject, Body, SendFromName, SendFromEmail: String);
var
  slBody: TStringList;
  idSMTP: TIdSMTP;
  idMessage: TIdMessage;
begin
 if UpperCase(SendToAddress) = UpperCase(SendFromEmail) then Exit;
 try
  idMessage := TIdMessage.Create(Self);
  idMessage.Recipients.Add;
  idMessage.Recipients[0].Address := SendToAddress;
  slBody := TstringList.Create;
  idSMTP := TIdSMTP.Create(Self);

     slBody.Text := Body;
     idMessage.Body.Assign(slBody);
     idMessage.Subject := Subject;
     idMessage.From.Address := SendFromEmail;
     idMessage.From.Name := SendFromName;
     { Details here... }
     idSMTP.UserName := Accounts[num-1].Login;
     idSMTP.Password := Accounts[num-1].Password;
     idSMTP.Host := Accounts[num-1].SMTPServer;
     idSMTP.Port := Accounts[num-1].SMTPPort;
     try
       idSMTP.Connect;
       idSMTP.Send(idMessage);
     except
     end;
     try
       idSMTP.Disconnect;
     except
     end;
    slBody.Free;

  idSMTP.Free;
  idMessage.Free;
  except
  end;
end;

function Process(S: String): String;
var I, Found: Integer;
begin
  Found := 0;
  for I:=1 to Length(S) do
   if (S[I] = '.') then
     Inc(Found);
  if Found > 1 then
   while (Found > 1) do
   begin
     Delete(S, 1, Pos('.', S));
     Dec(Found);
   end;
  Result := S;
end;

  function GenerateTempName: String;
  var
    TempFile: array[0..MAX_PATH - 1] of Char;
    TempPath: array[0..MAX_PATH - 1] of Char;
  begin
    GetTempPath(MAX_PATH, TempPath);
    if GetTempFileName(TempPath, PChar('abc'), 0, TempFile) = 0 then
      raise Exception.Create('GetTempFileName API failed.' +
        SysErrorMessage(GetLastError));
    Result := TempFile;
  end;

function Go(S: String): String;
const No: Array[1..9] of Char = ('\','/','?','*',':','"','<','>','|');
var I: Integer;
begin
  I := 1;
  for I:=1 to 9 do
   while Pos(No[I], S) > 0 do
    Delete(S, Pos(No[I], S), 1);
  Result := S;
end;

function Unique(S: String): String;
var I: Integer;
begin
  I := 0;
  if not FileExists(ExtractFilePath(Application.ExeName)+'Junk\'+S+'.txt') then
  begin
    Result := S+'.txt';
    Exit;
  end;
  while FileExists(ExtractFilePath(Application.ExeName)+'Junk\'+S+' '+IntToStr(I)+'.txt') do
   Inc(I);
  Result := S+' '+IntToStr(I)+'.txt';
end;

function GeneratePath(Subject, From: String; Date: TDateTime): String;
begin
  Result := Unique(Go(Subject+' - '+From+' ('+DateToStr(Date)+')'));
end;

function AddUnknownMessage(From, MailTo, Subject: String; Date: TDateTime; Size: Word): TUnknownMsg;
var P: TUnknownMsg;
begin
  P := New(TUnknownMsg);
  P^.Next := Accounts[num-1].UnknownMessages;
  P^.Account.Path := FileSavedTo; //GeneratePath(Subject, From, Date);
  P^.Account.From := From;
  P^.Account.Subject := Subject;
  P^.Account.MailTo := MailTo;
  P^.Account.Date := Date;
  P^.Account.Size := Size;
  P^.Account.Spam := False; // asume not a spam message
  P^.Account.Viewed := False; // asume not viewed
  Accounts[num-1].UnknownMessages := P;
  Result := P;
end;

procedure Allow(EMail: String);
var I: Integer; Found: Boolean;
begin
  Found := False;
  for I:=0 to Options.WhiteList.Count-1 do
   if UpperCase(EMail)=UpperCase(Options.WhiteList[I]) then
    begin
      Found := True;
      Break;
    end;
  if not Found then
   Options.WhiteList.Add(EMail);
end;

var
  i : integer;
  area : string;
  RuleEXE,ExeName,ExeParam : string;
  MailItem : TMailItem;

  RawMsg: TStringList;
  pRawMsg : PChar;

  P: TUnknownMsg;
  FR: Real;
  MarkAsSpam, RuleFound: Boolean;
begin
  MailItem := Accounts[num-1].Mail.FindMessage(msgnum);

  // block e-mails with no FROM address
  if (MsgHeader.From.Address = '') or InWhiteBlackList(wbBlack,MsgHeader.From.Address) then
  begin
    Inc(FNumToDelete);
    SetLength(FMsgsToDelete,FNumToDelete);
    FMsgsToDelete[FNumToDelete-1] := msgnum;
    Exit;
  end;

  // white list
  // --> MsgHeader.From.Address <-- is the FROM address of the e-mail received
  MailItem.IsInWhiteList := InWhiteBlackList(wbWhite,MsgHeader.From.Address);
  MailItem.Protect := MailItem.IsInWhiteList;
  { This e-mail is sent for verification! Protect it }
  if MsgHeader.Subject = editID.Text then
  begin
    MailItem.Protect := True;
    // now add this message to white list automatically
    Allow(MsgHeader.From.Address);
    btnSaveListsClick(Self);
    if btnLists.Down then
     btnListsClick(Self);
  end;
  if MailItem.IsInWhiteList then // leave this alone
   Exit;

  { ********************************************************************** }
  { If mail is NOT in allow/block list, send autoreply message }
      if Pos('@', Accounts[num-1].Login) <= 0 then
        SendSMTPMail(MsgHeader.From.Address, Replace(editSubject.Text), Replace(memoMessage.Text),
                     Accounts[num-1].Name, Accounts[num-1].Login+'@'+Process(Accounts[num-1].Server))
      else
        SendSMTPMail(MsgHeader.From.Address, Replace(editSubject.Text), Replace(memoMessage.Text),
                     Accounts[num-1].Name, Accounts[num-1].Login);

      // before deleting, first download and save to file!
      if not DirectoryExists(ExtractFilePath(Application.ExeName)+'Junk') then
       begin
         MkDir(ExtractFilePath(Application.ExeName)+'Junk');
         {Set attributes}
         FileSetAttr(ExtractFilePath(Application.ExeName)+'Junk', faHidden or faArchive or faDirectory);
       end;

       with Accounts[num-1].Prot do
       begin
         // get message
         RawMsg := TStringList.Create;
         try
           RetrieveRaw(StartingWithMail,pRawMsg);
           RawMsg.SetText(pRawMsg);
           FreePChar(pRawMsg);
           RawMsg.Add('.');
           Inc(StartingWithMail);
         except
         end;
         FileSavedTo := ExtractFilePath(Application.ExeName)+'Junk\'+GeneratePath(MsgHeader.Subject, MsgHeader.From.Address, MsgHeader.Date);
         RawMsg.SaveToFile(FileSavedTo);

         RawMsg.Free;
       end;

  RuleFound := False;
  MarkAsSpam := False;

  // rules for protect first ----------------------------------------------------------------------------
  for i := 0 to Rules.Count-1 do
  begin
    if Rules[i].Enabled and
       ( (Rules[i].Account = 0) or (Rules[i].Account = num) ) and
       ( not(Rules[i].New) or (Rules[i].New and MailItem.New) ) then
    begin
      if Rules[i].Protect then
      begin
        area := GetRuleAreaText(Rules[i].Area);
        if CheckRule(area,Rules[i].Compare,Rules[i].Text) then
        begin
          MailItem.Protect := True;
          if Rules[i].Log then
            LogRule('PROTECT',Rules[i].Name,MsgHeader.From.Text,MsgHeader.Subject,Accounts[num-1].Name);
        end;
      end;
    end;
  end;
  // black list
{  if InWhiteBlackList(wbBlack,MsgHeader.From.Address) then
  begin
    if (MsgHeader.From.Address <> '') and not MailItem.Protect and not MailItem.Important then
    begin
      if Options.BlackListSpam then
      begin
        MailItem.Spam := True;
        MailItem.Ignored := True;
        LogRule('SPAM','BlackList',MsgHeader.From.Text,MsgHeader.Subject,Accounts[num-1].Name);
      end
      else begin
        Inc(FNumToDelete);
        SetLength(FMsgsToDelete,FNumToDelete);
        FMsgsToDelete[FNumToDelete-1] := msgnum;
        LogRule('DELETE','BlackList',MsgHeader.From.Text,MsgHeader.Subject,Accounts[num-1].Name);
      end;
    end;
  end;}
  // other rules
  for i := 0 to Rules.Count-1 do
  begin
    // enabled?
    if Rules[i].Enabled and
       ( (Rules[i].Account = 0) or (Rules[i].Account = num) ) and
       ( not(Rules[i].New) or (Rules[i].New and MailItem.New) ) then
    begin
      area := GetRuleAreaText(Rules[i].Area);
      // check it against the rule
      if CheckRule(area,Rules[i].Compare,Rules[i].Text) then
      begin
        // wav
        if Rules[i].Wav <> '' then
        begin
          if not FNotified then
            FNotifyWav := Rules[i].Wav;
          FNotified := True;
          if Rules[i].Log then
            LogRule('WAV',Rules[i].Name,MsgHeader.From.Text,MsgHeader.Subject,Accounts[num-1].Name);
        end;
        // delete
        if Rules[i].Delete then
        begin
          if not InArray(FMsgsToDelete,msgnum) and
             not MailItem.Protect and
             not MailItem.Important then
          begin
            RuleFound := True; // delete
{            Inc(FNumToDelete);
            SetLength(FMsgsToDelete,FNumToDelete);
            FMsgsToDelete[FNumToDelete-1] := msgnum;}
            if Rules[i].Log then
              LogRule('DELETE',Rules[i].Name,MsgHeader.From.Text,MsgHeader.Subject,Accounts[num-1].Name);
          end;
        end;
        // ignore
        if Rules[i].Ignore then
        begin
          MailItem.Ignored := True;
          RuleFound := True; // ignore!
          if Rules[i].Log then
            LogRule('IGNORE',Rules[i].Name,MsgHeader.From.Text,MsgHeader.Subject,Accounts[num-1].Name);
        end;
        // exe
        if Rules[i].EXE <> '' then
        begin
          // replace macros
          RuleEXE := Rules[i].EXE;
          RuleEXE := AnsiReplaceText(RuleEXE,'%ACCOUNT%',Accounts[num-1].Name);
          RuleEXE := AnsiReplaceText(RuleEXE,'%ACCOUNTNUM%',IntToStr(num));
          RuleEXE := AnsiReplaceText(RuleEXE,'%FROM%',MailItem.From);
          RuleEXE := AnsiReplaceText(RuleEXE,'%TO%',MailItem.MailTo);
          RuleEXE := AnsiReplaceText(RuleEXE,'%SUBJECT%',MailItem.Subject);
          RuleEXE := AnsiReplaceText(RuleEXE,'%DATE%',MailItem.Date);
          RuleEXE := AnsiReplaceText(RuleEXE,'%SIZE%',IntToStr(MailItem.Size));
          RuleEXE := AnsiReplaceText(RuleEXE,'%MSGID%',MailItem.MsgID);
          RuleEXE := AnsiReplaceText(RuleEXE,'%UID%',MailItem.UID);
          RuleEXE := AnsiReplaceText(RuleEXE,'%MSGNUM%',IntToStr(msgnum));
          // execute
          SplitExeParams(RuleEXE,ExeName,ExeParam);
          ExecuteFile(ExeName,ExeParam,'',SW_RESTORE);
          if Rules[i].Log then
            LogRule('EXE',Rules[i].Name,MsgHeader.From.Text,MsgHeader.Subject,Accounts[num-1].Name);
        end;
        // important
        if Rules[i].Important then
        begin
          MailItem.Important := True;
          MailItem.Spam := False;
          FImportant := True;
          Balloon('Rule Notify',Translate('Important e-mail has arrived.'),bitInfo,3);
          if Rules[i].Log then
            LogRule('IMPORTANT',Rules[i].Name,MsgHeader.From.Text,MsgHeader.Subject,Accounts[num-1].Name);
        end;
        // spam
        if Rules[i].Spam and
           (MsgHeader.From.Address <> '') and
           {not MailItem.Protect and} not MailItem.Important then
        begin
          MailItem.Spam := True;
          MarkAsSpam := True;
          if Rules[i].Log then
            LogRule('SPAM',Rules[i].Name,MsgHeader.From.Text,MsgHeader.Subject,Accounts[num-1].Name);
        end;
      end;
    end; //enabled
  end;

  // and finally delete message from server first
  Inc(FNumToDelete);
  SetLength(FMsgsToDelete,FNumToDelete);
  FMsgsToDelete[FNumToDelete-1] := msgnum;

  if (not RuleFound) then
  begin
    // add message to unknown messages list
    P := AddUnknownMessage(MsgHeader.From.Address, MailItem.MailTo, MsgHeader.Subject, MsgHeader.Date, MailItem.Size);
    // in here we must test to see if the bayesian filter is enabled.
    // if it is, test to see if this is a spam e-mail
    // if it is a spam e-mail, set the appropiate flag
    P^.Account.Spam := MarkAsSpam;
    if Options.BayesianFilterActive then
     begin
       OpenFilter(Accounts[num-1].Name);
       P^.Account.Spam := MarkAsSpam;
       FR := Filtrate(RawMsg.GetText);
       if (not MarkAsSpam) and (FR > 0.5) then
         P^.Account.Spam := True;
       CloseFilter();
     end;
  end
  else
   DeleteFile(FileSavedTo); // delete this file as well
end;

procedure TSpamLearnerMainForm.ShowRule(selected: integer);
begin
  // show the selected rule in the editboxes
  if selected > -1 then
  begin
    FRuleChanged := False;
    panRuleDetail.Visible := True;
    actRuleDelete.Enabled := True;
    edRuleName.Tag := 1; // bug in WinNT
    edRuleName.Text := Rules[selected].Name;;
    edRuleName.Tag := 0;
    chkRuleEnabled.Checked := Rules[selected].Enabled;
    chkRuleNew.Checked := Rules[selected].New;
    cmbRuleAccount.ItemIndex := Rules[selected].Account;
    cmbRuleArea.ItemIndex := Ord(Rules[selected].Area);
    cmbRuleComp.ItemIndex := Ord(Rules[selected].Compare);
    cmbRuleCompChange(cmbRuleComp);
    edRuleText.Text := Rules[selected].Text;
    chkRuleWav.Checked := Rules[selected].Wav <> '';
    edRuleWav.Text := Rules[selected].Wav;
    chkRuleDelete.Checked := Rules[selected].Delete;
    chkRuleIgnore.Checked := Rules[selected].Ignore;
    chkRuleEXE.Checked := Rules[selected].EXE <> '';
    chkRuleImportant.Checked := Rules[selected].Important;
    chkRuleSpam.Checked := Rules[selected].Spam;
    chkRuleProtect.Checked := Rules[selected].Protect;
    edRuleEXE.Text := Rules[selected].EXE;
    chkRuleLog.Checked := Rules[selected].Log;
    Application.ProcessMessages;
    FRuleChanged := True;
  end
  else begin
    actRuleDelete.Enabled := False;
    panRuleDetail.Visible := False;
  end;
end;

procedure TSpamLearnerMainForm.DeleteRule(rulenum: integer);
begin
  Rules.Delete(rulenum);
  Dec(FNumRules);
  // list box
  lstRules.Items.Delete(rulenum);
  if rulenum > lstRules.Items.Count-1 then
    lstRules.ItemIndex := lstRules.Items.Count-1
  else
    lstRules.ItemIndex := rulenum;
  ShowRule(lstRules.ItemIndex);
end;

procedure TSpamLearnerMainForm.LogRule(Action,Name,From,Subject,Account : string);
////////////////////////////////////////////////////////////////////////////////
// Write the log action to a tab-delimited file
var
  fl : TextFile;
begin
  if Options.LogRules then
  begin
    AssignFile(fl,LogRuleName);
    if FileExists(LogRuleName) then
      Append(fl)
    else begin
      Rewrite(fl);
      WriteLn(fl,'Date',#9,'Action',#9,'RuleName',#9,'From',#9,'Subject',#9,'Account');
    end;
    Subject := AnsiReplaceStr(Subject,#9,' ');
    WriteLn(fl,DateTimeToStr(Now),#9,Action,#9,Name,#9,From,#9,Subject,#9,Account);
    CloseFile(fl);
  end;
end;

procedure TSpamLearnerMainForm.EnableRuleButtons;
begin
  if FRuleChanged then
  begin
    btnSaveRules.Enabled := True;
    btnCancelRule.Enabled := True;
  end;
end;

procedure TSpamLearnerMainForm.FillRuleAccounts;
var
  num,save : integer;
begin
  // fill rules account dropdown
  save := cmbRuleAccount.ItemIndex;
  cmbRuleAccount.Items.Text := Translate('All Accounts');
  for num := 1 to NumAccounts do
    cmbRuleAccount.Items.Add(Accounts[num-1].Name);
  cmbRuleAccount.ItemIndex := save;
end;

function TSpamLearnerMainForm.AddToWhiteBlackList(WhiteBlack: TWhiteBlack) : boolean;
////////////////////////////////////////////////////////////////////////////////
// Add selected from addresses to White List
var
  emails : TStringList;
  Item : TListItem;
begin
  Result := false;
  if lvMail.Selected = nil then
  begin
    TranslateDlg(Translate('No message selected.'), mtError, [mbOK], 0);
    Exit;
  end;

  emails := TStringList.Create;
  try
    // collect selected emails (remove duplicates)
    emails.Duplicates := dupIgnore;
    emails.CaseSensitive := False;
    emails.Sorted := True;
    Item := lvMail.Selected;
    while Item <> nil do
    begin
      emails.Add(Accounts[tabMail.TabIndex].Mail[StrToInt(Item.SubItems[colID])-1].Address);
      Item := lvMail.GetNextItem(Item, sdAll, [isSelected]);
    end;

    // add to either list
    if (emails.Count > 0) then
    begin
      if WhiteBlack = wbWhite then
      begin
        Options.WhiteList.Duplicates := dupIgnore;
        Options.WhiteList.CaseSensitive := False;
        Options.WhiteList.Sorted := True;
        Options.WhiteList.AddStrings(emails);
        Options.WhiteList.SaveToFile(ExtractFilePath(IniName)+'WhiteList.dat');
        if Assigned(frame) and (frame is TframeWhiteBlack) then
          (frame as TframeWhiteBlack).memWhiteList.Lines.Text := Options.WhiteList.Text;
        TranslateDlg(Translate('Added to the White List:')+#13#10+emails.Text,mtInformation,[mbOK],0);
        Result := True;
      end
      else begin
        if (TranslateDlg(Translate('This will add the following e-mails to the Black List:')
            +#13#10+emails.Text+
            #13#10+Translate('Are you sure?'), mtConfirmation, [mbYes,mbNo], 0) = mrYes) then
        begin
          Options.BlackList.Duplicates := dupIgnore;
          Options.BlackList.CaseSensitive := False;
          Options.BlackList.Sorted := True;
          Options.BlackList.AddStrings(emails);
          Options.BlackList.SaveToFile(ExtractFilePath(IniName)+'BlackList.dat');
          if Assigned(frame) and (frame is TframeWhiteBlack) then
            (frame as TframeWhiteBlack).memBlackList.Lines.Text := Options.BlackList.Text;
          Result := True;
        end;
      end;
    end;
  finally
    emails.Free;
  end;
end;

function TSpamLearnerMainForm.InWhiteBlackList(WhiteBlack: TWhiteBlack; email: string): boolean;
var
  list : TStringList;
  i : integer;
begin
  // select list
  if WhiteBlack = wbWhite then
    list := Options.WhiteList
  else
    list := Options.BlackList;
  // check if in list using wildcards
  Result := True;
  for i := 0 to list.Count-1 do
  begin
    if CheckWildcard(email,list[i]) then
      Exit;
  end;
  Result := False;
end;


//--------------------------------------------------------------- procedural ---

procedure TSpamLearnerMainForm.Quit;
begin
  SavePosINI;
  SaveViewedMessageIDs;
  Application.Terminate;
end;

procedure TSpamLearnerMainForm.ConnectAccount(num: integer);
var
  aHost,aProtocol : string;
  aUsername,aPassword : string;
  aPort : integer;
begin
  aHost := Accounts[num-1].Server;
  aPort := Accounts[num-1].Port;
  aProtocol := Accounts[num-1].Protocol;
  aUsername := Accounts[num-1].Login;
  aPassword := Accounts[num-1].Password;
  Accounts[num-1].Connecting := True;
  try
    Accounts[num-1].Prot.Connect(PChar(aHost),aPort,PChar(aProtocol),PChar(aUsername),PChar(aPassword), Options.TimeOut*1000);
    if Accounts[num-1].Prot.LastErrorMsg<>nil then
    begin
      raise EIdException.Create(Translate('Plug-in Error:')+' '+Accounts[num-1].Prot.LastErrorMsg);
    end;
  finally
    Accounts[num-1].Connecting := False;
  end;
end;

function TSpamLearnerMainForm.GetDefaultEmail: string;
////////////////////////////////////////////////////////////////////////////////
// Get the default e-mail program from registry
var
  Reg: TRegistry;
  EMailClient : string;
begin
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    if Reg.OpenKey('\Software\Clients\Mail', False) then
    begin
      EMailClient := Reg.ReadString('');
      Reg.CloseKey;
      Reg.OpenKey('\Software\Clients\Mail\'+EMailClient+'\shell\open\command', False);
      EMailClient := Reg.ReadString('');
      EMailClient := ExpandEnv(EMailClient);
      Result := EMailClient;
      Reg.CloseKey;
    end;
  finally
    Reg.Free;
  end;
end;

procedure TSpamLearnerMainForm.SwitchTimer;
var
  num : integer;
begin
  if Options.TimerAccount then
  begin
    // multiple timers
    dm.Timer.Enabled := False;
    for num := 1 to NumAccounts do
    begin
      if Assigned(Accounts[num-1].Timer) then Accounts[num-1].Timer.Free;
      Accounts[num-1].Timer := TTimer.Create(self);
      Accounts[num-1].Timer.Interval := Accounts[num-1].Interval * 60000;
      Accounts[num-1].Timer.Tag := num;
      Accounts[num-1].Timer.OnTimer := OnAccountTimer;
      Accounts[num-1].Timer.Enabled := Accounts[num-1].Enabled;
    end;
  end
  else begin
    // 1 timer
    dm.Timer.Enabled := True;
    for num := 1 to NumAccounts do
    begin
      if Assigned(Accounts[num-1].Timer) then
      begin
        Accounts[num-1].Timer.Enabled := False;
        Accounts[num-1].Timer.Free;
        Accounts[num-1].Timer := nil;
      end;
    end;
  end;
end;

procedure TSpamLearnerMainForm.RunQueue;
var
  acc : integer;
begin
  // check all accounts in the queue
  FNotified := False;
  while FQueue.Count > 0 do
  begin
    acc := Integer(FQueue.Pop);
    if Accounts[acc-1].Enabled then
    begin
      ShowIcon(acc,itChecking);
      CheckMail(acc, not FNotified);
      ShowIcon(acc,itNormal);
    end;
    if (NumAccounts > 0) and (tabMail.TabIndex = acc-1) then
      ShowMail(tabMail.TabIndex+1);
    Application.ProcessMessages;
  end;
  // show balloon
  if Options.Balloon and (CountAllNew > 0) then
    ShowInfo(True);
end;

function ConvertModifiers(HotKey : integer) : cardinal;
begin
  Result := 0;
  if (HotKey and scShift) = scShift then Result := Result or MOD_SHIFT;
  if (HotKey and scCtrl) = scCtrl then Result := Result or MOD_CONTROL;
  if (HotKey and scAlt) = scAlt then Result := Result or MOD_ALT;
  //if (HotKey and sc) = scShift then Result := Result or MOD_WIN;
end;

procedure TSpamLearnerMainForm.RegisterTheHotKeys;
begin
  // hot-keys
  if Options.HotKey1 <> 0 then
    RegisterHotKey(Self.Handle,1,ConvertModifiers(Options.HotKey1),Options.HotKey1 and not (scShift + scCtrl + scAlt));
  if Options.HotKey2 <> 0 then
    RegisterHotKey(Self.Handle,2,ConvertModifiers(Options.HotKey2),Options.HotKey2 and not (scShift + scCtrl + scAlt));
  if Options.HotKey3 <> 0 then
    RegisterHotKey(Self.Handle,3,ConvertModifiers(Options.HotKey3),Options.HotKey3 and not (scShift + scCtrl + scAlt));
  if Options.HotKey4 <> 0 then
    RegisterHotKey(Self.Handle,4,ConvertModifiers(Options.HotKey4),Options.HotKey4 and not (scShift + scCtrl + scAlt));
end;

procedure TSpamLearnerMainForm.UnRegisterTheHotKeys;
var
  i : integer;
begin
  for i := 1 to 4 do
    UnregisterHotKey(Self.Handle,i);
end;

procedure TSpamLearnerMainForm.DoMouseCommand(MouseCommand: TMouseCommand);
var
  tmp : integer;
  command : TCommand;
begin
  if GetKeyState(VK_SHIFT) < 0 then
  begin
    // shift click
    case MouseCommand of
      mcClick    : tmp := Options.ShiftLeftClick;
      mcRClick   : tmp := Options.ShiftRightClick;
      mcMClick   : tmp := Options.ShiftMiddleClick;
    else
      tmp := Options.LeftClick;
    end;
  end
  else begin
    // non-shift click
    case MouseCommand of
      mcClick    : tmp := Options.LeftClick;
      mcRClick   : tmp := Options.RightClick;
      mcMClick   : tmp := Options.MiddleClick;
      mcDblClick : tmp := Options.DblClick;
    else
      tmp := Options.LeftClick;
    end;
  end;

  command := TCommand(tmp);
  if (MouseCommand=mcClick) and FDoubleClicked then
    FDoubleClicked := False
  else
    DoCommand(command);
end;

procedure TSpamLearnerMainForm.DoHKCommand(HotKeyNum : integer);
var
  command : TCommand;
begin
  case HotKeyNum of
    1 : command := TCommand(Options.Action1);
    2 : command := TCommand(Options.Action2);
    3 : command := TCommand(Options.Action3);
    4 : command := TCommand(Options.Action4);
  else
    command := TCommand(Options.Action1);
  end;
  DoCommand(command);
end;

procedure TSpamLearnerMainForm.DoCommand(Command: TCommand);
var
  num : integer;
begin
  case Command of
    cmdShow            : ShowMessages;
    cmdMenu            : PopupAtCursor;
    cmdCheck           : CheckAllMail;
    cmdRun             : btnStartProgram.Click;
    cmdCheckShow       : CheckAndShow;
    cmdInfo            : ShowInfo;
    cmdCheckInfo       : CheckAndInfo;
    cmdToggleShow      : if FMinimized then ShowMessages else HideForm;
    cmdToggleAutoCheck : actAutoCheck.Execute;
    cmdNewMessage      : SendMail('','','');
    cmdToggleSound     : actSuspendSound.Execute;
    cmdDeleteSpam      : for num := 1 to Accounts.Count do
                           DeleteSpam(num,false);
    cmdMarkViewed      : actMarkViewed.Execute;
    cmdCheckFirst      : begin
                           ShowIcon(1,itChecking);
                           CheckMail(1);
                           ShowIcon(1,itNormal);
                           if tabMail.TabIndex=0 then
                             ShowMail(1);
                         end;
    // extra commands
    cmdAutoCheckOn     : begin
                           actAutoCheck.Checked := True;
                           UpdateTrayIcon;
                         end;
    cmdAutoCheckOff    : begin
                           actAutoCheck.Checked := False;
                           UpdateTrayIcon;
                         end;
    cmdSoundOn         : actSuspendSound.Checked := False;
    cmdSoundOff        : actSuspendSound.Checked := True;
  end;
end;

procedure TSpamLearnerMainForm.CheckAndShow;
begin
  CheckAllMail;
  if FTotalNew > 0 then
    ShowMessages;
end;

procedure TSpamLearnerMainForm.CheckAndInfo;
begin
  CheckAllMail;
  if FTotalNew > 0 then ShowInfo;
end;

procedure TSpamLearnerMainForm.PopupAtCursor;
var
  CursorPos: TPoint;
begin
  if GetCursorPos(CursorPos) then
  begin
    Application.ProcessMessages;
    SetForegroundWindow(TrayIcon.Handle);
    SetForegroundWindow(Self.Handle);
    dm.mnuTray.PopupComponent := dm.mnuTray;
    dm.mnuTray.Popup(CursorPos.X, CursorPos.Y);
    PostMessage(Self.Handle, WM_NULL, 0, 0)
  end;
end;

procedure TSpamLearnerMainForm.DeleteAccount(num: integer);
var
  i : integer;
begin
  if NumAccounts=1 then
  begin
    TranslateDlg(Translate('Cannot delete last Account'), mtError, [mbOK], 0);
    Exit;
  end;
  if TranslateDlg(Translate('Delete Account:')+' '+Accounts[num-1].Name+' ?',
                mtConfirmation, [mbYes, mbNo], 0) = mrYes then
  begin
    // remove from array
    Accounts.Delete(num-1);
    Dec(NumAccounts);
    // tab
    tabMail.Tabs.Delete(num-1);
    tabAccounts.Tabs.Delete(num-1);
    // remove from INI
    for i := 1 to NumAccounts do
      SaveAccountINI(i);
    // remove from rules dropdown
    FillRuleAccounts;
    // fix rules
    for i := 0 to Rules.Count-1 do
    begin
      if Rules[i].Account = num then
        Rules[i].Account := -1;
      if Rules[i].Account > num then
        Rules[i].Account := Rules[i].Account - 1;
    end;
    lstRulesClick(lstRules);
    SaveRulesINI;
    // show mail
    if NumAccounts>0 then
    begin
      tabMail.TabIndex := 0;
      tabAccounts.TabIndex := 0;
      ShowAccount(tabAccounts.TabIndex+1);
      ShowMail(tabMail.TabIndex+1);
    end;
  end;
end;

function TSpamLearnerMainForm.FirstAccountWithError: integer;
var
  num : integer;
begin
  Result := 0;
  for num := 1 to NumAccounts do
    if Accounts[num-1].Error then
    begin
      Result := num;
      Break;
    end;
end;

procedure TSpamLearnerMainForm.DeleteSpam(num: integer; confirm: boolean);
var
  msgnums : array of integer;
  i : integer;
begin
  for i := 0 to Accounts[num-1].Mail.Count-1 do
  begin
    if Accounts[num-1].Mail[i].Spam and
       not(Accounts[num-1].Mail[i].Important) and
       not InWhiteBlackList(wbWhite,Accounts[num-1].Mail[i].Address) then
    begin
      SetLength(msgnums,Length(msgnums)+1);
      msgnums[Length(msgnums)-1] := Accounts[num-1].Mail[i].MsgNum;
    end;
  end;
  if Length(msgnums) > 0 then
  begin
    if not(confirm) or
      (TranslateDlg(Translate('Delete Spam from Server?')+' '+#13#10#13#10+
                    Translate('Number of messages marked as Spam:')+' '+IntToStr(Length(msgnums))+#13#10+
                    Translate('This will delete all these messages.'),
                    mtConfirmation,[mbYes,mbNo],0) = mrYes) then
    begin
      ShowIcon(num,itDeleting);
      DeleteMultipleMail(num,msgnums);
      if CheckMail(num,false) < 0 then
        lvMail.Clear
      else
        ShowIcon(num,itNormal);
    end;
  end;
end;

procedure TSpamLearnerMainForm.SetSpamAction(act: TAction);
begin
  FSpamAction := act;
  actSpam.Caption := act.Caption;
  actSpam.ImageIndex := act.ImageIndex;
  actSpam.Hint := act.Hint;
  MailToolBar.AutoSizing := True;
end;



//-------------------------------------------------------------- translation ---

procedure ChangeItem(cmb : TComboBox; item : integer; st : string);
var
  tmp : integer;
begin
  tmp := cmb.ItemIndex;
  cmb.Items[item] := st;
  cmb.ItemIndex := tmp;
end;

function TSpamLearnerMainForm.TranslateDir(st : string; LangDirection : TLangDirection) : string;
begin
  if LangDirection = ToEnglish then
    Result := TranslateToEnglish(st)
  else
    Result := Translate(st);
end;

procedure TSpamLearnerMainForm.TranslateFormDir(form : TForm; LangDirection : TLangDirection);
var
  i,j : integer;
  TransToEnglish : boolean;
begin
  TransToEnglish := LangDirection = ToEnglish;
  for i := 0 to form.ComponentCount-1 do
  begin
    // all captions and hints
    SetProp(form.Components[i],'Caption',TransToEnglish);
    SetProp(form.Components[i],'Hint',TransToEnglish);
    // list view headers
    if form.Components[i] is TListView then
    begin
      for j := 0 to (form.Components[i] as TListView).Columns.Count-1 do
        SetProp((form.Components[i] as TListView).Column[j],'Caption',TransToEnglish)
    end;
  end;
  if form = Self then
  begin
    // rule accounts
    ChangeItem(cmbRuleAccount,0,TranslateDir(cmbRuleAccount.Items[0],LangDirection));
    // rule areas
    for i := 0 to cmbRuleArea.Items.Count-1 do
      ChangeItem(cmbRuleArea,i,TranslateDir(cmbRuleArea.Items[i],LangDirection));
    // rule compares
    for i := 0 to cmbRuleComp.Items.Count-1 do
      ChangeItem(cmbRuleComp,i,TranslateDir(cmbRuleComp.Items[i],LangDirection));
    // languages
    for i := 0 to Length(Options.Languages)-1 do
      Options.Languages[i] := TranslateDir(Options.Languages[i],LangDirection);
    // options treeview
    for i := 0 to tvOptions.Items.Count-1 do
      tvOptions.Items[i].Text := TranslateDir(tvOptions.Items[i].Text,LangDirection);
    tvOptions.Refresh;
    // active frame
    if Assigned(frame) then
    begin
      TranslateFrameDir(frame,LangDirection);
      if (frame is TframeDefaults) then
        (frame as TframeDefaults).ShowLanguages;
    end;
    // popup menus
    for i := 0 to dm.mnuMail.Items.Count-1 do
      dm.mnuMail.Items[i].Caption := TranslateDir(dm.mnuMail.Items[i].Caption,LangDirection);
    for i := 0 to dm.mnuTray.Items.Count-1 do
      dm.mnuTray.Items[i].Caption := TranslateDir(dm.mnuTray.Items[i].Caption,LangDirection);
    for i := 0 to dm.mnuColumns.Items.Count-1 do
    begin
      dm.mnuColumns.Items[i].Caption := TranslateDir(dm.mnuColumns.Items[i].Caption,LangDirection);
      if dm.mnuColumns.Items[i].Count > 0 then
      for j := 0 to dm.mnuColumns.Items[i].Count-1 do
        dm.mnuColumns.Items[i].Items[j].Caption := TranslateDir(dm.mnuColumns.Items[i].Items[j].Caption,LangDirection);
    end;
    // rules re-align
    AutoSizeAllCheckBox(gbRule);
    AutoSizeAllCheckBox(gbActions);
    edRuleWav.Left := chkRuleWav.Left + chkRuleWav.Width + 4;
    edRuleWav.Width := btnEdRuleWav.Left - edRuleWav.Left - 2;
    edRuleEXE.Left := chkRuleEXE.Left + chkRuleEXE.Width + 4;
    edRuleEXE.Width := btnEdRuleEXE.Left - edRuleEXE.Left - 2;
  end;
end;

procedure TSpamLearnerMainForm.TranslateFrameDir(frame : TFrame; LangDirection : TLangDirection);
var
  i,j : integer;
  TransToEnglish : boolean;
begin
  TransToEnglish := LangDirection = ToEnglish;
  for i := 0 to frame.ComponentCount-1 do
  begin
    // all captions and hints
    SetProp(frame.Components[i],'Caption',TransToEnglish);
    SetProp(frame.Components[i],'Hint',TransToEnglish);
    // list view headers
    if frame.Components[i] is TListView then
    begin
      for j := 0 to (frame.Components[i] as TListView).Columns.Count-1 do
        SetProp((frame.Components[i] as TListView).Column[j],'Caption',TransToEnglish)
    end;
  end;
end;

procedure TSpamLearnerMainForm.ReadTranslateStrings;
var
  fname : string;
  i : integer;
begin
  if Options.Language <> 0 then
  begin
    if not assigned(FTranslateStrings) then
      FTranslateStrings := TStringList.Create;
    fname := ExtractFilePath(Application.ExeName)+'languages\'+
             TranslateToEnglish(Options.Languages[Options.Language])+'.ptlang';
    if FileExists(fname) then
    begin
      FTranslateStrings.LoadFromFile(fname);
      // strip comments
      i := 0;
      while i <= FTranslateStrings.Count-1 do
      begin
        if (Copy(Trim(FTranslateStrings[i]),1,1)='#') or (Pos('=',FTranslateStrings[i]) = 0) then
          FTranslateStrings.Delete(i)
        else
          Inc(i);
      end;
    end;
  end;
  FLastLanguage := Options.Language;
end;

procedure TSpamLearnerMainForm.SetProp(obj: TObject; PropName: string; ToEnglish : boolean=False);
var
  pi,pi2 : PPropInfo;
  cap,newcap : string;
  tag1 : longint;
begin
  pi := GetPropInfo(obj.ClassInfo,PropName);
  if Assigned(pi) then
  begin
    pi2 := GetPropInfo(obj.ClassInfo,'Tag');
    tag1 := 0;
    if Assigned(pi2) then
     tag1 := GetOrdProp(obj,'Tag');
    if (tag1 = 999) then
       // ignore where tag=999
    else begin
      cap := GetStrProp(obj,PropName);
      if ToEnglish then
        newcap := TranslatetoEnglish(cap)
      else
        newcap := Translate(cap);
      if newcap <> '' then
        SetStrProp(obj,PropName,newcap);
    end;
  end;
end;

procedure TSpamLearnerMainForm.GetLanguages;
var
  sr : TSearchRec;
  res,i : integer;
  fname,old : string;
begin
  // save selected language
  if Options.Language < Length(Options.Languages) then
    old := TranslateToEnglish(Options.Languages[Options.Language]);
  SetLength(Options.Languages,1);
  Options.Languages[0] := 'English';
  // get ptlang files from SpamLearner directory
  res := FindFirst(ExtractFilePath(Application.ExeName)+'languages\*.ptlang',faAnyFile,sr);
  while res = 0 do
  begin
    fname := ChangeFileExt(sr.Name,'');
    if (lowercase(fname) <> 'blank') and (lowercase(fname) <> 'language') then
    begin
      SetLength(Options.Languages,Length(Options.Languages)+1);
      Options.Languages[Length(Options.Languages)-1] := fname;
    end;
    res := FindNext(sr);
  end;
  FindClose(sr);
  // reset to selected language
  for i := 0 to Length(Options.Languages)-1 do
    if Options.Languages[i] = old then
      Options.Language := i;
end;

//----------------------------------------------------------------- plug-ins ---

procedure TSpamLearnerMainForm.SetProtocol(num: integer);
var
  i,found : integer;
begin
  found := 0;
  for i := Low(Protocols) to High(Protocols) do
  begin
    if Protocols[i].Name = Accounts[num-1].Protocol then
    begin
      found := i;
      Break;
    end;
  end;
  Accounts[num-1].Prot := Protocols[found].Prot;
  Accounts[num-1].Prot.SetOnWork(OnProtWork);
end;

procedure TSpamLearnerMainForm.NotifyPluginExecute(MailCount,UnviewedCount,NewCount : integer; ResetTray : boolean);
var
  i : integer;
begin
  for i := Low(Plugins) to High(Plugins) do
  begin
    if Plugins[i].Enabled then
    begin
      if (Plugins[i] is TPluginNotify) then
        (Plugins[i] as TPluginNotify).Notify(MailCount,UnviewedCount,NewCount,ResetTray);
    end;
  end;
end;

procedure TSpamLearnerMainForm.NotifyPluginMessage(MsgFrom, MsgTo, MsgSubject: string;
                                          MsgDate : TDateTime;
                                          Viewed, New, Important, Spam: boolean);
var
  i : integer;
begin
  for i := Low(Plugins) to High(Plugins) do
  begin
    if Plugins[i].Enabled then
    begin
      if (Plugins[i] is TPluginNotify) then
        (Plugins[i] as TPluginNotify).MessageCheck(PChar(MsgFrom), PChar(MsgTo),
                                                   PChar(MsgSubject), MsgDate,
                                                   Viewed, New, Important, Spam);
    end;
  end;
end;

procedure TSpamLearnerMainForm.NotifyPluginMsgBody(MsgHeader, MsgBody: string);
var
  i : integer;
begin
  for i := Low(Plugins) to High(Plugins) do
  begin
    if Plugins[i].Enabled then
    begin
      if (Plugins[i] is TPluginNotify) then
        (Plugins[i] as TPluginNotify).MessageBody(PChar(MsgHeader), PChar(MsgBody));
    end;
  end;
end;


//----------------------------------------------------------- private events ---

procedure TSpamLearnerMainForm.OnAccountTimer(Sender: TObject);
begin
  if AllowAutoCheck then
  begin
    FQueue.Push(Pointer((Sender as TTimer).Tag));
    if (FQueue.Count >= 1) and not FBusy then RunQueue;
  end;
end;

procedure TSpamLearnerMainForm.OnFirstWait(Sender: TObject);
begin
  FFirstWaitTimer.Enabled := False;
  if AllowAutoCheck then
    CheckAllMail;
end;

procedure TSpamLearnerMainForm.OnHint(Sender: TObject);
begin
  if Assigned(FHintWindow) then
  begin
    FHintWindow.ReleaseHandle;
  end;
end;

procedure TSpamLearnerMainForm.OnProtWork(const AWorkCount: Integer);
begin
  if FPreview and not(FMinimized) and Assigned(frmPreview) then
  begin
    frmPreview.Progress.StepBy(AWorkCount-FMsgRead);
    FMsgRead := AWorkCount;
    Application.ProcessMessages;
    if frmPreview.FStop then
    begin
      Accounts[frmPreview.FAccountNum-1].Prot.SetOnWork(nil);
      Accounts[frmPreview.FAccountNum-1].Prot.Disconnect; //**
      Abort;
    end;
  end;
end;

procedure TSpamLearnerMainForm.OnProcessWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
begin
  OnProtWork(AWorkCount);
end;

procedure TSpamLearnerMainForm.OnCloseFree(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
  FInfoForm := nil;
end;

procedure TSpamLearnerMainForm.OnClickClose(Sender: TObject);
begin
  ((Sender as TControl).Parent as TForm).Close;
end;

//------------------------------------------------------------------------------
// Events
//------------------------------------------------------------------------------

procedure TSpamLearnerMainForm.FormCreate(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
// Init  -----------------------------------------------------------------------
//------------------------------------------------------------------------------

procedure LoadAccountDATA(num: integer);
var P: TUnknownMsg;
    F: file of Info;
    Q: Info;
begin
  if not FileExists(ExtractFilePath(Application.ExeName)+'Accounts\'+Accounts[num-1].Name+'.dat') then
   Exit;
  try
    AssignFile(F, ExtractFilePath(Application.ExeName)+'Accounts\'+Accounts[num-1].Name+'.dat');
    Reset(F);
    while not EOF(F) do
    begin
      Read(F, Q);
      P := New(TUnknownMsg);
      P^.Account := Q;
      P^.Next := Accounts[num-1].UnknownMessages;
      Accounts[num-1].UnknownMessages := P;
    end;
    CloseFile(F);
  except
  end;
end;

var
  num,param : integer;
  FIniFile: TRegIniFile;
begin
  btnSpamClick(Self);

  NewEmails := TStringList.Create;
  NewEmails.Clear;

  { Check for registration }
  FIniFile := TRegIniFile.Create('');
  FINIFile.RootKey := HKEY_CURRENT_USER;
  FINIFile.OpenKey('Software\SpamLearner',True);
  UserName := FIniFile.ReadString('Registration', 'User', '');
  RegKey := FIniFile.ReadString('Registration', 'Key', '');
  FIniFile.Free;
  IsRegistered := ValidRegistration(UserName, RegKey);
  if not IsRegistered then
   begin
     Check_It;
     if DaysLeft < 0 then
      begin
          Application.MessageBox('Evaluation Period Expired!'+#13#10#13#10+
            'Your evaluation period has expired. Please register if you would like'+#13#10+
            'to continue using this software.','SpamLearner',MB_OK+MB_ICONWARNING);
          with TRegForm.Create(Self) do
          try
           ShowModal;
          finally
           Free;
          end;
          if not IsRegistered then
            PostMessage(Application.Handle, WM_QUIT, 0, 0);
      end
      else
      with TRegForm.Create(Self) do
      try
       ShowModal;
      finally
       Free;
      end;
   end;

  // init vars
  FNumRules := 0;
  FNotified := False;
  FShownRules := False;
  FShutDown := False;
  FBusy := False;
  FDoubleClicked := False;
  FDeleting := False;
  FShowingInfo := False;
  FStop := False;
  FSortColumn := -1;
  FSortDirection := sdAsc;
  FSortColumn2 := -1;
  FSortDirection2 := sdAsc;
  FLastCheck := '';
  FAccountWithMail := -1;
  FLastLanguage := 0;
  FNewAccount := False;
  Application.OnHint := OnHint;
  frmPassword := nil;
  ShortTimeFormat := 'HH:mm';
  TimeSeparator := ':';
  // active pages
  tabMail.TabIndex := 0;
  tabAccounts.TabIndex := 0;
  PageControl.ActivePageIndex := 0;
  tvOptions.Selected := nil;
  tvOptions.FullExpand;
  lblOptionTitle.Font.Style := [fsBold];
  // create objects
  Accounts := TAccountItems.Create;
  Rules := TRuleItems.Create;
  MsgHeader := TIdMessage.Create(nil);
  MsgHeader.NoDecode := True;
  FQueue := TUniqueQueue.Create;
  // accept files to drop on me
  DragAcceptFiles(Self.Handle, True);
  // if Win2000+ then set Hint Separator to CRLF
  if (Win32Platform = VER_PLATFORM_WIN32_NT) and (Win32MajorVersion >= 5) then
    HintSep := #13#10;
  // get path from commandline
  if (ParamNonSwitch(1) <> '') then
    IniPath := ParamNonSwitch(1)
  else
    IniPath := ExtractFilePath(Application.ExeName);
  if Copy(IniPath,Length(IniPath),1) <> '\' then
    IniPath := IniPath + '\';
  // help file
  HelpFileName := ExtractFilePath(Application.ExeName)+'SpamLearner.chm';
  // POP3 protocol
  SetLength(Protocols,1);
  Protocols[0].Name := 'POP3';
  Protocols[0].Port := 110;
  Protocols[0].Prot := TPluginPOP3.Create;

  // ini files
  IniName := IniPath+'SpamLearner.ini';
  RuleName := IniPath+'Rules.ini';
  LogRuleName := IniPath+'Rules.log';
  ToolbarName := IniPath+'SpamLearner.customize';

  if FileExists(ToolbarName) then
  begin
    ActionManager.LoadFromFile(ToolbarName);
    ActionManager.FileName := '';
  end;
  SetSpamAction(actDeleteSpam);
  // get options
  LoadOptionsINI;
  // white / black list
  if FileExists(IniPath+'WhiteList.dat') then
    Options.WhiteList.LoadFromFile(IniPath+'WhiteList.dat');
  if FileExists(IniPath+'BlackList.dat') then
    Options.BlackList.LoadFromFile(IniPath+'BlackList.dat');

  if Options.OnTop then
    Self.FormStyle := fsStayOnTop;
  Application.ProcessMessages;

  // if WinXP+ then remove themes on vertical tabs
  if IsWinXP then
  begin
    InitThemeLibrary;
    SetWindowTheme(PageControl.Handle,' ',' ');
  end;
  // register hot-keys
  RegisterTheHotKeys;
  // translate
  TranslateForm(self);

{  // version info
  lblVersion.Caption := Translate('version')+' '+MajorVersion+'.'+MinorVersion;
  if ReleaseVersion <> '0' then
    lblVersion.Caption := lblVersion.Caption + '.' + ReleaseVersion;
  if BetaVersion <> '0' then
  begin
    if Copy(BetaVersion,1,2) = '0.' then
      lblVersion.Caption := lblVersion.Caption + ' (pre-beta ' + BetaVersion +')'
    else
      lblVersion.Caption := lblVersion.Caption + ' (beta ' + BetaVersion +')'
  end;
  if ReleaseCandidate <> '' then
    lblVersion.Caption := lblVersion.Caption + '  ' + ReleaseCandidate;
  Self.Caption := 'SpamLearner - '+lblVersion.Caption;}
  // disables
  btnSaveOptions.Enabled := False;
  btnCancel.Enabled := False;
  // anchors on large fonts (delphi bug?)
  if Self.PixelsPerInch <> 96 then
  begin
    btnSaveOptions.Left := panOptionButtonsRight.Width - btnCancel.Width - btnSaveOptions.Width - 20;
    btnCancel.Left := panOptionButtonsRight.Width - btnCancel.Width - 10;
    btnSaveRules.Left := panRulesButtonsRight.Width - btnCancelRule.Width - btnSaveRules.Width - 20;
    btnCancelRule.Left := panRulesButtonsRight.Width - btnCancelRule.Width - 10;
  end;
  // get accounts
  for num := 1 to NumAccounts do
  begin
    Accounts.Add;
    LoadAccountINI(num);
    LoadAccountDATA(num);
    tabMail.Tabs.Add(Accounts[num-1].Name);
    tabAccounts.Tabs.Add(Accounts[num-1].Name);
    if Accounts[num-1].Enabled then
      dm.AddBitmap(dm.imlTabs, dm.imlPopTrueColor,popClosed)
    else
      dm.AddBitmap(dm.imlTabs, dm.imlPopTrueColor,popDisabled);
  end;
  if NumAccounts > 0 then
    EnableFields(True);
  // add accounts to rules drop-down
  FillRuleAccounts;
  // position
  LoadPosINI;
  MailToolBar.Height := 0;
  // rules
  LoadRulesINI;
  // autorespond
  LoadAutorespondSettings;
  // show first account in editboxes
  if NumAccounts > 0 then ShowAccount(1);
  // startup options
  FMinimized := Options.Minimized;
  if FMinimized then HideForm;
  if Options.Minimized and not Options.MinimizeTray then
    Self.WindowState := wsMinimized;
  Application.ShowMainForm := not Options.Minimized;
  if Options.PasswordProtect and not Options.Minimized then
  begin
    Application.ShowMainForm := False;
    FMinimized := True;
    ShowForm;
  end;
  if Options.StartUp and not Application.Terminated then
  begin
    if Options.FirstWait > 0 then
    begin
      FFirstWaitTimer := TTimer.Create(self);
      FFirstWaitTimer.Interval := Options.FirstWait*1000;
      FFirstWaitTimer.OnTimer := OnFirstWait;
      FFirstWaitTimer.Enabled := True;
    end
    else
      if AllowAutoCheck then
        CheckAllMail;
  end;
  SwitchTimer;
  // comand-line actions
  param := ParamSwitchIndex('ACTION');
  if param > 0 then
  begin
    if Application.ShowMainForm then ShowForm;
    Application.ProcessMessages;
    repeat
      DoCommand(StrToAction(ParamSwitchValue(param)));
      param := ParamSwitchIndex('ACTION',param);
    until param = 0;
  end;
  // swap out memory
  SwapOutMemory;
end;

procedure TSpamLearnerMainForm.FormDestroy(Sender: TObject);
var
  num : integer;
begin
  NewEmails.Free;

  // free stuff
  //FreeAndNil(ActionManager);  // to prevent AV on destroy
  //FreeAndNil(MsgHeader);
  FQueue.Free;
  for num := 1 to NumAccounts do
  begin
    Accounts[num-1].ViewedMsgIDs.Free;
    Accounts[num-1].Mail.Free;
  end;
  Accounts.Free;
  Rules.Free;
  //for i := Low(Plugins) to High(Plugins) do   // causes AV
  //  Plugins[i].Free;

  // unregister drag n drop
  DragAcceptFiles(Self.Handle, False);
  // unregister hotkeys
  UnRegisterTheHotKeys;
end;

procedure TSpamLearnerMainForm.lblHomepageMouseEnter(Sender: TObject);
begin
  (Sender as TLabel).Font.Style := [fsUnderline];
end;

procedure TSpamLearnerMainForm.lblHomepageMouseLeave(Sender: TObject);
begin
  (Sender as TLabel).Font.Style := [];
end;

procedure TSpamLearnerMainForm.lblHomepageClick(Sender: TObject);
begin
  ExecuteFile('http://www.homepage.com','','',SW_RESTORE);
end;

procedure TSpamLearnerMainForm.btnSaveOptionsClick(Sender: TObject);
begin
  SaveOptionsINI;
  GetBitmapFromFileIcon(Options.MailProgram,btnStartProgram.Glyph,True);
  dm.imlActions.ReplaceMasked(actStartProgram.ImageIndex,btnStartProgram.Glyph,clBtnFace);
  dm.Timer.Interval := Options.Interval * 60000;
end;

procedure TSpamLearnerMainForm.btnCancelClick(Sender: TObject);
begin
  LoadOptionsINI;
end;

procedure TSpamLearnerMainForm.tabMailChange(Sender: TObject);
begin
  ShowMail(tabMail.TabIndex+1);
end;

procedure TSpamLearnerMainForm.btnSaveClick(Sender: TObject);
begin
  SaveAccountNum(tabAccounts.TabIndex+1);
  SaveAccountINI(tabAccounts.TabIndex+1);
  FillRuleAccounts;
  ShowIcon(tabMail.TabIndex+1,itNormal);
  ShowIcon(tabAccounts.TabIndex+1,itNormal);
  FAccChanged := False;
  btnSave.Enabled := False;
  btnCancelAccount.Enabled := False;
end;

procedure TSpamLearnerMainForm.lvMailDblClick(Sender: TObject);
begin
  actPreview.Execute;
end;

procedure TSpamLearnerMainForm.OptionsChange(Sender: TObject);
begin
  btnSaveOptions.Enabled := True;
  btnCancel.Enabled := True;
end;

procedure TSpamLearnerMainForm.lvMailColumnClick(Sender: TObject; Column: TListColumn);
begin
  // direction
  if FSortColumn = Column.Index then
    FSortDirection := sdDesc * FSortDirection
  else
    FSortDirection := sdAsc;
  // column
  SetSortColumn(Column.Index);
end;

procedure TSpamLearnerMainForm.lvMailCompare(Sender: TObject; Item1, Item2: TListItem;
  Data: Integer; var Compare: Integer);
begin
  case FSortColumn of
    -2 : Compare := CompareInt(IntToStr(Item1.ImageIndex),IntToStr(Item2.ImageIndex));  //status
    -1 : Compare := CompareInt(Item1.SubItems[4],Item2.SubItems[4]);                    //no sort
    0  : Compare := CompareText(Item1.Caption,Item2.Caption);                           //from
    2  : Compare := CompareText(StripSubjectPrefix(Item1.SubItems[1]),
                                StripSubjectPrefix(Item2.SubItems[1]));                 //subject
    3  : Compare := CompareDate(Item1.SubItems[2],Item2.SubItems[2]);                   //date
    4  : Compare := CompareInt(Item1.SubItems[3],Item2.SubItems[3]);                    //size
  else
   Compare := CompareText(Item1.SubItems[FSortColumn - 1],
                          Item2.SubItems[FSortColumn - 1]);
  end;
  Compare := FSortDirection * Compare;
end;

procedure TSpamLearnerMainForm.chkRuleWavClick(Sender: TObject);
begin
  edRuleWav.Text := '';
  edRuleWav.Visible := chkRuleWav.Checked;
  btnEdRuleWav.Visible := chkRuleWav.Checked;
  btnRuleSoundTest.Visible := chkRuleWav.Checked;
end;

procedure TSpamLearnerMainForm.edRuleNameChange(Sender: TObject);
begin
  EnableRuleButtons;
  if lstRules.ItemIndex > -1 then
  begin
    Rules[lstRules.ItemIndex].Name := edRuleName.Text;
    if edRuleName.Tag = 0 then // bug in WinNT
      lstRules.Items[lstRules.ItemIndex] := edRuleName.Text;
  end;

end;

procedure TSpamLearnerMainForm.lstRulesClick(Sender: TObject);
begin
  if GetKeyState(VK_LBUTTON) < 0 then
    ShowRule(lstRules.ItemIndex);
end;

procedure TSpamLearnerMainForm.chkRuleEnabledClick(Sender: TObject);
begin
  EnableRuleButtons;
  if lstRules.ItemIndex > -1 then
  begin
    Rules[lstRules.ItemIndex].Enabled := chkRuleEnabled.Checked;
    lstRules.Checked[lstRules.ItemIndex] := chkRuleEnabled.Checked;
  end;
end;

procedure TSpamLearnerMainForm.cmbRuleAreaChange(Sender: TObject);
begin
  EnableRuleButtons;
  if lstRules.ItemIndex > -1 then
    Rules[lstRules.ItemIndex].Area := TRuleArea(cmbRuleArea.ItemIndex);
end;

procedure TSpamLearnerMainForm.cmbRuleCompChange(Sender: TObject);
begin
  EnableRuleButtons;
  if (lstRules.ItemIndex > -1) and (cmbRuleComp.ItemIndex > -1) then
    Rules[lstRules.ItemIndex].Compare := TRuleCompare(cmbRuleComp.ItemIndex);
  // show text box?
  if (cmbRuleComp.ItemIndex > -1) and (TRuleCompare(cmbRuleComp.ItemIndex) = rcEmpty) then
  begin
    edRuleText.Text := '';
    edRuleText.Enabled := False;
    edRuleText.Color := clBtnFace;
  end
  else begin
    edRuleText.Enabled := True;
    edRuleText.Color := clWindow;
  end;
end;

procedure TSpamLearnerMainForm.cmbRuleAccountChange(Sender: TObject);
begin
  EnableRuleButtons;
  if lstRules.ItemIndex > -1 then
    Rules[lstRules.ItemIndex].Account := cmbRuleAccount.ItemIndex;
end;

procedure TSpamLearnerMainForm.chkRuleNewClick(Sender: TObject);
begin
  EnableRuleButtons;
  if lstRules.ItemIndex > -1 then
    Rules[lstRules.ItemIndex].New := chkRuleNew.Checked;
end;

procedure TSpamLearnerMainForm.edRuleTextChange(Sender: TObject);
begin
  EnableRuleButtons;
  if lstRules.ItemIndex > -1 then
    Rules[lstRules.ItemIndex].Text := edRuleText.Text;
end;

procedure TSpamLearnerMainForm.edRuleWavChange(Sender: TObject);
begin
  EnableRuleButtons;
  if lstRules.ItemIndex > -1 then
    Rules[lstRules.ItemIndex].Wav := edRulewav.Text;
end;

procedure TSpamLearnerMainForm.chkRuleDeleteClick(Sender: TObject);
begin
  EnableRuleButtons;
  if lstRules.ItemIndex > -1 then
    Rules[lstRules.ItemIndex].Delete := chkRuleDelete.Checked;
end;

procedure TSpamLearnerMainForm.chkRuleIgnoreClick(Sender: TObject);
begin
  EnableRuleButtons;
  if lstRules.ItemIndex > -1 then
    Rules[lstRules.ItemIndex].Ignore := chkRuleIgnore.Checked;
end;

procedure TSpamLearnerMainForm.chkRuleImportantClick(Sender: TObject);
begin
  EnableRuleButtons;
  if lstRules.ItemIndex > -1 then
    Rules[lstRules.ItemIndex].Important := chkRuleImportant.Checked;
end;

procedure TSpamLearnerMainForm.chkRuleLogClick(Sender: TObject);
begin
  EnableRuleButtons;
  if lstRules.ItemIndex > -1 then
    Rules[lstRules.ItemIndex].Log := chkRuleLog.Checked;
end;

procedure TSpamLearnerMainForm.edRuleEXEChange(Sender: TObject);
begin
  EnableRuleButtons;
  if lstRules.ItemIndex > -1 then
    Rules[lstRules.ItemIndex].EXE := edRuleEXE.Text;
end;

procedure TSpamLearnerMainForm.chkRuleEXEClick(Sender: TObject);
begin
  edRuleEXE.Text := '';
  edRuleEXE.Visible := chkRuleEXE.Checked;
  btnEdRuleEXE.Visible := chkRuleEXE.Checked;
end;

procedure TSpamLearnerMainForm.btnEdRuleEXEClick(Sender: TObject);
var
  dlgOpen : TOpenDialog;
begin
  dlgOpen := TOpenDialog.Create(nil);
  try
    dlgOpen.InitialDir := ExtractFileDir(edRuleEXE.Text);
    dlgOpen.Filter := Translate('EXE files')+' (*.exe)|*.exe|'+
                      Translate('All Files')+' (*.*)|*.*';
    if dlgOpen.Execute then
    begin
      edRuleEXE.Text := dlgOpen.FileName;
    end;
  finally
    dlgOpen.Free;
  end;
end;

procedure TSpamLearnerMainForm.btnSaveRulesClick(Sender: TObject);
begin
  SaveRulesINI;
end;

procedure TSpamLearnerMainForm.btnCancelRuleClick(Sender: TObject);
begin
  LoadRulesINI;
  lstRules.ItemIndex := -1;
  panRuleDetail.Visible := False;
  btnCancelRule.Enabled := False;
  btnSaveRules.Enabled := False;
end;

procedure TSpamLearnerMainForm.tabAccountsChange(Sender: TObject);
begin
  ShowAccount(tabAccounts.TabIndex+1);
  actDeleteAccount.Enabled := True;
end;

procedure TSpamLearnerMainForm.edAccChange(Sender: TObject);
begin
  FAccChanged := AccountChanged(tabAccounts.TabIndex) or FNewAccount;
  btnSave.Enabled := FAccChanged;
  btnCancelAccount.Enabled := FAccChanged;
end;

procedure TSpamLearnerMainForm.tabAccountsChanging(Sender: TObject; var AllowChange: Boolean);
begin
  if FAccChanged then
  begin
    case TranslateDlg(Translate('Account Info changed.'+#13+#10+
                    'Do you want to save it?'), mtConfirmation,
                    [mbYes, mbNo, mbCancel], 0) of
      mrYes    : begin
                   btnSave.Click;
                   AllowChange := True;
                 end;
      mrNo     : begin
                   if FNewAccount then
                   begin
                     Accounts.Delete(tabAccounts.TabIndex);
                     Dec(NumAccounts);
                     tabMail.Tabs.Delete(tabAccounts.TabIndex);
                     tabAccounts.Tabs.Delete(tabAccounts.TabIndex);
                     FNewAccount := False;
                   end;
                   AllowChange := True;
                 end;
      mrCancel : AllowChange := False;
    end;
  end;
end;

procedure TSpamLearnerMainForm.lblEMailClick(Sender: TObject);
begin
  SendMail('email@email.com','','');
end;

procedure TSpamLearnerMainForm.lvMailSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);
begin
  if lvMail.Selected = nil then
  begin
    actMarkViewed.Enabled := False;
    actPreview.Enabled := False;
    actDelete.Enabled := False;
    actReply.Enabled := False;
    actRuleFrom.Enabled := False;
    actRuleToMarkSpam.Enabled := False;
    actAddWhiteList.Enabled := False;
    actAddBlackList.Enabled := False;
    actMarkSpam.Enabled := False;
    actUnmarkSpam.Enabled := False;
    actHideViewed.Enabled := False;
    actTrainSpamFilter.Enabled := False;
  end
  else begin
    actMarkViewed.Enabled := True;
    actPreview.Enabled := (lvMail.SelCount=1);
    actDelete.Enabled := True;
    actReply.Enabled := True;
    actRuleFrom.Enabled := True;
    actRuleToMarkSpam.Enabled := True;
    actAddWhiteList.Enabled := True;
    actAddBlackList.Enabled := True;
    actMarkSpam.Enabled := True;
    actUnmarkSpam.Enabled := True;
    actHideViewed.Enabled := True;
    actTrainSpamFilter.Enabled := True;
  end;
  actSpam.Enabled := actDeleteSpam.Enabled or actMarkSpam.Enabled or actUnmarkSpam.Enabled;
end;

procedure TSpamLearnerMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var Ini: TINIFile;
begin
  if (Options.CloseMinimize) and not FShutDown then
  begin
    HideForm;
    CanClose := False;
  end;
end;

procedure TSpamLearnerMainForm.FormKeyPress(Sender: TObject; var Key: Char);
var
  num : integer;
  SomethingConnected : boolean;
begin
  if Key = Char(VK_ESCAPE) then
  begin
    SomethingConnected := False;
    for num := 1 to NumAccounts do
    begin
      if Accounts[num-1].Prot.Connected then
      begin
        SomethingConnected := True;
        Accounts[num-1].Prot.Disconnect;
      end;
    end;
    if not SomethingConnected then
      HideForm;
    FStop := True;
    FBusy := False;
    FDeleting := False;
  end;
end;

procedure TSpamLearnerMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  SavePosINI;
  SaveViewedMessageIDs;
end;

procedure TSpamLearnerMainForm.NoSort1Click(Sender: TObject);
begin
  SetSortColumn(-1);
end;

procedure TSpamLearnerMainForm.PageControlChange(Sender: TObject);
begin
  // mail page
  if (PageControl.ActivePageIndex = 0) then
  begin
    MarkViewed;
  end
  else
  if (PageControl.ActivePageIndex = 4) then
  begin
  // free any frames created
  if Assigned(frame) then FreeAndNil(frame);
  // create the selected frame
  frame := TframeWhiteBlack.Create(Self);
  // show frame
  if Assigned(frame) then
  begin
    frame.Parent := Panel1;
    frame.Align := alClient;
  end;
  FListsChanged := False;
  btnSaveLists.Enabled := False;
  btnCancelLists.Enabled := False;
  end;
  // if accounts page
  if (PageControl.ActivePageIndex = 1) and (NumAccounts>0) then
  begin
    tabAccounts.TabIndex := tabMail.TabIndex;
    tabAccounts.OnChange(nil);
  end;
end;

procedure TSpamLearnerMainForm.chkTimerAccountClick(Sender: TObject);
begin
  SwitchTimer;
  panIntervalAccount.Visible := Options.TimerAccount;
  btnSaveOptions.Enabled := True;
  btnCancel.Enabled := True;
end;

procedure TSpamLearnerMainForm.btnNeverAccountClick(Sender: TObject);
begin
  UpDownAccount.Position := 0;
end;

procedure TSpamLearnerMainForm.lblCheckUpdateClick(Sender: TObject);
begin
  ExecuteFile('http://www.homepage.com/checkupdate.php?major='+
              MajorVersion+'&minor='+MinorVersion+'&release='+ReleaseVersion+
              '&beta='+BetaVersion,'','',SW_RESTORE);
end;

procedure TSpamLearnerMainForm.FormKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  // help
  if Key = VK_F1 then
  begin
    if ssShift in Shift then
    begin
      case PageControl.ActivePageIndex of
        0 : HtmlHelp(0, HelpFileName+'::/mail.htm', HH_DISPLAY_TOPIC, 0);
        1 : HtmlHelp(0, HelpFileName+'::/accounts.htm', HH_DISPLAY_TOPIC, 0);
        2 : HtmlHelp(0, HelpFileName+'::/options.htm', HH_DISPLAY_TOPIC, 0);
        3 : HtmlHelp(0, HelpFileName+'::/rules.htm', HH_DISPLAY_TOPIC, 0);
        4 : HtmlHelp(0, HelpFileName+'::/contact.htm', HH_DISPLAY_TOPIC, 0);
      else
        HtmlHelp(0, HelpFileName, HH_DISPLAY_TOC, 0);
      end;
    end
    else
      HtmlHelp(0, HelpFileName, HH_DISPLAY_TOC, 0);
  end;
  // select all
  if (Key = Ord('A')) and (ssCtrl in Shift) and
     (PageControl.ActivePageIndex = 0) then
  begin
    lvMail.SelectAll;
    lvMail.SetFocus;
  end;
  // ctrl-F6 switch account tabs
  if (Key = VK_F6) and (ssCtrl in Shift) and
     (PageControl.ActivePageIndex <= 1) then
  begin
    if (ssShift in Shift) then
    begin
      // ctrl-shift-F6
      if tabMail.TabIndex > 0 then
        tabMail.TabIndex := tabMail.TabIndex - 1
      else
        tabMail.TabIndex := tabMail.Tabs.Count-1;
    end
    else begin
      // ctrl-F6
      if tabMail.TabIndex < tabMail.Tabs.Count-1 then
        tabMail.TabIndex := tabMail.TabIndex + 1
      else
        tabMail.TabIndex := 0;
    end;
    tabAccounts.TabIndex := tabMail.TabIndex;
    // sync info (event doesn't fire automatically?)
    tabMail.OnChange(nil);
    tabAccounts.OnChange(nil);
  end;
  // alt keys
  if (ssAlt in Shift) then
  begin
    if PageControl.ActivePage=tsMail then ExecuteAccelAction(MailToolbar,Key)
    else if PageControl.ActivePage=tsAccounts then ExecuteAccelAction(AccountsToolbar,Key)
    else if PageControl.ActivePage=tsRules then ExecuteAccelAction(RulesToolbar,Key);
  end;
end;

procedure TSpamLearnerMainForm.btnHelpRulesClick(Sender: TObject);
begin
  HtmlHelp(0, HelpFileName+'::/rules.htm', HH_DISPLAY_TOPIC, 0);
end;

procedure TSpamLearnerMainForm.btnHelpAccountsClick(Sender: TObject);
begin
  ShellExecute(Handle, 'open', 'http://www.SpamLearner.com/support', '', '', SW_SHOWNORMAL);
end;

procedure TSpamLearnerMainForm.btnHelpClick(Sender: TObject);
begin
  HtmlHelp(0, HelpFileName, HH_DISPLAY_TOC, 0);
end;

procedure TSpamLearnerMainForm.lvMailInfoTip(Sender: TObject; Item: TListItem; var InfoTip: String);
var
  MailItem : TMailItem;
begin
  InfoTip := '';
  if lvMail.ScreenToClient(Mouse.CursorPos).X  < lvMail.Columns[0].Width then
  if Item.ImageIndex <> 18 then
  begin
    MailItem := SelectedMailItem(Item);
    if MailItem <> nil then
      InfoTip := MailItem.Address;
  end
end;

procedure TSpamLearnerMainForm.btnEdSoundClick(Sender: TObject);
var
  dlgOpen : TOpenDialog;
begin
  dlgOpen := TOpenDialog.Create(nil);
  try
    dlgOpen.InitialDir := ExtractFileDir(edSound.Text);
    if dlgOpen.InitialDir='' then
       dlgOpen.InitialDir := ExtractFilePath(Application.ExeName)+'Sounds';
    dlgOpen.Filter := Translate('WAV files')+' (*.wav)|*.WAV';
    if dlgOpen.Execute then
    begin
      edSound.Text := dlgOpen.FileName;
      edSound.Font.Color := clWindowText;
    end;
  finally
    dlgOpen.Free;
  end;
end;

procedure TSpamLearnerMainForm.btnEdRuleWavClick(Sender: TObject);
var
  dlgOpen : TOpenDialog;
begin
  dlgOpen := TOpenDialog.Create(nil);
  try
    dlgOpen.InitialDir := ExtractFileDir(edRuleWav.Text);
    if dlgOpen.InitialDir='' then
       dlgOpen.InitialDir := ExtractFilePath(Application.ExeName)+'Sounds';
    dlgOpen.Filter := Translate('WAV files')+' (*.wav)|*.WAV';
    if dlgOpen.Execute then
    begin
      edRuleWav.Text := dlgOpen.FileName;
    end;
  finally
    dlgOpen.Free;
  end;
end;

procedure TSpamLearnerMainForm.TrayIconClick(Sender: TObject);
begin
  if Options.DoubleClickDelay then DoMouseCommand(mcClick);
end;

procedure TSpamLearnerMainForm.TrayIconDblClick(Sender: TObject);
begin
  FDoubleClicked := True;
  DoMouseCommand(mcDblClick);
end;

procedure TSpamLearnerMainForm.TrayIconMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  case Button of
    mbLeft   : if not Options.DoubleClickDelay then DoMouseCommand(mcClick);
    mbMiddle : DoMouseCommand(mcMClick);
    mbRight  : DoMouseCommand(mcRClick);
  end;
end;

procedure TSpamLearnerMainForm.StatusBarResize(Sender: TObject);
begin
  StatusBar.Panels[1].Width := 110;
  StatusBar.Panels[2].Width := 50;
  StatusBar.Panels[0].Width := StatusBar.Width - 160;
end;

procedure TSpamLearnerMainForm.lvMailColumnRightClick(Sender: TObject;
  Column: TListColumn; Point: TPoint);
begin
  SetColumnMenuCheckMarks;
  dm.mnuColumns.Popup(lvMail.ClientToScreen(Point).X,lvMail.ClientToScreen(Point).Y);
  // prevent other context-menu popup
  Abort;
end;

procedure TSpamLearnerMainForm.btnAccountSoundTestClick(Sender: TObject);
begin
  if (edSound.Text = Translate(UseDefaultSound)) or (edSound.Text = '') then
    PlayWav(Options.DefSound)
  else
    PlayWav(edSound.Text);
end;

procedure TSpamLearnerMainForm.btnRuleSoundTestClick(Sender: TObject);
begin
  PlayWav(edRuleWav.Text);
end;

procedure TSpamLearnerMainForm.btnStopClick(Sender: TObject);
var
  num : integer;
begin
  // disconnect all connected protocols
  for num := 1 to NumAccounts do
    if Accounts[num-1].Prot.Connected then
      Accounts[num-1].Prot.Disconnect;
  // set flags
  FStop := True;
  FBusy := False;
  FDeleting := False;
end;

procedure TSpamLearnerMainForm.btnCancelAccountClick(Sender: TObject);
begin
  if FNewAccount then
  begin
    Accounts.Delete(tabAccounts.TabIndex);
    Dec(NumAccounts);
    tabMail.Tabs.Delete(tabAccounts.TabIndex);
    tabAccounts.Tabs.Delete(tabAccounts.TabIndex);
    FNewAccount := False;
    tabAccounts.TabIndex := tabAccounts.Tabs.Count-1;
  end
  else begin
    LoadAccountINI(tabAccounts.TabIndex+1);
  end;
  ShowAccount(tabAccounts.TabIndex+1);
  FAccChanged := False;
  // buttons
  if NumAccounts=0 then EnableFields(False);
  btnSave.Enabled := False;
  btnCancelAccount.Enabled := False;
end;

procedure TSpamLearnerMainForm.PageControlChanging(Sender: TObject;
  var AllowChange: Boolean);
begin
  if (PageControl.ActivePage=tsLists) and (FListsChanged) then
   if Application.MessageBox('Lists have been changed. Save?','Lists Changed', MB_YESNO+MB_ICONQUESTION)=mrYes then
    begin
      FListsChanged := False;
      btnSaveListsClick(Self);
      AllowChange := True;
      Exit;
    end
   else
    begin
      FListsChanged := False;
      btnCancelListsClick(Self);
      AllowChange := True;
      Exit;
    end;

  if (PageControl.ActivePage=tsAccounts) and FAccChanged then
  begin
    case TranslateDlg(Translate('Account Info changed.'+#13+#10+
                    'Do you want to save it?'), mtConfirmation,
                    [mbYes, mbNo, mbCancel], 0) of
      mrYes    : begin
                   btnSave.Click;
                   AllowChange := True;
                 end;
      mrNo     : begin
                   if FNewAccount then
                   begin
                     Accounts.Delete(tabAccounts.TabIndex);
                     Dec(NumAccounts);
                     tabMail.Tabs.Delete(tabAccounts.TabIndex);
                     tabAccounts.Tabs.Delete(tabAccounts.TabIndex);
                     FNewAccount := False;
                   end;
                   AllowChange := True;
                 end;
      mrCancel : AllowChange := False;
    end;
  end;
end;

procedure TSpamLearnerMainForm.edSoundEnter(Sender: TObject);
begin
  if edSound.Text = Translate(UseDefaultSound) then
  begin
    edSound.Text := '';
    edSound.Font.Color := clWindowText;
  end;
end;

procedure TSpamLearnerMainForm.edSoundExit(Sender: TObject);
begin
  if edSound.Text = '' then
  begin
    edSound.Text := Translate(UseDefaultSound);
    edSound.Font.Color := clGrayText;
  end;
end;

procedure TSpamLearnerMainForm.btnEdAccountProgramClick(Sender: TObject);
var
  dlgOpen : TOpenDialog;
begin
  dlgOpen := TOpenDialog.Create(nil);
  try
    dlgOpen.InitialDir := ExtractFileDir(edAccountProgram.Text);
    dlgOpen.Filter := Translate('EXE files')+' (*.exe)|*.EXE|' +
                      Translate('All files')+' (*.*)|*.*';
    if dlgOpen.Execute then
    begin
      edAccountProgram.Text := dlgOpen.FileName;
      GetBitmapFromFileIcon(edAccountProgram.Text,btnAccountProgramTest.Glyph,True);
    end;
  finally
    dlgOpen.Free;
  end;
end;

procedure TSpamLearnerMainForm.btnAccountProgramTestClick(Sender: TObject);
begin
  ExecuteProgram(tabAccounts.TabIndex+1);
end;

procedure TSpamLearnerMainForm.edAccountProgramEnter(Sender: TObject);
begin
  if edAccountProgram.Text = Translate(UseDefaultProgram) then
  begin
    edAccountProgram.Text := '';
    edAccountProgram.Font.Color := clWindowText;
  end;
end;

procedure TSpamLearnerMainForm.edAccountProgramExit(Sender: TObject);
begin
  if edAccountProgram.Text = '' then
  begin
    edAccountProgram.Text := Translate(UseDefaultProgram);
    edAccountProgram.Font.Color := clGrayText;
  end;
end;

procedure TSpamLearnerMainForm.btnHintHelpClick(Sender: TObject);
begin
  ShellExecute(Handle, 'open', 'http://www.SpamLearner.com/universalsetup', '', '', SW_SHOWNORMAL);
end;

procedure TSpamLearnerMainForm.actDeleteExecute(Sender: TObject);
var
  msgnums : array of integer;
  i,j : integer;
  SaveTab : integer;
  warning : string;
  confirmed : boolean;

procedure DeleteEMail(num: Integer; Item: TListItem);
var P, Q: TUnknownMsg;
begin
  P := Accounts[num].UnknownMessages;
  if P = nil then Exit;
  if (P^.Account.From = Item.Caption) and (P^.Account.MailTo = Item.SubItems[0]) and
    (P^.Account.Subject = Item.SubItems[1]) {and (P^.Account.Date = StrToDate(Item.SubItems[2]))} and
    (IntToStr(P^.Account.Size)+' '+Translate('KB') = Item.SubItems[3]) and (UpperCase(P^.Account.Path) = UpperCase(Item.SubItems[6])) then
    begin // this is it!!!
      DeleteFile(ExtractFilePath(Application.ExeName)+'Junk\'+Accounts[num].UnknownMessages^.Account.Path);
      Accounts[num].UnknownMessages := Accounts[num].UnknownMessages^.Next;
      Dispose(P);
    end
  else
  if P^.Next <> nil then
  begin
    while (P^.Next <> nil) and (P^.Next^.Account.From <> Item.Caption) and (P^.Next^.Account.MailTo <> Item.SubItems[0]) and
          (P^.Next^.Account.Subject <> Item.SubItems[1]) and {(P^.Next^.Account.Date <> StrToDate(Item.SubItems[2])) and}
          (IntToStr(P^.Next^.Account.Size)+' '+Translate('KB') <> Item.SubItems[3]) and (UpperCase(P^.Account.Path) <> UpperCase(Item.SubItems[6])) do
      P := P^.Next;
    if P^.Next <> nil then  // found it !!!
    begin
      Q := P^.Next;
      DeleteFile(ExtractFilePath(Application.ExeName)+'Junk\'+Q^.Account.Path);
      P^.Next := P^.Next^.Next;
      Dispose(Q);
    end;
  end;
end;

begin
  if lvMail.Selected = nil then
    TranslateDlg(Translate('No message selected.'), mtError, [mbOK], 0)
  else
  begin
    if FDeleting then
    begin
      if not Options.NoError then
        Balloon('SpamLearner',Translate('Still busy deleting other messages.'), bitError, 15);
      Exit;
    end;
    if FBusy then
    begin
      if not Options.NoError then
        Balloon('SpamLearner',Translate('Error:')+' '+Translate('Still Busy Checking'),bitError,15);
      Exit;
    end;
    if Options.SafeDelete and not Accounts[tabMail.TabIndex].UIDLSupported then
      warning := Translate('WARNING: This account does NOT support Safe Delete.')+ #13#10#13#10;
    SaveTab := tabMail.TabIndex+1;
    Accounts[SaveTab-1].Error := False;

    if lvMail.SelCount = 1 then
    begin
      // one selected delete
      confirmed := not(Options.DeleteConfirm) or
                   (TranslateDlg(
                     warning +
                     Translate('Delete Message from the list?')+' '+#13#10#13#10+
                     Translate('From')+': '+lvMail.Selected.Caption+#13#10+
                     Translate('Subject')+': '+lvMail.Selected.SubItems[1],
                     mtConfirmation,[mbYes,mbNo],0) = mrYes);
      if not confirmed then
       lvMail.Selected := nil
      else
      begin
      if lvMail.Selected.ImageIndex = 18 then
      begin
        { This e-mail is ONLY in the LIST }
        try
          DeleteEMail(tabMail.TabIndex, lvMail.Selected);
        except
          Application.MessageBox('Unable to delete e-mail!','Warning', MB_OK+MB_ICONWARNING);
        end;
      end
      else
      begin
        ShowIcon(SaveTab,itDeleting);
        try
          DeleteMail(SaveTab,StrToInt(lvMail.Selected.SubItems[colID]));
        except
          on e : Exception do ErrorMsg(SaveTab,'Delete Error:',e.Message,Options.NoError);
        end;
      end;
      end;
    end
    else begin
      // multi-select delete
      confirmed := not(Options.DeleteConfirm) or
                   (TranslateDlg(
                     warning +
                     Translate('Delete Messages from the list?')+' '+#13#10#13#10+
                     Translate('Number of selected messages:')+' '+IntToStr(lvMail.SelCount)+#13#10+
                     Translate('This will delete all these selected messages.'),
                     mtConfirmation,[mbYes,mbNo],0) = mrYes);
      if not confirmed then
        lvMail.Selected := nil
      else
      begin
        j := 0;
        for i := 0 to lvMail.Items.Count-1 do
         if lvMail.Items[i].ImageIndex <> 18 then
          Inc(J);
        SetLength(msgnums,j);
        j := 0;
        for i := 0 to lvMail.Items.Count-1 do
        begin
          if lvMail.Items[i].Selected then
          begin
          if lvMail.Items[i].ImageIndex = 18 then { In memory??? }
            DeleteEMail(tabMail.TabIndex, lvMail.Items[i])
          else
          begin
            msgnums[j] := StrToInt(lvMail.Items[i].SubItems[colID]);
            Inc(j);
          end;
        end;
        end;
        ShowIcon(SaveTab,itDeleting);
        try
          DeleteMultipleMail(SaveTab,msgnums);
        except
          on e : Exception do ErrorMsg(SaveTab,'Delete Error:',e.Message,Options.NoError);
        end;
      end;
    end;
    // refresh view
{    if confirmed then
    begin
      if not Accounts[SaveTab-1].Error then
        if CheckMail(SaveTab,false) < 0 then
          lvMail.Clear;
      // showmail if tab hasn't changed
      if tabMail.TabIndex+1=SaveTab then
        ShowMail(tabMail.TabIndex+1)
      else
        ShowIcon(SaveTab,itNormal);
    end;}
  end;

  // remove selected
  I := 0;
  while I<=lvMail.Items.Count-1 do
  begin
    if lvMail.Items[I].Selected then
    begin
      lvMail.Items.Delete(I);
      Dec(I);
    end;
    Inc(I);
  end;
end;

procedure TSpamLearnerMainForm.actPreviewExecute(Sender: TObject);
var FPath: String;
    SL: TStringList;
    TmpStream: TMemoryStream;
    num, i: Integer;
    Sel: TListItem;

function Go(Sub: String; SL: TStringList): String;
var I: Integer; S: String;
begin
  Result := '';
  for I:=0 to SL.Count-1 do
  begin
    if Pos(UpperCase(Sub), UpperCase(SL[I]))=1 then
     begin
       S := SL[I];
       Delete(S, 1, Length(Sub)+1);
       Result := S;
       Break;
     end;
  end;
end;

function GoText(SL: TStringList): String;
var S: String; X: TStringList;
begin
  Result := '';
  X := TStringList.Create;
  X.Text := SL.Text;
  try
    while (X.Count > 0) and (X[0] <> '') do
     X.Delete(0);
    X.Delete(0);
  except
  end;
  Result := X.Text;
  X.Free;
end;

begin
  num := tabMail.TabIndex;
  Sel := lvMail.Selected;
  if lvMail.Selected = nil then
    TranslateDlg(Translate('No message selected.'), mtError, [mbOK], 0)
  else
  if lvMail.Selected.ImageIndex = 18 then
  begin
    try
      FPath := lvMail.Selected.SubItems[6];
      if not FileExists(FPath) then
      begin
        Application.MessageBox('Cannot preview this e-mail. It may have been deleted.', 'Preview', MB_OK+MB_ICONINFORMATION);
        Exit;
      end;
      // set this item to viewed
      SetViewed(tabMail.tabIndex, lvMail.Selected);
      // now go on
      frmPreview := TfrmPreview.Create(Application);
      frmPreview.IniName := IniName;
      frmPreview.GetINI;
      frmPreview.actDelete.Enabled := True;
      frmPreview.actDelete.Hint := Translate('Delete this message from the list');
      frmPreview.panProgress.Visible := False;
      SL := TStringList.Create;
      SL.LoadFromFile(FPath);
      frmPreview.FRawMsg := SL.Text;
      frmPreview.edFrom.Text := Go('From', SL);
      frmPreview.panPreviewFrom.Visible := frmPreview.edFrom.Text <> '';
      frmPreview.edTo.Text := Go('To', SL);
      frmPreview.panPreviewTo.Visible := frmPreview.edTo.Text <> '';
      frmPreview.edCC.Text := Go('CC', SL);
      frmPreview.panPreviewCC.Visible := frmPreview.edCC.Text <> '';
      frmPreview.edDate.Text := Go('Date', SL);
      frmPreview.panPreviewDate.Visible := frmPreview.edDate.Text <> '';
      frmPreview.edSubject.Text := Go('Subject', SL);
      frmPreview.panPreviewSubject.Visible := frmPreview.edSubject.Text <> '';
      frmPreview.edXMailer.Text := Go('XMailer', SL);
      frmPreview.panPreviewXMailer.Visible := frmPreview.edXMailer.Text <> '';

      frmPreview.DontProcess := True;
      frmPreview.memMail.Text := GoText(SL);
      frmPreview.Resume := frmPreview.memMail.Text;
      frmPreview.Show;

      SL.Free;
      // show contents
      Screen.Cursor := crDefault;

      SaveAccountInfo(tabMail.tabIndex+1);
    except
      frmPreview.DontProcess := False;
      Application.MessageBox('Cannot preview this e-mail.', 'Preview', MB_OK+MB_ICONINFORMATION)
    end;
  end
  else
    Preview(tabMail.TabIndex+1);
end;

procedure TSpamLearnerMainForm.actNewMailExecute(Sender: TObject);
begin
  SendMail('','','');
  HideForm;
end;

procedure TSpamLearnerMainForm.tvOptionsChange(Sender: TObject; Node: TTreeNode);
begin
  // free any frames created
  if Assigned(frame) then FreeAndNil(frame);
  // unselect?
  if (Node=nil) then
  begin
    lblOptionTitle.Caption := 'Options';
    imgOptionTitle.Canvas.Brush.Color := clWindow;
    imgOptionTitle.Canvas.FillRect(imgOptionTitle.Canvas.ClipRect);
    Exit;
  end;
  // create the selected frame
  panelAutorespond.Visible := False;
  panRulesTop.Visible := False;
  case Node.AbsoluteIndex of
    optInterval           : frame := TframeInterval.Create(Self);
    optDefaults           : frame := TframeDefaults.Create(Self);
    optGeneralOptions     : frame := TframeGeneralOptions.Create(Self);
    optAdvancedOptions    : frame := TframeAdvancedOptions.Create(Self);
    optAdvancedInterface  : frame := TframeAdvancedInterface.Create(Self);
    optRules              : begin btnSaveRules.Enabled := False; btnCancelRule.Enabled := False; panRulesTop.Visible := True; panRulesTop.Parent := panOptions; end;
    optAutorespond        : panelAutorespond.Visible := True;
    optAdvancedMisc       : frame := TframeAdvancedMisc.Create(Self);
    optMouseButtons       : frame := TframeMouseButtons.Create(Self);
    optHotKeys            : frame := TframeHotKeys.Create(Self);
//    optWhiteBlackList     : frame := TframeWhiteBlack.Create(Self);
    optPlugins            : frame := TframePlugins.Create(Self);
  end;
  // show frame
  if Assigned(frame) then
  begin
    frame.Parent := panOptions;
    frame.Align := alClient;
  end;
  // title
  lblOptionTitle.Caption := Node.Text;
  imgOptionTitle.Canvas.Brush.Color := clWindow;
  imgOptionTitle.Canvas.FillRect(imgOptionTitle.Canvas.ClipRect);
  dm.imlOptions.Draw(imgOptionTitle.Canvas,2,0,Node.ImageIndex);
end;

procedure TSpamLearnerMainForm.HelpMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  QuickHelp(Sender, Button, Shift, X, Y);
end;

procedure TSpamLearnerMainForm.actReplyExecute(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
// Reply to message using default mail client
{var
  email,subject : string;
  MailItem : TMailItem;}
var
  i : integer;
  SaveTab : integer;
  ProcessedList, Marked : TStrings;

procedure Allow(EMail: String);
var I: Integer; Found: Boolean;
begin
  Found := False;
  for I:=0 to Options.WhiteList.Count-1 do
   if UpperCase(EMail)=UpperCase(Options.WhiteList[I]) then
    begin
      Found := True;
      Break;
    end;
  if not Found then
   Options.WhiteList.Add(EMail);
end;

procedure Mark(Name: String);
var I: Integer;
    Found: Boolean;
begin
  Found := False;
  for I:=0 to Marked.Count-1 do
   if UpperCase(Marked[I])=UpperCase(Name) then
   begin
     Found := True;
     Break;
   end;
  if not Found then
    Marked.Add(Name);
end;

function Exists(Name: String): Boolean;
var I: Integer;
    Found: Boolean;
begin
  Found := False;
  for I:=0 to Marked.Count-1 do
   if UpperCase(Marked[I])=UpperCase(Name) then
   begin
     Found := True;
     Break;
   end;
  Result := Found;
end;

function AlreadySent(EMail: String): Boolean;
var I: Integer;
begin
  Result := False;
  for I:=0 to ProcessedList.Count-1 do
   if UpperCase(EMail)=UpperCase(ProcessedList[I]) then
    begin
      Result := True;
      Break;
    end;
end;

function Process(S: String): String;
var I, Found: Integer;
begin
  Found := 0;
  for I:=1 to Length(S) do
   if (S[I] = '.') then
     Inc(Found);
  if Found > 1 then
   while (Found > 1) do
   begin
     Delete(S, 1, Pos('.', S));
     Dec(Found);
   end;
  Result := S;
end;

procedure SendSMTPMail(num: Integer; SendToAddress, Subject, Body, SendFromName, SendFromEmail: String);
var
  slBody: TStringList;
  idSMTP: TIdSMTP;
  idMessage: TIdMessage;
begin
 if UpperCase(SendToAddress) = UpperCase(SendFromEmail) then Exit;
 try
  idMessage := TIdMessage.Create(Self);
  idMessage.Recipients.Add;
  idMessage.Recipients[0].Address := SendToAddress;
  slBody := TstringList.Create;
  idSMTP := TIdSMTP.Create(Self);

     slBody.Text := Body;
     idMessage.Body.Assign(slBody);
     idMessage.Subject := Subject;
     idMessage.From.Address := SendFromEmail;
     idMessage.From.Name := SendFromName;
     { Details here... }
     idSMTP.UserName := Accounts[num-1].Login;
     idSMTP.Password := Accounts[num-1].Password;
     idSMTP.Host := Accounts[num-1].SMTPServer;
     idSMTP.Port := Accounts[num-1].SMTPPort;
     try
       idSMTP.Connect;
       idSMTP.Send(idMessage);
     except
     end;
     try
       idSMTP.Disconnect;
     except
     end;
    slBody.Free;

  idSMTP.Free;
  idMessage.Free;
  except
  end;
end;

function GetSubject(T: TStringList): String;
var J: Integer; S: String;
begin
  Result := '';
  for J:=0 to T.Count-1 do
    if Pos('SUBJECT: ', UpperCase(T[J]))=1 then
     begin
       S := T[J];
       Delete(S, 1, 9);
       Result := S;
       Break;
     end;
end;

function GetSendFrom(T: TStringList): String;
var J: Integer; S: String;
begin
  Result := '';
  for J:=0 to T.Count-1 do
    if Pos('FROM: ', UpperCase(T[J]))=1 then
     begin
       S := T[J];
       Delete(S, 1, 6);
       Result := S;
       Break;
     end;
end;

function GetBody(T: TStringList): String;
var I, J: Integer;
begin
  I := T.IndexOf('');
  if I < 0 then I := -1;
  Result := '';
  for J:=I+1 to T.Count-1 do
    Result := Result + T[J] + #13#10;
end;

procedure SendBackMail(Account: TAccountItem; num: Integer; EMail: String);
var P: TUnknownMsg;
    T: TStringList;
begin
  P := Account.UnknownMessages;
  T := TStringList.Create;
  T.Clear;
  while P <> nil do
   begin
     if UpperCase(P^.Account.From) = UpperCase(EMail) then
      begin
        // send this one
        try
          T.LoadFromFile(ExtractFilePath(Application.ExeName)+'Junk\'+P^.Account.Path);
        except
        end;
        if Pos('@', Accounts[num].Login) <= 0 then
          SendSMTPMail(num+1, Accounts[num].Login+'@'+Process(Accounts[num].Server), GetSubject(T), GetBody(T), '', GetSendFrom(T))
        else
          SendSMTPMail(num+1, Accounts[num].Login, GetSubject(T), GetBody(T), '', GetSendFrom(T));
      end;
     P := P^.Next;
   end;
  T.Free;
end;

begin
  {* Replaced with ALLOW feature *}
  Marked := TStringList.Create;
  Marked.Clear;
  ProcessedList := TStringList.Create;
  ProcessedList.Clear;


  if lvMail.Selected = nil then
    TranslateDlg(Translate('No message selected.'), mtError, [mbOK], 0)
  else
  if Application.MessageBox('Are you sure you want to add the message(s) to the allow list?', 'Allow List', MB_YESNO+MB_ICONQUESTION)=mrYes then
  begin
    // first, add to allow list
    for i := 0 to lvMail.Items.Count-1 do
     if lvMail.Items[i].Selected then
     begin
     Mark(lvMail.Items[i].Caption); { Mark all e-mails from this address for deletion }
     if lvMail.Items[i].ImageIndex <> 18 then
     begin
       Accounts[tabMail.TabIndex].Mail.FindMessage(StrToInt(lvMail.Items[i].SubItems[colID])).IsInWhiteList := True;
       Allow( Accounts[tabMail.TabIndex].Mail.FindMessage(StrToInt(lvMail.Items[i].SubItems[colID])).Address );
     end
     else
       Allow( lvMail.Items[i].Caption );
       // now we must send all saved messages to user's account
       if not AlreadySent(lvMail.Items[i].Caption) then
       begin
         ProcessedList.Add(lvMail.Items[i].Caption);
         SendBackMail(Accounts[tabMail.TabIndex], tabMail.TabIndex, lvMail.Items[i].Caption);
       end;
     end;
    // save these to HDD
    btnSaveListsClick(Self);
    if btnLists.Down then
      btnListsClick(Self);

    SaveTab := tabMail.TabIndex+1;
    // refresh view
    begin
      if not Accounts[SaveTab-1].Error then
        if CheckMail(SaveTab,false) < 0 then
          lvMail.Clear;
      // showmail if tab hasn't changed
      if tabMail.TabIndex+1=SaveTab then
        ShowMail(tabMail.TabIndex+1)
      else
        ShowIcon(SaveTab,itNormal);
    end;
  end;

  if Marked.Count > 0 then { We must delete e-mail! }
  begin
    for I:=0 to lvMail.Items.Count-1 do
     if Exists(lvMail.Items[I].Caption) then
       lvMail.Items[I].Selected := True
     else
       lvMail.Items[I].Selected := False;

   { Now delete unnecessary e-mails! }
    actDeleteExecute(Self);
  end;

  Marked.Free;
  ProcessedList.Free;

  {* ------------ END ---------- *}

{  MailItem := SelectedMailItem;
  // get headers
  if MailItem.ReplyTo <> '' then
    email := MailItem.ReplyTo
  else
    email := MailItem.Address;
  subject := MailItem.Subject;
  if (Uppercase(Copy(subject,1,3)) <> 'RE:') and (Uppercase(Copy(subject,1,3)) <> 'RE[') then
    subject := 'Re: '+subject;
  // send mail
  SendMail(email,subject,'');}
end;

procedure TSpamLearnerMainForm.actRuleFromExecute(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
// Create rule to delete selected emails
// Multi-select code by Victor
var
  i : integer;
  emails : TStringList;
  Item : TListItem;
  MailItem : TMailItem;
begin
  if lvMail.Selected = nil then
  begin
    TranslateDlg(Translate('No message selected.'), mtError, [mbOK], 0);
    Exit;
  end;
  if lvMail.Selected.ImageIndex = 18 then Exit;

  emails := TStringList.Create;
  try
    // collect selected emails (remove duplicates)
    emails.Duplicates := dupIgnore;
    emails.CaseSensitive := False;
    emails.Sorted := True;
    Item := lvMail.Selected;
    while Item <> nil do
    begin
      MailItem := SelectedMailItem(Item);
      emails.Add(MailItem.Address);
      Item := lvMail.GetNextItem(Item, sdAll, [isSelected]);
    end;

    // ask to create rule
    if (emails.Count > 0) and
       (TranslateDlg(Translate('This will create a rule to delete all future e-mails from')
         +#13+#10+emails.Text+
         #13+#10+Translate('Are you sure?'), mtConfirmation, [mbYes,mbNo], 0) = mrYes) then
    begin
      for i := 0 to emails.Count-1 do
      begin
        // add the delete rule
        Inc(FNumRules);
        // add to rules
        with Rules.Add do
        begin
          Name := 'DelRule '+IntToStr(FNumRules);
          Enabled := True;
          New := False;
          Account := 0;
          Area := raFromAddress;
          Compare := rcEquals;
          Text := emails[i];
          Wav := '';
          Delete := True;
          Ignore := False;
          EXE := '';
          Important := False;
          Spam := False;
          Log := True;
        end;
        // add to listbox
        lstRules.Items.Add(Rules[FNumRules-1].Name);
        lstRules.Checked[FNumRules-1] := True;
        // save it
        SaveRulesINI;
        // mark as spam
        Item := lvMail.Selected;
        while Item <> nil do
        begin
          MailItem := SelectedMailItem(Item);
          MailItem.Spam := True;
          Item.ImageIndex := GetStatusIcon(MailItem);
          Item := lvMail.GetNextItem(Item, sdAll, [isSelected]);
        end;
      end;
    end;
  finally
    emails.Free;
  end;
end;

procedure TSpamLearnerMainForm.actNoSortExecute(Sender: TObject);
begin
  FSortDirection := sdAsc;
  SetSortColumn(NOSORT);
end;

procedure TSpamLearnerMainForm.actCheckExecute(Sender: TObject);
var
  SaveTab : integer;
begin
  FShiftClick := GetKeyState(VK_SHIFT) < 0;
  if tabMail.TabIndex >= 0 then
  begin
    SaveTab := tabMail.TabIndex+1;
    ShowIcon(SaveTab,itChecking);
    CheckMail(SaveTab);
    // still the same tab?
    if tabMail.TabIndex+1=SaveTab then
      ShowMail(SaveTab)
    else
      ShowIcon(SaveTab,itNormal);
  end;
end;

procedure TSpamLearnerMainForm.actAddAccountExecute(Sender: TObject);
var
  NoName : string;
begin
  // check if saved
  if FAccChanged then
  begin
    case TranslateDlg(Translate('Account Info changed.'+#13+#10+
                    'Do you want to save it?'), mtConfirmation,
                    [mbYes, mbNo, mbCancel], 0) of
      mrYes    : btnSave.Click;
      mrNo     : ;// nothing
      mrCancel : Exit;
    end;
  end;
  // add account
  Accounts.Add;
  Inc(NumAccounts);
  FNewAccount := True;
  btnSave.Enabled := True;
  btnCancelAccount.Enabled := True;
  // add tab
  NoName := Translate('NoName');
  tabAccounts.Tabs.Add(NoName);
  tabAccounts.TabIndex := NumAccounts-1;
  tabMail.Tabs.Add(NoName);
  dm.AddBitmap(dm.imlTabs, dm.imlPopTrueColor,popClosed);
  // enable fields
  EnableFields(True);
  chkAccEnabled.Checked := True;
  // clear the fields
  edName.Text := NoName;
  edServer.Text := '';
  edSMTP.Text := '';
  cmbProtocol.ItemIndex := 0;
  edPort.Text := '110';
  edSMTPPort.Text := '25';
  edLogin.Text := '';
  edPassword.Text := '';
  edAccountProgram.Text := Translate(UseDefaultProgram);
  edAccountProgram.Font.Color := clGrayText;
  edSound.Text := Translate(UseDefaultSound);
  edSound.Font.Color := clGrayText;
  colAccount.Selected := clRed;
  edName.SetFocus;
  // clear mail
  lvMail.Items.Clear;
  SpamList.Items.Clear;
end;

procedure TSpamLearnerMainForm.actDeleteAccountExecute(Sender: TObject);
begin
  if FNewAccount then
  begin
    Accounts.Delete(tabAccounts.TabIndex);
    Dec(NumAccounts);
    tabMail.Tabs.Delete(tabAccounts.TabIndex);
    tabAccounts.Tabs.Delete(tabAccounts.TabIndex);
    FNewAccount := False;
    tabAccounts.TabIndex := tabAccounts.Tabs.Count-1;
    ShowAccount(tabAccounts.TabIndex+1);
  end
  else if tabMail.TabIndex >= 0 then
    DeleteAccount(tabAccounts.TabIndex+1);
end;

procedure TSpamLearnerMainForm.actRuleAddExecute(Sender: TObject);
var
  RuleStr : string;
begin
  Inc(FNumRules);
  RuleStr := Translate('Rule');
  // add to rules
  with Rules.Add do
  begin
    Name := RuleStr + ' '+IntToStr(FNumRules);
    Enabled := True;
    New := False;
    Account := 0;
    Area := raHeader;
    Compare := rcContains;
    Text := '';
    Wav := '';
    Delete := False;
    Ignore := False;
    EXE := '';
    Important := False;
    Spam := False;
    Log := True;
  end;
  // add to listbox
  lstRules.Items.Add(Rules[FNumRules-1].Name);
  lstRules.Checked[FNumRules-1] := True;
  lstRules.ItemIndex := FNumRules-1;
  panRuleDetail.Visible := True;
  // clear rule detail
  edRuleName.Text := RuleStr + ' '+IntToStr(FNumRules);
  edRuleName.SelectAll;
  edRuleName.SetFocus;
  chkRuleEnabled.Checked := True;
  chkRuleNew.Checked := False;
  // clear criteria
  cmbRuleAccount.ItemIndex := 0;
  cmbRuleArea.ItemIndex := 0;
  cmbRuleComp.ItemIndex := 0;
  edRuleText.Text := '';
  // clear action checkboxes
  chkRuleWav.Checked := False;
  chkRuleDelete.Checked := False;
  chkRuleIgnore.Checked := False;
  chkRuleImportant.Checked := False;
  chkRuleSpam.Checked := False;
  chkRuleLog.Checked := True;
  // enable buttons
  FRuleChanged := True;
  EnableRuleButtons;
end;

procedure TSpamLearnerMainForm.actRuleDeleteExecute(Sender: TObject);
begin
  if lstRules.ItemIndex > -1 then
  begin
    if TranslateDlg(Translate('Delete Rule:')+' '+Rules[lstRules.ItemIndex].Name+#13#10+
                  Translate('Are you sure?'), mtConfirmation, [mbYes, mbNo], 0) = mrYes then
    begin
      DeleteRule(lstRules.ItemIndex);
    end;
  end
  else begin
    TranslateDlg(Translate('No rule selected'), mtError, [mbOK], 0);
  end;
  btnSaveRules.Enabled := True;
  btnCancelRule.Enabled := True;
end;

procedure TSpamLearnerMainForm.actShowMessagesExecute(Sender: TObject);
begin
  btnSpamClick(Self);
  ShowMessages;
end;

procedure TSpamLearnerMainForm.actCheckAllExecute(Sender: TObject);
begin
  CheckAllMail;
end;

procedure TSpamLearnerMainForm.actStartProgramExecute(Sender: TObject);
var
  i : integer;
  res : boolean;
begin
  if not FMinimized and (PageControl.ActivePageIndex = 0) then
    res := ExecuteProgram(tabMail.TabIndex+1)
  else
    res := ExecuteProgram(FAccountWithMail);
  if FShowingInfo then frmInfo.Close;
  if res then HideForm;
  for i := 1 to NumAccounts do
    MarkViewed(i);
  UpdateTrayIcon;
  if not Options.ResetTray then ClearTrayIcon;
end;

procedure TSpamLearnerMainForm.actAutoCheckExecute(Sender: TObject);
begin
  UpdateTrayIcon;
end;

procedure TSpamLearnerMainForm.actOptionsExecute(Sender: TObject);
begin
  PageControl.ActivePageIndex := 2;
  ShowForm;
  btnSettingsClick(Self);
end;

procedure TSpamLearnerMainForm.actRulesExecute(Sender: TObject);
begin
  PageControl.ActivePageIndex := 3;
  ShowForm;
end;

procedure TSpamLearnerMainForm.actAboutExecute(Sender: TObject);
begin
  PageControl.ActivePageIndex := 4;
  ShowForm;
end;

procedure TSpamLearnerMainForm.actHelpExecute(Sender: TObject);
begin
//  HtmlHelp(0, HelpFileName, HH_DISPLAY_TOC, 0);
  with TAboutForm.Create(Self) do
   try
    ShowModal;
   finally
    Free;
   end;
end;

procedure TSpamLearnerMainForm.actToTrayExecute(Sender: TObject);
begin
  HideForm;
end;

procedure TSpamLearnerMainForm.actQuitExecute(Sender: TObject);
begin
  Quit;
end;

procedure TSpamLearnerMainForm.actCustomizeExecute(Sender: TObject);
begin
  ActionManager.FileName := ToolbarName;
  dm.ShowCustomizeDlg(ActionManager,True);
end;

procedure TSpamLearnerMainForm.lstRulesClickCheck(Sender: TObject);
begin
  if lstRules.ItemIndex > -1 then
  begin
    Rules[lstRules.ItemIndex].Enabled := lstRules.Checked[lstRules.ItemIndex];
    chkRuleEnabled.Checked := Rules[lstRules.ItemIndex].Enabled;
    FRuleChanged := True;
    EnableRuleButtons;
  end;
end;


procedure TSpamLearnerMainForm.actRulesImportExecute(Sender: TObject);
var
  OpenDialog : TOpenDialog;
  Ini : TIniFile;
  i,RuleCount : integer;
  section : string;
begin
  OpenDialog := TOpenDialog.Create(nil);
  try
    OpenDialog.Filter := Translate('INI Files')+' (*.ini)|*.ini';
    if OpenDialog.Execute then
    begin
      Ini := TIniFile.Create(OpenDialog.FileName);
      try
        RuleCount := Ini.ReadInteger('Options','NumRules',0);
        while Rules.Count < FNumRules+RuleCount do
          Rules.Add;
        for i := FNumRules to FNumRules+RuleCount-1 do
        begin
          section := 'Rule'+IntToStr(i-FNumRules+1);
          Rules[i].Name := Ini.ReadString(Section,'Name','NoName');
          Rules[i].Account := Ini.ReadInteger(Section,'Account',0);
          Rules[i].Area := StrToRuleArea(Ini.ReadString(Section,'Area','Header'));
          Rules[i].Compare := StrToRuleCompare(Ini.ReadString(Section,'Func','Contains'));
          Rules[i].Text := Ini.ReadString(Section,'Text','');
          Rules[i].Wav := Ini.ReadString(Section,'Wav','');
          Rules[i].EXE := Ini.ReadString(Section,'EXE','');
          Rules[i].Enabled := Ini.ReadBool(Section,'Enabled',False);
          Rules[i].New := Ini.ReadBool(Section,'New',False);
          Rules[i].Delete := Ini.ReadBool(Section,'Delete',False);
          Rules[i].Ignore := Ini.ReadBool(Section,'Ignore',False);
          Rules[i].Important := Ini.ReadBool(Section,'Important',False);
          Rules[i].Spam := Ini.ReadBool(Section,'Spam',False);
          Rules[i].Log := Ini.ReadBool(Section,'Log',True);
          // list box
          lstRules.Items.Add(Rules[i].Name);
          lstRules.Checked[i] := Rules[i].Enabled;
        end;
        FNumRules := FNumRules+RuleCount;
      finally
        Ini.Free;
      end;
    end;
  finally
    OpenDialog.Free;
  end;
end;

procedure TSpamLearnerMainForm.lvAdvancedOptionsSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);
begin
  Item.Selected := False;
  tvOptions.Items[Item.Index+4].Selected := True;
end;

procedure TSpamLearnerMainForm.lvOptionsSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);
begin
  Item.Selected := False;
  if Item.Index >= 4 then
    tvOptions.Items[Item.Index+3].Selected := True
  else
    tvOptions.Items[Item.Index].Selected := True;
end;

procedure TSpamLearnerMainForm.actHideViewedExecute(Sender: TObject);
var
  msgnums : array of integer;
  i,j : integer;
  SaveTab : integer;
  Marked : TStrings;

procedure Block(EMail: String);
var I: Integer; Found: Boolean;
begin
  Found := False;
  for I:=0 to Options.BlackList.Count-1 do
   if UpperCase(EMail)=UpperCase(Options.BlackList[I]) then
    begin
      Found := True;
      Break;
    end;
  if not Found then
   Options.BlackList.Add(EMail);
end;

procedure DeleteEMail(num: Integer; Item: TListItem);
var P, Q: TUnknownMsg;
begin
  P := Accounts[num].UnknownMessages;
  if P = nil then Exit;
  if (P^.Account.From = Item.Caption) and (P^.Account.MailTo = Item.SubItems[0]) and
    (P^.Account.Subject = Item.SubItems[1]) {and (P^.Account.Date = StrToDate(Item.SubItems[2]))} and
    (IntToStr(P^.Account.Size)+' '+Translate('KB') = Item.SubItems[3]) and (UpperCase(P^.Account.Path) = UpperCase(Item.SubItems[6])) then
    begin // this is it!!!
      DeleteFile(ExtractFilePath(Application.ExeName)+'Junk\'+Accounts[num].UnknownMessages^.Account.Path);
      Accounts[num].UnknownMessages := Accounts[num].UnknownMessages^.Next;
      Dispose(P);
    end
  else
  if P^.Next <> nil then
  begin
    while (P^.Next <> nil) and (P^.Next^.Account.From <> Item.Caption) and (P^.Next^.Account.MailTo <> Item.SubItems[0]) and
          (P^.Next^.Account.Subject <> Item.SubItems[1]) and {(P^.Next^.Account.Date <> StrToDate(Item.SubItems[2])) and}
          (IntToStr(P^.Next^.Account.Size)+' '+Translate('KB') <> Item.SubItems[3]) and (UpperCase(P^.Account.Path) <> UpperCase(Item.SubItems[6])) do
      P := P^.Next;
    if P^.Next <> nil then  // found it !!!
    begin
      Q := P^.Next;
      DeleteFile(ExtractFilePath(Application.ExeName)+'Junk\'+Q^.Account.Path);
      P^.Next := P^.Next^.Next;
      Dispose(Q);
    end;
  end;
end;

procedure Mark(Name: String);
var I: Integer;
    Found: Boolean;
begin
  Found := False;
  for I:=0 to Marked.Count-1 do
   if UpperCase(Marked[I])=UpperCase(Name) then
   begin
     Found := True;
     Break;
   end;
  if not Found then
    Marked.Add(Name);
end;

function Exists(Name: String): Boolean;
var I: Integer;
    Found: Boolean;
begin
  Found := False;
  for I:=0 to Marked.Count-1 do
   if UpperCase(Marked[I])=UpperCase(Name) then
   begin
     Found := True;
     Break;
   end;
  Result := Found;
end;

begin
  { Replaced with BLOCK feature }
  Marked := TStringList.Create;
  Marked.Clear;

  if lvMail.Selected = nil then
    TranslateDlg(Translate('No message selected.'), mtError, [mbOK], 0)
  else
  if Application.MessageBox('Are you sure you want to add the message(s) to the block list?', 'Block List', MB_YESNO+MB_ICONQUESTION)=mrYes then
  begin
    // first, add to block list
    for i := 0 to lvMail.Items.Count-1 do
     if lvMail.Items[i].Selected then
     begin
       Mark(lvMail.Items[i].Caption); { Mark all e-mails from this address for deletion }
       if lvMail.Items[i].ImageIndex <> 18 then
         Block( Accounts[tabMail.TabIndex].Mail.FindMessage(StrToInt(lvMail.Items[i].SubItems[colID])).Address )
       else
         Block(lvMail.Items[i].Caption);
     end;
    // save these to HDD
    btnSaveListsClick(Self);
    if btnLists.Down then
      btnListsClick(Self);

    // next, delete...
    if FDeleting then
    begin
      if not Options.NoError then
        Balloon('SpamLearner',Translate('Still busy deleting other messages.'), bitError, 15);
      Exit;
    end;
    if FBusy then
    begin
      if not Options.NoError then
        Balloon('SpamLearner',Translate('Error:')+' '+Translate('Still Busy Checking'),bitError,15);
      Exit;
    end;
{    if Options.SafeDelete and not Accounts[tabMail.TabIndex].UIDLSupported then
      warning := Translate('WARNING: This account does NOT support Safe Delete.')+ #13#10#13#10;}
    SaveTab := tabMail.TabIndex+1;
    Accounts[SaveTab-1].Error := False;
    if lvMail.SelCount = 1 then
    begin
      // one selected delete
        ShowIcon(SaveTab,itDeleting);
        try
          DeleteMail(SaveTab,StrToInt(lvMail.Selected.SubItems[colID]));
        except
//          on e : Exception do ErrorMsg(SaveTab,'Delete Error:',e.Message,Options.NoError);
        end;
    end
    else begin
      // multi-select delete
        SetLength(msgnums,lvMail.SelCount);
        j := 0;
        for i := 0 to lvMail.Items.Count-1 do
        begin
          if lvMail.Items[i].Selected then
{          if lvMail.Items[i].ImageIndex = 18 then
            DeleteEMail(tabMail.TabIndex, lvMail.Items[i])
          else}
          begin
            try
              msgnums[j] := StrToInt(lvMail.Items[i].SubItems[colID]);
            except
              msgnums[j] := i;
            end;
            Inc(j);
          end;
        end;
        ShowIcon(SaveTab,itDeleting);
        try
          DeleteMultipleMail(SaveTab,msgnums);
        except
//          on e : Exception do ErrorMsg(SaveTab,'Delete Error:',e.Message,Options.NoError);
        end;
    end;
    // refresh view
    begin
      if not Accounts[SaveTab-1].Error then
        if CheckMail(SaveTab,false) < 0 then
          lvMail.Clear;
      // showmail if tab hasn't changed
      if tabMail.TabIndex+1=SaveTab then
        ShowMail(tabMail.TabIndex+1)
      else
        ShowIcon(SaveTab,itNormal);
    end;
  end;

  if Marked.Count > 0 then { We must delete e-mail! }
  begin
    for I:=0 to lvMail.Items.Count-1 do
     if Exists(lvMail.Items[I].Caption) then
       lvMail.Items[I].Selected := True
     else
       lvMail.Items[I].Selected := False;

   { Now delete unnecessary e-mails! }
    actDeleteExecute(Self);
  end;

  Marked.Free;

  {  Options.HideViewed := actHideViewed.Checked;
  ShowMail(tabMail.TabIndex+1);}
end;

procedure TSpamLearnerMainForm.cmbProtocolChange(Sender: TObject);
begin
  if length(Protocols)-1 < cmbProtocol.ItemIndex then Exit;
  // port
  if Protocols[cmbProtocol.ItemIndex].Port < 0 then
  begin
    edPort.Text := '';
    EnableControl(edPort,false);
    edServer.Text := '';
    EnableControl(edServer,false);
  end
  else begin
    EnableControl(edPort,true);
    EnableControl(edServer,true);
    edPort.Text := IntToStr(Protocols[cmbProtocol.ItemIndex].Port);
    Accounts[tabAccounts.TabIndex].Prot := Protocols[cmbProtocol.ItemIndex].Prot;
  end;
  // buttons
  FAccChanged := AccountChanged(tabAccounts.TabIndex);
  btnSave.Enabled := FAccChanged;
  btnCancelAccount.Enabled := FAccChanged;
end;

procedure TSpamLearnerMainForm.actAddWhiteListExecute(Sender: TObject);
begin
  AddToWhiteBlackList(wbWhite);
{  if AddToWhiteBlackList(wbWhite) and Options.BlackListSpam then
    actUnmarkSpam.Execute;}
end;

procedure TSpamLearnerMainForm.actAddBlackListExecute(Sender: TObject);
begin
  AddToWhiteBlackList(wbBlack);
{  if AddToWhiteBlackList(wbBlack) and Options.BlackListSpam then
     actMarkSpam.Execute;}
end;

procedure TSpamLearnerMainForm.actMarkViewedExecute(Sender: TObject);
var
  i : integer;
begin
  for I:=0 to lvMail.Items.Count-1 do
   if lvMail.Items[I].Selected then
    SetViewed(tabMail.tabIndex, lvMail.Items[I]);

  // proceed as usual
  {
  for i := 1 to NumAccounts do
    MarkViewed(i);
  if FShowingInfo then
    frmInfo.Close;
  if Not FMinimized and (tabMail.Tabs.Count>0) then
    ShowMail(tabMail.TabIndex+1);
  }
end;

procedure TSpamLearnerMainForm.actMarkSpamExecute(Sender: TObject);
var
  Item : TListItem;
  MailItem : TMailItem;
begin
  Item := lvMail.Selected;
  if Item.ImageIndex = 18 then Exit;
  while Item <> nil do
  begin
    MailItem := SelectedMailItem(Item);
    MailItem.Spam := True;
    Item.ImageIndex := GetStatusIcon(MailItem);
    Item := lvMail.GetNextItem(Item, sdAll, [isSelected]);
    actDeleteSpam.Enabled := True;
    actSelectSpam.Enabled := actDeleteSpam.Enabled;
    actSpam.Enabled := actDeleteSpam.Enabled or actMarkSpam.Enabled or actUnmarkSpam.Enabled;
  end;
  //SetSpamAction(actMarkSpam);
end;

procedure TSpamLearnerMainForm.actUnmarkSpamExecute(Sender: TObject);
var
  Item : TListItem;
  MailItem : TMailItem;
begin
  Item := lvMail.Selected;
  if Item.ImageIndex = 18 then Exit;
  while Item <> nil do
  begin
    MailItem := SelectedMailItem(Item);
    MailItem.Spam := False;
    Item.ImageIndex := GetStatusIcon(MailItem);
    Item := lvMail.GetNextItem(Item, sdAll, [isSelected]);
  end;
  actDeleteSpam.Enabled := CountSpam(tabMail.TabIndex+1) > 0;
  actSelectSpam.Enabled := actDeleteSpam.Enabled;
  actSpam.Enabled := actDeleteSpam.Enabled or actMarkSpam.Enabled or actUnmarkSpam.Enabled;
  //SetSpamAction(actUnmarkSpam);
end;

procedure TSpamLearnerMainForm.actDeleteSpamExecute(Sender: TObject);
var
  SaveTab : integer;
begin
  SaveTab := tabMail.TabIndex+1;
  DeleteSpam(tabMail.TabIndex+1, Options.DeleteConfirm);
  if tabMail.TabIndex+1 = SaveTab then
    ShowMail(tabMail.TabIndex+1);
  //SetSpamAction(actDeleteSpam);
end;

procedure TSpamLearnerMainForm.MouseMoveReset(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
  ResetToolbar;
end;

procedure TSpamLearnerMainForm.chkRuleSpamClick(Sender: TObject);
begin
  EnableRuleButtons;
  if lstRules.ItemIndex > -1 then
    Rules[lstRules.ItemIndex].Spam := chkRuleSpam.Checked;
end;

procedure TSpamLearnerMainForm.actRuleToMarkSpamExecute(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
// Create rule to mark selected emails as spam
var
  i : integer;
  emails : TStringList;
  Item : TListItem;
  MailItem : TMailItem;
begin
  if lvMail.Selected = nil then
  begin
    TranslateDlg(Translate('No message selected.'), mtError, [mbOK], 0);
    Exit;
  end;
  if lvMail.Selected.ImageIndex = 18 then Exit;

  emails := TStringList.Create;
  try
    // collect selected emails (remove duplicates)
    emails.Duplicates := dupIgnore;
    emails.CaseSensitive := False;
    emails.Sorted := True;
    Item := lvMail.Selected;
    while Item <> nil do
    begin
      MailItem := SelectedMailItem(Item);
      emails.Add(MailItem.Address);
      Item := lvMail.GetNextItem(Item, sdAll, [isSelected]);
    end;

    // ask to create rule
    if (emails.Count > 0) and
       (TranslateDlg(Translate('This will create a rule to spam mark all future e-mails from')
         +#13+#10+emails.Text+
         #13+#10+Translate('Are you sure?'), mtConfirmation, [mbYes,mbNo], 0) = mrYes) then
    begin
      for i := 0 to emails.Count-1 do
      begin
        // add the delete rule
        Inc(FNumRules);
        // add to rules
        with Rules.Add do
        begin
          Name := 'SpamRule '+IntToStr(FNumRules);
          Enabled := True;
          New := False;
          Account := 0;
          Area := raFromAddress;
          Compare := rcEquals;
          Text := emails[i];
          Wav := '';
          Delete := False;
          Ignore := True;
          EXE := '';
          Important := False;
          Spam := True;
          Log := True;
        end;
        // add to listbox
        lstRules.Items.Add(Rules[FNumRules-1].Name);
        lstRules.Checked[FNumRules-1] := True;
        // save it
        SaveRulesINI;
        // mark as spam
        Item := lvMail.Selected;
        while Item <> nil do
        begin
          MailItem := SelectedMailItem(Item);
          MailItem.Spam := True;
          Item.ImageIndex := GetStatusIcon(MailItem);
          Item := lvMail.GetNextItem(Item, sdAll, [isSelected]);
        end;
        // del spam button
        actDeleteSpam.Enabled := True;
        actSelectSpam.Enabled := actDeleteSpam.Enabled;
        actSpam.Enabled := actDeleteSpam.Enabled or actMarkSpam.Enabled or actUnmarkSpam.Enabled;
      end;
    end;
  finally
    emails.Free;
  end;
end;

procedure TSpamLearnerMainForm.lvMailKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case key of
    VK_DELETE : actDelete.Execute;
    VK_SPACE  : actPreview.Execute;
  end;
end;

procedure TSpamLearnerMainForm.actSelectSpamExecute(Sender: TObject);
var
  i : integer;
  MailItem : TMailItem;
begin
  for i := 0 to lvMail.Items.Count-1 do
  begin
    MailItem := SelectedMailItem(lvMail.Items[i]);
    if MailItem.Spam then
      lvMail.Items[i].Selected := True;
  end;
end;

procedure TSpamLearnerMainForm.imgLogoClick(Sender: TObject);
begin
  SwapOutMemory;
end;

procedure TSpamLearnerMainForm.tvOptionsMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbRight then
    tvOptions.Selected := nil
  else
    QuickHelp(Sender, Button, Shift, X, Y);
end;

procedure TSpamLearnerMainForm.lvMailMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbRight then
    dm.mnuMail.Popup(lvMail.ClientToScreen(Point(X,Y)).X,lvMail.ClientToScreen(Point(X,Y)).Y);
end;

procedure TSpamLearnerMainForm.DragMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if (Button = mbLeft) and (Screen.Cursor <> crHourGlass) and
    (GetKeyState(VK_LBUTTON) < 0) then
    (Sender as TControl).BeginDrag(False,12);
end;

procedure TSpamLearnerMainForm.tabDragDrop(Sender, Source: TObject; X,  Y: Integer);
var
  i,num,new,old : integer;
  map : array of integer;
begin
  // get tabs
  new := (Sender as TTabControl).IndexOfTabAt(X,Y);
  old := (Sender as TTabControl).TabIndex;
  if (old <> new) and (Screen.Cursor <> crHourGlass) then
  begin
    Screen.Cursor := crHourGlass;
    try
      // save oldnum
      for num := 1 to Accounts.Count do
        Accounts[num-1].OldNum := num;
      // move
      Accounts.Move(old,new);
      tabMail.Tabs.Move(old,new);
      tabAccounts.Tabs.Move(old,new);
      SwitchTimer;
      // select
      (Sender as TTabControl).TabIndex := new;
      // show icons
      for num := 1 to Accounts.Count do
        ShowIcon(num, itNormal);
      // create mapping array
      SetLength(map,Accounts.Count);
      for num := 1 to Accounts.Count do
        map[Accounts[num-1].OldNum-1] := num;
      // fix rules
      FillRuleAccounts;
      for i := 0 to Rules.Count-1 do
        if Rules[i].Account > 0 then
          Rules[i].Account := map[Rules[i].Account-1];
      lstRulesClick(lstRules);
      SetLength(map,0);
      // save
      for num := 1 to Accounts.Count do
        SaveAccountINI(num);
      SaveRulesINI;
    finally
      Screen.Cursor := crDefault;
    end;
  end;
end;

procedure TSpamLearnerMainForm.lstRulesDragDrop(Sender, Source: TObject; X, Y: Integer);
var
  new,old : integer;
begin
  // get old/new
  new := (Sender as TCheckListBox).ItemAtPos(Point(X,Y),True);
  if new < 0 then new := (Sender as TCheckListBox).Count-1;
  old := (Sender as TCheckListBox).ItemIndex;
  if (old <> new) and (Screen.Cursor <> crHourGlass) then
  begin
    Screen.Cursor := crHourGlass;
    try
      // move
      Rules.Move(old,new);
      (Sender as TCheckListBox).Items.Move(old,new);
      // select
      (Sender as TCheckListBox).ItemIndex := new;
      // show change
      lstRulesClick(lstRules);
      FRuleChanged := True;
      EnableRuleButtons;
    finally
      Screen.Cursor := crDefault;
    end;
  end;
end;

procedure TSpamLearnerMainForm.actSuspendSoundExecute(Sender: TObject);
begin
  UpdateTrayIcon;
end;

procedure TSpamLearnerMainForm.panMailButtonsResize(Sender: TObject);
var
  newwidth : integer;
begin
  newwidth := panMailButtons.Width div 3;
  btnStartProgram.Width := newwidth + 16;
  btnStartProgram.Left := 5;
  btnCheckAll.Width := newwidth + 16;
  btnCheckAll.Left := panMailButtons.Width div 2 - btnCheckAll.Width div 2 + 33;
  btnToTray.Width := newwidth - 50;
  btnToTray.Left := panMailButtons.Width - btnToTray.Width - 5;
end;

procedure TSpamLearnerMainForm.tabMailDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept := (Sender = Source);
end;

procedure TSpamLearnerMainForm.lstRulesDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
var
  save : integer;
  CursorPos: TPoint;
begin
  Accept := (Sender = Source);
  // bit of a hack to prevent false dragging
  if GetKeyState(VK_LBUTTON) >= 0 then
  begin
    save := lstRules.ItemIndex;
    (Sender as TControl).EndDrag(False);
    lstRules.ItemIndex := save;
    Exit;
  end;

  // scroll
  if (Y < 10) or (Y > lstRules.Height-10) then
  begin
    GetCursorPos(CursorPos);
    CursorPos := lstRules.ScreenToClient(CursorPos);
    while (CursorPos.X = X) and (CursorPos.Y = Y) do
    begin
      if GetAsyncKeyState(VK_LBUTTON) >= 0 then Exit;
      if (Y < 10) then
        SendMessage(lstRules.Handle,WM_VSCROLL,SB_LINEUP,0)
      else
        SendMessage(lstRules.Handle,WM_VSCROLL,SB_LINEDOWN,0);
      //Application.ProcessMessages;
      Sleep(50);
      GetCursorPos(CursorPos);
      CursorPos := lstRules.ScreenToClient(CursorPos);
    end;
  end;
end;

procedure TSpamLearnerMainForm.lstRulesKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  ShowRule(lstRules.ItemIndex);
end;

procedure TSpamLearnerMainForm.actSpamExecute(Sender: TObject);
//var
//  i : integer;
begin
  if Assigned(FSpamAction) then
    FSpamAction.Execute
  else begin
    {if Assigned(MailToolBar.ActionClient) then
      for i := 0 to MailToolBar.ActionClient.Items.Count-1 do
        if (MailToolBar.ActionClient.Items[i].Action = actSpam) and
           (MailToolBar.ActionClient.Items[i].Items.Count = 0) then
        begin
          MailToolBar.ActionClient.Items[i].Items.Add.Action := actDeleteSpam;
          MailToolBar.ActionClient.Items[i].Items.Add.Caption := '-';
          MailToolBar.ActionClient.Items[i].Items.Add.Action := actMarkSpam;
          MailToolBar.ActionClient.Items[i].Items.Add.Action := actUnmarkSpam;
          MailToolbar.RecreateControls;
        end;}
  end;
end;

procedure TSpamLearnerMainForm.MailToolBarGetControlClass(Sender: TCustomActionBar;
  AnItem: TActionClient; var ControlClass: TCustomActionControlClass);
begin
  if (Sender.ActionClient.Items[AnItem.Index].Action = actSpam) and
     (Sender.ActionClient.Items[AnItem.Index].Items.Count = 0) then
  begin
    Sender.ActionClient.Items[AnItem.Index].Items.Add.Action := actDeleteSpam;
    Sender.ActionClient.Items[AnItem.Index].Items.Add.Caption := '-';
    Sender.ActionClient.Items[AnItem.Index].Items.Add.Action := actMarkSpam;
    Sender.ActionClient.Items[AnItem.Index].Items.Add.Action := actUnmarkSpam;
  end;
  ControlClass := MailToolbar.Style.GetControlClass(Sender,Sender.ActionClient.Items[AnItem.Index]);
end;

procedure TSpamLearnerMainForm.lstRulesKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_DELETE then actRuleDelete.Execute;
end;

procedure TSpamLearnerMainForm.chkRuleProtectClick(Sender: TObject);
begin
  EnableRuleButtons;
  if lstRules.ItemIndex > -1 then
    Rules[lstRules.ItemIndex].Protect := chkRuleProtect.Checked;
end;

procedure TSpamLearnerMainForm.lvMailCustomDrawItem(Sender: TCustomListView;
  Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
begin
  if Options.ShowViewed then
  begin
    if Item.StateIndex>0 then
      Sender.Canvas.Font.Style := [fsBold]
    else
      Sender.Canvas.Font.Style := [];

    // determine if message was previewed
    if not GetViewed(tabMail.tabIndex, Item) then
     Sender.Canvas.Font.Style := [fsBold] // not viewed
    else
     Sender.Canvas.Font.Style := []; // viewe
  end;
end;

function GetWelcomeMessage(Host : string; Port : integer) : string;
var
  TCP : TIdTCPClient;
begin
  try
    TCP := TIdTCPClient.Create(nil);
    try
      TCP.Host := Host;
      TCP.Port := Port;
      TCP.Connect(Options.TimeOut*1000);
      TCP.GetResponse([]);
      Result := {TCP.LastCmdResult.TextCode + ' ' +} TCP.LastCmdResult.Text.Text;
      TCP.Disconnect;
    finally
      TCP.Free;
    end;
  except
    // ignore
  end;
end;

procedure TSpamLearnerMainForm.actTestAccountExecute(Sender: TObject);
var
  msgcount,num : integer;
  info,st : string;
  sl : TStringList;
begin
  if tabAccounts.TabIndex < 0 then
   Exit;
  Screen.Cursor := crHourGlass;
  try
    num := tabAccounts.TabIndex+1;
    SaveAccountNum(num);
    ConnectAccount(num);
    try
      msgcount := Accounts[num-1].Prot.CheckMessages;
      info := Translate('Login OK') + #13#10;
      info := info + Translate('Message Count:')+' ' +IntToStr(msgcount) + #13#10#13#10;
      sl := TStringList.Create;
      try
        if GetUIDs(num,sl) then
        begin
          st := Translate('Supported');
          if (msgcount>0) and (sl.Text='') then st := st + ' (' + Translate('Empty') + ')';
        end
        else begin
          st := Translate('NOT Supported');
        end;

        info := info + Translate('Quick Checking and Safe Delete (UIDL):')+' '+st;
      finally
        sl.Free;
      end;
    finally
      Accounts[num-1].Prot.Disconnect;
      if Accounts[num-1].Port in [110,143] then
        info := GetWelcomeMessage(Accounts[num-1].Server,Accounts[num-1].Port) + #13#10 + info;
      Screen.Cursor := crDefault;
      ShowMemo(Translate('Connection Info'),info,450,250);
    end;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TSpamLearnerMainForm.tabMailChanging(Sender: TObject;
  var AllowChange: Boolean);
begin
  ShowIcon(tabMail.TabIndex+1,itNormal);
end;

procedure TSpamLearnerMainForm.lvVolunteersChange(Sender: TObject; Item: TListItem; Change: TItemChange);
begin
  // language volunteers translate
  Item.Caption := Translate(Item.Caption);
end;

procedure TSpamLearnerMainForm.btnWizardClick(Sender: TObject);
begin
  with TformSetup.Create(Self) do
   try
    ShowModal;
   finally
    Free;
   end;
  btnSpamClick(Self);
end;

procedure TSpamLearnerMainForm.FormShow(Sender: TObject);
begin
  if StartWizard and (not AlreadyStarted) then
  begin
    AlreadyStarted := True;
    PageControl.ActivePageIndex := 1;
    with TWelcomeForm.Create(Self) do
     try
       ShowModal;
       if ModalResult = mrOK then
        if EMailClient.ItemIndex = 0 then
          btnImportClick(Self)
        else
          btnWizardClick(Self);
     finally
      Free;
     end;
  end;
  btnSpamClick(Self);
end;

procedure TSpamLearnerMainForm.memoMessageChange(Sender: TObject);
begin
  // change save options
  btnSaveSettings.Enabled := True;
end;

procedure TSpamLearnerMainForm.btnSaveSettingsClick(Sender: TObject);
var F: TAutorespondFile;
    Content: TAutorespond;
    I: Integer;
begin
  { Save autorespond settings }
  AssignFile(F, ExtractFilePath(Application.ExeName)+'Autorespond.dat');
  Rewrite(F);
  Content.Subject := editSubject.Text;
  Content.LengthMsg := Length(memoMessage.Text);
  for I:=1 to Content.LengthMsg do
    Content.Msg[I] := memoMessage.Text[I];
  Content.Msg[Content.LengthMsg+1] := #0;
  Content.ID := editID.Text;
  Write(F, Content);
  CloseFile(F);
  { Disable button }
  btnSaveSettings.Enabled := False;
end;

procedure TSpamLearnerMainForm.LoadAutorespondSettings;
var F: TAutorespondFile;
    Content: TAutorespond;
    I: Integer;
    S: String;
begin
  { Load autorespond settings }
  if not FileExists(ExtractFilePath(Application.ExeName)+'Autorespond.dat') then
   Exit;
  AssignFile(F, ExtractFilePath(Application.ExeName)+'Autorespond.dat');
  Reset(F);
  Read(F, Content);
  editSubject.Text := Content.Subject;
  S := '';
  for I:=1 to Content.LengthMsg do
    S := S + Content.Msg[I];
  memoMessage.Text := S;
  editID.Text := Content.ID;
  CloseFile(F);
  { Disable button }
  btnSaveSettings.Enabled := False;
end;

procedure TSpamLearnerMainForm.btnCancelListsClick(Sender: TObject);
begin
  { Cancel }
  // white / black list
  if FileExists(IniPath+'WhiteList.dat') then
    Options.WhiteList.LoadFromFile(IniPath+'WhiteList.dat')
  else
    Options.WhiteList.Clear;
  if FileExists(IniPath+'BlackList.dat') then
    Options.BlackList.LoadFromFile(IniPath+'BlackList.dat')
  else
    Options.BlackList.Clear;

  SendMessage(frame.Handle, WM_RELOAD, 0, 0);
  FListsChanged := False;
  btnSaveLists.Enabled := False;
  btnCancelLists.Enabled := False;
end;

procedure TSpamLearnerMainForm.btnSaveListsClick(Sender: TObject);
var URL: String; I: Integer; Resp: TStream;

procedure SendPostData(URL: TStringList);
var
  data: TIdMultiPartFormDataStream;
  I: Integer;
begin
  data := TIdMultiPartFormDataStream.Create;
  try
    { add the used parameters for the script }
    for I:=0 to URL.Count - 1 do
     data.AddFormField(IntToStr(I), URL[I]);
    { Call the Post method of TIdHTTP and read the result into TMemo }
    HTTP.Post('http://wrm.modwest.com/spampost/verify_data.php', data);
  finally
    data.Free;
  end;
end;

begin
  // white/black list
  if Options.WhiteList.Count>0 then
    Options.WhiteList.SaveToFile(ExtractFilePath(IniName)+'WhiteList.dat')
  else
    DeleteFile(ExtractFilePath(IniName)+'WhiteList.dat');
  if Options.BlackList.Count>0 then
    Options.BlackList.SaveToFile(ExtractFilePath(IniName)+'BlackList.dat')
  else
    DeleteFile(ExtractFilePath(IniName)+'BlackList.dat');
  FListsChanged := False;
  btnSaveLists.Enabled := False;
  btnCancelLists.Enabled := False;

  // send this info to the web
  if not UpdateNotRequired then
  if Options.UpdateBlockList then
  begin
    if NewEmails.Count > 0 then
      SendPostData(NewEmails);
    NewEmails.Clear;
  end;
end;

procedure TSpamLearnerMainForm.btnSpamClick(Sender: TObject);
begin
  PageControl.ActivePageIndex := 0;
  PageControlChange(Self);
  btnSpam.Down := True;
end;

procedure TSpamLearnerMainForm.btnAccountsClick(Sender: TObject);
begin
  PageControl.ActivePageIndex := 1;
  PageControlChange(Self);
  btnAccounts.Down := True;
end;

procedure TSpamLearnerMainForm.btnSettingsClick(Sender: TObject);
begin
  PageControl.ActivePageIndex := 2;
  PageControlChange(Self);
  btnSettings.Down := True;
end;

procedure TSpamLearnerMainForm.btnListsClick(Sender: TObject);
begin
  PageControl.ActivePageIndex := 4;
  PageControlChange(Self);
  btnLists.Down := True;
end;

procedure TSpamLearnerMainForm.edNameKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key in ['\','/','?','*',':','"','<','>','|']) then
   Key := #0;
end;

procedure TSpamLearnerMainForm.btnImportClick(Sender: TObject);
begin
  { Outlook Import Wizard }
  with TOutlookWizardForm.Create(Self) do
   try
     ShowModal;
   finally
     Free;
   end;
end;

procedure TSpamLearnerMainForm.btnAddressBookClick(Sender: TObject);
begin
  with TAddressBookForm.Create(Self) do
   try
    ShowModal;
   finally
    Free;
   end;
end;

function TSpamLearnerMainForm.ValidRegistration(UserName, RegCode: String): Boolean;
var S, K: String;

function GetKey(S: String): String;
begin
  Result := Copy(S, 1, 5); // first 5 nr. are random = key
  // the nr. at position 6 is totally random :P
end;

function GetCode(S: String): String;
begin
  Result := Copy(S, 8, Length(S)-7); // the rest is the code
end;

function GetUser(S: String): String;
begin
  while (Length(S) < 40) do
   S := S + ' ';
  Result := S;
end;

function Eliminate(Ch: Char; S: String): String;
begin
  while Pos(Ch,S) <> 0 do
   Delete(S, Pos(Ch, S), 1);
  Result := S;
end;

begin
 Result := False;
 try
  // checks to see if the reg. data is valid
  // 10 groups of 6 letters
  if Length(RegCode) < 60+9 then
   begin
     Result := False;
     Exit;
   end;
  K := GetKey(RegCode); // get key used to encrypt
  S := GetCode(RegCode); // get code
  S := B64Decode(Eliminate('-',S));
  _DecryptString(K, S);
  Result := GetKey(RegCode) + GetUser(UserName) = S;
 except
 end;
end;

procedure TSpamLearnerMainForm.Check_It;
var
  RINIFile: TRegINIFile;
  d1,d2: TDateTime;
  X1: String;

  a,c: integer;
  s1: string;

Function Crypt(S : String) : String;
(* xor can be used to *toggle* values.  In this Case it is toggling  *)
(* Character of the String based on its postion in the String.  This *)
(* ensures that the mask is always known For the pupose of decoding. *)
  Var
    i : Byte;
  begin
    For i := 1 to Length(S) Do
      S[i] := Char(ord(S[i]) xor i);
    Crypt := S;
  end;

begin
 try
  RIniFile := TRegIniFile.Create('');
  RINIFile.RootKey := HKEY_CURRENT_USER;
  { HKEY_CURRENT_USER\Microsoft\Windows\CurrentVersion\Data\ }
  RINIFile.OpenKey('Software\Microsoft\Windows\CurrentVersion',True);

  { encrypted DATE-TIMES. ex: 35517-15 }

  X1:=RIniFile.ReadString('SMData','Product', '');
  if X1 = 'Windows' then // expired
   begin
     DaysLeft := -1;
     Exit;
   end;
  X1:=RIniFile.ReadString('SMData','Product_Id', '');
  if X1='' then {not exists}
   begin
     // first run, write date
     RIniFile.WriteString('SMData','Product_Id',Crypt(DateTimeToStr(Date)+'-1'));

     TimesRun := 1;
     DaysLeft := 13;
   end
  else
   begin
     x1 := Crypt(x1);

     a:=pos('-',x1);
     s1:=copy(x1,1,a-1);
     d1:=StrToDateTime(s1); //date

     // expired?
     d2:=Date;
     c:=length(x1);
     x1:=copy(x1,a+1,c);

     TimesRun:=StrToInt(x1)+1;
     DaysLeft:=14-Round(d2-d1);

     // rewrite strings
     RIniFile.WriteString('SMData','Product_Id',Crypt(DateTimeToStr(d1)+'-'+IntToStr(TimesRun)));
     // expired?
     if DaysLeft < 0 then
      RIniFile.WriteString('SMData','Product','Windows');
   end;
  RINiFile.Free;
 except
 end;
end;

procedure TSpamLearnerMainForm.actTrainSpamFilterExecute(Sender: TObject);
var I: Integer;
    FPath: String;
    SL: TStringList;
    num: Integer;
    Found: Boolean;
    Item: TListItem;

procedure ClassifySpam(num: Integer; Item: TListItem);
var P, Q: TUnknownMsg;
begin
  P := Accounts[num].UnknownMessages;
  if P = nil then Exit;
  if (P^.Account.From = Item.Caption) and (P^.Account.MailTo = Item.SubItems[0]) and
    (P^.Account.Subject = Item.SubItems[1]) {and (P^.Account.Date = StrToDate(Item.SubItems[2]))} and
    (IntToStr(P^.Account.Size)+' '+Translate('KB') = Item.SubItems[3]) and (UpperCase(P^.Account.Path) = UpperCase(Item.SubItems[6])) then
    begin // this is it!!!
      P^.Account.Spam := True;
    end
  else
  if P^.Next <> nil then
  begin
    while (P^.Next <> nil) and (P^.Next^.Account.From <> Item.Caption) and (P^.Next^.Account.MailTo <> Item.SubItems[0]) and
          (P^.Next^.Account.Subject <> Item.SubItems[1]) and {(P^.Next^.Account.Date <> StrToDate(Item.SubItems[2])) and}
          (IntToStr(P^.Next^.Account.Size)+' '+Translate('KB') <> Item.SubItems[3]) and (UpperCase(P^.Account.Path) <> UpperCase(Item.SubItems[6])) do
      P := P^.Next;
    if P^.Next <> nil then  // found it !!!
    begin
      P^.Next^.Account.Spam := True;
    end;
  end;
end;

begin
  if lvMail.Selected = nil then
  begin
    Application.MessageBox('Please select at least one e-mail from the list.', 'Warning', MB_OK+MB_ICONWARNING);
    Exit;
  end;
  num := tabMail.TabIndex+1;
  Found := False;
  I := 0;
  while I<=lvMail.Items.Count-1 do
  begin
    if lvMail.Items[I].Selected then
    begin
     // train spam filter
   FPath := lvMail.Items[I].SubItems[6];;
   if not FileExists(FPath) then
    Application.MessageBox('Cannot train filter with this e-mail. It may have been deleted.', 'Train Filter', MB_OK+MB_ICONINFORMATION)
   else
   begin
     Found := True;
     if Application.MessageBox(PChar('Please classify this e-mail:'+#13#10#13#10+'From: '+#9+lvMail.Items[I].Caption+#13#10+'Subject:'+#9+lvMail.Items[I].SubItems[1]+#13#10#13#10+'Is this a spam e-mail?'), 'Question', MB_YESNO+MB_ICONQUESTION)=mrYes then
     begin
       //
       OpenFilter(Accounts[num-1].Name);
       SL := TStringList.Create;
       SL.LoadFromFile(FPath);
       Teach(SL.Text, 1);
       SL.Free;
       CloseFilter();
       // now add this e-mail to the spam category
       Item := SpamList.Items.Add;
       Item.Assign(lvMail.Items[I]);
       ClassifySpam(num-1, Item);
       lvMail.Items.  Delete(I);
       Dec(I);
     end
     else
     begin
       OpenFilter(Accounts[num-1].Name);
       SL := TStringList.Create;
       SL.LoadFromFile(FPath);
       Teach(SL.Text, 0);
       SL.Free;
       CloseFilter();
     end;
   end;
  end;
   Inc(I);
  end;
  if not Found then
    Application.MessageBox('Please select one or more messages to perform this action.', 'Warning', MB_OK+MB_ICONWARNING)
  else
  begin
    SaveAccountInfo(num);
    Application.MessageBox('Bayesian filter training complete.', 'Information', MB_OK+MB_ICONINFORMATION);
  end;
end;

procedure TSpamLearnerMainForm.SpamListInfoTip(Sender: TObject; Item: TListItem;
  var InfoTip: String);
var
  MailItem : TMailItem;
begin
  InfoTip := '';
  if SpamList.ScreenToClient(Mouse.CursorPos).X  < SpamList.Columns[0].Width then
  if Item.ImageIndex <> 18 then
  begin
    MailItem := SelectedMailItem(Item);
    if MailItem <> nil then
      InfoTip := MailItem.Address;
  end
end;

procedure TSpamLearnerMainForm.SetSortColumn2(ColNum : integer);
////////////////////////////////////////////////////////////////////////////////
// Set the column to sort by
begin
  // remove sort indicator
  if FSortColumn2 >= 0 then
    SetColumnImage(SpamList,FSortColumn2,-1);
  // new col
  FSortColumn2 := ColNum;
  // sort column
  SpamList.AlphaSort;
  // add sort indicator
  if ColNum >= 0 then
  begin
    if FSortDirection2 = sdAsc then
      SetColumnImage(SpamList,FSortColumn2,mSortAsc)
    else
      SetColumnImage(SpamList,FSortColumn2,mSortDesc);
  end;
end;

procedure TSpamLearnerMainForm.SpamListColumnClick(Sender: TObject;
  Column: TListColumn);
begin
  // direction
  if FSortColumn2 = Column.Index then
    FSortDirection2 := sdDesc * FSortDirection2
  else
    FSortDirection2 := sdAsc;
  // column
  SetSortColumn2(Column.Index);
end;

procedure TSpamLearnerMainForm.SpamListCompare(Sender: TObject; Item1,
  Item2: TListItem; Data: Integer; var Compare: Integer);
begin
  case FSortColumn2 of
    -2 : Compare := CompareInt(IntToStr(Item1.ImageIndex),IntToStr(Item2.ImageIndex));  //status
    -1 : Compare := CompareInt(Item1.SubItems[4],Item2.SubItems[4]);                    //no sort
    0  : Compare := CompareText(Item1.Caption,Item2.Caption);                           //from
    2  : Compare := CompareText(StripSubjectPrefix(Item1.SubItems[1]),
                                StripSubjectPrefix(Item2.SubItems[1]));                 //subject
    3  : Compare := CompareDate(Item1.SubItems[2],Item2.SubItems[2]);                   //date
    4  : Compare := CompareInt(Item1.SubItems[3],Item2.SubItems[3]);                    //size
  else
   Compare := CompareText(Item1.SubItems[FSortColumn2 - 1],
                          Item2.SubItems[FSortColumn2 - 1]);
  end;
  Compare := FSortDirection2 * Compare;
end;

procedure TSpamLearnerMainForm.SpamListDblClick(Sender: TObject);
begin
  actPreviewSpam.Execute;
end;

procedure TSpamLearnerMainForm.actPreviewSpamExecute(Sender: TObject);
var FPath: String;
    SL: TStringList;
    TmpStream: TMemoryStream;
    num, i: Integer;
    Sel: TListItem;

function Go(Sub: String; SL: TStringList): String;
var I: Integer; S: String;
begin
  Result := '';
  for I:=0 to SL.Count-1 do
  begin
    if Pos(UpperCase(Sub), UpperCase(SL[I]))=1 then
     begin
       S := SL[I];
       Delete(S, 1, Length(Sub)+1);
       Result := S;
       Break;
     end;
  end;
end;

function GoText(SL: TStringList): String;
var S: String; X: TStringList;
begin
  Result := '';
  X := TStringList.Create;
  X.Text := SL.Text;
  try
    while (X.Count > 0) and (X[0] <> '') do
     X.Delete(0);
    X.Delete(0);
  except
  end;
  Result := X.Text;
  X.Free;
end;

begin
  num := tabMail.TabIndex;
  Sel := SpamList.Selected;
  if SpamList.Selected = nil then
    TranslateDlg(Translate('No message selected.'), mtError, [mbOK], 0)
  else
  if SpamList.Selected.ImageIndex = 18 then
  begin
    try
      FPath := SpamList.Selected.SubItems[6];;
      if not FileExists(FPath) then
      begin
        Application.MessageBox('Cannot preview this e-mail. It may have been deleted.', 'Preview', MB_OK+MB_ICONINFORMATION);
        Exit;
      end;
      // set this as viewed
      SetViewed(tabMail.tabIndex, SpamList.Selected);
      // continue previewing
      frmPreview := TfrmPreview.Create(Application);
      frmPreview.IniName := IniName;
      frmPreview.GetINI;
      frmPreview.actDelete.Enabled := False;
      frmPreview.actDelete.Hint := Translate('Delete this message from the list');
      frmPreview.panProgress.Visible := False;
      SL := TStringList.Create;
      SL.LoadFromFile(FPath);
      frmPreview.FRawMsg := SL.Text;
      frmPreview.edFrom.Text := Go('From', SL);
      frmPreview.panPreviewFrom.Visible := frmPreview.edFrom.Text <> '';
      frmPreview.edTo.Text := Go('To', SL);
      frmPreview.panPreviewTo.Visible := frmPreview.edTo.Text <> '';
      frmPreview.edCC.Text := Go('CC', SL);
      frmPreview.panPreviewCC.Visible := frmPreview.edCC.Text <> '';
      frmPreview.edDate.Text := Go('Date', SL);
      frmPreview.panPreviewDate.Visible := frmPreview.edDate.Text <> '';
      frmPreview.edSubject.Text := Go('Subject', SL);
      frmPreview.panPreviewSubject.Visible := frmPreview.edSubject.Text <> '';
      frmPreview.edXMailer.Text := Go('XMailer', SL);
      frmPreview.panPreviewXMailer.Visible := frmPreview.edXMailer.Text <> '';

      frmPreview.DontProcess := True;
      frmPreview.memMail.Text := GoText(SL);
      frmPreview.Resume := frmPreview.memMail.Text;
      frmPreview.Show;

      SL.Free;
      // show contents
      Screen.Cursor := crDefault;

      SaveAccountInfo(tabMail.tabIndex+1);
    except
      frmPreview.DontProcess := False;
      Application.MessageBox('Cannot preview this e-mail.', 'Preview', MB_OK+MB_ICONINFORMATION)
    end;
  end
  else
    Preview(tabMail.TabIndex+1);
end;

procedure TSpamLearnerMainForm.SpamListClick(Sender: TObject);
begin
  if SpamList.Selected = nil then
  begin
    actMarkSpamAsViewed.Enabled := False;
    actPreviewSpam.Enabled := False;
    act_DeleteSpam.Enabled := False;
    act_UnmarkSpam.Enabled := False;
  end
  else
  begin
    actMarkSpamAsViewed.Enabled := True;
    actPreviewSpam.Enabled := True;
    act_DeleteSpam.Enabled := True;
    act_UnmarkSpam.Enabled := True;
  end;
end;

procedure TSpamLearnerMainForm.act_DeleteSpamExecute(Sender: TObject);
var I: Integer;

procedure DeleteEMail(num: Integer; Item: TListItem);
var P, Q: TUnknownMsg;
begin
  P := Accounts[num].UnknownMessages;
  if P = nil then Exit;
  if (P^.Account.From = Item.Caption) and (P^.Account.MailTo = Item.SubItems[0]) and
    (P^.Account.Subject = Item.SubItems[1]) {and (P^.Account.Date = StrToDate(Item.SubItems[2]))} and
    (IntToStr(P^.Account.Size)+' '+Translate('KB') = Item.SubItems[3]) and (UpperCase(P^.Account.Path) = UpperCase(Item.SubItems[6])) then
    begin // this is it!!!
      DeleteFile(ExtractFilePath(Application.ExeName)+'Junk\'+Accounts[num].UnknownMessages^.Account.Path);
      Accounts[num].UnknownMessages := Accounts[num].UnknownMessages^.Next;
      Dispose(P);
    end
  else
  if P^.Next <> nil then
  begin
    while (P^.Next <> nil) and (P^.Next^.Account.From <> Item.Caption) and (P^.Next^.Account.MailTo <> Item.SubItems[0]) and
          (P^.Next^.Account.Subject <> Item.SubItems[1]) and {(P^.Next^.Account.Date <> StrToDate(Item.SubItems[2])) and}
          (IntToStr(P^.Next^.Account.Size)+' '+Translate('KB') <> Item.SubItems[3]) and (UpperCase(P^.Account.Path) <> UpperCase(Item.SubItems[6])) do
      P := P^.Next;
    if P^.Next <> nil then  // found it !!!
    begin
      Q := P^.Next;
      DeleteFile(ExtractFilePath(Application.ExeName)+'Junk\'+Q^.Account.Path);
      P^.Next := P^.Next^.Next;
      Dispose(Q);
    end;
  end;
end;

begin
  // delete spam e-mail from list
  I := 0;
  while I<=SpamList.Items.Count-1 do
  begin
    if SpamList.Items[I].Selected then
    begin
      DeleteEMail(tabMail.tabIndex, SpamList.Selected);
      SpamList.Items.Delete(I);
      Dec(I);
    end;
    Inc(I);
  end;
  SpamListClick(Self);
  SaveAccountInfo(tabMail.tabIndex+1);
end;

procedure TSpamLearnerMainForm.act_UnmarkSpamExecute(Sender: TObject);
var I: Integer;

procedure ClassifySpam(num: Integer; Item: TListItem);
var P, Q: TUnknownMsg;
begin
  P := Accounts[num].UnknownMessages;
  if P = nil then Exit;
  if (P^.Account.From = Item.Caption) and (P^.Account.MailTo = Item.SubItems[0]) and
    (P^.Account.Subject = Item.SubItems[1]) {and (P^.Account.Date = StrToDate(Item.SubItems[2]))} and
    (IntToStr(P^.Account.Size)+' '+Translate('KB') = Item.SubItems[3]) and (UpperCase(P^.Account.Path) = UpperCase(Item.SubItems[6])) then
    begin // this is it!!!
      P^.Account.Spam := False;
    end
  else
  if P^.Next <> nil then
  begin
    while (P^.Next <> nil) and (P^.Next^.Account.From <> Item.Caption) and (P^.Next^.Account.MailTo <> Item.SubItems[0]) and
          (P^.Next^.Account.Subject <> Item.SubItems[1]) and {(P^.Next^.Account.Date <> StrToDate(Item.SubItems[2])) and}
          (IntToStr(P^.Next^.Account.Size)+' '+Translate('KB') <> Item.SubItems[3]) and (UpperCase(P^.Account.Path) <> UpperCase(Item.SubItems[6])) do
      P := P^.Next;
    if P^.Next <> nil then  // found it !!!
    begin
      P^.Next^.Account.Spam := False;
    end;
  end;
end;

var Item: TListItem;
begin
  // unmark spam e-mail as incoming
  I := 0;
  while I<=SpamList.Items.Count-1 do
  begin
    if SpamList.Items[I].Selected then
    begin
      ClassifySpam(tabMail.tabIndex, SpamList.Items[I]); // declassify
      // move from this list to the other
      Item := lvMail.Items.Add;
      Item.Assign(SpamList.Items[I]);
      SpamList.Items.Delete(I);
      Dec(I);
    end;
    Inc(I);
  end;
  SpamListClick(Self);
  SaveAccountInfo(tabMail.tabIndex+1);
end;

procedure TSpamLearnerMainForm.actEmptyExecute(Sender: TObject);
var I: Integer;
begin
  if tabMail.tabIndex < 0 then Exit;
  if Application.MessageBox('Are you sure you want to empty the spam e-mail list?', 'Warning', MB_YESNO+MB_ICONQUESTION)=mrNo then Exit;
  // empty spam list
  for I:=0 to SpamList.Items.Count-1 do
   SpamList.Items[I].Selected := True;
  act_DeleteSpam.Execute;
  SpamListClick(Self);
  SaveAccountInfo(tabMail.tabIndex+1);
end;

procedure TSpamLearnerMainForm.SaveAccountInfo(num: Integer);
var
    F: file of Info;
    P: TUnknownMsg;
begin
  // we must save account information for this account!!!
  {$I-}
  if not DirectoryExists(ExtractFilePath(Application.ExeName)+'Accounts') then
  begin
    MkDir(ExtractFilePath(Application.ExeName)+'Accounts');
    {Set attributes}
    FileSetAttr(ExtractFilePath(Application.ExeName)+'Accounts', faHidden or faArchive or faDirectory);
    if IOResult <> 0 then Exit; { Error }
  end;
  {$I+}
  try
    AssignFile(F, ExtractFilePath(Application.ExeName)+'Accounts\'+Accounts[num-1].Name+'.dat');
    Rewrite(F);
    P := Accounts[num-1].UnknownMessages;
    while (P <> nil) do
    begin
      Write(F, P^.Account);
      P := P^.Next;
    end;
    if FileSize(F)=0 then
    begin
      CloseFile(F);
      DeleteFile(ExtractFilePath(Application.ExeName)+'Accounts\'+Accounts[num-1].Name+'.dat');
    end
    else
     CloseFile(F);
  except
    { Error }
  end;
end;

procedure TSpamLearnerMainForm.SpamListCustomDrawItem(Sender: TCustomListView;
  Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
begin
  if Options.ShowViewed then
  begin
    // determine if message was previewed
    if not GetViewed(tabMail.tabIndex, Item) then
     Sender.Canvas.Font.Style := [fsBold] // not viewed
    else
     Sender.Canvas.Font.Style := []; // viewe
  end;
end;

procedure TSpamLearnerMainForm.actMarkSpamAsViewedExecute(Sender: TObject);
var
  i : integer;
begin
  for I:=0 to SpamList.Items.Count-1 do
   if SpamList.Items[I].Selected then
    SetViewed(tabMail.tabIndex, SpamList.Items[I]);
end;

end.
