#include "Tools.h"

Tools::Tools()
{
	m_log = NULL;
	m_hModule = NULL;

	LogOpen();
}

Tools::Tools(HINSTANCE	hModule)
{
	m_log = NULL;
	m_hModule = NULL;

	if (hModule != NULL)
	{
		m_hModule = hModule;
	}

	m_logState = CheckLogging();
	if (m_logState > 0)
	{
		LogOpen();
	}
}

Tools::~Tools()
{
	if (m_logState > 0)
	{
		LogClose();
	}
}

// String manipulation

BSTR Tools::Trim(BSTR bstrString)
{
	wstring wsDest;
	wstring wsSrc;
	wstring::size_type iStart, iEnd;

	if (bstrString != NULL)
	{
		wsSrc = bstrString;
		if ( !wsSrc.empty() )
		{
			iStart = wsSrc.find_first_not_of(SPACE_CHARS);
			iEnd = wsSrc.find_last_not_of(SPACE_CHARS);
			if (iStart != -1 && iEnd != -1)
			{
				wsDest = wstring(wsSrc, iStart, iEnd - iStart + 1);
			}
		}
	}
	return _bstr_t(wsDest.c_str());
}

BSTR Tools::ItemName(BSTR bstrString)
{
	wstring wsDest;
	wstring wsSrc;
	wstring::size_type iPos;

	if (bstrString != NULL)
	{
		wsSrc = bstrString;
		if ( !wsSrc.empty() )
		{
			iPos = wsSrc.find_last_of(L"/");
			if (iPos != -1)
			{
				wsDest = wsSrc.substr(iPos+1);
			}
		}
	}
	return _bstr_t(wsDest.c_str());
}

BSTR Tools::Mid(BSTR bstrString, int Pos, int Len)
{
	wstring wsDest;
	wstring wsSrc;
	wstring::size_type iStart;
	int iLengte;

	if (bstrString != NULL && Pos>-1)
	{
		wsSrc = bstrString;
		iStart = Pos;
		if (Len<1)
			iLengte = (wsSrc.end()-wsSrc.begin()) - Pos;
		else
			iLengte = Len;

		wsDest = wsSrc.substr( iStart, iLengte );
	}
	return _bstr_t(wsDest.c_str());
}

BSTR Tools::MidStr(BSTR bstrString, BSTR bstrFrom, BSTR bstrTo)
{
	wstring wsDest;
	wstring wsSrc;
	wstring wsFrom;
	wstring wsTo;
	wstring::size_type iStart, iEnd;

	if (bstrString != NULL && bstrFrom != NULL && bstrTo != NULL)
	{
		wsSrc = bstrString;
		wsFrom = bstrFrom;
		wsTo = bstrTo;
		if ( !wsSrc.empty() && wsSrc.length()>wsFrom.length() )
		{
			iStart = wsSrc.find(wsFrom);
			if ( iStart < wsSrc.length() )
			{
				iStart += wsFrom.length();
				if ( !wsTo.empty() )
				{
					iEnd = wsSrc.find(wsTo, iStart);
					wsDest = wsSrc.substr( iStart, iEnd-iStart );
				}
				else
				{
					wsDest = wsSrc.substr( iStart );
				}
			}
		}
	}
	return Trim(_bstr_t(wsDest.c_str()));
}

BSTR Tools::Replace(BSTR bstrString, BSTR bstrOldStr, BSTR bstrNewStr)
{
	wstring wsDest;
	wstring wsOld;
	wstring wsNew;
	wstring::size_type iPos, iFound;

	if (bstrString != NULL && bstrOldStr != NULL && bstrNewStr != NULL)
	{
		wsDest = bstrString;
		wsOld = bstrOldStr;
		wsNew = bstrNewStr;
		iPos = 0;
		iFound = wsDest.find(wsOld);
		while ( iFound!=wstring::npos && !wsDest.empty() && iFound<=wsDest.length() && iFound>=iPos )
		{
			iPos = iFound;
			wsDest.replace( iPos, wsOld.length(), wsNew);
			iPos+= wsNew.length();
			iFound = wsDest.find(wsOld, iPos);
		}
	}
	return _bstr_t(wsDest.c_str());
}

BSTR Tools::Remove(BSTR bstrString, BSTR bstrDelStr)
{
	return Replace(bstrString, bstrDelStr, L"");
}

int Tools::InStr(BSTR bstrString, BSTR bstrFind)
{
	wstring wsSrc;
	wstring wsFind;
	wstring::size_type Pos;
	int iRet = -1;

	if (bstrString != NULL && bstrFind != NULL)
	{
		wsSrc = bstrString;
		wsFind = bstrFind;
		if ( !wsSrc.empty() && wsSrc.length()>=wsFind.length() )
		{
			Pos = wsSrc.find(wsFind);
			if ( Pos < wsSrc.length() )
			{
				iRet = Pos + 1;
			}
			else
			{
				iRet = 0;
			}
		}
	}
	return iRet;
}

int Tools::Find(BSTR bstrString, BSTR bstrFind, int count)
{
	wstring wsSrc;
	wstring wsFind;
	wstring::size_type Pos=0;
	int iRet = -1;
	int iCnt=0;

	if (bstrString != NULL && bstrFind != NULL)
	{
		wsSrc = bstrString;
		wsFind = bstrFind;
		if ( !wsSrc.empty() && wsSrc.length()>=wsFind.length() )
		{
			for (iCnt=0; iCnt<count; iCnt++)
			{
				Pos = wsSrc.find(wsFind, Pos+1);
				if ( Pos < wsSrc.length() )
				{
					iRet = Pos;
				}
				else
				{
					iRet = wsSrc.length();
					break;
				}
			}
		}
	}
	return iRet;
}

long Tools::stol(BSTR pBuf)
{
	long n;
	BOOL bValid;
	int c;

	bValid = TRUE;
	n = 0;
	while (bValid)
	{
		switch (*pBuf)
		{
		case _T('\0'):
			bValid = FALSE;
			break;
		default:
			if (*pBuf >= _T('0') && *pBuf <= _T('9'))
				c = *pBuf - _T('0');
			else
				bValid = FALSE;
			break;
		}
		if (bValid)
		{
			n = (n * 10) + c;
			pBuf++;
		}
	}

	return n;
}

// Registry

void Tools::setreg()
{
// Set Access Across Domains:
// [HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3] "1406"=dword:00000000

	HKEY regkey;
	REGSAM rsRights = KEY_ALL_ACCESS;

	if (RegOpenKeyEx(HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\3", 0, rsRights, &regkey) == ERROR_SUCCESS)
	{
		DWORD dwOff = 0;
		DWORD dwSetting = 100;
		DWORD dwLen = sizeof(dwSetting);

		if (RegQueryValueEx(regkey, "1406", NULL, NULL, (LPBYTE)&dwSetting, &dwLen) == ERROR_SUCCESS)
		{
			if (dwSetting == 0 )
			{
				LogWrite( "  'Access Across Domains' Security Setting already Enabled" );
			}
			else
			{
				if (RegSetValueEx(regkey, "1406", 0, REG_DWORD, (LPBYTE)&dwOff, sizeof(dwOff)) == ERROR_SUCCESS)
				{
					LogWrite( "  'Access Across Domains' Security Setting set to Enabled" );
				}
				else
				{
					LogWrite( "ERROR: Could not set 'Access Across Domains'\n       If this plugin doen not work please enable 'Access Across Domains' in the Internet Explorer Security Settings." );
				}
			}
		}
		else
		{
			LogWrite( "ERROR: Could not read 'Access Across Domains' Security Setting in Registry!" );
		}

		RegCloseKey(regkey);
	}
	else
	{
		LogWrite( "ERROR: Could not find Internet Explorer Security Zone in Registry!" );
	}
}

// Logging

void Tools::LogOpen()
{
	_bstr_t bsFile;
	TCHAR szModule[_MAX_PATH];

	if (GetModuleFileName(m_hModule, szModule, _MAX_PATH) != 0)
	{
		bsFile  = szModule;
		bsFile  = Mid(bsFile, 0, bsFile.length()-11);
		bsFile += "Hotmail.log";
	}
	
	m_log = CreateFile(	bsFile, GENERIC_WRITE, FILE_SHARE_READ, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
}

void Tools::LogClose()
{
	CloseHandle(m_log);
}

void Tools::LogWrite( char *s )
{
	if (m_logState > 0)
	{
		_bstr_t bsMessage;
		DWORD written;

		SYSTEMTIME st;
		GetLocalTime(&st);
		TCHAR strTime[12];
		sprintf(strTime, "%02d:%02d:%02d ", st.wHour, st.wMinute, st.wSecond);
		
		bsMessage  = strTime;
		bsMessage += s;
		bsMessage += "\n";

		WriteFile(m_log, (char*)bsMessage, bsMessage.length(), &written, 0);
	}
}

void Tools::LogWriteExt( char *s )
{
	if (m_logState == 2)
	{
		LogWrite(s);
	}
}

int Tools::CheckLogging()
{
	int ret = 0; // Disabled by Default

	HKEY regkey;
	REGSAM rsRights = KEY_ALL_ACCESS;

	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, "Software\\SpamBull\\Plugins\\Hotmail", 0 ,rsRights, &regkey) == ERROR_SUCCESS)
	{
		DWORD dwLogging = 100;
		DWORD dwLen = sizeof(dwLogging);

		if (RegQueryValueEx(regkey, "Logging", NULL, NULL, (LPBYTE)&dwLogging, &dwLen) == ERROR_SUCCESS)
		{
			if (dwLogging <= 2 )
			{
				ret = dwLogging;
			}
		}
		RegCloseKey(regkey);
	}
	return ret;
}

void Tools::SetLogging(int State)
{
	HKEY regkey;
	REGSAM rsRights = KEY_ALL_ACCESS;
	DWORD dwLogging = 0;

	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, "Software\\SpamBull\\Plugins\\Hotmail", 0 ,rsRights, &regkey) != ERROR_SUCCESS)
	{
		// create Key
		DWORD Disp;
		if (RegCreateKeyEx(HKEY_LOCAL_MACHINE,"Software\\SpamBull\\Plugins\\Hotmail",0,0,REG_OPTION_NON_VOLATILE,rsRights,0,&regkey,&Disp)!=ERROR_SUCCESS)
		{
			LogWrite( "ERROR: Could not create Logging Registry Key!" );
			return;
		}
	}

	dwLogging = State;
	// Only Change if Logfile is opened already
	if (m_logState > 0 && State > 0)
	{
		m_logState = State;
	}

	if (RegSetValueEx(regkey, "Logging", 0, REG_DWORD, (LPBYTE)&dwLogging, sizeof(dwLogging)) != ERROR_SUCCESS)
	{
		LogWrite( "ERROR: Could not set Logging Registry Value!" );
	}
	RegCloseKey(regkey);
}

// MSXML Check

bool Tools::isMSXMLInstalled()
{
	bool ret = false;

	static _TCHAR	szTemp[TEMP_SIZE];
	static DWORD	dwLen;
	
	try
	{
		HKEY hKey;
		DWORD retCode;

		retCode = RegOpenKeyEx(HKEY_CLASSES_ROOT, 
						_T("CLSID\\{f5078f32-c551-11d3-89b9-0000f81fe221}\\ProgID"), 
						0, 
						KEY_QUERY_VALUE, 
						&hKey);

		if (retCode != ERROR_SUCCESS) return false;

		retCode = RegQueryValueEx(hKey, _T(""), NULL, NULL, (LPBYTE)szTemp, &(dwLen = sizeof(szTemp)));

		if (retCode != ERROR_SUCCESS) return false;

		RegCloseKey(hKey);

		if ( strcmp(szTemp, "Msxml2.DOMDocument.3.0") == 0 )
		{
			ret = true;
		}
	}
	catch(...)
	{
	}
	
	return ret;
}
