#ifndef PLUGIN_TOOLS_H
#define PLUGIN_TOOLS_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// STL
#pragma warning(disable:4786)
#include <string>
#include <algorithm>
using namespace std;
#define SPACE_CHARS L" \n\t\r"

#include <windows.h>
#include <comdef.h>		// BSTR Types
#include <tchar.h>		// _T   Types

#define TEMP_SIZE  _MAX_PATH	// size of buffer

class Tools  
{
public:
	Tools();
	Tools(HINSTANCE	hModule);
	virtual ~Tools();

	// String manipulation
	BSTR	Trim(BSTR bstrString);
	BSTR	ItemName(BSTR bstrString);
	BSTR	Mid(BSTR bstrString, int Pos, int Len);
	BSTR	MidStr(BSTR bstrString, BSTR bstrFrom, BSTR bstrTo);
	BSTR	Replace(BSTR bstrString, BSTR bstrOldStr, BSTR bstrNewStr);
	BSTR	Remove(BSTR bstrString, BSTR bstrDelStr);
	int		InStr(BSTR bstrString, BSTR bstrFind);
	int		Find(BSTR bstrString, BSTR bstrFind, int count);
	long	stol(BSTR pBuf);

	// Registry
	void	setreg();

	// Logging
	void	LogOpen();
	void	LogClose();
	void	LogWrite( char *s );
	void	LogWriteExt( char *s );
	int		CheckLogging();
	void	SetLogging(int State);

	// MSXML Check
	bool	isMSXMLInstalled();

private:
	HANDLE		m_log;
	HINSTANCE	m_hModule;
	int				m_logState;
};

#endif // PLUGIN_TOOLS_H
