unit PreviewEmailUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, ComCtrls, StrUtils, Menus, Printers, Tabs,
  ImgList, ToolWin, ActnMan, ActnCtrls, ActnList, XPStyleActnCtrls,
  ActnPopupCtrl, IdBaseComponent, IdMessage, StdActns, BandActn, RichEdit;

type
  TfrmPreview = class(TForm)
    panOK: TPanel;
    panPreviewFrom: TPanel;
    btnOK: TBitBtn;
    Label1: TLabel;
    edFrom: TEdit;
    tsMessageParts: TTabSet;
    lvAttachments: TListView;
    spltAttachemnts: TSplitter;
    imlAttachments: TImageList;
    toolbarPreview: TActionToolBar;
    ActionManagerPreview: TActionManager;
    actSave: TAction;
    imlActions: TImageList;
    actPrint: TAction;
    actReply: TAction;
    actDelete: TAction;
    panProgress: TPanel;
    btnStop: TSpeedButton;
    Progress: TProgressBar;
    lblProgress: TLabel;
    mnPreviewEmailUnitToolbar: TPopupActionBarEx;
    Customize1: TMenuItem;
    Msg: TIdMessage;
    actAttachmentOpen: TAction;
    actAttachmentSave: TAction;
    actAttachmentSaveAll: TAction;
    mnuAttachments: TPopupMenu;
    Open2: TMenuItem;
    Save2: TMenuItem;
    N2: TMenuItem;
    SaveAllAttachments2: TMenuItem;
    mnuEdit: TPopupActionBarEx;
    actEditCut: TEditCut;
    actEditCopy: TEditCopy;
    actEditPaste: TEditPaste;
    actEditSelectAll: TEditSelectAll;
    actEditUndo: TEditUndo;
    actEditDelete: TEditDelete;
    Undo1: TMenuItem;
    N3: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    Delete1: TMenuItem;
    N4: TMenuItem;
    SelectAll1: TMenuItem;
    N5: TMenuItem;
    actEditFont: TFontEdit;
    SelectFont1: TMenuItem;
    actEditReadOnly: TAction;
    ReadOnly1: TMenuItem;
    actCustomize: TAction;
    panPreviewTo: TPanel;
    Label2: TLabel;
    edTo: TEdit;
    panPreviewDate: TPanel;
    Label4: TLabel;
    edDate: TEdit;
    panPreviewSubject: TPanel;
    Label3: TLabel;
    edSubject: TEdit;
    panPreviewXMailer: TPanel;
    Label5: TLabel;
    edXMailer: TEdit;
    panPreviewCC: TPanel;
    Label6: TLabel;
    edCC: TEdit;
    imgPreview: TImage;
    memMail: TRichEdit;
    procedure panOKResize(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnStopClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure tsMessagePartsChange(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure actSaveExecute(Sender: TObject);
    procedure actPrintExecute(Sender: TObject);
    procedure actReplyExecute(Sender: TObject);
    procedure actDeleteExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure actAttachmentSaveExecute(Sender: TObject);
    procedure lvAttachmentsSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure actAttachmentOpenExecute(Sender: TObject);
    procedure actAttachmentSaveAllExecute(Sender: TObject);
    procedure lvAttachmentsDblClick(Sender: TObject);
    procedure actEditFontAccept(Sender: TObject);
    procedure actEditFontBeforeExecute(Sender: TObject);
    procedure actEditReadOnlyExecute(Sender: TObject);
    procedure actCustomizeExecute(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure edEnter(Sender: TObject);
    procedure edMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  protected
    procedure WndProc(var Message: TMessage); override;
  private
    { Private declarations }
    FFilesToDelete : TStringList;
    FToolbarFileName : string;
    FCustomized : boolean;
    FEnter : boolean;
    FTab : integer;
    procedure DeleteTempFiles;
    procedure AddFileToDelete(FileName : string);
    procedure LoadActionManager;
    procedure SaveActionManager;
  public
    { Public declarations }
    FStop : Boolean;
    FDecoded : boolean;
    DontProcess: Boolean;
    Resume: String;
    IniName : string;
    FAccountNum,FMsgNum : integer;
    FUID : string;
    FReplyTo : string;
    FRawMsg : string;
    FBody : string;
    procedure GetINI;
    procedure SaveINI;
    function AttachmentIcon(filename : string) : integer;
    procedure ShowMsg;
  end;

var
  frmPreview: TfrmPreview;

implementation

{$R *.DFM}

uses
  UtilsUnit, MainFormUnit, GeneralDataUnit, GlobalToolsUnit,
  IniFiles, ShellAPI, CommCtrl, TypInfo;

const
  iconNone = 0;
  iconText = 1;
  iconHTML = 2;
  iconPic = 3;
  iconZip = 4;
  iconEXE = 5;
  iconWarning = 6;
  iconEMail = 7;
  iconMusic = 8;
  iconMovie = 9;

function Translate(english : string) : string;
begin
  Result := SpamLearnerMainForm.Translate(english);
end;

procedure TfrmPreview.WndProc(var Message: TMessage);
var
  p: TENLink;
  strURL: string;
begin
  if (Message.Msg = WM_NOTIFY) then
  begin
    if (PNMHDR(Message.lParam).code = EN_LINK) then
    begin
      p := TENLink(Pointer(TWMNotify(Message).NMHdr)^);
      if (p.Msg = WM_LBUTTONDOWN) then
      begin
        SendMessage(memMail.Handle, EM_EXSETSEL, 0, Longint(@(p.chrg)));
        strURL := memMail.SelText;
        memMail.SelLength := 0;
        ShellExecute(Handle, 'open', PChar(strURL), nil, nil, SW_SHOWNORMAL);
      end
    end
  end;

  inherited;
end;

procedure TfrmPreview.DeleteTempFiles;
var
  i : integer;
begin
  // delete MSG temp files
  for i := 0 to Msg.MessageParts.Count - 1 do
  begin
    if Msg.MessageParts.Items[i] is TIdAttachment then
    begin
      DeleteFile((Msg.MessageParts.Items[i] as TIdAttachment).StoredPathName);
    end;
  end;
  // delete execute temp files
  if Assigned(FFilesToDelete) then
  begin
    for i := 0 to FFilesToDelete.Count-1  do
    begin
      DeleteFile(FFilesToDelete[i]);
    end;
    FreeAndNil(FFilestoDelete);
  end;
end;

procedure TfrmPreview.AddFileToDelete(FileName: string);
begin
  if not Assigned(FFilesToDelete) then
    FFilesToDelete := TStringList.Create;
  FFilesToDelete.Add(FileName);
end;

procedure TfrmPreview.LoadActionManager;
var
  S: TFileStream;
  S2,S3 : TMemoryStream;
  st : string;
begin
  if FileExists(FToolbarFileName) then
  begin
    S := TFileStream.Create(FToolbarFileName, fmOpenRead or fmShareDenyWrite);
    try
      S2 := TMemoryStream.Create;
      try
        ObjectBinaryToText(S,S2);
        S2.Position := 0;
        SetLength(st,S2.Size);
        S2.Read(st[1],S2.Size);
        st := AnsiReplaceStr(st,'frmPreviewInstance',Self.Name);
        S2.Clear;
        S2.Write(st[1],Length(st));
        S3 := TMemoryStream.Create;
        try
          S2.Position := 0;
          ObjectTextToBinary(S2,S3);
          S3.Position := 0;
          ActionManagerPreview.LoadFromStream(S3);
        finally
          S3.Free;
        end;
      finally
        S2.Free;
      end;
    finally
      S.Free;
    end;
  end;
end;


procedure TfrmPreview.SaveActionManager;
var
  S2,S3 : TMemoryStream;
  st : string;
begin
  if FCustomized then
  begin
    S2 := TMemoryStream.Create;
    try
      ActionManagerPreview.SaveToStream(S2);
      S3 := TMemoryStream.Create;
      try
        S2.Position := 0;
        ObjectBinaryToText(S2,S3);
        S3.Position := 0;
        SetLength(st,S3.Size);
        S3.Read(st[1],S3.Size);
        st := AnsiReplaceStr(st,Self.Name,'frmPreviewInstance');
        S3.Clear;
        S3.Write(st[1],Length(st));
        S3.Position := 0;
        S2.Clear;
        ObjectTextToBinary(S3,S2);
        S2.Position := 0;
        S2.SaveToFile(FToolbarFileName);
      finally
        S3.Free;
      end;
    finally
      S2.Free;
    end;
  end;
end;


procedure TfrmPreview.GetINI;
var
  Ini : TIniFile;
  NewLeft,NewTop,cnt : integer;
begin
  // load toolbar
  LoadActionManager;
  // load from ini
  Ini := TIniFile.Create(IniName);
  try
    // options
    memMail.ReadOnly := Ini.ReadBool('Preview','ReadOnly',True);
    actEditReadOnly.Checked := memMail.ReadOnly;
    // pos/size
    Self.Width := Ini.ReadInteger('Preview','Width',Self.Width);
    Self.Height := Ini.ReadInteger('Preview','Height',Self.Height);
    if Ini.ReadBool('Preview','Maximized',false) then
      Self.WindowState := wsMaximized
    else
      Self.WindowState := wsNormal;
    NewLeft := Ini.ReadInteger('Preview','Left',Screen.WorkAreaWidth-Self.Width);
    NewTop := Ini.ReadInteger('Preview','Top',Screen.WorkAreaHeight-Self.Height);
    // make sure there isn't already a window at the spot
    cnt := 0;
    while WindowAt(Self,NewLeft,NewTop) do
    begin
      Inc(cnt);
      Inc(NewLeft,32);
      Inc(NewTop,32);
      // off screen?
      if NewTop + Self.Height > Screen.Height then
      begin
        NewTop := 0;
        Inc(NewLeft,40);
      end;
      if NewLeft + Self.Width > Screen.Width then
      begin
        NewLeft := 0;
        Inc(NewTop,40);
      end;
      // couldn't find a spot?
      if (cnt > 100) then
      begin
        NewLeft := 0;
        NewTop := 0;
        Break;
      end;
    end;
    Self.Left := NewLeft;
    Self.Top := NewTop;
    // font
    memMail.Font.Name := Ini.ReadString('Preview','FontName','Courier New');
    memMail.Font.Size := Ini.ReadInteger('Preview','FontSize',8);
    memMail.Font.Color := Ini.ReadInteger('Preview','FontColor',clWindowText);
    SetSetProp(memMail.Font,'Style',Ini.ReadString('Preview','FontStyle',''));
    memMail.Font.Charset := Ini.ReadInteger('Preview','FontCharset',DEFAULT_CHARSET);
    // tab
    FTab := Ini.ReadInteger('Preview','Tab',0);
  finally
     Ini.Free;
  end;
end;

procedure TfrmPreview.SaveINI;
var
  Ini : TIniFile;
begin
  // save toolbar
  SaveActionManager;
  // save to ini
  Ini := TIniFile.Create(IniName);
  try
    // options
    Ini.WriteBool('Preview','ReadOnly',memMail.ReadOnly);
    // pos/size
    Ini.WriteInteger('Preview','Left',Self.Left);
    Ini.WriteInteger('Preview','Top',Self.Top);
    Ini.WriteBool('Preview','Maximized',Self.WindowState = wsMaximized);
    if Self.WindowState <> wsMaximized then
    begin
      Ini.WriteInteger('Preview','Width',Self.Width);
      Ini.WriteInteger('Preview','Height',Self.Height);
    end;
    // font
    Ini.WriteString('Preview','FontName',memMail.Font.Name);
    Ini.WriteInteger('Preview','FontSize',memMail.Font.Size);
    Ini.WriteInteger('Preview','FontColor',memMail.Font.Color);
    Ini.WriteString('Preview','FontStyle',GetSetProp(memMail.Font,'Style'));
    Ini.WriteInteger('Preview','FontCharset',memMail.Font.Charset);
    // tab
    Ini.WriteInteger('Preview','Tab',tsMessageParts.TabIndex);
  finally
     Ini.Free;
  end;
end;

function TfrmPreview.AttachmentIcon(filename: string): integer;
var
  ext : string;
begin
  ext := LowerCase(ExtractFileExt(filename));
  if (filename = 'Body') or (filename = 'Text') or (ext = '.txt') then
    Result := iconText
  else if (ext = '.htm') or (ext = '.html') or (ext = '.url') then
    Result := iconHTML
  else if (ext = '.jpg') or (ext = '.gif') or (ext = '.bmp') or (ext = '.jpeg') or (ext = '.png') then
    Result := iconPic
  else if (ext = '.zip') or (ext = '.rar') or (ext = '.ace') or (ext = '.cab') then
    Result := iconZip
  else if (ext = '.exe') or (ext = '.com') then
    Result := iconEXE
  else if (ext = '.pif') or (ext = '.vbs') or (ext = '.bat') or (ext = '.cmd') or (ext = '.scr') or
          (ext = '.shs') or (ext = '.js') or (ext = '.dll') or (ext = '.lnk') or (ext = '.chm') then
    Result := iconWarning
  else if (ext = '.eml') or (ext = '.msg') then
    Result := iconEMail
  else if (ext = '.mp3') or (ext = '.wav') or (ext = '.wma') then
    Result := iconMusic
  else if (ext = '.avi') or (ext = '.mpg') or (ext = '.mpeg') or (ext = '.mov') or (ext = '.wmv') then
    Result := iconMovie
  else
    Result := iconNone;
end;

procedure TfrmPreview.ShowMsg;
////////////////////////////////////////////////////////////////////////////////
// Show the Message in the preview form
var
  i : integer;
  aname,mimetype : string;
begin
  Enabled := False;
  try
    Self.Caption := Self.Caption + ' [' + Msg.Subject + ']';
    // fixed headers
    edFrom.Text := Msg.From.Text;
    if Msg.ReplyTo.Count>0 then
      FReplyTo := Msg.ReplyTo[0].Address
    else
      FReplyTo := Msg.From.Address;
    edTo.Text := Msg.Recipients.EMailAddresses;
    edSubject.Text := Msg.Subject;
    edDate.Text := DateTimeToStr(Msg.Date);
    // optional headers
    if Msg.CCList.EMailAddresses <> '' then
    begin
      panPreviewCC.Visible := True;
      edCC.Text := Msg.CCList.EMailAddresses;
    end;
    if Msg.Headers.Values['X-Mailer'] <> '' then
    begin
      panPreviewXMailer.Visible := True;
      edXMailer.Text := Msg.Headers.Values['X-Mailer'];
    end;
    Application.ProcessMessages;
    // body
    FBody := '';
    if Msg.MessageParts.Count > 1 then
    begin
      // with attachments
      if Msg.MessageParts.Items[0] is TidText then
        FBody := FBody + TidText(Msg.MessageParts.Items[0]).Body.Text
      else if Msg.MessageParts.Items[0] is TIdAttachment then
        FBody := FBody + #13#10+SpamLearnerMainForm.Translate('Attachment:')+' '+
                         TidAttachment(Msg.MessageParts.Items[0]).ContentType;

      if Msg.MessageParts.Items[1] is TidText then
        FBody := FBody + TidText(Msg.MessageParts.Items[1]).Body.Text;

      lvAttachments.Show;
      spltAttachemnts.Show;
      // attachments
      for i := 0 to Msg.MessageParts.Count-1 do
      begin
        mimetype := LowerCase(Copy(Msg.MessageParts.Items[i].ContentType,1,Pos(';',Msg.MessageParts.Items[i].ContentType)-1));
        if mimetype <> 'multipart/alternative' then
        begin
          if (Msg.MessageParts.Items[i] is TIdAttachment) then
            aname := TIdAttachment(Msg.MessageParts.Items[i]).FileName
          else begin
            if i = 0 then aname := 'Body' else aname := 'Text';
            if mimetype = 'text/html' then aname := 'Message.htm';
          end;
          with lvAttachments.Items.Add do
          begin
            Caption := aname;
            ImageIndex := AttachmentIcon(aname);
            StateIndex := i;
            //Hint := mimetype;
          end;
        end;
      end;
      FDecoded := True;
    end
    else begin
      // no attachments
      if Msg.NoDecode then
        FBody := Msg.Body.Text
      else begin
        try
          FBody := FBody + Msg.Body.Text;
          if (Msg.MessageParts.Count>0) then
          begin
            if (Msg.MessageParts.Items[0] is TidText) then
            begin
              if TidText(Msg.MessageParts.Items[0]).Body <> Msg.Body then
                FBody := FBody + TidText(Msg.MessageParts.Items[0]).Body.Text;
            end
            else
              FBody := FBody + SpamLearnerMainForm.Translate('Attachment:')+' ['+
                                TidAttachment(Msg.MessageParts.Items[0]).FileName+']';
          end
          else begin
            FBody := Msg.Body.Text;
          end;
        except
          FBody := Msg.Body.Text;
        end;
      end;
      // top x lines
      if Options.TopLines>0 then
        FBody := StrAfter(FRawMsg,#13#10#13#10);
      lvAttachments.Hide;
      spltAttachemnts.Hide;
      FDecoded := False;
    end;
    memMail.Lines.Clear;
    if FTab = 0 then
      memMail.Lines.Add(FBody)
    else if (FTab < tsMessageParts.Tabs.Count) then
      tsMessageParts.TabIndex := FTab;
    panProgress.Visible := False;
    Screen.Cursor := crDefault;
    Accounts[FAccountNum-1].Prot.Disconnect;
  finally
    btnOK.Enabled := True;
    btnOK.SetFocus;
  end;
  Enabled := True;
end;


// -----------------------------------------------------------------------------
// ----------------------------------------------------------------- Events ----
// -----------------------------------------------------------------------------

procedure TfrmPreview.FormCreate(Sender: TObject);
var
  mask: Word;
  i : integer;
begin
  DontProcess := False;
  // rich edit with URLs
  mask := SendMessage(Handle, EM_GETEVENTMASK, 0, 0);
  SendMessage(memMail.Handle, EM_SETEVENTMASK, 0, mask or ENM_LINK);
  SendMessage(memMail.Handle, EM_AUTOURLDETECT, Integer(True), 0);
  // clear edit boxes
  edTo.Text := '';
  edFrom.Text := '';
  edSubject.Text := '';
  edDate.Text := '';
  edCC.Text := '';
  edXMailer.Text := '';
  panPreviewCC.Visible := False;
  panPreviewXMailer.Visible := False;
  // translate extras
  for i := 0 to tsMessageParts.Tabs.Count-1 do
    tsMessageParts.Tabs[i] := Translate(tsMessageParts.Tabs[i]);
  // action manager
  FToolbarFileName := ExtractFilePath(Application.ExeName)+'Preview.customize';
  FCustomized := False;
end;

procedure TfrmPreview.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  SaveINI;
  DeleteTempFiles;
  Action := caFree;
end;

procedure TfrmPreview.panOKResize(Sender: TObject);
begin
  btnOK.Left := (panOK.Width div 2) - (btnOK.Width div 2);
end;

procedure TfrmPreview.btnStopClick(Sender: TObject);
begin
  FStop := True;
  btnOK.Enabled := True;
end;

procedure TfrmPreview.btnOKClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmPreview.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := btnOK.Enabled;
end;

procedure TfrmPreview.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key = #27) then
  begin
    if panProgress.Visible then
      btnStop.Click
    else
      Self.Close;
  end;
end;

procedure TfrmPreview.tsMessagePartsChange(Sender: TObject; NewTab: Integer; var AllowChange: Boolean);
begin
  if DontProcess then
  begin
    if newTab = 0 then
     begin
       memMail.Text := Resume;
     end
    else
     if NewTab = tsMessageParts.Tabs.Count-1 then
     begin
       if (btnOK.Enabled) then btnOK.SetFocus;
       memMail.Visible := True;
       memMail.Lines.Clear;
       memMail.Lines.Add(FRawMsg);
       lvAttachments.Hide;
       spltAttachemnts.Hide;
     end;
    AllowChange := True;
    Exit;
  end;
  if NewTab = tsMessageParts.Tabs.Count-1 then
  begin
    if (btnOK.Enabled) then btnOK.SetFocus;
    memMail.Visible := True;
    memMail.Lines.Clear;
    memMail.Lines.Add(FRawMsg);
    lvAttachments.Hide;
    spltAttachemnts.Hide;
  end
  else if NewTab = 0 then
  begin
    if (btnOK.Enabled) then btnOK.SetFocus;
    memMail.Visible := True;
    memMail.Lines.Clear;
    memMail.Lines.Add(FBody);
    if lvAttachments.Items.Count > 0 then
    begin
      lvAttachments.Show;
      spltAttachemnts.Show;
    end;
  end;
end;

procedure TfrmPreview.actSaveExecute(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
// Save Message
var
  MsgLines : TStringList;
  SaveDialog : TSaveDialog;
begin
  SaveDialog := TSaveDialog.Create(nil);
  try
    // prepare save dialog
    SaveDialog.DefaultExt := 'eml|txt|msg|';
    SaveDialog.Filter := 'Outlook Express (*.eml)|*.eml|Text File (*.txt)|*.txt|E-Mail Message (*.msg)|*.msg|All Files (*.*)|*.*';
    SaveDialog.Options := [ofOverwritePrompt];
    SaveDialog.FileName := Copy(edSubject.Text,LastDelimiter(':',edSubject.Text)+1,
                                Length(edSubject.Text)-LastDelimiter(':',edSubject.Text));
    SaveDialog.FileName := Trim(CharsReplace(SaveDialog.FileName,['"','.','/','*','\','<','>'],' '));
    // run it
    if SaveDialog.Execute then
    begin
      if Uppercase(ExtractFileExt(SaveDialog.FileName)) = '.TXT' then
      begin
        MsgLines := TStringlist.Create;
        try
          MsgLines.Add('From: '+edFrom.Text);
          MsgLines.Add('To: '+edTo.Text);
          MsgLines.Add('Subject: '+edSubject.Text);
          MsgLines.Add(StringOfChar('-',70)+#13#10);
          MsgLines.Add(memMail.Lines.Text);
          MsgLines.SaveToFile(SaveDialog.FileName);
        finally
          MsgLines.Free;
        end;
      end
      else begin
        MsgLines := TStringlist.Create;
        try
          MsgLines.Add(FRawMsg);
          MsgLines.SaveToFile(SaveDialog.FileName);
        finally
          MsgLines.Free;
        end;
      end;
    end;
  finally
    SaveDialog.Free;
  end;
end;


procedure TfrmPreview.actPrintExecute(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
// Print
var
  i,h : Integer;
begin
  with Printer do
  begin
    BeginDoc;

    Canvas.Font.Name := 'Courier New';
    Canvas.Font.Size := 11;
    // from
    Canvas.Font.Style := [fsBold];
    Canvas.TextOut(100,100,Translate('From')+':  ');
    Canvas.Font.Style := [];
    Canvas.TextOut(100+Canvas.TextWidth(Translate('From')+':  '),100,edFrom.Text);
    h := Canvas.TextHeight(Translate('From')+':  '+edFrom.Text);
    // to
    Canvas.Font.Style := [fsBold];
    Canvas.TextOut(100,100+h,Translate('To')+':  ');
    Canvas.Font.Style := [];
    Canvas.TextOut(100+Canvas.TextWidth(Translate('To')+':  '),100+h,edTo.Text);
    h := h + Canvas.TextHeight(Translate('To')+':  '+edTo.Text);
    // date
    Canvas.Font.Style := [fsBold];
    Canvas.TextOut(100,100+h,Translate('Date')+':  ');
    Canvas.Font.Style := [];
    Canvas.TextOut(100+Canvas.TextWidth(Translate('Date')+':  '),100+h,edDate.Text);
    h := h + Canvas.TextHeight(Translate('Date')+':  '+edDate.Text);
    // subject
    Canvas.Font.Style := [fsBold];
    Canvas.TextOut(100,100+h,Translate('Subject')+':  ');
    Canvas.Font.Style := [];
    Canvas.TextOut(100+Canvas.TextWidth(Translate('Subject')+':  '),100+h,edSubject.Text);
    h := h + Canvas.TextHeight(Translate('Subject')+':  '+edSubject.Text);
    // line
    h := h + 15;
    Canvas.Brush.Color := clBlack;
    Canvas.Rectangle(100,100+h,(Pagewidth - 100),100+h+5);
    h := h + 30;
    Canvas.Brush.Color := clWhite;
    // body
    Canvas.Font.Size := 9;
    for i := 0 to memMail.Lines.Count do
     Canvas.TextOut(100,100+h + (i * Canvas.TextHeight(memMail.Lines.Strings[i])),
                                 memMail.Lines.Strings[i]);

    EndDoc;
  end;
end;


procedure TfrmPreview.actReplyExecute(Sender: TObject);
var
  email,subject,body : string;
begin
  // get headers
  email := FReplyTo;
  subject := edSubject.Text;
  if (Uppercase(Copy(subject,1,3)) <> 'RE:') and (Uppercase(Copy(subject,1,3)) <> 'RE[') then
    subject := 'Re: '+subject;
  if memMail.SelLength > 1 then
    body := memMail.SelText
  else
    body := memMail.Text;
  body := #13#10'> ' + AnsiReplaceStr(body,#13#10,#13#10'> ');
  // send it
  SpamLearnerMainForm.SendMail(email,subject,body);
end;


procedure TfrmPreview.actDeleteExecute(Sender: TObject);
begin
  if not(Options.DeleteConfirm) or
     (SpamLearnerMainForm.TranslateDlg(
      SpamLearnerMainForm.Translate('Delete Message from Server?'),
      mtConfirmation,[mbYes,mbNo],0) = mrYes) then
  begin
    // delete it
    if SpamLearnerMainForm.DeleteMail(FAccountNum,FMsgNum,FUID) then
    begin
      // first hide instead of close, or FAccountNum will get destroyed
      Self.Hide;
      // re-check
      SpamLearnerMainForm.ShowIcon(FAccountNum,itChecking);
      if SpamLearnerMainForm.CheckMail(FAccountNum,false) < 0 then
        SpamLearnerMainForm.lvMail.Clear
      else begin
        // showmail if tab hasn't changed
        if SpamLearnerMainForm.tabMail.TabIndex+1=FAccountNum then
          SpamLearnerMainForm.ShowMail(FAccountNum)
        else
          SpamLearnerMainForm.ShowIcon(FAccountNum,itNormal);
      end;
      // now close (and free) window
      Self.Close;
    end;
  end;

end;

procedure TfrmPreview.lvAttachmentsSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);
var
  SomethingSelected : boolean;
begin
  SomethingSelected := not (lvAttachments.Selected = nil);
  actAttachmentOpen.Enabled := SomethingSelected;
  actAttachmentSave.Enabled := SomethingSelected;
end;

procedure TfrmPreview.actAttachmentSaveExecute(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
// Save Attachment
var
  SaveDialog : TSaveDialog;
begin
  if lvAttachments.Selected = nil then Exit;
  SaveDialog := TSaveDialog.Create(nil);
  try
    SaveDialog.Options := [ofOverwritePrompt];
    SaveDialog.FileName := lvAttachments.Selected.Caption;
    if SaveDialog.Execute then
    begin
      if Msg.MessageParts[lvAttachments.Selected.StateIndex] is TIdAttachment then
      begin
        if not CopyFile(pchar((Msg.MessageParts[lvAttachments.Selected.StateIndex] as TIdAttachment).StoredPathName),
                        pchar(SaveDialog.FileName),false) then
        begin
          MessageDlg(SpamLearnerMainForm.Translate('Failed to Save Attachment.')+#13#10#13#10+
                     SaveDialog.FileName, mtError, [mbOK], 0);
        end;
      end
      else begin
        if Msg.MessageParts[lvAttachments.Selected.StateIndex] is TIdText then
        begin
          (Msg.MessageParts[lvAttachments.Selected.StateIndex] as TIdText).Body.SaveToFile(SaveDialog.FileName);
        end
        else
          MessageDlg(SpamLearnerMainForm.Translate('Unknown Attachment Type.'), mtError, [mbOK], 0);
      end;
    end;
  finally
    SaveDialog.Free;
  end;
end;

procedure TfrmPreview.actAttachmentOpenExecute(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
// Open Attachment
var
  OldName,NewName : string;
begin
  if lvAttachments.Selected = nil then Exit;
  // check for malicious filetype
  if lvAttachments.Selected.ImageIndex in [iconEXE,iconWarning] then
  begin
    MessageDlg(SpamLearnerMainForm.Translate('Because of the Security Risk, SpamLearner doesn''t allow the opening of Executable files.'), mtError, [mbOK], 0);
  end
  else begin
    if Msg.MessageParts[lvAttachments.Selected.StateIndex] is TIdAttachment then
    begin
      // rename temp file
      OldName := (Msg.MessageParts[lvAttachments.Selected.StateIndex] as TIdAttachment).StoredPathName;
      NewName := TempFileName(lvAttachments.Selected.Caption);
      if CopyFile(PChar(OldName), PChar(NewName), true) then
      begin
        // run it
        AddFileToDelete(NewName);
        ExecuteFile(NewName,'','',SW_NORMAL);
      end
      else
        MessageDlg(SpamLearnerMainForm.Translate('Unable to Copy file.'), mtError, [mbOK], 0);
    end
    else begin
      if Msg.MessageParts[lvAttachments.Selected.StateIndex] is TIdText then
      begin
        if LowerCase(ExtractFileExt(lvAttachments.Selected.Caption)) = '.htm' then
        begin
          NewName := TempFileName(lvAttachments.Selected.Caption);
          // run it
          AddFileToDelete(NewName);
          ExecuteFile(NewName,'','',SW_NORMAL);
        end
        else begin
          // show text in memo
          memMail.Lines.Assign((Msg.MessageParts[lvAttachments.Selected.StateIndex] as TIdText).Body);
        end;
      end
      else
        MessageDlg(SpamLearnerMainForm.Translate('Unknown Attachment Type.'), mtError, [mbOK], 0);
    end;
  end;
end;

procedure TfrmPreview.actAttachmentSaveAllExecute(Sender: TObject);
var
  i : integer;
begin
  for i := 0 to lvAttachments.Items.Count-1 do
  begin
    lvAttachments.Items[i].Selected := True;
    actAttachmentSave.Execute;
  end;
end;

procedure TfrmPreview.lvAttachmentsDblClick(Sender: TObject);
begin
  actAttachmentOpen.Execute;
end;

procedure TfrmPreview.actEditFontAccept(Sender: TObject);
begin
  memMail.Font := actEditFont.Dialog.Font;
end;

procedure TfrmPreview.actEditFontBeforeExecute(Sender: TObject);
begin
  actEditFont.Dialog.Font := memMail.Font;
  {actEditFont.Dialog.Font.Name := memMail.Font.Name;
  actEditFont.Dialog.Font.Size := memMail.Font.Size;
  actEditFont.Dialog.Font.Color := memMail.Font.Color;
  actEditFont.Dialog.Font.Style := memMail.Font.Style;
  actEditFont.Dialog.Font.Charset := memMail.Font.Charset;}
end;

procedure TfrmPreview.actEditReadOnlyExecute(Sender: TObject);
begin
  memMail.ReadOnly := actEditReadOnly.Checked;
end;

procedure TfrmPreview.actCustomizeExecute(Sender: TObject);
begin
  FCustomized := True;
  dm.ShowCustomizeDlg(ActionManagerPreview,False);
end;

procedure TfrmPreview.FormResize(Sender: TObject);
begin
  panProgress.Left := (memMail.Width div 2) - (panProgress.Width div 2);
  panProgress.Top := memMail.Top + (memMail.Height div 2) - (panProgress.Height div 2);
end;

procedure TfrmPreview.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (ssCtrl in Shift) and ((Key = VK_F6) or (Key = VK_TAB)) then
  begin
    if tsMessageParts.TabIndex=0 then
      tsMessageParts.TabIndex := 1
    else
      tsMessageParts.TabIndex := 0;
  end;
end;

procedure TfrmPreview.edEnter(Sender: TObject);
begin
  (Sender as TEdit).SelectAll;
  FEnter := True;
end;

procedure TfrmPreview.edMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if FEnter then
  begin
   (Sender as TEdit).SelectAll;
   FEnter := False;
  end;
end;

end.
