unit AddressBookImportUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons, ComCtrls, ComObj,
  WindowsAddressBook;

type
  TAddressBookForm = class(TForm)
    Image1: TImage;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Panel1: TPanel;
    Notebook: TNotebook;
    btnExit: TBitBtn;
    btnBack: TBitBtn;
    btnNext: TBitBtn;
    Shape1: TShape;
    Label1: TLabel;
    Label2: TLabel;
    Group: TRadioGroup;
    Label3: TLabel;
    Image2: TImage;
    Label4: TLabel;
    Label5: TLabel;
    PBar: TProgressBar;
    Label6: TLabel;
    lblStatus: TLabel;
    Shape2: TShape;
    WAB: TWinAddressBook;
    procedure BitBtn1Click(Sender: TObject);
    procedure btnNextClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AddressBookForm: TAddressBookForm;

implementation

{$R *.dfm}

uses GeneralDataUnit, MainFormUnit, GlobalToolsUnit;

procedure TAddressBookForm.BitBtn1Click(Sender: TObject);
begin
  Close;
end;

procedure TAddressBookForm.btnNextClick(Sender: TObject);

procedure Allow(EMail: String);
var I: Integer; Found: Boolean;
begin
  Found := False;
  for I:=0 to Options.BlackList.Count-1 do
   if UpperCase(EMail)=UpperCase(Options.WhiteList[I]) then
    begin
      Found := True;
      Break;
    end;
  if not Found then
   Options.WhiteList.Add(EMail);
end;

procedure AutoImport;
const
 olFolderContacts = $0000000A;
var
 outlook, NameSpace, Contacts, Contact: OleVariant;
 i: Integer;
 Imported: Integer;
 GoImported: Boolean;
 E, F: String;
begin
try
 outlook := CreateOleObject('Outlook.Application');
 NameSpace := outlook.GetNameSpace('MAPI');
 Contacts := NameSpace.GetDefaultFolder(olFolderContacts);
 Imported := 0;
 PBar.Max := Contacts.Items.Count;
 for i := 1 to Contacts.Items.Count do
 begin
   Contact := Contacts.Items.Item(i);
   {now you can read any property of contact. For example, full name and email address}
   GoImported := False;
   E := Contact.Email1Address;
   F := Contact.FullName;
   if E <> '' then
   begin
     GoImported := True;
     Allow(E);
   end;
   E := Contact.Email2Address;
   if E <> '' then
   begin
     GoImported := True;
     Allow(E);
   end;
   E := Contact.Email3Address;
   if E <> '' then
   begin
     GoImported := True;
     Allow(E);
   end;
   if GoImported then
     Imported := Imported + 1;
   PBar.Position := i;
   Application.ProcessMessages;
   lblStatus.Caption := IntToStr(Imported);
 end;
 Outlook := UnAssigned;
except
  Application.MessageBox('Unable to retrieve information from Outlook!', 'Warning', MB_OK+MB_ICONWARNING);
end;
end;

function Go(S: String): String;
begin
 if Pos('EMAIL_ADDRESS', S) <= 0 then
  begin
    Result := '';
    Exit;
  end;
 Delete(S, 1, Pos('EMAIL_ADDRESS', S)+Length('EMAIL_ADDRESS)')-1);
 // now we start with the e-mail
 if Pos(#13#10, S) > 0 then
   S := Copy(S, 1, Pos(#13#10, S)-1);
 Result := S;
end;

procedure Process;
var Imported, I: Integer; S: String;
begin
  if Group.ItemIndex = 0 then
    AutoImport
  else
  begin
    // outlook express
   Imported := 0;
   WAB.SetToDefaultAddressBook;
   WAB.LoadFile;
   PBar.Max := WAB.contacts.Count;
   if WAB.Contacts.Count > 0 then
   for I:=0 to WAB.Contacts.Count-1 do
   begin
     PBar.Position := I+1;
     wab.getPropertiesOf(wab.contacts[i]);
     S := Go(WAB.properties.text);
     if S <> '' then
     begin
       Allow(S);
       Inc(Imported);
     end;
   end;
   lblStatus.Caption := IntToStr(Imported);
  end;
  SpamLearnerMainForm.PageControlChange(Self); // this is so that we display the new additions correctly
  SpamLearnerMainForm.btnSaveListsClick(Self);
end;

begin
  if btnNext.Caption = 'Finish' then begin Close; Exit; end;
  btnBack.Enabled := True;
  Notebook.PageIndex := Notebook.PageIndex + 1;
  if Notebook.PageIndex = Notebook.Pages.Count-1 then
   begin
     btnBack.Enabled := False;
     btnExit.Enabled := False;
     btnNext.Enabled := False;
     Process;
     Label5.Visible := True;
     Label4.Caption := 'Finished!';
     btnNext.Caption := 'Finish';
     btnNext.Enabled := True;
   end;
end;

end.
