unit BayesianFilter;

interface
 uses sysutils;

type
ref=^treg;
treg1=packed record
  cuv:string[20];
  pon:single;
end;
treg=record
  ab:treg1;
  urm:ref;
end;

procedure openfilter(account: string);
procedure closefilter;
procedure teach(text:string;mtype:single);
function filtrate(text:string):single;
function MatchPattern(InpStr, Pattern: PChar):Boolean;

var
  buf:array of treg1;
  wcards:array of string[20];
  dat:text;
  n,size1,sizeaux:longint;
  AccName: String;

implementation

function MatchPattern(InpStr, Pattern: PChar):Boolean;
begin
  while (True) do
  begin
   case Pattern[0] of
   #0:
      begin //End of pattern reached.
        Result := (InpStr[0] = #0); //TRUE if end of InpStr.
        Exit;
      end;
   '*':
        begin //Match zero or more occurances of any char.
          if (Pattern[1] = #0) then
          begin //Match any number of trailing chars.
            Result := True;
            Exit;
          end
          else
            Inc(Pattern);
          while (InpStr[0] <> #0) do
          begin //Try to match any substring of InpStr.
if (MatchPattern(InpStr, Pattern)) then
begin
Result := True;
Exit;
end;

//Continue testing next char...
Inc(InpStr);
end;
end;

'?':
begin //Match any one char.
if (InpStr[0] = #0) then
begin
Result := False;
Exit;
end;

//Continue testing next char...
Inc(InpStr);
Inc(Pattern);
end;

'[':
begin //Match given set of chars.
if (Pattern[1] in [#0, '[', ']']) then
begin //Invalid Set - So no match.
Result := False;
Exit;
end;

if (Pattern[1] = '^') then
begin //Match for exclusion of given set...
Inc(Pattern, 2);
Result := True;
while (Pattern[0] <> ']') do
begin
if (Pattern[1] = '-') then
begin //Match char exclusion range.
if (InpStr[0] >= Pattern[0]) and
(InpStr[0] <= Pattern[2]) then
begin //Given char failed set exclusion range.
Result := False;
Break;
end
else
Inc(Pattern, 3);
end
else
begin //Match individual char exclusion.
if (InpStr[0] = Pattern[0]) then
begin //Given char failed set element exclusion.
Result := False;
Break;
end
else
Inc(Pattern);
end;
end;
end
else
begin //Match for inclusion of given set...
Inc(Pattern);
Result := False;
while (Pattern[0] <> ']') do
begin
if (Pattern[1] = '-') then
begin //Match char inclusion range.
if (InpStr[0] >= Pattern[0]) and
(InpStr[0] <= Pattern[2]) then
begin //Given char matched set range inclusion. Continue testing...
Result := True;
Break;
end
else
Inc(Pattern, 3);
end
else
begin //Match individual char inclusion.
if (InpStr[0] = Pattern[0]) then
begin //Given char matched set element inclusion. Continue testing...
Result := True;
Break;
end
else
Inc(Pattern);
end;
end;
end;

if (Result) then
begin //Match was found. Continue further.
Inc(InpStr);

//Position Pattern to char after "]"
while (Pattern[0] <> ']') and (Pattern[0]
<> #0) do
Inc(Pattern);

if (Pattern[0] = #0) then
begin //Invalid Pattern - missing "]"
Result := False;
Exit;
end
else
Inc(Pattern);
end
else
Exit;
end;

else
begin //Match given single char.
if (InpStr[0] <> Pattern[0]) then
begin
Result := False;
Break;
end;

//Continue testing next char...
Inc(InpStr);
Inc(Pattern);
end;
end;
end;
end;

function Go(S: String): String;
const No: Array[1..9] of Char = ('\','/','?','*',':','"','<','>','|');
var I: Integer;
begin
  I := 1;
  for I:=1 to 9 do
   while Pos(No[I], S) > 0 do
    Delete(S, Pos(No[I], S), 1);
  Result := S;
end;

procedure openfilter(account: string);
var fis,pat:file;
    size,i:longint;
begin
  {$I-}
  if not DirectoryExists(ExtractFilePath(ParamStr(0))+'Accounts') then
  begin
    MkDir(ExtractFilePath(ParamStr(0))+'Accounts');
    {Set attributes}
    FileSetAttr(ExtractFilePath(ParamStr(0))+'Accounts', faHidden or faArchive or faDirectory);
    if IOResult <> 0 then Exit; { Error }
  end;
  {$I+}

  accName := Go(account);
  size1:=0;
  if fileexists(ExtractFilePath(ParamStr(0))+'Accounts\'+accName+' - Filter.dat') then
  begin
    assignfile(fis, ExtractFilePath(ParamStr(0))+'Accounts\'+accName+' - Filter.dat');
    reset(fis,1);
    size:=sizeof(treg1);
    size1:=filesize(fis) div size;
    setlength(buf,size1);
    for i:=0 to size1-1 do
      blockread(fis,buf[i],size);
    closefile(fis);
  end
  else
    setlength(buf,0);
  if fileexists(ExtractFilePath(ParamStr(0))+'Accounts\'+accName+' - Connect.dat') then
  begin
    assignfile(dat,ExtractFilePath(ParamStr(0))+'Accounts\'+accName+' - Connect.dat');
    reset(dat);
    read(dat,n);
    closefile(dat);
  end
  else
    n:=0;
  if fileexists(ExtractFilePath(ParamStr(0))+'Accounts\'+accName+' - Patterns.dat') then
  begin
    assignfile(pat,ExtractFilePath(ParamStr(0))+'Accounts\'+accName+' - Patterns.dat');
    reset(pat,1);
    size:=21;
    sizeaux:=filesize(pat) div size;
    setlength(wcards,sizeaux);
    for i:=0 to sizeaux-1 do
      blockread(pat,wcards[i],size);
    closefile(pat);
  end
  else
    setlength(wcards,0);
end;

procedure closefilter;
var fis:file;
    size,i:longint;
begin
  assignfile(fis,ExtractFilePath(ParamStr(0))+'Accounts\'+accName+' - Filter.dat');
  size:=sizeof(treg1);
  rewrite(fis,1);
  for i:=0 to size1-1 do
    blockwrite(fis,buf[i],size);
  buf:=nil;
  wcards:=nil;
  closefile(fis);
  assignfile(dat,ExtractFilePath(ParamStr(0))+'Accounts\'+accName+' - Connect.dat');
  rewrite(dat);
  write(dat,n);
  closefile(dat);
end;
procedure teach(text:string;mtype:single);
var
  art,art2:treg1;
  p,fanion,q1,q2,r:ref;
  lungime,i,j,wcount:integer;
  jpoz:longint;
begin
  i:=1;
  j:=1;
  wcount:=0;
  new(p);
  new(fanion);
  p^.urm:=fanion;
  fanion^.urm:=nil;
  lungime:=strlen(Pchar(text));
  while i<=lungime do
  begin
     if text[i] in [' ',':',';','.','?','!',',','(',')',#13,#10,#9] then
     begin
      if i-j>3 then
          begin
            art.cuv:=copy(text,j,i-j);
            wcount:=wcount+1;
            if wcount=1000 then
              i:=lungime;
            fanion^.ab:=art;
            q2:=p;
            q1:=q2^.urm;
            while strcomp(pchar(string(q1^.ab.cuv)),pchar(string(art.cuv)))<0 do
            begin
              q2:=q1;
              q1:=q2^.urm;
            end;
            if (strcomp(pchar(string(q1^.ab.cuv)),pchar(string(art.cuv)))<>0) or (q1=fanion)  then
            begin
              new(r);
              r^.ab:=art;
              r^.urm:=q1;
              q2^.urm:=r;
            end;
          end;
      j:=i+1;
     end;
     i:=i+1;
  end;
  if i-j>3 then
          begin
            art.cuv:=copy(text,j,i-j);
            wcount:=wcount+1;
            fanion^.ab:=art;
            q2:=p;
            q1:=q2^.urm;
            while strcomp(pchar(string(q1^.ab.cuv)),pchar(string(art.cuv)))<0 do
            begin
              q2:=q1;
              q1:=q2^.urm;
            end;
            if (strcomp(pchar(string(q1^.ab.cuv)),pchar(string(art.cuv)))<>0) or (q1=fanion)  then
            begin
              new(r);
              r^.ab:=art;
              r^.urm:=q1;
              q2^.urm:=r;
            end;
          end;
  r:=p^.urm;
	jpoz:=0;
	while r<>fanion do
  begin
		art:=r^.ab;
		i:=1;
    repeat
      if jpoz=size1 then i:=0
      else art2:=buf[jpoz];
      jpoz:=jpoz+1;
    until (i=0) or (strcomp(pchar(string(art.cuv)),pchar(string(art2.cuv)))<=0);
		jpoz:=jpoz-1;
    if strcomp(pchar(string(art.cuv)),pchar(string(art2.cuv)))=0 then
    begin
      art.pon:=(n*art2.pon+mtype)/(n+1);
			buf[jpoz].pon:=art.pon;
		end
		else if i=0 then
        begin
			    art.pon:=mtype;
          size1:=size1+1;
          setlength(buf,size1);
          buf[jpoz]:=art;
        end
		    else
        begin
			    art.pon:=mtype;
          size1:=size1+1;
          setlength(buf,size1);
          for i:=size1-1 downto jpoz+1 do
            buf[i]:=buf[i-1];
          buf[jpoz]:=art;
        end;
    jpoz:=jpoz+1;
    r:=r^.urm;
  end;
  n:=n+1;
end;
function filtrate(text:string):single;
var
  art,art2:treg1;
  p,fanion,q1,q2,r:ref;
  lungime,i,j,k,mtype,wcount:integer;
  rez:single;
  jpoz:longint;
begin
{*****determinam cuvintele din text*****}
  i:=1;
  j:=1;
  wcount:=0;
  rez:=0.0;
  new(p);
  new(fanion);
  p^.urm:=fanion;
  fanion^.urm:=nil;
  lungime:=strlen(Pchar(text));
  while i<=lungime do
  begin
     if text[i] in [' ',':',';','.','?','!',',','(',')',#13,#10,#9] then
     begin
      if i-j>3 then
          begin
            art.cuv:=copy(text,j,i-j);
            wcount:=wcount+1;
            if wcount=1000 then
              i:=lungime;
            fanion^.ab:=art;
            q2:=p;
            q1:=q2^.urm;
            while strcomp(pchar(string(q1^.ab.cuv)),pchar(string(art.cuv)))<0 do
            begin
              q2:=q1;
              q1:=q2^.urm;
            end;
            if (strcomp(pchar(string(q1^.ab.cuv)),pchar(string(art.cuv)))<>0) or (q1=fanion)  then
            begin
              new(r);
              r^.ab:=art;
              r^.urm:=q1;
              q2^.urm:=r;
            end;
          end;
      j:=i+1;
     end;
     i:=i+1;
  end;
  if i-j>3 then
          begin
            art.cuv:=copy(text,j,i-j);
            wcount:=wcount+1;
            fanion^.ab:=art;
            q2:=p;
            q1:=q2^.urm;
            while strcomp(pchar(string(q1^.ab.cuv)),pchar(string(art.cuv)))<0 do
            begin
              q2:=q1;
              q1:=q2^.urm;
            end;
            if (strcomp(pchar(string(q1^.ab.cuv)),pchar(string(art.cuv)))<>0) or (q1=fanion)  then
            begin
              new(r);
              r^.ab:=art;
              r^.urm:=q1;
              q2^.urm:=r;
            end;
          end;
{*****determinam spamicitatea*****}
  r:=p^.urm;
  jpoz:=0;
  while r<>fanion do
  begin
    art:=r^.ab;
    j:=1;
    k:=0;
    repeat
      if k=sizeaux then j:=2
      else if matchpattern(pchar(string(art.cuv)),pchar(string(wcards[k]))) then
      begin
        j:=0;
        r^.ab.pon:=1;
      end;
    k:=k+1;
    until j<>1;
    if j<>0 then
      begin
      i:=1;
      repeat
        if jpoz=size1 then i:=0
        else art2:=buf[jpoz];
        jpoz:=jpoz+1;
      until (i=0) or (strcomp(pchar(string(art.cuv)),pchar(string(art2.cuv)))<=0);
      if (i=0) or (strcomp(pchar(string(art.cuv)),pchar(string(art2.cuv)))<>0) then
      begin
        r^.ab.pon:=0.5;
        jpoz:=jpoz-1;
      end
      else
        r^.ab.pon:=art2.pon;
    end;
    r:=r^.urm;
  end;
{*****formula lui bayes*****}
  r:=p^.urm;
	while r<>fanion do
  begin
		rez:=rez+r^.ab.pon;
		r:=r^.urm;
  end;
	rez:=rez/wcount;
{*****readaptarea bazei*****}
  if rez>0.5 then mtype:=1
	else mtype:=0;
	r:=p^.urm;
	jpoz:=0;
	while r<>fanion do
  begin
		art:=r^.ab;
		i:=1;
    repeat
      if jpoz=size1 then i:=0
      else art2:=buf[jpoz];
      jpoz:=jpoz+1;
    until (i=0) or (strcomp(pchar(string(art.cuv)),pchar(string(art2.cuv)))<=0);
		jpoz:=jpoz-1;
    if strcomp(pchar(string(art.cuv)),pchar(string(art2.cuv)))=0 then
    begin
      art.pon:=(n*art2.pon+mtype)/(n+1);
			buf[jpoz].pon:=art.pon;
		end
		else if i=0 then
        begin
			    art.pon:=mtype;
          size1:=size1+1;
          setlength(buf,size1);
          buf[jpoz]:=art;
        end
		    else
        begin
			    art.pon:=mtype;
          size1:=size1+1;
          setlength(buf,size1);
          for i:=size1-1 downto jpoz+1 do
            buf[i]:=buf[i-1];
          buf[jpoz]:=art;
        end;
    jpoz:=jpoz+1;
    r:=r^.urm;
  end;
  n:=n+1;
  result:=rez;
end;
end.
