unit GOFrameUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, 
  Dialogs, StdCtrls, ExtCtrls;

type
  TframeGeneralOptions = class(TFrame)
    chkMinimized: TCheckBox;
    chkAnimated: TCheckBox;
    chkResetTray: TCheckBox;
    chkStartUp: TCheckBox;
    chkShowForm: TCheckBox;
    chkRotateIcon: TCheckBox;
    chkBalloon: TCheckBox;
    lblFirstWait: TLabel;
    edFirstWait: TEdit;
    lblSeconds: TLabel;
    chkUpdate: TCheckBox;
    chkEnableBayesianFilter: TCheckBox;
    procedure OptionsChange(Sender: TObject);
    procedure HelpMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
    procedure ShowFirstWait;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  end;

implementation

uses MainFormUnit, GlobalToolsUnit, UtilsUnit;

{$R *.dfm}

{ TframeGeneralOptions }

constructor TframeGeneralOptions.Create(AOwner: TComponent);
begin
  inherited;
  Options.Busy := True;
  SpamLearnerMainForm.TranslateFrame(self);
  // options to screen
  chkStartUp.Checked := Options.StartUp;
  edFirstWait.Text := IntToStr(Options.FirstWait);
  chkMinimized.Checked := Options.Minimized;
  chkAnimated.Checked := Options.Animated;
  chkResetTray.Checked := Options.ResetTray;
  chkRotateIcon.Checked := Options.RotateIcon;
  chkShowForm.Checked := Options.ShowForm;
  chkBalloon.Checked := Options.Balloon;
  chkUpdate.Checked := Options.UpdateBlockList;
  chkEnableBayesianFilter.Checked := Options.BayesianFilterActive;
  // autosize
  AutoSizeAllCheckBox(Self);
  edFirstWait.Left := lblFirstWait.Left + lblFirstWait.Width + 4;
  lblSeconds.Left := edFirstWait.Left + edFirstWait.Width + 4; 

  ShowFirstWait;
  Options.Busy := False;
end;

procedure TframeGeneralOptions.ShowFirstWait;
begin
  // firstwait
  edFirstWait.Enabled := Options.StartUp;
  if edFirstWait.Enabled then
  begin
    edFirstWait.Color := clWindow;
    if edFirstWait.Text = '' then edFirstWait.Text := '0';
  end
  else begin
    edFirstWait.Color := clBtnFace;
    edFirstWait.Text := '';
  end;
  // labels
  lblFirstWait.Enabled := Options.StartUp;
  lblSeconds.Enabled := Options.StartUp;
end;

procedure TframeGeneralOptions.OptionsChange(Sender: TObject);
begin
  if not Options.Busy then
  begin
    // screen to options
    Options.StartUp := chkStartUp.Checked;
    Options.FirstWait := StrToIntDef(edFirstWait.Text,0);
    Options.Minimized := chkMinimized.Checked;
    Options.Animated := chkAnimated.Checked;
    Options.ResetTray := chkResetTray.Checked;
    Options.RotateIcon := chkRotateIcon.Checked;
    Options.ShowForm := chkShowForm.Checked;
    Options.Balloon := chkBalloon.Checked;
    Options.BayesianFilterActive := chkEnableBayesianFilter.Checked;
    Options.UpdateBlockList := chkUpdate.Checked;
    ShowFirstWait;
    // buttons
    SpamLearnerMainForm.btnSaveOptions.Enabled := True;
    SpamLearnerMainForm.btnCancel.Enabled := True;
  end;
end;

procedure TframeGeneralOptions.HelpMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  SpamLearnerMainForm.QuickHelp(Sender, Button, Shift, X, Y);
end;

end.
