unit HKFrameUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, 
  Dialogs, ComCtrls, StdCtrls;

type
  TframeHotKeys = class(TFrame)
    Label25: TLabel;
    Label26: TLabel;
    cmbAction1: TComboBox;
    cmbAction2: TComboBox;
    cmbAction3: TComboBox;
    cmbAction4: TComboBox;
    hkHotKey1: THotKey;
    hkHotKey2: THotKey;
    hkHotKey3: THotKey;
    hkHotKey4: THotKey;
    procedure OptionsChange(Sender: TObject);
    procedure HelpMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  end;

implementation

uses MainFormUnit, GlobalToolsUnit;

{$R *.dfm}

{ TframeHotKeys }

constructor TframeHotKeys.Create(AOwner: TComponent);
var
  i : integer;
  st : string;
begin
  inherited;
  Options.Busy := True;
  SpamLearnerMainForm.TranslateFrame(self);
  // fill action dropdowns
  for i := Low(Actions) to High(Actions) do
  begin
    st := SpamLearnerMainForm.Translate(Actions[i]);
    cmbAction1.Items.Add(st);
    cmbAction2.Items.Add(st);
    cmbAction3.Items.Add(st);
    cmbAction4.Items.Add(st);
  end;
  // options to screen
  cmbAction1.ItemIndex := Options.Action1;
  cmbAction2.ItemIndex := Options.Action2;
  cmbAction3.ItemIndex := Options.Action3;
  cmbAction4.ItemIndex := Options.Action4;
  hkHotKey1.HotKey := Options.HotKey1;
  hkHotKey2.HotKey := Options.HotKey2;
  hkHotKey3.HotKey := Options.HotKey3;
  hkHotKey4.HotKey := Options.HotKey4;
  Options.Busy := False;
end;

procedure TframeHotKeys.OptionsChange(Sender: TObject);
begin
  if not Options.Busy then
  begin
    // screen to options
    Options.Action1 := cmbAction1.ItemIndex;
    Options.Action2 := cmbAction2.ItemIndex;
    Options.Action3 := cmbAction3.ItemIndex;
    Options.Action4 := cmbAction4.ItemIndex;
    Options.HotKey1 := hkHotKey1.HotKey;
    Options.HotKey2 := hkHotKey2.HotKey;
    Options.HotKey3 := hkHotKey3.HotKey;
    Options.HotKey4 := hkHotKey4.HotKey;
    // buttons
    SpamLearnerMainForm.btnSaveOptions.Enabled := True;
    SpamLearnerMainForm.btnCancel.Enabled := True;
  end;
end;

procedure TframeHotKeys.HelpMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  SpamLearnerMainForm.QuickHelp(Sender, Button, Shift, X, Y);
end;

end.
