unit IntervalFrameUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, 
  Dialogs, ComCtrls, StdCtrls, Buttons, ExtCtrls;

type
  TframeInterval = class(TFrame)
    chkTimerAccount: TCheckBox;
    panInterval: TPanel;
    btnNever: TSpeedButton;
    lblMinutes: TLabel;
    lblCheckEvery: TLabel;
    edTime: TEdit;
    UpDown: TUpDown;
    procedure btnNeverClick(Sender: TObject);
    procedure OptionsChange(Sender: TObject);
    procedure HelpMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  end;

implementation

uses MainFormUnit, GlobalToolsUnit, UtilsUnit;

{$R *.dfm}

//-----------------------------------------------------------------[ public ]---

constructor TframeInterval.Create(AOwner: TComponent);
begin
  inherited;
  Options.Busy := True;
  SpamLearnerMainForm.TranslateFrame(self);
  edTime.Tag := 1;
  // options to screen
  chkTimerAccount.Checked := Options.TimerAccount;
  UpDown.Position := Options.Interval;
  // autosize
  AutoSizeCheckBox(chkTimerAccount);
  edTime.Left := lblCheckEvery.Left + lblCheckEvery.Width + 4;
  UpDown.Left := edTime.Left + edTime.Width;
  lblMinutes.Left := UpDown.Left + UpDown.Width + 4;
  btnNever.Left := edTime.Left + (edTime.Width+UpDown.Width) div 2 - (btnNever.Width div 2); 

  Options.Busy := False;
end;


//-----------------------------------------------------------------[ events ]---

procedure TframeInterval.OptionsChange(Sender: TObject);
begin
  if not Options.Busy then
  begin
    // screen to options
    Options.Interval := UpDown.Position;
    Options.TimerAccount := chkTimerAccount.Checked;
    // buttons
    if (Sender = edTime) and (edTime.Tag = 1) then
      edTime.Tag := 0
    else
    begin
      SpamLearnerMainForm.btnSaveOptions.Enabled := True;
      SpamLearnerMainForm.btnCancel.Enabled := True;
    end;
  end;
  panInterval.Visible := not Options.TimerAccount;
  SpamLearnerMainForm.panIntervalAccount.Visible := Options.TimerAccount;
end;

procedure TframeInterval.btnNeverClick(Sender: TObject);
begin
  UpDown.Position := 0;
end;


procedure TframeInterval.HelpMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  SpamLearnerMainForm.QuickHelp(Sender, Button, Shift, X, Y);
end;

end.
