unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, uEncryption, Base64, XPMan;

type
  TMainForm = class(TForm)
    UserEdit: TEdit;
    Label1: TLabel;
    GenerateBtn: TButton;
    Label2: TLabel;
    SerialKey: TEdit;
    Label3: TLabel;
    XPManifest1: TXPManifest;
    procedure GenerateBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.GenerateBtnClick(Sender: TObject);
var S, U: String;

function GetUser(S: String): String;
begin
  while Length(S) < 40 do
   S := S + ' ';
  Result := S;
end;

function GetRandomKey: String;
// generate 5 nr. random key
var S1: String; I: Word;
begin
  S1 := '12345';
  Randomize;
  for I:=1 to 5 do
   repeat
    S1[I] := Chr(Random(132));
   until UpCase(S1[I]) in ['A'..'Z','0'..'9','=','-','_'];
  Result := S1;
end;

function Add(S: String): String;
// adds a '-' each 6 chars
var I, HowMany: Word;
begin
  I := 1;
  HowMany := 1;
  repeat
    if HowMany mod 6 = 0 then
    begin
     Insert('-', S, I+1);
     Inc(I,2);
     HowMany := 1;
    end
  else begin Inc(I); Inc(HowMany); end;
  until I >= Length(S);
  Result := S;
end;

function Valid(S: String): Boolean;
var R: Boolean;
    I: Integer;
begin
  R := True;
  for I:=1 to Length(S) do
   if not (UpCase(S[I]) in ['A'..'Z','0'..'9','-']) then
    begin
     R := False;
     Break;
    end;
  for I:=1 to Length(S) do
   if (S[I] = '-') and (I mod 7 <> 0) then
   begin
     R := False;
     Break;
   end;
  Result := R;
end;

var Ch: Char;
begin
  if UserEdit.Text = '' then
   begin
     ShowMessage('Enter a user name!');
     Exit;
   end;
  Label3.Caption := 'Generating valid serial...';
  repeat
  U := GetRandomKey;
  S := U + GetUser(UserEdit.Text);
  _EncryptString(U, S);
  S := B64Encode(S); // the string will be returned in base64
  repeat // generate random char on position 6
   Ch := Chr(Random(132));
  until UpCase(Ch) in ['A'..'Z','0'..'9'];
  SerialKey.Text := U + Ch + '-' + Add(S);
  Application.ProcessMessages;
  until (Valid(SerialKey.Text));
  Label3.Caption := 'Serial generated.';
end;

end.
