unit uEncryption;

interface
uses Clipbrd, Twofish, sha1, base64;

procedure _HashString(s: string; var Digest: TSHA1Digest);
procedure _EncryptString(key: string; var s: string);
procedure _DecryptString(key: string; var s: string);

implementation

// produces a hash of a string

procedure _HashString(s: string; var Digest: TSHA1Digest);
var
  Context: TSHA1Context; // record to store intermediate data
begin
  SHA1Init(Context); // initialise the data record
  SHA1Update(Context, @S[1], Length(S)); // update the data record with the string
  SHA1Final(Context, Digest); // produce the final hash
end;

// encrypts a string

procedure _EncryptString(key: string; var s: string);
var
  KeyData: TTwofishData; // the initialized key data
  Digest: TSHA1Digest;
  IV: array[0..15] of byte; // the initialization vector needed for chaining modes
begin
  _HashString(key, Digest);
  TwofishInit(KeyData, @Digest, Sizeof(Digest), nil); // initialize the key data using a hash of the key
  FillChar(IV, Sizeof(IV), 0); // make the IV all zeros
  TwofishEncryptCBC(KeyData, @IV, @IV); // encrypt the IV to get a 'random' IV
  Move(IV, KeyData.InitBlock, Sizeof(KeyData.InitBlock)); // move the IV into the keydata so can use chaining
  TwofishReset(KeyData); // reset the keydata so it uses the new IV
  TwofishEncryptCFB(KeyData, @S[1], @S[1], Length(S)); // encrypt the string using CFB stream mode (could also use OFBC)
  TwofishBurn(KeyData); // clear all the key data
end;

// decrypts a string

procedure _DecryptString(key: string; var s: string);
var
  KeyData: TTwofishData; // the initialized key data
  Digest: TSHA1Digest;
  IV: array[0..15] of byte; // the initialization vector needed for chaining modes
begin
  _HashString(key, Digest);
  TwofishInit(KeyData, @Digest, Sizeof(Digest), nil); // initialize the key data using a hash of the key
  FillChar(IV, Sizeof(IV), 0); // make the IV all zeros
  TwofishEncryptCBC(KeyData, @IV, @IV); // encrypt the IV to get a 'random' IV
  Move(IV, KeyData.InitBlock, Sizeof(KeyData.InitBlock)); // move the IV into the keydata so can use chaining
  TwofishReset(KeyData); // reset the keydata so it uses the new IV
  TwofishDecryptCFB(KeyData, @S[1], @S[1], Length(S)); // decrypt the string using CFB stream mode (could also use OFBC)
  TwofishBurn(KeyData); // clear all the key data
end;

end.

