unit SetupWizardUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Buttons, ImgList, Spin, GlobalToolsUnit, UtilsUnit,
  INIFiles;

type
  TformSetup = class(TForm)
    panelBottom: TPanel;
    panelTop: TPanel;
    panel: TPanel;
    Shape1: TShape;
    imgRight: TImage;
    lblTitle: TLabel;
    btnCancel: TBitBtn;
    btnNext: TBitBtn;
    btnBack: TBitBtn;
    btnHelp: TBitBtn;
    imgSetup: TImageList;
    imageLeft: TImage;
    imgMain: TImageList;
    Notebook: TNotebook;
    Label1: TLabel;
    Label2: TLabel;
    Bevel: TBevel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label9: TLabel;
    Label11: TLabel;
    Label8: TLabel;
    Label12: TLabel;
    lstWhite: TMemo;
    Label13: TLabel;
    lstBlack: TMemo;
    Label10: TLabel;
    editName: TEdit;
    Label14: TLabel;
    editServer: TEdit;
    comboProtocol: TComboBox;
    Label15: TLabel;
    chkEnabled: TCheckBox;
    Label16: TLabel;
    editPort: TEdit;
    Label17: TLabel;
    editLogin: TEdit;
    Label18: TLabel;
    editPassword: TEdit;
    colorEdit: TColorBox;
    Label19: TLabel;
    Label20: TLabel;
    editProgram: TEdit;
    btnOpenProgram: TSpeedButton;
    btnTestProgram: TSpeedButton;
    Label21: TLabel;
    editSound: TEdit;
    btnOpenSound: TSpeedButton;
    btnTestSound: TSpeedButton;
    Image1: TImage;
    Label22: TLabel;
    editSMTPServer: TEdit;
    Label23: TLabel;
    editSMTPPort: TEdit;
    Image2: TImage;
    procedure FormCreate(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnNextClick(Sender: TObject);
    procedure btnBackClick(Sender: TObject);
    procedure btnOpenProgramClick(Sender: TObject);
    procedure btnOpenSoundClick(Sender: TObject);
    procedure btnTestProgramClick(Sender: TObject);
    procedure btnTestSoundClick(Sender: TObject);
    procedure editProgramEnter(Sender: TObject);
    procedure editProgramExit(Sender: TObject);
    procedure editSoundEnter(Sender: TObject);
    procedure editSoundExit(Sender: TObject);
    procedure btnHelpClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const TitleStrings: Array[0..3] of ShortString = ('Welcome',
                                                  'Set-Up Your Account',
                                                  'Allow/Block Lists',
                                                  'Wizard Complete');

var
  formSetup: TformSetup;

implementation

uses MainFormUnit;

{$R *.dfm}

procedure TformSetup.FormCreate(Sender: TObject);
begin
  imgSetup.GetBitmap(0, imgRight.Picture.Bitmap);
  imgMain.GetBitmap(0, imageLeft.Picture.Bitmap);

  { Create new account }
   if SpamLearnerMainForm.numAccounts = 0 then
    SpamLearnerMainForm.FAccChanged := False;

    SpamLearnerMainForm.actAddAccountExecute(Self);
    editName.Text := SpamLearnerMainForm.edName.Text;
    editServer.Text := SpamLearnerMainForm.edServer.Text;
    editSMTPServer.Text := SpamLearnerMainForm.edSMTP.Text;
    comboProtocol.Items.Assign(SpamLearnerMainForm.cmbProtocol.Items);
    comboProtocol.ItemIndex := SpamLearnerMainForm.cmbProtocol.ItemIndex;
    editPort.Text := SpamLearnerMainForm.edPort.Text;
    editSMTPPort.Text := SpamLearnerMainForm.edSMTPPort.Text;
    editLogin.Text := SpamLearnerMainForm.edLogin.Text;
    editPassword.Text := SpamLearnerMainForm.edPassword.Text;
    colorEdit.Color := SpamLearnerMainForm.colAccount.Color;
    editProgram.Text := SpamLearnerMainForm.edAccountProgram.Text;
    editSound.Text := SpamLearnerMainForm.edSound.Text;

  { Open white-black list }
    lstWhite.Text := Options.WhiteList.Text;
    lstBlack.Text := Options.BlackList.Text
end;

procedure TformSetup.btnCancelClick(Sender: TObject);
begin
  Close;
end;

procedure TformSetup.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if Notebook.PageIndex <> 3 then
  begin
    if Application.MessageBox('Are you sure you want to close the wizard?','Wizard Not Complete', MB_YESNO+MB_ICONQUESTION) = mrYes then
    begin
      { Delete account created, wizard was cancelled }
      SpamLearnerMainForm.actDeleteAccountExecute(Self);
      Action := caFree;
    end
    else
      Action := caNone;
  end
  else
  begin
    { Wizard closed successfully, save account }
    SpamLearnerMainForm.edName.Text := editName.Text;
    SpamLearnerMainForm.edServer.Text := editServer.Text;
    SpamLearnerMainForm.edSMTP.Text := editSMTPServer.Text;
    SpamLearnerMainForm.cmbProtocol.ItemIndex := comboProtocol.ItemIndex;
    SpamLearnerMainForm.edPort.Text := editPort.Text;
    SpamLearnerMainForm.edSMTPPort.Text := editSMTPPort.Text;
    SpamLearnerMainForm.edLogin.Text := editLogin.Text;
    SpamLearnerMainForm.edPassword.Text := editPassword.Text;
    SpamLearnerMainForm.colAccount.Color := colorEdit.Color;
    SpamLearnerMainForm.edAccountProgram.Text := editProgram.Text;
    SpamLearnerMainForm.edSound.Text := editSound.Text;
    try
      SpamLearnerMainForm.btnSaveClick(Self);
    except
      Application.MessageBox('Unable to save account information.', 'Warning', MB_OK+MB_ICONWARNING);
    end;
    { Save white-black list }
    Options.WhiteList.Text := lstWhite.Text;
    Options.BlackList.Text := lstBlack.Text;
    SpamLearnerMainForm.btnSaveListsClick(Self);

    { Check all e-mail }
    if SpamLearnerMainForm.StartWizard then
    begin
     SpamLearnerMainForm.StartWizard := False;
     SpamLearnerMainForm.CheckAllMail;
    end
    else
     if SpamLearnerMainForm.NumAccounts > 0 then
      SpamLearnerMainForm.CheckMail(SpamLearnerMainForm.NumAccounts-1, True);
    Action := caFree;
  end;
end;

procedure TformSetup.btnNextClick(Sender: TObject);
begin
  if Notebook.PageIndex = 3 then
    Close; { Finish }

  Notebook.PageIndex := Notebook.PageIndex + 1;
  btnBack.Enabled := (Notebook.PageIndex > 0);
  if Notebook.PageIndex = 3 then
  begin
    btnNext.Caption := 'Finish';
    btnCancel.Enabled := False;
  end
  else
    btnNext.Caption := 'Next';

  lblTitle.Caption := TitleStrings[Notebook.PageIndex];

  imageLeft.Picture.Bitmap.Canvas.FillRect(imageLeft.ClientRect);
  imgRight.Picture.Bitmap.Canvas.FillRect(imgRight.ClientRect);
  imgSetup.GetBitmap(Notebook.PageIndex, imgRight.Picture.Bitmap);
  imgMain.GetBitmap(Notebook.PageIndex, imageLeft.Picture.Bitmap);
  Update;
end;

procedure TformSetup.btnBackClick(Sender: TObject);
begin
  btnCancel.Enabled := True;
  Notebook.PageIndex := Notebook.PageIndex - 1;
  btnBack.Enabled := (Notebook.PageIndex > 0);

  lblTitle.Caption := TitleStrings[Notebook.PageIndex];
  btnNext.Caption := 'Next';

  imageLeft.Picture.Bitmap.Canvas.FillRect(imageLeft.ClientRect);
  imgRight.Picture.Bitmap.Canvas.FillRect(imgRight.ClientRect);
  imgSetup.GetBitmap(Notebook.PageIndex, imgRight.Picture.Bitmap);
  imgMain.GetBitmap(Notebook.PageIndex, imageLeft.Picture.Bitmap);
  Update;
end;

procedure TformSetup.btnOpenProgramClick(Sender: TObject);
var
  dlgOpen : TOpenDialog;
begin
  dlgOpen := TOpenDialog.Create(nil);
  try
    dlgOpen.InitialDir := ExtractFileDir(editProgram.Text);
    dlgOpen.Filter := 'EXE files'+' (*.exe)|*.EXE|' +
                      'All files'+' (*.*)|*.*';
    if dlgOpen.Execute then
    begin
      editProgram.Text := dlgOpen.FileName;
      GetBitmapFromFileIcon(editProgram.Text, btnTestProgram.Glyph, True);
    end;
  finally
    dlgOpen.Free;
  end;
end;

procedure TformSetup.btnOpenSoundClick(Sender: TObject);
var
  dlgOpen : TOpenDialog;
begin
  dlgOpen := TOpenDialog.Create(nil);
  try
    dlgOpen.InitialDir := ExtractFileDir(editSound.Text);
    if dlgOpen.InitialDir='' then
       dlgOpen.InitialDir := ExtractFilePath(Application.ExeName)+'Sounds';
    dlgOpen.Filter := 'WAV files'+' (*.wav)|*.WAV';
    if dlgOpen.Execute then
    begin
      editSound.Text := dlgOpen.FileName;
      editSound.Font.Color := clWindowText;
    end;
  finally
    dlgOpen.Free;
  end;
end;

procedure TformSetup.btnTestProgramClick(Sender: TObject);
////////////////////////////////////////////////////////////////////////////////
// Run the e-mail client
var
  MailProgram,ExeName,Params : string;
begin
  // determine mail program
  MailProgram := Options.MailProgram;
  // run it
  if MailProgram = '' then
  begin
    Application.MessageBox('No E-Mail Client specified', 'Error', MB_ICONERROR + MB_OK);
  end
  else
  begin
    SplitExeParams(MailProgram,ExeName,Params);
    ExecuteFile(ExeName,Params,'',SW_NORMAL);
  end;
end;

procedure TformSetup.btnTestSoundClick(Sender: TObject);
begin
  if (editSound.Text = UseDefaultSound) or (editSound.Text = '') then
    PlayWav(Options.DefSound)
  else
    PlayWav(editSound.Text);
end;

procedure TformSetup.editProgramEnter(Sender: TObject);
begin
  if editProgram.Text = UseDefaultProgram then
  begin
    editProgram.Text := '';
    editProgram.Font.Color := clWindowText;
  end;
end;

procedure TformSetup.editProgramExit(Sender: TObject);
begin
  if editProgram.Text = '' then
  begin
    editProgram.Text := UseDefaultProgram;
    editProgram.Font.Color := clGrayText;
  end;
end;

procedure TformSetup.editSoundEnter(Sender: TObject);
begin
  if editSound.Text = UseDefaultSound then
  begin
    editSound.Text := '';
    editSound.Font.Color := clWindowText;
  end;
end;

procedure TformSetup.editSoundExit(Sender: TObject);
begin
  if editSound.Text = '' then
  begin
    editSound.Text := UseDefaultSound;
    editSound.Font.Color := clGrayText;
  end;
end;

procedure TformSetup.btnHelpClick(Sender: TObject);
begin
  ExecuteFile('http://www.SpamLearner.com/popsetup','','',SW_RESTORE);
end;

end.
