unit WBFrameUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

const WM_RELOAD = WM_USER + 1000;

type
  TframeWhiteBlack = class(TFrame)
    spltWhiteBlack: TSplitter;
    memWhiteList: TMemo;
    lblWhiteList: TLabel;
    lblBlackList: TLabel;
    memBlackList: TMemo;
    procedure FrameResize(Sender: TObject);
    procedure memListChange(Sender: TObject);
    procedure HelpMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure memWhiteListExit(Sender: TObject);
    procedure memBlackListExit(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    procedure Reload(var Msg: TMessage); message WM_RELOAD;
  end;

implementation

uses MainFormUnit, GlobalToolsUnit;

{$R *.dfm}

constructor TframeWhiteBlack.Create(AOwner: TComponent);
begin
  inherited;
  Options.Busy := True;
  SpamLearnerMainForm.TranslateFrame(self);
  memWhiteList.Lines.Text := Options.WhiteList.Text;
  memBlackList.Lines.Text := Options.BlackList.Text;
  Options.Busy := False;
end;

procedure TframeWhiteBlack.FrameResize(Sender: TObject);
begin
  memWhiteList.Height := (Self.Height - lblWhiteList.Height - lblBlackList.Height - spltWhiteBlack.Height) div 2;
end;

procedure TframeWhiteBlack.memListChange(Sender: TObject);
begin
    // butons
    SpamLearnerMainForm.fListsChanged := True;
    SpamLearnerMainForm.btnSaveLists.Enabled := True;
    SpamLearnerMainForm.btnCancelLists.Enabled := True;
end;

procedure TframeWhiteBlack.HelpMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  SpamLearnerMainForm.QuickHelp(Sender, Button, Shift, X, Y);
end;

procedure TframeWhiteBlack.memWhiteListExit(Sender: TObject);
begin
  Options.WhiteList.Assign(memWhiteList.Lines)
end;

procedure TframeWhiteBlack.memBlackListExit(Sender: TObject);
begin
  Options.BlackList.Assign(memBlackList.Lines);
end;

procedure TframeWhiteBlack.Reload;
begin
  memWhiteList.Lines.Text := Options.WhiteList.Text;
  memBlackList.Lines.Text := Options.BlackList.Text;
end;

end.
