unit GeneralFrameUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, 
  Dialogs, StdCtrls, Buttons;

type
  TframeDefaults = class(TFrame)
    Label9: TLabel;
    btnEdProgram: TSpeedButton;
    btnTest: TSpeedButton;
    Label8: TLabel;
    btnEdDefSound: TSpeedButton;
    btnSndTest: TSpeedButton;
    Label24: TLabel;
    btnLanguageRefresh: TSpeedButton;
    edProgram: TEdit;
    edDefSound: TEdit;
    cmbLanguage: TComboBox;
    procedure btnEdProgramClick(Sender: TObject);
    procedure btnEdDefSoundClick(Sender: TObject);
    procedure cmbLanguageChange(Sender: TObject);
    procedure btnLanguageRefreshClick(Sender: TObject);
    procedure btnTestClick(Sender: TObject);
    procedure btnSndTestClick(Sender: TObject);
    procedure OptionsChange(Sender: TObject);
    procedure HelpMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    procedure ShowLanguages;
  end;

implementation

uses MainFormUnit, UtilsUnit, GlobalToolsUnit;

{$R *.dfm}

constructor TframeDefaults.Create(AOwner: TComponent);
begin
  inherited;
  Options.Busy := True;
  SpamLearnerMainForm.TranslateFrame(self);
  // options to screen
  edProgram.Text := Options.MailProgram;
  edDefSound.Text := Options.DefSound;
  btnTest.Glyph.Assign(SpamLearnerMainForm.btnStartProgram.Glyph);
  ShowLanguages;
  Options.Busy := False;
end;

procedure TframeDefaults.ShowLanguages;
var
  i : integer;
  langs : TStringList;
begin
  langs := TStringList.Create;
  try
    // copy languages from options to stringlist
    for i := Low(Options.Languages)+1 to High(Options.Languages) do
      langs.Add(SpamLearnerMainForm.Translate(Options.Languages[i]));

    // sort it
    langs.Sort;
    langs.Insert(0,SpamLearnerMainForm.Translate(Options.Languages[0]));

    // copy from stringlist to combo-box
    cmbLanguage.Items.Assign(langs);
    cmbLanguage.ItemIndex := cmbLanguage.Items.IndexOf(Options.Languages[Options.Language]);
  finally
    langs.Free;
  end;
end;

procedure TframeDefaults.OptionsChange(Sender: TObject);
begin
  if not Options.Busy then
  begin
    // screen to options
    Options.MailProgram := edProgram.Text;
    Options.DefSound := edDefSound.Text;
    // buttons
    SpamLearnerMainForm.btnSaveOptions.Enabled := True;
    SpamLearnerMainForm.btnCancel.Enabled := True;
  end;
end;

procedure TframeDefaults.btnEdProgramClick(Sender: TObject);
var
  dlgOpen : TOpenDialog;
begin
  dlgOpen := TOpenDialog.Create(nil);
  try
    dlgOpen.InitialDir := ExtractFileDir(edProgram.Text);
    dlgOpen.Filter := SpamLearnerMainForm.Translate('EXE files')+' (*.exe)|*.exe|'+
                      SpamLearnerMainForm.Translate('All Files')+' (*.*)|*.*';
    if dlgOpen.Execute then
    begin
      edProgram.Text := dlgOpen.FileName;
      GetBitmapFromFileIcon(edProgram.Text,btnTest.Glyph,True);
    end;
  finally
    dlgOpen.Free;
  end;
end;


procedure TframeDefaults.btnEdDefSoundClick(Sender: TObject);
var
  dlgOpen : TOpenDialog;
begin
  dlgOpen := TOpenDialog.Create(nil);
  try
    dlgOpen.InitialDir := ExtractFileDir(edDefSound.Text);
    if dlgOpen.InitialDir='' then
       dlgOpen.InitialDir := ExtractFilePath(Application.ExeName)+'Sounds';  
    dlgOpen.Filter := SpamLearnerMainForm.Translate('WAV files')+' (*.wav)|*.WAV';
    if dlgOpen.Execute then
    begin
      edDefSound.Text := dlgOpen.FileName;
    end;
  finally
    dlgOpen.Free;
  end;
end;

procedure TframeDefaults.cmbLanguageChange(Sender: TObject);
var
  i : integer;
  lang : string;
begin
  // screen to options
  lang := cmbLanguage.Text;
  for i := Low(Options.Languages) to High(Options.Languages) do
    if Options.Languages[i] = lang then
    begin
      Options.Language := i;
      Break;
    end;
  // butons
  SpamLearnerMainForm.btnSaveOptions.Enabled := True;
  SpamLearnerMainForm.btnCancel.Enabled := True;
end;

procedure TframeDefaults.btnLanguageRefreshClick(Sender: TObject);
begin
  SpamLearnerMainForm.RefreshLanguages;
  ShowLanguages;
end;

procedure TframeDefaults.btnTestClick(Sender: TObject);
begin
  SpamLearnerMainForm.ExecuteProgram;
end;

procedure TframeDefaults.btnSndTestClick(Sender: TObject);
begin
  PlayWav(Options.DefSound);
end;


procedure TframeDefaults.HelpMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  SpamLearnerMainForm.QuickHelp(Sender, Button, Shift, X, Y);
end;


end.
