unit GlobalToolsUnit;

interface

uses Classes, ExtCtrls, Contnrs, SysUtils, PluginSupportUnit, Misc;

var
  Options : record
    Busy : boolean;
    // Bayesian filter enabled?
    BayesianFilterActive: Boolean;
    // upload/download ?
    UpdateBlockList: Boolean;
    // show splash screen ?
    ShowSplashScreen: Boolean;
    // interval
    TimerAccount : boolean;
    Interval : integer;
    // defaults
    MailProgram : string;
    DefSound : string;
    Languages : array of string;
    Language : integer;
    // general options
    StartUp : boolean;
    Minimized : boolean;
    Animated : boolean;
    ResetTray : boolean;
    RotateIcon : boolean;
    ShowForm : boolean;
    Balloon : boolean;
    FirstWait : integer;
    // advanced - connection
    TimeOut : integer;
    QuickCheck : boolean;
    CheckWhileMinimized : boolean;
    IgnoreRetrieveErrors : boolean;
    Online : boolean;
    TopLines : integer;
    GetBody : boolean;
    GetBodyLines : integer;
    GetBodySize : integer;
    // advanced - interface
    CheckingIcon : integer;
    ShowViewed : boolean;
    CloseMinimize : boolean;
    MinimizeTray : boolean;
    NoError : boolean;
    MultilineAccounts : boolean;
    DeleteConfirm : boolean;
    PasswordProtect : boolean;
    Password : string;
    OnTop : boolean;
    AdvInfo : boolean;
    AdvInfoDelay : integer;
    HideViewed : boolean;
    DoubleClickDelay : boolean;
    // advanced - misc
    UseMAPI : boolean;
    LogRules : boolean;
    SafeDelete : boolean;
    RememberViewed : boolean;
    BlackListSpam : boolean;
    DontCheckTimes : boolean;
    DontCheckStart : TDateTime;
    DontCheckEnd : TDateTime;
    // mouse buttons
    LeftClick : integer;
    RightClick : integer;
    MiddleClick : integer;
    DblClick : integer;
    ShiftLeftClick : integer;
    ShiftRightClick : integer;
    ShiftMiddleClick : integer;
    // hot keys
    Action1 : integer;
    Action2 : integer;
    Action3 : integer;
    Action4 : integer;
    HotKey1 : integer;
    HotKey2 : integer;
    HotKey3 : integer;
    HotKey4 : integer;
    // white list / black list
    WhiteList : TStringList;
    BlackList : TStringList;
    // info
    InfoTab : integer;
    InfoCol1 : integer;
    InfoCol2 : integer;
    InfoCol3 : integer;
    InfoCol4 : integer;
  end;

const
  // checking icon
  ciNone = 0;
  ciLightning = 1;
  ciStar = 2;
  ciAnimatedStar = 3;
  // options
  optInterval = 0;
  optDefaults = 1;
  optGeneralOptions = 2;
  optAdvancedOptions = 3;
  optAdvancedInterface = 4;
  optRules = 5;
  optAutorespond = 6;
  optAdvancedMisc = 7;
  optMouseButtons = 8;
  optHotKeys = 9;
  optPlugins = 10;


type
  TAutorespond = record
                    Subject, ID: ShortString;
                    LengthMsg: Word;
                    Msg: Array[1..4097] of Char;
                 end;
  TAutorespondFile = file of TAutorespond;

  TProtocol = record
    Name : string;
    Port : integer;
    Prot : TPluginProtocol;
  end;

var
  Protocols : array of TProtocol;

const
  Actions : array[0..14] of string =
    ('Nothing','Review Spam & Junk E-Mail','Pop-Up Menu','Check for Mail',
     'Shortcut to E-Mail Client','Check and Show','Show Info','Check and Info',
     'Toggle Message Window','Toggle AutoCheck','New Message',
     'Toggle Sound','Delete Spam','Mark as Viewed','Check First Account');

type
  TCommand = (cmdNothing,cmdShow,cmdMenu,cmdCheck,
              cmdRun,cmdCheckShow,cmdInfo,cmdCheckInfo,
              cmdToggleShow,cmdToggleAutoCheck,cmdNewMessage,
              cmdToggleSound, cmdDeleteSpam, cmdMarkViewed,
              cmdCheckFirst,
              // extra commands
              cmdAutoCheckOn,cmdAutoCheckOff,cmdSoundOn,cmdSoundOff);

function StrToAction(st: string): TCommand;

implementation

function StrToAction(st: string): TCommand;
begin
  st := UpperCase(st);
  Result := cmdNothing;
  if st = 'SHOW' then Result := cmdShow
  else if st = 'MENU' then Result := cmdMenu
  else if st = 'CHECK' then Result := cmdCheck
  else if st = 'CHECKALL' then Result := cmdCheck
  else if st = 'RUNCLIENT' then Result := cmdRun
  else if st = 'CHECKSHOW' then Result := cmdCheckShow
  else if st = 'INFO' then Result := cmdInfo
  else if st = 'CHECKINFO' then Result := cmdCheckInfo
  else if st = 'WINDOW' then Result := cmdToggleShow
  else if st = 'AUTOCHECK' then Result := cmdToggleAutoCheck
  else if st = 'NEW' then Result := cmdNewMessage
  else if st = 'SOUND' then Result := cmdToggleSound
  else if st = 'DELSPAM' then Result := cmdDeleteSpam
  else if st = 'MARKVIEWED' then Result := cmdMarkViewed
  else if st = 'AUTOCHECKON' then Result := cmdAutoCheckOn
  else if st = 'AUTOCHECKOFF' then Result := cmdAutoCheckOff
  else if st = 'SOUNDON' then Result := cmdSoundOn
  else if st = 'SOUNDOFF' then Result := cmdSoundOff
end;


initialization
  Options.WhiteList := TStringList.Create;
  Options.BlackList := TStringList.Create;

finalization
  Options.WhiteList.Free;
  Options.BlackList.Free;


end.
