unit MailToolsUnit;

interface

uses MAPI, Windows, Forms, Dialogs, SysUtils;

type
  TUnknownMsg = ^UnknownMsg;
  Info = record
           From, Subject, MailTo: ShortString;
           Path:                  ShortString;
           Date:                  TDateTime;
           Size:                  Word;
           Spam:                  Boolean;
           Viewed:                Boolean;
         end;
  UnknownMsg = record
                 Account: Info;
                 Next: TUnknownMsg;
               end;

function SendMailMAPI(const Subject, Body, FileName, SenderName, SenderEMail,
  RecepientName, RecepientEMail: string): Integer;

implementation

function SendMailMAPI(const Subject, Body, FileName, SenderName, SenderEMail,
  RecepientName, RecepientEMail: string): Integer;
var
  message: TMapiMessage;
  lpSender,
    lpRecepient: TMapiRecipDesc;
  FileAttach: TMapiFileDesc;
  SM: TFNMapiSendMail;
  MAPIModule: HModule;
begin
  FillChar(message, SizeOf(message), 0);
  with message do
  begin
    if (Subject <> '') then
    begin
      lpszSubject := PChar(Subject)
    end;
    if (Body <> '') then
    begin
      lpszNoteText := PChar(Body)
    end;
    if (SenderEMail <> '') then
    begin
      lpSender.ulRecipClass := MAPI_ORIG;
      if (SenderName = '') then
      begin
        lpSender.lpszName := PChar(SenderEMail)
      end
      else
      begin
        lpSender.lpszName := PChar(SenderName)
      end;
      lpSender.lpszAddress := PChar('SMTP:' + SenderEMail);
      lpSender.ulReserved := 0;
      lpSender.ulEIDSize := 0;
      lpSender.lpEntryID := nil;
      lpOriginator := @lpSender;
    end;
    if (RecepientEMail <> '') then
    begin
      lpRecepient.ulRecipClass := MAPI_TO;
      if (RecepientName = '') then
      begin
        lpRecepient.lpszName := PChar(RecepientEMail)
      end
      else
      begin
        lpRecepient.lpszName := PChar(RecepientName)
      end;
      lpRecepient.lpszAddress := PChar('SMTP:' + RecepientEMail);
      lpRecepient.ulReserved := 0;
      lpRecepient.ulEIDSize := 0;
      lpRecepient.lpEntryID := nil;
      nRecipCount := 1;
      lpRecips := @lpRecepient;
    end
    else
    begin
      lpRecips := nil
    end;
    if (FileName = '') then
    begin
      nFileCount := 0;
      lpFiles := nil;
    end
    else
    begin
      FillChar(FileAttach, SizeOf(FileAttach), 0);
      FileAttach.nPosition := Cardinal($FFFFFFFF);
      FileAttach.lpszPathName := PChar(FileName);
      nFileCount := 1;
      lpFiles := @FileAttach;
    end;
  end;
  MAPIModule := LoadLibrary(PChar(MAPIDLL));
  if MAPIModule = 0 then
  begin
    Result := -1
  end
  else
  begin
    try
      @SM := GetProcAddress(MAPIModule, 'MAPISendMail');
      if @SM <> nil then
      begin
        Result := SM(0, Application.Handle, message, MAPI_DIALOG or
          MAPI_LOGON_UI, 0);
      end
      else
      begin
        Result := 1
      end;

    finally
      FreeLibrary(MAPIModule);
    end;
  end;
  if Result <> 0 then
    begin
      MessageDlg('Error sending mail (' + IntToStr(Result) + ').', mtError, [mbOk],
        0)
    end;
end;

end.
