unit OutlookFormUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Buttons, ComCtrls, Registry, MainFormUnit, ShellAPI;

type
  TOutlookWizardForm = class(TForm)
    topPanel: TPanel;
    Shape1: TShape;
    Image1: TImage;
    Label1: TLabel;
    Label2: TLabel;
    bottomPanel: TPanel;
    btnHelp: TBitBtn;
    btnBack: TBitBtn;
    btnNext: TBitBtn;
    btnCancel: TBitBtn;
    Notebook: TNotebook;
    Label3: TLabel;
    Label4: TLabel;
    Bevel1: TBevel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Bevel2: TBevel;
    Label8: TLabel;
    Label9: TLabel;
    Info: TRadioGroup;
    Label10: TLabel;
    Label11: TLabel;
    Bevel3: TBevel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Accounts: TRadioGroup;
    Label15: TLabel;
    PBar: TProgressBar;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Timer1: TTimer;
    Image2: TImage;
    procedure btnCancelClick(Sender: TObject);
    procedure btnNextClick(Sender: TObject);
    procedure btnBackClick(Sender: TObject);
    procedure btnHelpClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  OutlookWizardForm: TOutlookWizardForm;

implementation

{$R *.dfm}

procedure TOutlookWizardForm.btnCancelClick(Sender: TObject);
begin
  Close;
end;

procedure TOutlookWizardForm.btnNextClick(Sender: TObject);

procedure Process;
var Reg: TRegINIFile;
    Keys: TStrings;
    I: Integer;
    TotalImported: Word;

procedure AddAccount(Name: String);
begin
   if SpamLearnerMainForm.numAccounts = 0 then
    SpamLearnerMainForm.FAccChanged := False;
   SpamLearnerMainForm.actAddAccountExecute(Self);
   { Add account }
   SpamLearnerMainForm.edName.Text := Reg.ReadString(Name, 'Account Name', 'Default');
   SpamLearnerMainForm.edServer.Text := Reg.ReadString(Name, 'POP3 Server', 'Default');
   SpamLearnerMainForm.edSMTP.Text := Reg.ReadString(Name, 'SMTP Server', 'Default');
   SpamLearnerMainForm.cmbProtocol.ItemIndex := 0; { POP3 }
//   SpamLearnerMainForm.edPort.Text := Reg.ReadString(Name, 'POP3 Port', '110');
//   SpamLearnerMainForm.edSMTPPort.Text := Reg.ReadString(Name, 'SMTP Port', '25');
   SpamLearnerMainForm.edLogin.Text := Reg.ReadString(Name, 'POP3 User Name', 'Default');
   SpamLearnerMainForm.edPassword.Text := ''; { Nothing }
   try
    SpamLearnerMainForm.btnSaveClick(Self);
   except
    Dec(TotalImported);
   end;
end;

begin
  TotalImported := 0;
  Reg := TRegINIFile.Create;
  Reg.RootKey := HKEY_CURRENT_USER;
  if (Info.ItemIndex = 1) or (Info.ItemIndex = 2) then
    if Reg.KeyExists('Software\Microsoft\Internet Account Manager\Accounts') then
    begin
      { Process Outlook Express }
      Reg.OpenKey('Software\Microsoft\Internet Account Manager\Accounts', False);
      Keys := TStringList.Create;
      Reg.ReadSections(Keys); { Read all sections }
      I := 0;
      while I <= Keys.Count - 1 do
       begin
         try
           StrToInt(Keys[I]);
           if Length(Keys[I]) <> 8 then
           begin { Not in format! }
             Keys.Delete(I);
             Dec(I);
           end;
         except
           Keys.Delete(I);
           Dec(I);
         end;
         Inc(I);
       end;
      PBar.Max := Keys.Count;
      PBar.Position := 0;
      if Accounts.ItemIndex = 0 then
        { Only current account }
        begin
         AddAccount(Keys[0]);
         TotalImported := 1;
         Label19.Caption := IntToStr(TotalImported);
         PBar.Position := PBar.Max;
        end
      else
        { All accounts }
        begin
         for I:=0 to Keys.Count - 1 do
         begin
           AddAccount(Keys[I]);
           PBar.Position := PBar.Position+1;
           Application.ProcessMessages;
           TotalImported := TotalImported + 1;
           Label19.Caption := IntToStr(TotalImported);
         end;
         PBar.Position := PBar.Max;
        end;
      Keys.Free;
    end;
  Reg.Free;

  Reg := TRegINIFile.Create; { Re-open }
  Reg.RootKey := HKEY_CURRENT_USER;
  if (Info.ItemIndex = 0) or (Info.ItemIndex = 2) then
   if Reg.KeyExists('Software\Microsoft\Office\Outlook\OMI Account Manager\Accounts') then
    begin
      { Process Outlook }
      Reg.OpenKey('Software\Microsoft\Office\Outlook\OMI Account Manager\Accounts', False);
      Keys := TStringList.Create;
      Reg.ReadSections(Keys); { Read all sections }
      I := 0;
      while I <= Keys.Count - 1 do
       begin
         try
           StrToInt(Keys[I]);
           if Length(Keys[I]) <> 8 then
           begin { Not in format! }
             Keys.Delete(I);
             Dec(I);
           end;
         except
           Keys.Delete(I);
           Dec(I);
         end;
         Inc(I);
       end;
      PBar.Max := Keys.Count;
      PBar.Position := 0;
      if Accounts.ItemIndex = 0 then
        { Only current account }
        begin
         AddAccount(Keys[0]);
         TotalImported := 1;
         Label19.Caption := IntToStr(TotalImported);
         PBar.Position := PBar.Max;
        end
      else
        { All accounts }
        begin
         for I:=0 to Keys.Count - 1 do
         begin
           AddAccount(Keys[I]);
           PBar.Position := PBar.Position+1;
           Application.ProcessMessages;
           TotalImported := TotalImported + 1;
           Label19.Caption := IntToStr(TotalImported);
         end;
         PBar.Position := PBar.Max;
        end;
    end;
  Reg.Free;
end;

begin
  if Notebook.PageIndex = 3 then
  begin
    Close;
    Exit;
  end;

  Notebook.PageIndex := Notebook.PageIndex+1;
  btnBack.Enabled := True;

  if Notebook.PageIndex = 3 then
  begin
    btnNext.Enabled := False;
    btnBack.Enabled := False;
    btnCancel.Enabled := False;

    Process; // in here we process accounts

    Label15.Caption := 'Finished!';
    btnNext.Caption := 'Finish';
    btnNext.Enabled := True;
    PBar.Visible := False;
    Label16.Visible := True;
  end;
end;

procedure TOutlookWizardForm.btnBackClick(Sender: TObject);
begin
  Notebook.PageIndex := Notebook.PageIndex - 1;
  if Notebook.PageIndex = 0 then
    btnBack.Enabled := False;
end;

procedure TOutlookWizardForm.btnHelpClick(Sender: TObject);
begin
  ShellExecute(Handle, 'open', 'http://www.SpamLearner.com/support', '', '', SW_SHOWNORMAL);
end;

end.
