#include "Plugin.h"
#include <winuser.h>
#include <tchar.h>
#include "Resource.h"


BOOL WINAPI DllMain (HINSTANCE hInst, DWORD ulReason, LPVOID lpReserved)
{
  switch(ulReason)
  {
    case DLL_PROCESS_ATTACH:
      g_hInst = hInst;
      g_pPlugin = new Plugin();
      break;
    case DLL_THREAD_ATTACH:
      break;
    case DLL_THREAD_DETACH:
      break;
    case DLL_PROCESS_DETACH:
      delete g_pPlugin;
      break;
  };
  return (1);
}

LRESULT CALLBACK DlgProc(HWND hWndDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
	int iLog;

	switch(Msg)
	{
		case WM_INITDIALOG:
			iLog = g_pTools->CheckLogging();
			if ( iLog > 0)   CheckDlgButton(hWndDlg, IDC_CHECK_LOG, BST_CHECKED);
			if ( iLog == 2)  CheckDlgButton(hWndDlg, IDC_CHECK_LOG_EXT, BST_CHECKED);
			return TRUE;
			break;

		case WM_COMMAND:
			bool bChecked;

			switch( LOWORD( wParam ) )
			{
				case IDC_CHECK_LOG :
					bChecked = (IsDlgButtonChecked( hWndDlg, IDC_CHECK_LOG ) == BST_CHECKED);
					CheckDlgButton( hWndDlg, IDC_CHECK_LOG, bChecked ? BST_CHECKED : BST_UNCHECKED );
					if (bChecked)
						EnableWindow(GetDlgItem( hWndDlg, IDC_CHECK_LOG_EXT), true);
					else
						EnableWindow(GetDlgItem( hWndDlg, IDC_CHECK_LOG_EXT), false);
					break;
				case IDC_CHECK_LOG_EXT :
					bChecked = (IsDlgButtonChecked( hWndDlg, IDC_CHECK_LOG_EXT ) == BST_CHECKED);
					CheckDlgButton( hWndDlg, IDC_CHECK_LOG_EXT, bChecked ? BST_CHECKED : BST_UNCHECKED );
					break;
				case IDCANCEL :
          EndDialog( hWndDlg, IDCANCEL );
          break;
				case IDOK:
					iLog = 0;
					if ( IsDlgButtonChecked( hWndDlg, IDC_CHECK_LOG ) == BST_CHECKED )
					{
						iLog = 1;
						if ( IsDlgButtonChecked( hWndDlg, IDC_CHECK_LOG_EXT ) == BST_CHECKED )
						{
							iLog = 2;
						}
					}
					g_pTools->SetLogging(iLog);
					EndDialog(hWndDlg, IDOK);
					return TRUE;
			}
			break;
	}

	return FALSE;
}

int pCheckMessages()
{
  return g_pPlugin->CheckMessages();
}

void pConnect(LPCSTR Server, int Port, LPCSTR Protocol, LPCSTR UserName, LPCSTR Password, int Timeout)
{
  g_pPlugin->Connect(Server, Port, Protocol, UserName, Password, Timeout);
}

bool pConnected()
{
  return g_pPlugin->Connected();
}

bool fDelete(int MsgNum)
{
  return g_pPlugin->Delete(MsgNum);
}

void pDisconnect()
{
  g_pPlugin->Disconnect();
}

void pFreePChar(LPCSTR* pstrBuffer)
{
  g_pPlugin->FreePChar(pstrBuffer);
}

void pInit()
{
  g_pPlugin->Init();
}

ShortString fPluginName()
{
  return g_pPlugin->PluginName();
}

int fPluginType()
{
  return g_pPlugin->PluginType();
}

ShortString fProtocols()
{
  return g_pPlugin->Protocols();
}

bool fRetrieveHeader(int MsgNum, LPCSTR* pHeader)
{
  return g_pPlugin->RetrieveHeader(MsgNum, pHeader);
}

int fRetrieveMsgSize(int MsgNum)
{
  return g_pPlugin->RetrieveMsgSize(MsgNum);
}

bool fRetrieveRaw(int MsgNum, LPCSTR* pRawMsg)
{
  return g_pPlugin->RetrieveRaw(MsgNum, pRawMsg);
}

bool fRetrieveTop(int MsgNum, int LineCount, LPCSTR* pDest)
{
  return g_pPlugin->RetrieveTop(MsgNum, LineCount, pDest);
}

void pSetOnWork(__closure pCallBack)
{
  g_pPlugin->SetOnWork(pCallBack);
}

LPCSTR fLastErrorMsg()
{
  return g_pPlugin->LastErrorMsg();
}

void pShowOptions()
{
  g_pPlugin->ShowOptions();
}

bool fUIDL(LPCSTR* pUIDL, int MsgNum)
{
  return g_pPlugin->UIDL(pUIDL, MsgNum);
}

int fInterfaceVersion()
{
  return g_pPlugin->InterfaceVersion();
}

void pMessageCheck(LPCSTR MsgFrom, LPCSTR MsgTo, LPCSTR MsgSubject, TDateTime MsgDate, bool Viewed, bool New, bool Important, bool Spam)
{
}

void pNotify(int MailCount, int UnviewedCount, int NewCount, bool ResetTray)
{
}

void pUnload()
{
  g_pPlugin->Unload();
}


///////////////////////////////// Plugin Class Public /////////////////////////////////////////

Plugin::Plugin()
{
	g_bConnected = false;
	g_pInbox = NULL;
	g_pXMLHTTP = NULL;
	g_iTimeout = 60;

	g_pTools = new Tools(g_hInst);

  // Set PluginName
	strcpy(g_sstrName.str,"Hotmail\0"); // Zero-Terminated !
	g_sstrName.len = strlen(g_sstrName.str);

	// Set PluginType (piNotify, piProtocol or piRuleAction)
  g_iPluginType = piProtocol;

	strcpy(g_sstrProtocols.str,"HTTPmail (Hotmail)\0");
	g_sstrProtocols.len = strlen(g_sstrProtocols.str);

  // Initialize OLE libraries
	CoInitialize(NULL);
}

Plugin::~Plugin()
{
	delete g_pTools;

  // UnInitialize OLE libraries
	CoUninitialize();
}

void Plugin::Init()
{
	g_pTools->LogWrite( "- Init" );
}

ShortString Plugin::PluginName()
{
	return g_sstrName;
}

int Plugin::PluginType()
{
	return g_iPluginType;
}

ShortString Plugin::Protocols()
{
	return g_sstrProtocols;
}

bool Plugin::Connected()
{
	return g_bConnected;
}

void Plugin::Connect(LPCSTR Server, int Port, LPCSTR Protocol, LPCSTR Username, LPCSTR Password, int Timeout)
{
  _bstr_t bsLogConn;
	char sTemp[20];

	bsLogConn  = "- Connect [";
	bsLogConn += "Protocol:";
	bsLogConn += Protocol;
 #ifdef _DEBUG
	bsLogConn += " Username:";
	bsLogConn += Username;
	bsLogConn += " Password:";
	bsLogConn += Password;
 #endif
	bsLogConn += " Timeout:";
	bsLogConn += itoa(Timeout, sTemp, 10);
	bsLogConn += "]";
	g_pTools->LogWrite( bsLogConn );

	g_iTimeout = Timeout;

  _bstr_t bsResponse;
	_bstr_t bsStatus;
  HRESULT hr;
	long lState = 0;
	long lStatus = 0;

	strcpy(g_strErrorMsg, "\0");

	g_pTools->setreg();

	if ( g_pTools->isMSXMLInstalled() )
	{
		try
		{
			g_pTools->LogWrite( "  Create MSXML Instances" );
			g_pXMLHTTP.CreateInstance("Msxml2.XMLHTTP.3.0");
			g_pInbox.CreateInstance("Msxml2.DOMDocument.3.0");
		}
		catch (...)
		{
			g_pTools->LogWrite( "  ERROR: Could not open MSXML; please (re)install MSXML3!" );
			if ( strlen(g_strErrorMsg) == 0 )
			{
				strcpy(g_strErrorMsg, "Could not open MSXML; please (re)install MSXML3!");
			}
			Disconnect();

			return;
		}
	}
	else
	{
		g_pTools->LogWrite( "  ERROR: MSXML3 not installed" );
		if ( strlen(g_strErrorMsg) == 0 )
		{
			strcpy(g_strErrorMsg, "Could not find MSXML; please (re)install MSXML3!");
		}
		return;
	}

  try
  {
		g_bConnected = true;

		for(int auth=1; auth<=2; auth++) // Current Microsoft HTTPMail protocol needs us to login twice!
		{
			_bstr_t bsHotmailURL = "http://services.msn.com/svcs/hotmail/httpmail.asp";
			g_pTools->LogWrite( "  Open XMLHTTP Object" );
			hr = g_pXMLHTTP->open(_bstr_t("PROPFIND"), bsHotmailURL, VARIANT_FALSE, _variant_t(Username), _variant_t(Password));
			if (FAILED(hr))	throw hr;

			_bstr_t bsQueryFolders = 
				"<?xml version='1.0'?>"
				"<D:propfind xmlns:D='DAV:' xmlns:h='http://schemas.microsoft.com/hotmail/' xmlns:hm='urn:schemas:httpmail:'>"
				" <D:prop>"
				"  <hm:inbox/>"
				"  <hm:deleteditems/>"
				" </D:prop>"
				"</D:propfind>";

			g_pTools->LogWrite( "  Set XMLHTTP RequestHeader PROPFIND to QueryFolders" );
			hr = g_pXMLHTTP->setRequestHeader("PROPFIND", bsQueryFolders);
			if (FAILED(hr))	throw hr;

			// Pretend we are Outlook Express
			g_pTools->LogWrite( "  Set XMLHTTP RequestHeader User-Agent to Outlook Express" );
	    hr=g_pXMLHTTP->setRequestHeader("User-Agent","Outlook Express/5.0 (MSIE 5.0; Windows 98; DigExt; MSNIA)");
			if (FAILED(hr))	throw hr;

			g_pTools->LogWrite( "  Send -->" );
			hr = g_pXMLHTTP->send();
			if (FAILED(hr))	throw hr;
		}

		g_pTools->LogWrite( "  Get XMLHTTP ReadyState" );
    hr = g_pXMLHTTP->get_readyState(&lState);
  	if (FAILED(hr))	throw hr;

    if (lState == 4)
		{
			bsStatus = g_pXMLHTTP->GetstatusText();

			if (strcmp( (char*)bsStatus, "Multi-Status") == 0)
			{
				_bstr_t bsLogStatus  = "  Status: ";
				bsLogStatus += bsStatus;
				g_pTools->LogWrite( bsLogStatus );

				bsResponse = g_pXMLHTTP->responseText;
				g_bsInboxURL = g_pTools->MidStr(bsResponse, L"<hm:inbox>", L"</hm:inbox>");
				g_bsTrashURL = g_pTools->MidStr(bsResponse, L"<hm:deleteditems>", L"</hm:deleteditems>");

				_bstr_t bsQF;
				bsQF  = "  QueryFolders: ";
				bsQF += bsResponse;
				g_pTools->LogWriteExt( bsQF );

				_bstr_t bsInbox;
				bsInbox  = "  Inbox URL: ";
				bsInbox += g_bsInboxURL;
				g_pTools->LogWriteExt( bsInbox );
			}
			else
			{
				_bstr_t bsLogStatus  = "  ERROR: ";
				bsLogStatus += bsStatus;
				g_pTools->LogWrite( bsLogStatus );

				strcpy(g_strErrorMsg, (char*)bsStatus);

				g_bConnected = false;
				throw hr;
			}
		}
		else
		{
			g_pTools->LogWrite( "  ERROR: Connection Not Ready" );
			strcpy(g_strErrorMsg, "Connection Not Ready");

			g_bConnected = false;
			throw hr;
		}

		if (g_bConnected)
		{
			g_pTools->LogWrite( "  Open XMLHTTP Object" );
			hr = g_pXMLHTTP->open("PROPFIND", g_bsInboxURL, VARIANT_FALSE);
			if (FAILED(hr))	throw hr;

	/* Alternative GetFolderInfo

			_bstr_t bsGetFolderInfo = 
				"<?xml version='1.0'?>"
				"<D:propfind xmlns:D='DAV:' xmlns:hm='urn:schemas:httpmail:'>"
				" <D:prop>"
				"  <D:isfolder/>"
				"  <D:displayname/>"
				"  <hm:special/>"
				"  <D:hassubs/>"
				"  <D:nosubs/>"
				"  <hm:unreadcount/>"
				"  <D:visiblecount/>"
				"  <hm:special/>"
				" </D:prop>"
				"</D:propfind>";
	*/
			_bstr_t bsGetFolderInfo = 
				"<?xml version='1.0'?>"
				"<D:propfind xmlns:D='DAV:' xmlns:hm='urn:schemas:httpmail:' xmlns:m='urn:schemas:mailheader:'>"
				" <D:prop>"
				"  <D:isfolder/>"
				"  <hm:read/>"
				"  <m:hasattachment/>"
				"  <m:to/>"
				"  <m:from/>"
				"  <m:subject/>"
				"  <m:date/>"
				"  <D:getcontentlength/>"
				" </D:prop>"
				"</D:propfind>";

			g_pTools->LogWrite( "  Set XMLHTTP RequestHeader PROPFIND to GetFolderInfo" );
			hr = g_pXMLHTTP->setRequestHeader("PROPFIND", bsGetFolderInfo);
			if (FAILED(hr))	throw hr;

			g_pTools->LogWrite( "  Send -->" );
			hr = g_pXMLHTTP->send();
			if (FAILED(hr))	throw hr;

			_bstr_t bsResp;
			bsResp  = "  GetFolderInfo:\n";
			bsResp += g_pXMLHTTP->responseText;
			g_pTools->LogWriteExt( bsResp );

			g_pInbox = g_pXMLHTTP->responseXML;
		}
  }
	catch (...)
	{
		g_pTools->LogWrite( "  Could not connect to Hotmail server!" );
		if ( strlen(g_strErrorMsg) == 0 )
		{
			strcpy(g_strErrorMsg, "Could not connect to Hotmail server!");
		}
		Disconnect();
  }
}

// Return number of messages
int Plugin::CheckMessages()
{
	g_pTools->LogWrite( "- CheckMessages" );

	if (g_bConnected && g_pInbox!=NULL && g_pInbox->parsed)
	{
		IXMLDOMNodeListPtr NodeListPtr;

		NodeListPtr = g_pInbox->getElementsByTagName(_bstr_t("D:prop"));
		return NodeListPtr->length;
	}
	else
	{
		g_pTools->LogWrite( "  ERROR: Inbox Not loaded" );
		return 0;
	}
}

bool Plugin::UIDL(LPCSTR* pUIDL, int MsgNum)
{
  _bstr_t bsLog;
	char sTemp[20];

	bsLog  = "- UIDL (";
	bsLog += itoa(MsgNum, sTemp, 10);
	bsLog += ")";
	g_pTools->LogWrite( bsLog );

	bool bSuccess = false;

	if (g_bConnected && g_pInbox!=NULL && g_pInbox->parsed)
	{
		IXMLDOMNodeListPtr NodeListPtr;
		IXMLDOMNodePtr spProp, spID;
		_bstr_t bsUIDL;

		bsUIDL = "";

		try
		{
			NodeListPtr = g_pInbox->getElementsByTagName(_bstr_t("D:prop"));

			if (NodeListPtr!=NULL && NodeListPtr->length > 0)
			{
				if (MsgNum==-1)
				{
					// List of UIDL's seperated by \n
					for (int i=0; i<=NodeListPtr->length; i++)
					{
						NodeListPtr->get_item(i, &spProp);

						if (spProp!=NULL && spProp->parsed)
						{
							spID = spProp->selectSingleNode("D:id");
							if (spID!=NULL && spID->parsed)
							{
								bsUIDL += itoa(i+1, sTemp, 10);
								bsUIDL += " ";
								bsUIDL += spID->text;
								bsUIDL += "\n";
							}
						}
					}
					bSuccess = true;
				}
				else
				{
					NodeListPtr->get_item(MsgNum-1, &spProp);

					if (spProp!=NULL && spProp->parsed)
					{
						bsUIDL += itoa(MsgNum, sTemp, 10);
						bsUIDL += " ";
						spID = spProp->selectSingleNode("D:id");
						if (spID!=NULL && spID->parsed)
						{
							bsUIDL += spID->text;
						}
						bSuccess = true;
					}
				}
			}
			g_pTools->LogWriteExt( bsUIDL );
		}
		catch (...)
		{
			g_bConnected = false;
			g_pTools->LogWrite( "  ERROR in UIDL!" );
		}

		g_lpPStr = new char[bsUIDL.length() * sizeof(char) + sizeof(char)];
		strcpy(g_lpPStr, (char*)bsUIDL);
  
		*pUIDL = g_lpPStr;
	}
	else
	{
		g_pTools->LogWrite( "  ERROR: Inbox Not loaded" );
	}
	
	return true;
}

bool Plugin::RetrieveHeader(int MsgNum, LPCSTR* pHeader)
{
  _bstr_t bsLog;
	char sTemp[20];

	bsLog  = "- RetrieveHeader (";
	bsLog += itoa(MsgNum, sTemp, 10);
	bsLog += ")";
	g_pTools->LogWrite( bsLog );

	bool bSuccess = false;

	if (g_pInbox!=NULL && g_pInbox->parsed)
	{
		IXMLDOMNodeListPtr NodeListPtr;
		IXMLDOMNodePtr spProp, spTo, spToAddr, spFrom, spFromAddr, spDate, spSubject;
		_bstr_t bsHeader;

		bsHeader = "";

		try
		{
			NodeListPtr = g_pInbox->getElementsByTagName(_bstr_t("D:prop"));

			if (NodeListPtr!=NULL && NodeListPtr->length > 0)
			{
				NodeListPtr->get_item(MsgNum-1, &spProp);

				if (spProp!=NULL && spProp->parsed)
				{
					// To
					bsHeader += "To: ";
					spTo = spProp->selectSingleNode(_bstr_t("m:to"));
					if (spTo!=NULL && spTo->parsed)
					{
						bsHeader += spTo->text;
					}
					spToAddr = spProp->selectSingleNode("h:toaddr");
					if (spToAddr!=NULL && spToAddr->parsed)
					{
						bsHeader += "<";
						bsHeader += spToAddr->text;
						bsHeader += ">";
					}
					bsHeader += "\n";
					// From
					bsHeader += "From: ";
					spFrom = spProp->selectSingleNode("m:from");
					_bstr_t bsFrom;
					if (spFrom!=NULL && spFrom->parsed)
					{
						bsFrom = spFrom->text;
						bsHeader += bsFrom;
					}
					if ( !(g_pTools->InStr(bsFrom, L"@")>0) )
					{
						spFromAddr = spProp->selectSingleNode("h:fromaddr");
						if (spFromAddr!=NULL && spFromAddr->parsed)
						{
							bsHeader += "<";
							bsHeader += spFromAddr->text;
							bsHeader += ">";
						}
					}
					bsHeader += "\n";
					// Subject
					bsHeader += "Subject: ";
					spSubject = spProp->selectSingleNode("m:subject");
					if (spSubject!=NULL && spSubject->parsed)
					{
						bsHeader += spSubject->text;
					}
					bsHeader += "\n";
					// Date
					spDate = spProp->selectSingleNode("m:date");
					if (spDate!=NULL && spDate->parsed)
					{
						_bstr_t bsDate = spDate->text;
						_bstr_t bsTmp;
						_bstr_t bsMonth;
						int			iMonth;

						// Converting from Hotmail Format: 2003-09-15T09:00:00 To ddd, dd MMM yyyy hh:mm:ss
						bsHeader += "Date: ";
						bsHeader += g_pTools->Trim(g_pTools->Mid(bsDate, 8, 2));
						bsHeader += " ";
						bsMonth = g_pTools->Trim(g_pTools->Mid(bsDate, 5, 2));
						iMonth = atoi(bsMonth);
						// correct offset
						if ( iMonth>=1 && iMonth<=12 )
							iMonth--;
						else
							iMonth = 0;
						bsHeader += Month[iMonth];
						bsHeader += " ";
						bsHeader += g_pTools->Trim(g_pTools->Mid(bsDate, 0, 4));
						int iTime;
						bsHeader += " ";
						iTime = g_pTools->InStr(bsDate, L"T");
						if (iTime>0) bsHeader += g_pTools->Trim(g_pTools->Mid(bsDate, iTime, 8));
						bsHeader += " +0000";
						bsHeader += "\n";
					}
					// Final CR (End of Header)
					bsHeader += "\n";

					bSuccess = true;
				}
			}
		}
		catch (...)
		{
			g_bConnected = false;
			g_pTools->LogWrite( "  ERROR in RetrieveHeader!" );
		}

		_bstr_t bsHdr;
		bsHdr  = "  Header:\n";
		bsHdr += bsHeader;
		g_pTools->LogWriteExt( bsHdr );

		g_lpPStr = new char[bsHeader.length() * sizeof(char) + sizeof(char)];
		strcpy(g_lpPStr, (char*)bsHeader);
  
		*pHeader = g_lpPStr;
	}
	else
	{
		g_pTools->LogWrite( "  ERROR: Inbox Not loaded" );
	}

	return bSuccess;
}

int Plugin::RetrieveMsgSize(int MsgNum)
{
  _bstr_t bsLog;
	char sTemp[20];

	bsLog  = "- RetrieveMsgSize (";
	bsLog += itoa(MsgNum, sTemp, 10);
	bsLog += ")";
	g_pTools->LogWrite( bsLog );

	int iLen = 0;

	if (g_pInbox!=NULL && g_pInbox->parsed)
	{
		IXMLDOMNodeListPtr NodeListPtr;
		IXMLDOMNodePtr spProp, spLength;
		_bstr_t bsLength;

		NodeListPtr = g_pInbox->getElementsByTagName("D:prop");
		NodeListPtr->get_item(MsgNum-1, &spProp);

		spLength = spProp->selectSingleNode("D:getcontentlength");
		iLen = g_pTools->stol(_bstr_t(spLength->text));
	}
	else
	{
		g_pTools->LogWrite( "  ERROR: Inbox Not loaded" );
	}

	return iLen;
}

bool Plugin::RetrieveRaw(int MsgNum, LPCSTR* pRawMsg)
{
  _bstr_t bsLog;
	char sTemp[20];

	bsLog  = "- RetrieveRaw (";
	bsLog += itoa(MsgNum, sTemp, 10);
	bsLog += ")";
	g_pTools->LogWrite( bsLog );

	bool bSuccess = false;

	if (g_pInbox!=NULL && g_pInbox->parsed)
	{
		IXMLDOMNodeListPtr NodeListPtr;
		IXMLDOMNodePtr spURL, spResp;
		HRESULT hr;
		_bstr_t bsRaw, bsURL;

		NodeListPtr = g_pInbox->getElementsByTagName("D:response");

		NodeListPtr->get_item(MsgNum-1, &spResp);

		spURL = spResp->selectSingleNode("D:href");

		bsURL = spURL->text;

		try
		{
			g_bConnected = true;

			g_pTools->LogWrite( "  Open XMLHTTP Object" );
			hr = g_pXMLHTTP->open(_bstr_t("GET"), bsURL, VARIANT_FALSE);
			if (FAILED(hr))	throw hr;

			g_pTools->LogWrite( "  Send -->" );
			hr = g_pXMLHTTP->send();
			if (FAILED(hr))	throw hr;

			bsRaw = g_pXMLHTTP->responseText;
			_bstr_t bsMess;
			bsMess  = "  Message: ";
			bsMess += bsRaw;
			g_pTools->LogWriteExt( bsMess );

			bSuccess = true;
		}
		catch (...)
		{
			g_bConnected = false;
			g_pTools->LogWrite( "  RetrieveRaw Error!" );
		}
	
		g_lpPStr = new char[bsRaw.length() * sizeof(char) + sizeof(char)];
		strcpy(g_lpPStr, (char*)bsRaw);
  
		*pRawMsg = g_lpPStr;
	}
	else
	{
		g_pTools->LogWrite( "  ERROR: Inbox Not loaded" );
	}

	return bSuccess;
}

bool Plugin::RetrieveTop(int MsgNum, int LineCount, LPCSTR* pDest)
{
  _bstr_t bsLog;
	char sTemp[20];

	bsLog  = "- RetrieveTop (";
	bsLog += itoa(MsgNum, sTemp, 10);
	bsLog += "): ";
	bsLog += itoa(LineCount, sTemp, 10);
	bsLog += " Lines";
	g_pTools->LogWrite( bsLog );

	bool bSuccess = false;

	if (g_pInbox!=NULL && g_pInbox->parsed)
	{
		IXMLDOMNodeListPtr NodeListPtr;
		IXMLDOMNodePtr spURL, spResp;
		HRESULT hr;
		_bstr_t bsRaw, bsURL;

		NodeListPtr = g_pInbox->getElementsByTagName("D:response");

		NodeListPtr->get_item(MsgNum-1, &spResp);

		spURL = spResp->selectSingleNode("D:href");

		bsURL = spURL->text;

		try
		{
			g_bConnected = true;

			g_pTools->LogWrite( "  Open XMLHTTP Object" );
			hr = g_pXMLHTTP->open(_bstr_t("GET"), bsURL, VARIANT_FALSE);
			if (FAILED(hr))	throw hr;

			g_pTools->LogWrite( "  Send -->" );
			hr = g_pXMLHTTP->send();
			if (FAILED(hr))	throw hr;

			bsRaw = g_pXMLHTTP->responseText;

			bSuccess = true;
		}
		catch (...)
		{
			g_bConnected = false;
			g_pTools->LogWrite( "  RetrieveRaw Error!" );
		}
	
//		int iLen = g_pTools->Find(bsRaw, L"\n", LineCount);
//		bsRaw = g_pTools->Mid(bsRaw, 0, iLen);
		g_lpPStr = new char[bsRaw.length() * sizeof(char) + sizeof(char)];
		strcpy(g_lpPStr, (char*)bsRaw);
  
		*pDest = g_lpPStr;
	}
	else
	{
		g_pTools->LogWrite( "  ERROR: Inbox Not loaded" );
	}

	return bSuccess;
}

bool Plugin::Delete(int MsgNum)
{
  _bstr_t bsLog;
	char sTemp[20];

	bsLog  = "- Delete (";
	bsLog += itoa(MsgNum, sTemp, 10);
	bsLog += ")";
	g_pTools->LogWrite( bsLog );

	bool bSuccess = false;

	if (g_pInbox!=NULL && g_pInbox->parsed)
	{
		IXMLDOMNodeListPtr NodeListPtr;
		IXMLDOMNodePtr spResp, spFrom;
		HRESULT hr;
		_bstr_t bsFrom, bsTo;

		NodeListPtr = g_pInbox->getElementsByTagName("D:response");

		NodeListPtr->get_item(MsgNum-1, &spResp);

		spFrom = spResp->selectSingleNode("D:href");
		bsFrom = spFrom->text;
		bsTo   = g_bsTrashURL;
		bsTo  += g_pTools->ItemName(bsFrom);

		try
		{
			g_bConnected = true;

			g_pTools->LogWrite( "  Open XMLHTTP Object" );
			hr = g_pXMLHTTP->open(_bstr_t("MOVE"), bsFrom, VARIANT_FALSE);
			if (FAILED(hr))	throw hr;

			g_pTools->LogWrite( "  Set XMLHTTP RequestHeader Destination to Trash" );
			hr = g_pXMLHTTP->setRequestHeader("Destination", bsTo);
			if (FAILED(hr))	throw hr;

			g_pTools->LogWrite( "  Send -->" );
			hr = g_pXMLHTTP->send();
			if (FAILED(hr))	throw hr;

			bSuccess = true;
		}
		catch (...)
		{
			g_bConnected = false;
			g_pTools->LogWrite( "  Delete Error!" );
		}
	}
	else
	{
		g_pTools->LogWrite( "  ERROR: Inbox Not loaded" );
	}
	
	return bSuccess;
}

void Plugin::Disconnect()
{
	g_pTools->LogWrite( "- Disconnect" );

	g_bConnected = false;

	g_bsInboxURL = "";
	g_bsTrashURL = "";

  g_pInbox.Release();
  g_pXMLHTTP.Release();
}

void Plugin::FreePChar(LPCSTR* pstrBuffer)
{
	if (*pstrBuffer)
	{
  	delete g_lpPStr;
		g_lpPStr = NULL;
	}
}

void Plugin::SetOnWork(__closure pCallBack)
{
}

LPCSTR Plugin::LastErrorMsg()
{
	if ( strlen(g_strErrorMsg) > 0 )
	{
		if (g_bConnected)
		{
			Disconnect();
		}

		TCHAR tcErr[150];
		sprintf(tcErr, "- LastErrorMsg: %s", g_strErrorMsg);
		g_pTools->LogWrite( tcErr );

		return g_strErrorMsg;
	}
	else
	{
		g_pTools->LogWrite( "- LastErrorMsg: No Errors" );

		return NULL;
	}
}

void Plugin::ShowOptions()
{
	// Thanks to Winspy
	TCHAR AppName[] = "SpamBull";
	TCHAR WinName[] = "TApplication";

	if (DialogBoxParam( g_hInst, MAKEINTRESOURCE(IDD_OPTIONS), FindWindow(WinName, AppName), (DLGPROC)DlgProc, 0) == IDOK )
	{
	}
}

int Plugin::InterfaceVersion()
{
	return 1;
}

void Plugin::Unload()
{
	g_pTools->LogWrite( "- Unload" );
}

/*
_bstr_t Plugin::SendXML()
{
	HRESULT hr;
	_bstr_t bsResp;
	long time = 0;
	long lState = 0;

	try
	{
		g_bConnected = true;

		g_pTools->LogWrite( "  SendXML -->" );
		hr = g_pXMLHTTP->send();
		if (FAILED(hr))	throw hr;

    while (time < g_iTimeout)
		{
	    hr = g_pXMLHTTP->get_readyState(&lState);
	  	if (FAILED(hr))	throw hr;

			if (lState != 4)
			{
				// Sleep(500); // Sleep for 0.5 Second
				time += 1;
			}
			else
			{
				break;
			}
		}

		if (lState != 4)
		{
			hr = g_pXMLHTTP->abort();
  		if (FAILED(hr))	throw hr;
		}
		
		bsResp = g_pXMLHTTP->responseText;
		_bstr_t bsMess;
		bsMess  = "  Message: ";
		bsMess += bsResp;
		g_pTools->LogWriteExt( bsMess );
	}
	catch (...)
	{
		g_bConnected = false;
		g_pTools->LogWrite( "  SendXML Error!" );
	}
	return bsResp;
}
*/
