#ifndef PLUGIN_H
#define PLUGIN_H

#include <windows.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include "tools.h"

// Microsoft XML Parser Definitions
#import "msxml3.dll"
using namespace MSXML2;

#ifndef __OS2 
 #define NULL_PTR ((void far *) 0)
 #define USER_FAR far
#else
 #define NULL_PTR ((void  *) 0)
 #define USER_FAR                   
#endif /* __OS2 */

#ifdef __cplusplus
extern "C"{
#endif

typedef unsigned char   Uchar;
typedef unsigned short  Ushort;
typedef unsigned long   Ulong;

typedef double TDateTime;

typedef struct
{
  unsigned char len;
  char          str[255]; // Max 255
} ShortString; 

typedef struct
{
  LPVOID ptr;
  int*   par;
} __closure;

enum {piNotify, piProtocol, piRuleAction} TPluginType;

static const char* Month[] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};

void __cdecl main (void);

LRESULT CALLBACK DlgProc(HWND hWndDlg, UINT Msg, WPARAM wParam, LPARAM lParam);

// Plugin Functions

int   pCheckMessages();

void  pConnect(LPCSTR Server, int Port, LPCSTR Protocol, LPCSTR UserName, LPCSTR Password, int Timeout);

bool  pConnected();

bool  fDelete(int MsgNum);

void  pDisconnect();

void  pFreePChar(LPCSTR* pstrBuffer);

void  pInit();

ShortString fPluginName();

int fPluginType();

ShortString fProtocols();

bool  fRetrieveHeader(int MsgNum, LPCSTR* pHeader);

int   fRetrieveMsgSize(int MsgNum);

bool  fRetrieveRaw(int MsgNum, LPCSTR* pRawMsg);

bool  fRetrieveTop(int MsgNum, int LineCount, LPCSTR* pDest);

void  pSetOnWork(__closure pCallBack);

LPCSTR fLastErrorMsg();

void  pShowOptions();

bool  fUIDL(LPCSTR* pUIDL, int MsgNum);

int   fInterfaceVersion();

void  pUnload();

void pMessageCheck(LPCSTR MsgFrom, LPCSTR MsgTo, LPCSTR MsgSubject, TDateTime MsgDate, bool Viewed, bool New, bool Important, bool Spam);

void pNotify(int MailCount, int UnviewedCount, int NewCount, bool ResetTray);

class Plugin
{
  public:
    Plugin();
    ~Plugin();

		ShortString PluginName();
		int         PluginType();
		ShortString Protocols();

		int			CheckMessages();
		void		Connect(LPCSTR Server, int Port, LPCSTR Protocol, LPCSTR UserName, LPCSTR Password, int Timeout);
		bool		Connected();
		bool		Delete(int MsgNum);
		void		Disconnect();
		void		FreePChar(LPCSTR* pstrBuffer);
		void		Init();
		bool		RetrieveHeader(int MsgNum, LPCSTR* pHeader);
		int			RetrieveMsgSize(int MsgNum);
		bool		RetrieveRaw(int MsgNum, LPCSTR* pRawMsg);
		bool		RetrieveTop(int MsgNum, int LineCount, LPCSTR* pDest);
		void		SetOnWork(__closure pCallBack);
		LPCSTR	LastErrorMsg();
		void		ShowOptions();
		bool		UIDL(LPCSTR* pUIDL, int MsgNum);
		int			InterfaceVersion();
		void		Unload();

//	private:
//		_bstr_t SendXML();
};

// Globals

HINSTANCE       g_hInst;
Plugin* g_pPlugin;

bool								g_bConnected;
IXMLDOMDocument2Ptr g_pInbox;
IXMLHTTPRequestPtr	g_pXMLHTTP;
_bstr_t							g_bsInboxURL;
_bstr_t							g_bsTrashURL;
Tools*							g_pTools;
ShortString					g_sstrName;
int									g_iPluginType;
ShortString					g_sstrProtocols;
char*								g_lpPStr;
char								g_strErrorMsg[100];
int									g_iTimeout;

#ifdef __cplusplus
}
#endif

#endif // PLUGIN_H
