Attribute VB_Name = "modExpImp"
Option Explicit
Type GUID
    l1 As Long
    l2 As Long
    l3 As Long
    l4 As Long
End Type
Declare Function CoCreateGuid Lib "OLE32.DLL" (lpGuid As GUID) As Long
Declare Function StringFromGUID2 Lib "OLE32.DLL" (lpGuid As GUID, ByVal lpString As String, ByVal cbBytes As Integer) As Integer

Public Const FILE_VERSION As Long = 1

Public Function Export(ByVal strFilePathName As String, ByVal Options As PropertyBag)

    Dim iFileNum As Long
    Dim strSignature As String * 3

    iFileNum = FreeFile
    Open strFilePathName For Binary As iFileNum
    
    ' Put File signature and data file version
    strSignature = "TBD"
    Put iFileNum, , strSignature
    Put iFileNum, , FILE_VERSION
    
    ' Put toolbar options
    PutStringToFile iFileNum, Options.ReadProperty("Name")                  ' Toolbar Name
    PutStringToFile iFileNum, Options.ReadProperty("AffiliateID")           ' AffiliateID
    PutStringToFile iFileNum, Options.ReadProperty("UpdateLink")            ' Update URL
    PutLongToFile iFileNum, Options.ReadProperty("UpdateInterval")          ' Update Interval
    
    PutStringToFile iFileNum, Options.ReadProperty("ProviderUsername")      ' Provider username
    PutStringToFile iFileNum, Options.ReadProperty("ProviderPassword")      ' Provider password
    PutStringToFile iFileNum, Options.ReadProperty("ProviderUnique")        ' Provider unique
        
    ' Put Logo Button Description
    PutStringToFile iFileNum, Options.ReadProperty("LogoLink")              ' Logo Link
    PutPictureToFile iFileNum, Options.ReadProperty("LogoPictFileName")     ' Normal picture
    PutPictureToFile iFileNum, Options.ReadProperty("LogoPictFileNameHot")  ' Hot picture
    
    
    ' Put search and combo properties
    PutLongToFile iFileNum, 100                                             ' Combobox Width
    PutStringToFile iFileNum, Options.ReadProperty("SearchURL")             ' Search URL
    PutStringToFile iFileNum, Options.ReadProperty("SearchCaption")         ' Search Caption
    
    ' Put additional features info
    PutBoolToFile iFileNum, Options.ReadProperty("PopupBlocker")            ' Popup blocker
    PutPictureToFile iFileNum, ""                                           ' Normal Icon
    PutPictureToFile iFileNum, ""                                           ' Hot Icon
    
    PutBoolToFile iFileNum, Options.ReadProperty("Cleaner")                 ' Cleaner
    PutPictureToFile iFileNum, ""                                           ' Normal Icon
    PutPictureToFile iFileNum, ""                                           ' Hot Icon
    
    PutBoolToFile iFileNum, Options.ReadProperty("Translate")               ' Translator
    PutStringToFile iFileNum, Options.ReadProperty("TranslateURL")          ' Translate URL
    PutPictureToFile iFileNum, ""                                           ' Normal Icon
    PutPictureToFile iFileNum, ""                                           ' Hot Icon

    Close iFileNum
End Function


Private Sub PutStringToFile(ByVal iFileNum As Long, ByVal strString As String)
    
    Dim iLen As Long
    Dim iChar As Integer
    Dim i As Long
    
    ' Put string length
    iLen = Len(strString)
    Put iFileNum, , iLen
    
    ' Put string
    For i = 1 To iLen
        iChar = Asc(Mid(strString, i))
        Put iFileNum, , iChar
    Next i
End Sub

Private Sub PutLongToFile(ByVal iFileNum As Long, ByVal iLong As Long)
    Put iFileNum, , iLong
End Sub

Private Sub PutBoolToFile(ByVal iFileNum As Long, ByVal bValue As Boolean)
    Dim iLong As Long
    If bValue Then iLong = 1 Else iLong = 0
    Put iFileNum, , iLong
End Sub

Private Sub PutPictureToFile(ByVal iFileNum As Long, ByVal iPictureFileName As String)

End Sub
