// SearchHook.cpp
// By VONeS.h

#include "stdafx.h"
#include "MyClassFactory.h"
#include "constants.h"

extern HMODULE g_hThisModule=NULL;
extern WORD g_nSrvRefCount=0;

BOOL WINAPI DllMain(HMODULE hModule, DWORD  dwReason, LPVOID lpReserved) {	
	
	switch (dwReason) {
	
		case DLL_PROCESS_ATTACH:			
			break;
		case DLL_THREAD_ATTACH:
			break;
		case DLL_THREAD_DETACH:
			break;
		case DLL_PROCESS_DETACH:
			break;
	}

    return TRUE;
}

STDAPI DllCanUnloadNow() {
  
	if(g_nSrvRefCount) {
		return S_FALSE;
	} else {
		return S_OK;
	}
}

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, void ** ppvObject) {
 	
	if (!ppvObject) {
		return E_INVALIDARG;
	}

	*ppvObject=NULL;

	IMyClassFactory *pObj=new IMyClassFactory;
	
	if (!pObj)
		return E_OUTOFMEMORY;

	if (FAILED(pObj->QueryInterface(riid, ppvObject))) {
		delete pObj;
		return CLASS_E_CLASSNOTAVAILABLE;
	}

	return S_OK;
}

STDAPI DllRegisterServer() {
	
	TCHAR fileName[_MAX_PATH];
	HKEY hClassKey, hServKey;
	
	// Get module file name
	const DWORD len = GetModuleFileName(g_hThisModule, fileName, _MAX_PATH);	

	// Register COM-Object
	if (ERROR_SUCCESS != RegCreateKeyEx(HKEY_CLASSES_ROOT, TEXT("CLSID\\") SERVER_GUID, 0, NULL, 0, KEY_WRITE, NULL,&hClassKey, NULL))
		return SELFREG_E_CLASS;

	if (ERROR_SUCCESS != RegSetValueEx(hClassKey, NULL, 0, REG_SZ, (BYTE*)SERVER_NAME, lstrlen(SERVER_NAME)+1))
		return SELFREG_E_CLASS;

	if (ERROR_SUCCESS != RegCreateKeyEx(hClassKey, TEXT("InProcServer32"), 0, NULL, 0, KEY_WRITE, NULL, &hServKey, NULL))
		return SELFREG_E_CLASS;

	if (ERROR_SUCCESS != RegSetValueEx(hServKey, NULL, 0, REG_SZ, (BYTE*)fileName, len))
		return SELFREG_E_CLASS;

	if (ERROR_SUCCESS != RegSetValueEx(hServKey, TEXT("ThreadingModel"), 0, REG_SZ, (BYTE*)TEXT("Apartment"), lstrlen(_T("Apartment"))+1))
		return SELFREG_E_CLASS;

	RegCloseKey(hServKey);
	RegCloseKey(hClassKey);

	// Register Internet Explorer URL Search Hook
	if (ERROR_SUCCESS != RegOpenKeyEx(HKEY_CURRENT_USER, _T("Software\\Microsoft\\Internet Explorer\\URLSearchHooks"), 0, KEY_WRITE, &hClassKey))
		return SELFREG_E_CLASS;
	
	if (ERROR_SUCCESS != RegSetValueEx(hClassKey, SERVER_GUID, 0, REG_SZ, (LPBYTE)"\0", 1)) 
		return SELFREG_E_CLASS;
	
	RegCloseKey(hClassKey);
	return S_OK;
}

STDAPI DllUnregisterServer() {
	
	HKEY hCurrKey = NULL;
	
	// Delete COM-Object from registry
	if (ERROR_SUCCESS == RegOpenKeyEx(HKEY_CLASSES_ROOT, _T("CLSID"), 0, KEY_WRITE, &hCurrKey)) {
		SHDeleteKey(hCurrKey, SERVER_GUID);
		RegCloseKey(hCurrKey);
	}

	// Delete Internet Explorer URL Search Hook
	if (ERROR_SUCCESS == RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\Microsoft\\Internet Explorer\\URLSearchHooks"), 0, KEY_WRITE, &hCurrKey)) {
		RegDeleteValue(hCurrKey, SERVER_GUID);
		RegCloseKey(hCurrKey);
	}

	return S_OK;
}