VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsIEToolbar"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private m_pSite As IUnknownVB
Private m_ContainerWnd As Long
Private m_bandWnd As Long
Private m_pOldQueryContextMenu As Long

Private Const IID_IWebBrowserApp = "{0002DF05-0000-0000-C000-000000000046}"
Private Const IID_IWebBrowser2 = "{D30C1661-CDAF-11D0-8A3E-00C04FC9E26E}"

Implements IDeskBand
Implements IInputObject
Implements IObjectWithSite

Private Sub Class_Initialize()
    ' Initialization
End Sub

Private Sub Class_Terminate()
    ' Termination
End Sub

Private Sub IDeskBand_CloseDW(ByVal dwReserved As Long)
    'The band form will not trigger it's unload or terminate event unless we shut it down here
    Unload frmMain
    
    'Class_Terminate event dose not fire so any clean up code in the terminate event will not be executed so call it manualy
    Class_Terminate
End Sub

Private Sub IDeskBand_ContextSensitiveHelp(ByVal fEnterMode As Boolean)
    Err.Raise E_NOTIMPL
End Sub

Private Sub IDeskBand_GetBandInfo(ByVal dwBandID As Long, ByVal dwViewMode As Long, ByVal pdbi As VBShellLib.LPDESKBANDINFO)
    
    Dim dbi As DESKBANDINFO
    
    If pdbi = 0 Then
        Exit Sub
    End If
    
    CopyMemory dbi, ByVal pdbi, Len(dbi)
    
    If (dbi.dwMask And DBIM_MINSIZE) Then
        dbi.ptMinSize.X = frmMain.mWidth
        dbi.ptMinSize.Y = frmMain.mHeight
    End If

    If (dbi.dwMask And DBIM_MAXSIZE) Then
        dbi.ptMaxSize.X = -1
        dbi.ptMaxSize.Y = frmMain.mHeight
    End If

    If (dbi.dwMask And DBIM_INTEGRAL) Then
        dbi.ptIntegral.X = 1&
        dbi.ptIntegral.Y = 1&
    End If

    If (dbi.dwMask And DBIM_ACTUAL) Then
        dbi.ptActual.X = frmMain.ScaleX(frmMain.Width, vbTwips, vbPixels)
        dbi.ptActual.Y = frmMain.ScaleY(frmMain.Height, vbTwips, vbPixels)
    End If

    If (dbi.dwMask And DBIM_TITLE) Then
        Dim title() As Byte
        title = vbNullChar
        CopyMemory dbi.wszTitle(0), title(0), UBound(title) + 1
    End If

    If (dbi.dwMask And DBIM_MODEFLAGS) Then
        dbi.dwModeFlags = DBIMF_VARIABLEHEIGHT And DBIMF_NORMAL
    End If

    If (dbi.dwMask And DBIM_BKCOLOR) Then
        'Use the default background color by removing
        'DBIM_BKCOLOR flag and setting crBkgnd
        dbi.dwMask = dbi.dwMask And Not DBIM_BKCOLOR
    End If
    
    CopyMemory ByVal pdbi, dbi, Len(dbi)

End Sub

Private Function IDeskBand_GetWindow() As Long
    IDeskBand_GetWindow = m_bandWnd
End Function

Private Sub IDeskBand_ResizeBorderDW(ByVal prcBorder As Long, ByVal punkToolbarSite As Long, ByVal fReserved As Boolean)
    Err.Raise E_NOTIMPL
End Sub

Private Sub IDeskBand_ShowDW(ByVal fShow As Boolean)
    If (fShow) Then
        ShowWindow m_bandWnd, SW_SHOW
    Else
        ShowWindow m_bandWnd, SW_HIDE
    End If
End Sub

Private Sub IInputObject_HasFocusIO()
    Err.Raise E_NOTIMPL
    
End Sub

Private Sub IInputObject_TranslateAcceleratorIO(ByVal lpMsg As lpMsg)

    'Dim MyMsg As msg
    
    'Dim iVirtKey As Integer
    
    'iVirtKey = MyMsg
        
    'CopyMemory MyMsg, lpMsg, Len(msg)
    
    'MsgBox "TranslateAcceleratorIO"
    Err.Raise E_NOTIMPL
End Sub

Private Sub IInputObject_UIActivateIO(ByVal fActivate As Boolean, ByVal lpMsg As lpMsg)
    If (fActivate) Then
        SetFocus m_bandWnd
        'SetFocus frmBand.cmbSearch.hwnd
    End If
End Sub

Private Sub IObjectWithSite_GetSite(ByVal priid As LPGUID, ppvSite As LPVOID)
    m_pSite.QueryInterface priid, ppvSite
End Sub

Private Sub IObjectWithSite_SetSite(ByVal pUnkSite As IUnknownVB)
    On Error GoTo error_handler
    
    Dim isp As IServiceProvider
    Dim oleWnd As IOleWindow
        
    Dim wba As GUID 'IWebBrowserApp
    Dim wb2 As GUID 'IWebBrowser2
        
    Dim dwStyle As Long
    
    If Not (pUnkSite Is Nothing) Then
    
        If Not (m_pSite Is Nothing) Then
            Set m_pSite = Nothing
        End If
        
        Set m_pSite = pUnkSite
        Set oleWnd = pUnkSite
        
        'QueryInterface for IServiceProvider
        Set isp = pUnkSite
        
        'Query service provider to get IWebBrowser2 (InternetExplorer)
        CLSIDFromString StrPtr(IID_IWebBrowserApp), wba
        CLSIDFromString StrPtr(IID_IWebBrowser2), wb2
        
        Load frmMain
        Set frmMain.InternetExplorer = isp.QueryService(VarPtr(wba), VarPtr(wb2))
        
        Set isp = Nothing
        
        If Not (oleWnd Is Nothing) Then
            
            m_ContainerWnd = oleWnd.GetWindow
            m_bandWnd = frmMain.hwnd
            
            dwStyle = GetWindowLong(m_bandWnd, GWL_STYLE)
            dwStyle = dwStyle Or WS_CLIPSIBLINGS 'Or WS_CHILD
            
            SetWindowLong m_bandWnd, GWL_STYLE, dwStyle
            SetParent m_bandWnd, m_ContainerWnd
              
        End If
        Set oleWnd = Nothing
    Else
        Set m_pSite = Nothing
    End If
   
   Exit Sub
   
error_handler:
    MsgBox Err.Description
End Sub

