Attribute VB_Name = "modIECleaner"
Option Explicit

Private Const CLSCTX_INPROC = &H1& Or &H2&
Private Const CC_STDCALL = 4
Private Const MAX_PATH = 260

Public Type UUID
    Data1 As Long
    Data2 As Integer
    Data3 As Integer
    Data4(0 To 7) As Byte
End Type

Public Type WIN32_FIND_DATA
        dwFileAttributes As Long
        ftCreationTime As FILETIME
        ftLastAccessTime As FILETIME
        ftLastWriteTime As FILETIME
        nFileSizeHigh As Long
        nFileSizeLow As Long
        dwReserved0 As Long
        dwReserved1 As Long
        cFileName As String * MAX_PATH
        cAlternate As String * 14
End Type

Private Declare Function CoCreateInstance Lib "OLE32" (ByRef rclsid As UUID, ByVal pUnkOuter As Long, ByVal dwClsContext As Long, ByRef riid As UUID, ByRef ppv As Long) As Long
Private Declare Function DispCallFunc Lib "OLEAUT32" (ByVal pvInstance As Long, ByVal oVft As Long, ByVal CallConv As Long, ByVal vtReturn As VbVarType, ByVal cActuals As Long, ByRef prgvt As Integer, ByRef prgpvarg As Long, ByRef pvargResult As Variant) As Long

Public Declare Function FindFirstFile Lib "kernel32" Alias "FindFirstFileA" (ByVal lpFileName As String, lpFindFileData As WIN32_FIND_DATA) As Long
Public Declare Function FindNextFile Lib "kernel32" Alias "FindNextFileA" (ByVal hFindFile As Long, lpFindFileData As WIN32_FIND_DATA) As Long
Public Declare Function FindClose Lib "kernel32" (ByVal hFindFile As Long) As Long
Private Declare Function DeleteFile Lib "kernel32" Alias "DeleteFileA" (ByVal lpFileName As String) As Long

'Vtbl
Public Enum eVtblFunctionOffsetCUrlHistory
    ' IUrlHistoryStg2 Interface
    vtblOffsetAddUrlAndNotify = 32  '6 Args
    vtblOffsetClearHistory = 36     '0 Arg
        ' IUrlHistoryStg Interface
        vtblOffsetAddUrl = 12           '3 Args
        vtblOffsetDeleteUrl = 16        '2 Args
        vtblOffsetQueryUrl = 20         '3 Args
        vtblOffsetBindToObject = 24     '3 Args
        vtblOffsetEnumUrls = 28         '1 Arg
            ' IUnknwon Interface
            vtblOffsetQueryInterface = 0    '2 Args
            vtblOffsetAddRef = 4            '0 Arg
            vtblOffsetRelease = 8           '0 Arg
End Enum

Private Function CLSID_CUrlHistory() As UUID
    'Object[Microsoft Url History Service]
    'HKCR\CLSID\{3C374A40-BAE4-11CF-BF7D-00AA006946EE}
    With CLSID_CUrlHistory
        .Data1 = &H3C374A40
        .Data2 = &HBAE4
        .Data3 = &H11CF
        .Data4(0) = &HBF
        .Data4(1) = &H7D
        .Data4(2) = &H0
        .Data4(3) = &HAA
        .Data4(4) = &H0
        .Data4(5) = &H69
        .Data4(6) = &H46
        .Data4(7) = &HEE
    End With
End Function

Private Function IID_IUrlHistoryStg() As UUID
    'Interface[IID_IUrlHistoryStg]
    'HKCR\Interface\{3C374A41-BAE4-11CF-BF7D-00AA006946EE}
    With IID_IUrlHistoryStg2
        .Data1 = &HAFA0DC11
        .Data2 = &HC313
        .Data3 = &H11D0
        .Data4(0) = &H83
        .Data4(1) = &H1A
        .Data4(2) = &H0
        .Data4(3) = &HC0
        .Data4(4) = &H4F
        .Data4(5) = &HD5
        .Data4(6) = &HAE
        .Data4(7) = &H38
    End With
End Function

Private Function IID_IUrlHistoryStg2() As UUID
    'Interface[IUrlHistoryStg2]
    'HKCR\Interface\{AFA0DC11-C313-11D0-831A-00C04FD5AE38}
    With IID_IUrlHistoryStg2
        .Data1 = &HAFA0DC11
        .Data2 = &HC313
        .Data3 = &H11D0
        .Data4(0) = &H83
        .Data4(1) = &H1A
        .Data4(2) = &H0
        .Data4(3) = &HC0
        .Data4(4) = &H4F
        .Data4(5) = &HD5
        .Data4(6) = &HAE
        .Data4(7) = &H38
    End With
End Function

Public Sub ClearHistory()
    Dim hr As Long
    Dim udtCUrlHistory As UUID
    Dim udtIUrlHistoryStg2 As UUID
    Dim lngPUrlHistoryStg2 As Long
    Dim lngPArgs() As Long
    Dim intVtArgs() As Integer
    Dim varResult As Variant

    DelRegistryKey HKEY_CURRENT_USER, "Software\Microsoft\Internet Explorer", "TypedUrls"

    ' Get GUID's
    udtCUrlHistory = CLSID_CUrlHistory
    udtIUrlHistoryStg2 = IID_IUrlHistoryStg2
    
    ' Create instance of history object
    hr = CoCreateInstance(udtCUrlHistory, 0&, CLSCTX_INPROC, udtIUrlHistoryStg2, lngPUrlHistoryStg2)
    If hr <> 0& Then
        Debug.Print Err.LastDllError
        Exit Sub    'Err.Raise hr
    End If
    
    
    ' ClearHistory
    ReDim lngPArgs(0)
    ReDim intVtArgs(0)
    hr = DispCallFunc(lngPUrlHistoryStg2, vtblOffsetClearHistory, CC_STDCALL, vbLong, 0, intVtArgs(0), lngPArgs(0), varResult)

    ' Release com object
    ReDim lngPArgs(0)
    ReDim intVtArgs(0)
    hr = DispCallFunc(lngPUrlHistoryStg2, vtblOffsetRelease, CC_STDCALL, vbLong, 0, intVtArgs(0), lngPArgs(0), varResult)
    
End Sub


Public Sub ClearCookies()

    On Error Resume Next

    Dim strCookiePath As String
    Dim fd As WIN32_FIND_DATA
    Dim hFind As Long
    Dim iPos As Long
    Dim strFileName As String
    
    ' Get directory with cookies
    strCookiePath = GetRegistryValue(HKEY_CURRENT_USER, "Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders", "Cookies")
    strCookiePath = strCookiePath & "\"
       
    ' Delete all files from that directory
    hFind = FindFirstFile(strCookiePath & "*", fd)
    
    If hFind = -1 Then  ' INVALID_HANDLE_VALUE
        Exit Sub
    End If
    
    ' Skip first file - this is ".", so do nothing
        
    ' Delete all files
    While FindNextFile(hFind, fd) <> 0
        iPos = InStr(1, fd.cFileName, Chr(0), vbTextCompare)
        strFileName = strCookiePath & Left(fd.cFileName, iPos - 1)
        DeleteFile strFileName
    Wend
    
    'Close search
    FindClose hFind
End Sub
