Attribute VB_Name = "modFileSystem"
Option Explicit

'============================================================
'
' This class manage the files system information
'
'============================================================

'---- API Constant Declarations
Private Const REG_SZ As Long = 1

Private Const HKEY_CLASSES_ROOT = &H80000000
Private Const ERROR_SUCCESS = 0
Private Const KEY_ALL_ACCESS = &H3F
Private Const REG_OPTION_NON_VOLATILE = 0

Private PromptOnErr As Boolean

'---- API Constant Declarations
Private Const MAX_PATH = 260

Private Const INVALID_HANDLE_VALUE = -1

Private Const FO_MOVE = &H1
Private Const FO_COPY = &H2
Private Const FO_DELETE = &H3
Private Const FO_RENAME = &H4

Private Const FOF_SILENT = &H4
Private Const FOF_RENAMEONCOLLISION = &H8
Private Const FOF_NOCONFIRMATION = &H10
Private Const FOF_SIMPLEPROGRESS = &H100
Private Const FOF_ALLOWUNDO = &H40

'---- API Structure Declarations
Private Type FILETIME
    dwLowDateTime As Long
    dwHighDateTime As Long
End Type

Private Type WIN32_FIND_DATA
    dwFileAttributes As Long
    ftCreationTime As FILETIME
    ftLastAccessTime As FILETIME
    ftLastWriteTime As FILETIME
    nFileSizeHigh As Long
    nFileSizeLow As Long
    dwReserved0 As Long
    dwReserved1 As Long
    cFileName As String * MAX_PATH
    cAlternate As String * 14
End Type

Private Type SHFILEOPSTRUCT
    hwnd As Long
    wFunc As Long
    pFrom As String
    pTo As String
    fFlags As Integer
    fAborted As Boolean
    hNameMaps As Long
    sProgress As String
End Type

'---- API Declarations
Private Declare Function SHFileOperation Lib "shell32.dll" Alias "SHFileOperationA" (lpFileOp As SHFILEOPSTRUCT) As Long
Private Declare Function FindFirstFileA Lib "kernel32" (ByVal lpFileName As String, lpFindFileData As WIN32_FIND_DATA) As Long
Private Declare Function FindNextFileA Lib "kernel32" (ByVal hFindFile As Long, lpFindFileData As WIN32_FIND_DATA) As Long
Private Declare Function FindClose Lib "kernel32" (ByVal hFindFile As Long) As Long
Private Declare Function GetLogicalDrives Lib "kernel32" () As Long
Private Declare Function GetShortPathNameA Lib "kernel32" (ByVal lpszLongPath As String, ByVal lpszShortPath As String, ByVal cchBuffer As Long) As Long
Private Declare Function GetTempFileNameA Lib "kernel32" (ByVal lpszPath As String, ByVal lpPrefixString As String, ByVal wUnique As Long, ByVal lpTempFileName As String) As Long
Private Declare Function GetTempPathA Lib "kernel32" (ByVal nBufferLength As Long, ByVal lpBuffer As String) As Long
Private Declare Function GetWindowsDirectoryA Lib "kernel32" (ByVal lpBuffer As String, ByVal nSize As Long) As Long
Private Declare Function GetSystemDirectoryA Lib "kernel32" (ByVal lpBuffer As String, ByVal nSize As Long) As Long
Private Declare Function RegCloseKey Lib "advapi32.dll" (ByVal hKey As Long) As Long
Private Declare Function RegCreateKeyEx Lib "advapi32.dll" Alias "RegCreateKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal Reserved As Long, ByVal lpClass As String, ByVal dwOptions As Long, ByVal samDesired As Long, ByVal lpSecurityAttributes As Long, phkResult As Long, lpdwDisposition As Long) As Long
Private Declare Function RegOpenKeyEx Lib "advapi32.dll" Alias "RegOpenKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal ulOptions As Long, ByVal samDesired As Long, phkResult As Long) As Long
Private Declare Function RegSetValueExString Lib "advapi32.dll" Alias "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, ByVal lpValue As String, ByVal cbData As Long) As Long


'============================================================
'                        System path
'============================================================

'------------------------------------------------------------
' Returns the Windows path.
Public Property Get WindowsPath() As String

    Dim sBuffer As String
    Dim lResult As Long
    
    ' Get the path
    sBuffer = Space$(MAX_PATH)
    lResult = GetWindowsDirectoryA(sBuffer, MAX_PATH)
    
    If lResult Then
        WindowsPath = left$(sBuffer, lResult - 1&)
    End If
    
End Function

'------------------------------------------------------------
' Returns the System path.
Private Function GetSystemPath() As String

    Dim sBuffer As String
    Dim lResult As Long
    
    sBuffer = Space$(MAX_PATH)
    lResult = GetSystemDirectoryA(sBuffer, MAX_PATH)
    
    If lResult Then
        GetSystemPath = left$(sBuffer, lResult - 1&)
    End If

End Function

'============================================================
'                        System files management
'============================================================

'------------------------------------------------------------
' Create a temporary file.
'
' sFileNamePrefix : A prefix for the new file ( Optional )
Public Function GetTempFilename(Optional sFileNamePrefix As String) As String
    
    Dim lResult As Long
    Dim sTemporaryFile As String
    Dim sTemporaryFolder As String

    '---- Get the temporary folder
    sTemporaryFolder = Space$(MAX_PATH)
    lResult = GetTempPathA(MAX_PATH, sTemporaryFolder)
    
    If lResult Then

        '-- Extract the folder
        sTemporaryFolder = left$(sTemporaryFolder, lResult - 1&)
    
        '-- No prefix
        If Len(sFileNamePrefix) = 0 Then
            sFileNamePrefix = "tmp"
        End If

        '-- Ask the file
        sTemporaryFile = Space$(MAX_PATH)
        lResult = GetTempFileNameA(sTemporaryFolder, sFileNamePrefix, 0&, sTemporaryFile)
        
        If lResult Then
            GetTempFilename = left$(sTemporaryFile, lResult - 1&)
        End If

    End If

End Function

'============================================================
'                   File extention association
'============================================================

'------------------------------------------------------------
' Create a temporary file.
'
' sFileNamePrefix : A prefix for the new file ( Optional )
Public Function AssociateFileExtension(ByVal sExtension As String, ByVal sFileType As String, ByVal sFileTypeName As String, ByVal sAction As String, ByVal sAppPath As String, Optional sSwitch As String = "", Optional sSetIcon As Boolean = False, Optional sDefaultIcon As String = "", Optional sPromptOnError As Boolean = False) As Boolean

On Error GoTo ErrorHandler:

    PromptOnErr = sPromptOnError

    '---- Check that 'sAppPath' exists.
    If Dir(sAppPath, vbNormal) = "" Then
    
        If sPromptOnError Then
            MsgBox "The application path '" & sAppPath & "' cannot be found.", vbCritical + vbOKOnly, "DLL/OCX Register"
        End If
        
        AssociateFileExtension = False
        
        Exit Function
        
    End If

    Dim ERROR_CHARS As String: ERROR_CHARS = "\/:*?<>|" & Chr(34)
    Dim i As Integer

    '---- Check extension has "." at front
    If Asc(sExtension) <> 46 Then sExtension = "." & sExtension

    '---- Check for invalid chars within extension
    For i = 1 To Len(sExtension)
        
        If InStr(1, ERROR_CHARS, Mid(sExtension, i, 1), vbTextCompare) Then
        
            If sPromptOnError Then
                MsgBox "The file extension '" & sExtension & "' contains an illegal char (\/:*?<>|" & Chr(34) & ").", vbCritical + vbOKOnly, "DLL/OCX Register"
            End If

            AssociateFileExtension = False
            
            Exit Function
            
        End If
        
    Next

    If sSwitch <> "" Then sSwitch = " " & Trim(sSwitch)
    
    sAction = sFileType & "\shell\" & sAction & "\command"

    Call CreateSubKey(HKEY_CLASSES_ROOT, sExtension)        ' Create .xxx key
    Call CreateSubKey(HKEY_CLASSES_ROOT, sAction)           ' Create action key

    If sSetIcon Then
        Call CreateSubKey(HKEY_CLASSES_ROOT, (sFileType & "\DefaultIcon"))                ' Create default icon key

        If sDefaultIcon = "" Then
        
            ' This line of code sets the application's own icon as the default file icon
            Call SetKeyDefault(HKEY_CLASSES_ROOT, sFileType & "\DefaultIcon", Trim(sAppPath & ",0"))


        Else
        
            Call SetKeyDefault(HKEY_CLASSES_ROOT, sFileType & "\DefaultIcon", Trim(sDefaultIcon))

        End If
    End If
    
    Call SetKeyDefault(HKEY_CLASSES_ROOT, sExtension, sFileType) ' Set .xxx key default

    Call SetKeyDefault(HKEY_CLASSES_ROOT, sFileType, sFileTypeName) ' Set file type default

    Call SetKeyDefault(HKEY_CLASSES_ROOT, sAction, sAppPath & sSwitch & " %1") ' Set Command line

    AssociateFileExtension = True
    
    Exit Function

ErrorHandler:

    If sPromptOnError Then
        MsgBox "An error occured while attempting to create the file extension '" & sExtension & "'.", vbCritical + vbOKOnly, "DLL/OCX Register"
    End If

    AssociateFileExtension = False

End Function


'============================================================
'                   Helper methods
'============================================================

Private Function CreateSubKey(RootKey As Long, NewKey As String) As Boolean
    
    ' This function creates a new sub key
    Dim hKey As Long, regReply As Long
    regReply = RegCreateKeyEx(RootKey, NewKey, _
         0&, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0&, hKey, 0&)

    If regReply <> ERROR_SUCCESS Then
        If PromptOnErr Then MsgBox "An error occured while attempting to to create a registery key.", vbCritical + vbOKOnly, "DLL/OCX Register"

        CreateSubKey = False
    Else
        CreateSubKey = True
    End If

    Call RegCloseKey(hKey)
    
End Function


Private Function SetKeyDefault(RootKey As Long, Address As String, Value As String) As Boolean
    
    ' This function sets the default vaule of the key which is always a string
    Dim regReply As Long, hKey As Long
    regReply = RegOpenKeyEx(RootKey, Address, 0, KEY_ALL_ACCESS, hKey)

    If regReply <> ERROR_SUCCESS Then
        If PromptOnErr Then MsgBox "An error occured while attempting to access the registery.", vbCritical + vbOKOnly, "DLL/OCX Register"
        SetKeyDefault = False
        Exit Function
    End If

    Value = Value & Chr(0)

    regReply = RegSetValueExString(hKey, "", 0&, REG_SZ, Value, Len(Value))

    If regReply <> ERROR_SUCCESS Then
        If PromptOnErr Then MsgBox "An error occured while attempting to set key default value.", vbCritical + vbOKOnly, "DLL/OCX Register"

        SetKeyDefault = False
    Else
        SetKeyDefault = True
    End If

    Call RegCloseKey(hKey)
    
End Function


'??????????????????????????????????????????????????????????????????????????????
'??????????????????????????????????????????????????????????????????????????????
'??????????????????????????????????????????????????????????????????????????????
'??????????????????????????????????????????????????????????????????????????????
'??????????????????????????????????????????????????????????????????????????????

'Public Sub PutToRecycleBin()

'Public Const FO_DELETE = &H3
'Public Const FOF_ALLOWUNDO = &H40


'Dim SHop As SHFILEOPSTRUCT
'Dim strFile As String 'the complete path to the deleted file

'With SHop
    '.wFunc = FO_DELETE
    '.pFrom = strFile
    '.fFlags = FOF_ALLOWUNDO
'End With

'SHFileOperation SHop

'End Sub

Public Function DriveExists(ByVal sDriveLetter As String) As Boolean
    '-------------------------------------------------------------
    '   Determines whether a drive exists.
    '-------------------------------------------------------------
    '   API Declarations:
    '-------------------------------------------------------------
    '   Private Declare Function GetLogicalDrives Lib "kernel32" _
    '       () As Long
    '-------------------------------------------------------------
    Dim dwDrives As Long
    Dim Mask As Long
    
    dwDrives = GetLogicalDrives()
    Mask = 2 ^ (Asc(UCase$(sDriveLetter)) - 65)
    
    DriveExists = ((dwDrives And Mask) = Mask)
End Function


Public Function FileList(ByVal sPath As String, _
    ByRef saFileList() As String, _
    Optional ByVal sFileSpec As String = "*") As Long
    '-------------------------------------------------------------
    '   Files saFileList() with a list of all files and folders
    '   in a given path. Returns the number of files.
    '-------------------------------------------------------------
    '   API Declarations:
    '-------------------------------------------------------------
    '   Private Const MAX_PATH = 260
    '   Private Const INVALID_HANDLE_VALUE = -1
    '
    '   Private Type FILETIME
    '        dwLowDateTime As Long
    '        dwHighDateTime As Long
    '    End Type
    
    '    Private Type WIN32_FIND_DATA
    '        dwFileAttributes As Long
    '        ftCreationTime As FILETIME
    '        ftLastAccessTime As FILETIME
    '        ftLastWriteTime As FILETIME
    '        nFileSizeHigh As Long
    '        nFileSizeLow As Long
    '        dwReserved0 As Long
    '        dwReserved1 As Long
    '        cFileName As String * MAX_PATH
    '        cAlternate As String * 14
    '    End Type
    '
    '    Private Declare Function FindNextFileA Lib "kernel32" _
    '        (ByVal hFindFile As Long, _
    '        lpFindFileData As WIN32_FIND_DATA) As Long
    '
    '   Private Declare Function FindFirstFileA Lib "kernel32" _
    '       (ByVal lpFileName As String, _
    '       lpFindFileData As WIN32_FIND_DATA) As Long
    '
    '   Private Declare Function FindClose Lib "kernel32" _
    '       (ByVal hFindFile As Long) As Long
    '-------------------------------------------------------------

    Dim iCnt As Long
    Dim iMax As Long
    Dim uFIND_DATA As WIN32_FIND_DATA
    Dim r As Long
    Dim hFind As Long
    Dim sName As String
    
    If right$(sPath, 1) <> "\" Then
        sPath = sPath & "\"
    End If
    
    sPath = sPath & sFileSpec
    
    iMax = 49
    ReDim saFileList(iMax)
    
    
    hFind = FindFirstFileA(sPath, uFIND_DATA)
    
    If Not hFind = INVALID_HANDLE_VALUE Then
        sName = uFIND_DATA.cFileName
        If InStr(sName, Chr$(0)) Then
            sName = left$(sName, InStr(sName, Chr$(0)) - 1&)
            If Not sName = "." Then
                If Not sName = ".." Then
                    saFileList(0) = sName
                    iCnt = 1&
                End If
            End If
        End If
    
        r = FindNextFileA(hFind, uFIND_DATA)
        
        Do Until r = 0&
            sName = uFIND_DATA.cFileName
            
            If InStr(sName, Chr$(0)) Then
                sName = left$(sName, InStr(sName, Chr$(0)) - 1&)
            End If
            
            If Not sName = "." Then
                If Not sName = ".." Then
                    iCnt = iCnt + 1&
                    
                    If iCnt >= iMax Then
                        iMax = iMax + 50
                        ReDim Preserve saFileList(iMax)
                    End If
                    
                    saFileList(iCnt - 1&) = sName
                End If
            End If
                
            r = FindNextFileA(hFind, uFIND_DATA)
        Loop
    
        r = FindClose(hFind)
    End If
    
    If iCnt = 0& Then
        Erase saFileList()
    Else
        ReDim Preserve saFileList(iCnt - 1&)
    End If
    
    FileList = iCnt
End Function


Public Function FileExists(ByVal sFile As String) As Boolean
    '-------------------------------------------------------------
    '   Determines whether a file or path exists.
    '-------------------------------------------------------------
    '   API Declarations:
    '-------------------------------------------------------------
    '   Private Const MAX_PATH = 260
    '   Private Const INVALID_HANDLE_VALUE = -1
    '
    '   Private Type FILETIME
    '        dwLowDateTime As Long
    '        dwHighDateTime As Long
    '    End Type
    
    '    Private Type WIN32_FIND_DATA
    '        dwFileAttributes As Long
    '        ftCreationTime As FILETIME
    '        ftLastAccessTime As FILETIME
    '        ftLastWriteTime As FILETIME
    '        nFileSizeHigh As Long
    '        nFileSizeLow As Long
    '        dwReserved0 As Long
    '        dwReserved1 As Long
    '        cFileName As String * MAX_PATH
    '        cAlternate As String * 14
    '    End Type
    '
    '   Private Declare Function FindFirstFileA Lib "kernel32" _
    '       (ByVal lpFileName As String, _
    '       lpFindFileData As WIN32_FIND_DATA) As Long
    '
    '   Private Declare Function FindClose Lib "kernel32" _
    '       (ByVal hFindFile As Long) As Long
    '-------------------------------------------------------------
    Dim r As Long
    Dim uFIND_DATA As WIN32_FIND_DATA
    
    r = FindFirstFileA(sFile, uFIND_DATA)
    If r = INVALID_HANDLE_VALUE Then
        FileExists = False
    Else
        FileExists = True
        Call FindClose(r)
    End If
    
End Function


Public Function CopyFiles( _
    FileNames As Variant, MoveTo As String, _
    Optional ShowConfirmation As Boolean = True, _
    Optional HideProgress As Boolean = False, _
    Optional RenameOnCollision As Boolean = False) As Boolean
    '-------------------------------------------------------------
    ' Copies the specifed files to a new location. The user can
    ' pass in either a single filename or an array of filenames.
    '-------------------------------------------------------------
    '   Depends on:
    '       CopyMoveFiles()
    '-------------------------------------------------------------
  
    CopyFiles = CopyMoveFiles(FO_COPY, FileNames, MoveTo, _
        ShowConfirmation, HideProgress, RenameOnCollision)
End Function


Public Function RenameFiles( _
    SrcFile As String, DestFile As String, _
    Optional ShowConfirmation As Boolean = True, _
    Optional RenameOnCollision As Boolean = False) As Boolean
    '-------------------------------------------------------------
    ' Renames the specifed file.
    '-------------------------------------------------------------
    '   Depends on:
    '       CopyMoveFiles()
    '-------------------------------------------------------------

    RenameFiles = CopyMoveFiles(FO_RENAME, SrcFile, DestFile, _
        ShowConfirmation, False, RenameOnCollision)
End Function


Public Function MoveFiles(FileNames As Variant, _
    MoveTo As String, _
    Optional ShowConfirmation As Boolean = True, _
    Optional HideProgress As Boolean = False, _
    Optional RenameOnCollision As Boolean = False) As Boolean
    '-------------------------------------------------------------
    ' Moves the specifed files to a new location. The user can
    ' pass in either a single filename or an array of filenames.
    '-------------------------------------------------------------
    '   Depends on:
    '       CopyMoveFiles()
    '-------------------------------------------------------------
  
    MoveFiles = CopyMoveFiles(FO_MOVE, FileNames, MoveTo, _
        ShowConfirmation, HideProgress, RenameOnCollision)
End Function


Private Function CopyMoveFiles( _
    Operation As Integer, _
    FileNames As Variant, _
    MoveTo As String, _
    ShowConfirmation As Boolean, _
    HideProgress As Boolean, _
    RenameOnCollision As Boolean) As Boolean
    '-------------------------------------------------------------
    ' Copies/moves/renames the specifed files. The user can
    ' pass in either a single filename or an array of filenames.
    '-------------------------------------------------------------
    '   API Declarations:
    '-------------------------------------------------------------
    '   Private Const FOF_ALLOWUNDO = &H40
    '   Private Const FOF_NOCONFIRMATION = &H10
    '   Private Const FOF_SILENT = &H4
    '
    '   Private Const FO_DELETE = &H3
    '
    '   Private Type SHFILEOPSTRUCT
    '       hwnd As Long
    '       wFunc As Long
    '       pFrom As String
    '       pTo As String
    '       fFlags As Integer
    '       fAborted As Boolean
    '       hNameMaps As Long
    '       sProgress As String
    '   End Type
    '
    '   Private Declare Function SHFileOperation Lib _
    '   "shell32.dll" Alias "SHFileOperationA" _
    '   (lpFileOp As SHFILEOPSTRUCT) As Long
    '-------------------------------------------------------------
    Dim r As Long
    Dim i As Integer
    Dim sOrig As String
    Dim SHFileOp As SHFILEOPSTRUCT

    If IsArray(FileNames) Then
        For i = LBound(FileNames) To UBound(FileNames)
            sOrig = sOrig & FileNames(i) & Chr$(0)
        Next i
    Else
        sOrig = FileNames & Chr$(0)
    End If
  
    With SHFileOp
        .wFunc = Operation
        .pFrom = sOrig
        .pTo = MoveTo
        If Not ShowConfirmation Then
            .fFlags = FOF_NOCONFIRMATION
        End If
        If HideProgress Then
            .fFlags = .fFlags Or FOF_SILENT
        End If
        If RenameOnCollision Then
            .fFlags = .fFlags Or FOF_RENAMEONCOLLISION
        End If
    End With
  
    r = SHFileOperation(SHFileOp)
  
    If r = 0 Then
        CopyMoveFiles = Not SHFileOp.fAborted
    Else
        CopyMoveFiles = False
    End If
End Function


Public Function DeleteFiles(FileNames As Variant, _
    Optional MoveToRecycle As Boolean = False, _
    Optional ShowConfirmation As Boolean = True, _
    Optional HideProgress As Boolean = False) As Long
    '-------------------------------------------------------------
    ' Deletes the specifed files. The user can
    ' pass in either a single filename or an array of filenames.
    '-------------------------------------------------------------
    '   API Declarations:
    '-------------------------------------------------------------
    '   Private Const FOF_ALLOWUNDO = &H40
    '   Private Const FOF_NOCONFIRMATION = &H10
    '   Private Const FOF_SILENT = &H4
    '
    '   Private Const FO_DELETE = &H3
    '
    '   Private Type SHFILEOPSTRUCT
    '       hwnd As Long
    '       wFunc As Long
    '       pFrom As String
    '       pTo As String
    '       fFlags As Integer
    '       fAborted As Boolean
    '       hNameMaps As Long
    '       sProgress As String
    '   End Type
    '
    '   Private Declare Function SHFileOperation Lib _
    '   "shell32.dll" Alias "SHFileOperationA" _
    '   (lpFileOp As SHFILEOPSTRUCT) As Long
    '-------------------------------------------------------------
    
    Dim sDest As String
    Dim i As Integer
    Dim SHFileOp As SHFILEOPSTRUCT
    Dim r As Long
  
    With SHFileOp
        If MoveToRecycle Then
            .fFlags = FOF_ALLOWUNDO
        End If
        If Not ShowConfirmation Then
            .fFlags = .fFlags Or FOF_NOCONFIRMATION
        End If
        If HideProgress Then
            .fFlags = .fFlags Or FOF_SILENT
        End If
    End With
  
    If IsArray(FileNames) Then
        For i = LBound(FileNames) To UBound(FileNames)
            sDest = sDest & FileNames(i) & Chr$(0)
        Next i
    Else
        sDest = FileNames & Chr$(0)
    End If
  
    With SHFileOp
        .wFunc = FO_DELETE
        .pFrom = sDest
    End With
  
    r = SHFileOperation(SHFileOp)
    If r <> 0 Then
        DeleteFiles = False
    Else
        DeleteFiles = Not SHFileOp.fAborted
    End If
End Function


