#pragma once
#include <vector>
#include <fstream>
using namespace std;

CString readString( CFile& file );
void writeString( CFile& file, CString str );


class CSite
{
	protected:
		CString mName;
		CString mURL;

		//registration is required for this site
		int mRegFlag;

		CString mUsername;
		CString mPassword;

		BOOL mAutoLogin;

		//


	public:
		//page control names
		CString mFormFirstName;
		CString mFormLastName;
		CString mFormFullName;
		CString mFormEmail;
		CString mFormWebsiteTitle;
		CString mFormWebsite;
		CString mFormTitle;
		CString mFormArticle;
		CString mFormCompany;
		CString mFormSubmitter;

		CString mFormLogin;
		CString mFormPassword;

		CString mFormSummary;
		CString mFormBio;
		CString mFormLoginSubmit;

		//name of the form for the submit
		CString mForm;
		
	public:
		CSite()
		{
			mRegFlag = 0;
			mAutoLogin = 0;
		}
		~CSite()
		{
		}

		void Save( CFile& file )
		{
			writeString( file, mName );
			writeString( file, mURL );

			file.Write( (const char*)&mRegFlag, sizeof( int ) );

			if (mRegFlag)
			{
				writeString( file, mUsername );
				writeString( file, mPassword );
			}
			file.Write( &mAutoLogin, 4 );

			writeString( file, mFormFirstName );
			writeString( file, mFormLastName );
			writeString( file, mFormFullName );
			writeString( file, mFormEmail );
			writeString( file, mFormWebsiteTitle );
			writeString( file, mFormWebsite );
			writeString( file, mFormTitle );
			writeString( file, mFormArticle );
			writeString( file, mFormCompany );
			writeString( file, mFormSubmitter );
			writeString( file, mFormLogin );
			writeString( file, mFormPassword );
			writeString( file, mFormSummary );
			writeString( file, mFormBio );
			writeString( file, mFormLoginSubmit );
			writeString( file, mForm );
		}

		void Load( CFile& file )
		{
			mName = readString( file );

			mURL = readString( file );

			file.Read( &mRegFlag, sizeof( int ) );
			if (mRegFlag)
			{
				mUsername = readString( file );
				mPassword = readString( file );
			}
			file.Read( &mAutoLogin, 4 );

			mFormFirstName = readString( file );
			mFormLastName = readString( file );
			mFormFullName = readString( file );
			mFormEmail = readString( file );
			mFormWebsiteTitle = readString( file );
			mFormWebsite = readString( file );
			mFormTitle = readString( file );
			mFormArticle = readString( file );
			mFormCompany = readString( file );
			mFormSubmitter = readString( file );
			mFormLogin = readString( file );
			mFormPassword = readString( file );
			mFormSummary = readString( file );
			mFormBio = readString( file );
			mFormLoginSubmit = readString( file );
			mForm = readString( file );
		}

		void Create( CString name, CString url, int regflag, CString username, CString password )
		{
			setName( name );
			setURL( url );
			setRegFlag( regflag );
			setUsername( username );
			setPassword( password );
		}

		void setName( CString name ){ mName = name; }
		void setURL( CString url ){ mURL = url; }
		void setRegFlag( int flag ){ mRegFlag = flag; }
		void setUsername( CString name ){ mUsername = name; }
		void setPassword( CString pw ){ mPassword = pw; }
		void setAutoLogin( BOOL autologin ){ mAutoLogin = autologin; }

		CString getName(){ return mName; }
		CString getURL(){ return mURL; }
		int getRegFlag(){ return mRegFlag; }
		CString getUsername(){ return mUsername; }
		CString getPassword(){ return mPassword; }
		BOOL getAutoLogin(){ return mAutoLogin; }


		virtual void Submit()
		{

		}

		virtual CString getRequest( std::string name, std::string email, std::string website,
										std::string title, std::string article )
		{
			CString request = _T("");

			return request;
		}

};

class CArticle
{
	public:
		CString mTitle;
		CString mText;
		CString mSummary;
		CString mKeywords;

	public:
		CArticle()
		{
		}
		~CArticle()
		{
		}

		void Save( CFile& file )
		{
			int len = mTitle.GetLength();
			file.Write( (const char*)&len, sizeof( int ) );
			file.Write( (const char*)mTitle.GetBuffer(0), len );

			len = mText.GetLength();
			file.Write( (const char*)&len, sizeof( int ) );
			file.Write( (const char*)mText.GetBuffer(0), len );

			len = mSummary.GetLength();
			file.Write( (const char*)&len, sizeof( int ) );
			file.Write( (const char*)mSummary.GetBuffer(0), len );

			len = mKeywords.GetLength();
			file.Write( (const char*)&len, sizeof( int ) );
			file.Write( (const char*)mKeywords.GetBuffer(0), len );
		}

		void Load( CFile& file )
		{
			int len = 0;
			file.Read( &len, sizeof( int ) );
			char* buffer = new char[len+1];
			file.Read( buffer, len );
			buffer[len] = 0;
			mTitle = buffer;
			delete [] buffer;

			len = 0;
			file.Read( &len, sizeof( int ) );
			buffer = new char[len+1];
			file.Read( buffer, len );
			buffer[len] = 0;
			mText = buffer;
			delete [] buffer;

			len = 0;
			file.Read( &len, sizeof( int ) );
			buffer = new char[len+1];
			file.Read( buffer, len );
			buffer[len] = 0;
			mSummary = buffer;
			delete [] buffer;

			len = 0;
			file.Read( &len, sizeof( int ) );
			buffer = new char[len+1];
			file.Read( buffer, len );
			buffer[len] = 0;
			mKeywords = buffer;
			delete [] buffer;
		}


		void setTitle( CString title )
		{
			mTitle = title;
		}
		void setText( CString text )
		{
			mText = text;
		}
		void setSummary( CString summary )
		{
			mSummary = summary;
		}

		void setKeywords( CString keywords ){ mKeywords = keywords; }


		CString getTitle(){ return mTitle; }
		CString getText(){ return mText; }
		CString getSummary(){ return mSummary; }
		CString getKeywords(){ return mKeywords; }

};


class CManualSite
{
	public:
		CString mTitle;
		CString mURL;

	public:
		void Save( CFile& file )
		{
			int len = mTitle.GetLength();
			file.Write( (const char*)&len, sizeof( int ) );
			file.Write( (const char*)mTitle.GetBuffer(0), len );

			len = mURL.GetLength();
			file.Write( (const char*)&len, sizeof( int ) );
			file.Write( (const char*)mURL.GetBuffer(0), len );
		}

		void Load( CFile& file )
		{
			int len = 0;
			file.Read( &len, sizeof( int ) );
			char* buffer = new char[len+1];
			file.Read( buffer, len );
			buffer[len] = 0;
			mTitle = buffer;
			delete [] buffer;

			len = 0;
			file.Read( &len, sizeof( int ) );
			buffer = new char[len+1];
			file.Read( buffer, len );
			buffer[len] = 0;
			mURL = buffer;
			delete [] buffer;
		}
};

class CArticleManager
{
	public:
		std::vector<CManualSite*> mManualSites;
		std::vector<CSite*> mAutoSites;
		std::vector<CArticle*> mArticles;
		std::vector<CSite*> mCheckedSites;

		std::vector<CString> mFirstNameElements;
		std::vector<CString> mLastNameElements;
		std::vector<CString> mFullNameElements;
		std::vector<CString> mEmailElements;
		std::vector<CString> mWebsiteElements;
		std::vector<CString> mWebsiteTitleElements;
		std::vector<CString> mTitleElements;
		std::vector<CString> mSummaryElements;
		std::vector<CString> mArticleElements;
		std::vector<CString> mCompanyElements;
		std::vector<CString> mBioElements;
		std::vector<CString> mUsernameElements;
		std::vector<CString> mPasswordElements;
		std::vector<CString> mCountryElements;
		std::vector<CString> mAddressElements;
		std::vector<CString> mAddress2Elements;
		std::vector<CString> mCityElements;
		std::vector<CString> mStateElements;
		std::vector<CString> mZipElements;
		std::vector<CString> mPhoneElements;
		std::vector<CString> mKeywordsElements;

	public:
		int mBrowsing;


		CString mFirstName;
		CString mLastName;
		CString mFullName;
		CString mCountry;
		CString mAddress;
		CString mAddress2;
		CString mCity;
		CString mState;
		CString mZipCode;
		CString mWebsite;
		CString mWebsiteTitle;
		CString mEmail;
		CString mCompany;
		CString mBio;

		CString mPhone;
		CString mUsername;
		CString mPassword;

public:
		CArticleManager(void);
		~CArticleManager(void);

		void Init();

		//get sites that require registration
		int getRegSites( std::vector<CSite*>& sites )
		{
			int count = 0;
			for (std::vector<CSite*>::iterator i = mAutoSites.begin();
					i < mAutoSites.end(); i++)
			{
				if ((*i)->getRegFlag())
				{
					sites.push_back( (*i) );
					count++;
				}
			}
			return count;
		}

		std::vector<CSite*> getAutoSites(){ return mAutoSites; }
		std::vector<CArticle*> getArticles(){ return mArticles; }

		void Save( CString filename );
		void Load( CString filename );

		void addAutoSite( CSite* site )
		{
			mAutoSites.push_back( site );
		}
		void addArticle( CArticle* art )
		{
			mArticles.push_back( art );
		}

		void Save()
		{
			Save( _T("artsub.dat") );
		}

		void Submit( CArticle* article, CSite* site );

		BOOL PostData2Script( CString url, CString sData);

		void LoadGenericElements();
		void SaveGenericElements();

		int isFirstName( CString id )
		{
			for (std::vector<CString>::iterator i = mFirstNameElements.begin();
					i < mFirstNameElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}
		int isLastName( CString id )
		{
			for (std::vector<CString>::iterator i = mLastNameElements.begin();
					i < mLastNameElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}

		int isFullName( CString id )
		{
			for (std::vector<CString>::iterator i = mFullNameElements.begin();
					i < mFullNameElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}

		int isEmail( CString id )
		{
			for (std::vector<CString>::iterator i = mEmailElements.begin();
					i < mEmailElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}

		int isWebsite( CString id )
		{
			for (std::vector<CString>::iterator i = mWebsiteElements.begin();
					i < mWebsiteElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}

		int isWebsiteTitle( CString id )
		{
			for (std::vector<CString>::iterator i = mWebsiteTitleElements.begin();
					i < mWebsiteTitleElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}

		int isTitle( CString id )
		{
			for (std::vector<CString>::iterator i = mTitleElements.begin();
					i < mTitleElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}

		int isSummary( CString id )
		{
			for (std::vector<CString>::iterator i = mSummaryElements.begin();
					i < mSummaryElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}

		int isArticle( CString id )
		{
			for (std::vector<CString>::iterator i = mArticleElements.begin();
					i < mArticleElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}

		int isCompany( CString id )
		{
			for (std::vector<CString>::iterator i = mCompanyElements.begin();
					i < mCompanyElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}
		int isBio( CString id )
		{
			for (std::vector<CString>::iterator i = mBioElements.begin();
					i < mBioElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}

		//login
		int isUsername( CString id )
		{
			for (std::vector<CString>::iterator i = mUsernameElements.begin();
					i < mUsernameElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}

		int isPassword( CString id )
		{
			for (std::vector<CString>::iterator i = mPasswordElements.begin();
					i < mPasswordElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}

		int isCountry( CString id )
		{
			for (std::vector<CString>::iterator i = mCountryElements.begin();
					i < mCountryElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}

		int isAddress( CString id )
		{
			for (std::vector<CString>::iterator i = mAddressElements.begin();
					i < mAddressElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}

		int isAddress2( CString id )
		{
			for (std::vector<CString>::iterator i = mAddress2Elements.begin();
					i < mAddress2Elements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}

		int isCity( CString id )
		{
			for (std::vector<CString>::iterator i = mCityElements.begin();
					i < mCityElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}

		int isState( CString id )
		{
			for (std::vector<CString>::iterator i = mStateElements.begin();
					i < mStateElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}

		int isZip( CString id )
		{
			for (std::vector<CString>::iterator i = mZipElements.begin();
					i < mZipElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}

		int isPhone( CString id )
		{
			for (std::vector<CString>::iterator i = mPhoneElements.begin();
					i < mPhoneElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}

		int isKeywords( CString id )
		{
			for (std::vector<CString>::iterator i = mKeywordsElements.begin();
					i < mKeywordsElements.end(); i++)
			{
				if (!(*i).CompareNoCase( id ))
				{
					return 1;
				}
			}
			return 0;
		}


		void DeleteSite( CSite* site )
		{
			for (std::vector<CSite*>::iterator i = this->mAutoSites.begin();
					i < mAutoSites.end(); i++)
			{
				if ((*i) == site)
				{
					mAutoSites.erase( i );
					Save();
					delete site;
					return;
				}
			}
		}	
		void DeleteArticle( CArticle* article )
		{
			for (std::vector<CArticle*>::iterator i = mArticles.begin();
					i < mArticles.end(); i++)
			{
				if ((*i) == article)
				{
					mArticles.erase( i );
					Save();
					delete article;
					return;
				}
			}
		}	

		CString mAppName;
		CString mHeaderURL;
		CString mHelpURL;
		CString mAbout1;
		CString mAbout2;
		CString mAbout3;
		CString mAboutURL;

		void LoadConfig()
		{
			ifstream file( "config.ini" );
	
			if (!file.is_open())
			{
				return;
			}
			while( !file.eof() )
			{
				char buffer[5000];
				file.getline( buffer, 5000 );

				std::string str1 = buffer;
				if (str1.length() > 0)
				{
					int i1 = (int)str1.find( "=" );
					std::string key = str1.substr( 0, i1 );
					std::string val = str1.substr( i1 + 1, str1.length() - (i1+1) );
					int done = 0;
					while( !done )
					{
						done = 1;
						if (val[0] == ' ')
						{
							done = 0;
							val = val.substr( 1, val.length() - 1 );
						}
						if (val[val.length()-1] == ' ')
						{
							val	= val.substr( 0, val.length() - 1 );
							done = 0;
						}
						if (key[0] == ' ')
						{
							done = 0;
							key = key.substr( 1, key.length() - 1 );
						}
						if (key[key.length()-1] == ' ')
						{
							key = key.substr( 0, key.length() - 1 );
							done = 0;
						}
					}
					if (key.compare( "appname" ) == 0)
					{
						mAppName = val.c_str();
					}
					else if (key.compare( "header" ) == 0)
					{
						mHeaderURL = val.c_str();
					}
					else if (key.compare( "help" ) == 0)
					{
						mHelpURL = val.c_str();
					}
					else if (key.compare( "aboutline1" ) == 0)
					{
						mAbout1 = val.c_str();
					}
					else if (key.compare( "aboutline2" ) == 0)
					{
						mAbout2 = val.c_str();
					}
					else if (key.compare( "aboutline3" ) == 0)
					{
						mAbout3 = val.c_str();
					}
					else if (key.compare( "abouturl" ) == 0)
					{
						mAboutURL = val.c_str();
					}
				}
			}
			file.close();
		}


};
