// ArticleSubmitter.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "ArticleSubmitter.h"
#include "ArticleSubmitterDlg.h"
#include <initguid.h>
#include "ArticleSubmitter_i.c"
#include ".\articlesubmitter.h"
#include "SplashDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CArticleSubmitterApp


class CArticleSubmitterModule :
	public CAtlMfcModule
{
public:
	DECLARE_LIBID(LIBID_ArticleSubmitterLib);
	DECLARE_REGISTRY_APPID_RESOURCEID(IDR_ARTICLESUBMITTER, "{F5175990-9DA0-4EA8-9401-5DE0C0B8F33B}");};

CArticleSubmitterModule _AtlModule;

BEGIN_MESSAGE_MAP(CArticleSubmitterApp, CWinApp)
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()


// CArticleSubmitterApp construction

CArticleSubmitterApp::CArticleSubmitterApp()
{
	mCurArticle = 0;
}


// The one and only CArticleSubmitterApp object

CArticleSubmitterApp theApp;


// CArticleSubmitterApp initialization

BOOL CArticleSubmitterApp::InitInstance()
{
	AfxOleInit();
	// InitCommonControls() is required on Windows XP if an application
	// manifest specifies use of ComCtl32.dll version 6 or later to enable
	// visual styles.  Otherwise, any window creation will fail.
	InitCommonControls();

	CWinApp::InitInstance();

	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	AfxEnableControlContainer();
	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);
	// Register class factories via CoRegisterClassObject().
	if (FAILED(_AtlModule.RegisterClassObjects(CLSCTX_LOCAL_SERVER, REGCLS_MULTIPLEUSE)))
		return FALSE;
	// App was launched with /Embedding or /Automation switch.
	// Run app as automation server.
	if (cmdInfo.m_bRunEmbedded || cmdInfo.m_bRunAutomated)
	{
		// Don't show the main window
		return TRUE;
	}
	// App was launched with /Unregserver or /Unregister switch.
	if (cmdInfo.m_nShellCommand == CCommandLineInfo::AppUnregister)
	{
		_AtlModule.UpdateRegistryAppId(FALSE);
		_AtlModule.UnregisterServer(TRUE);
		return FALSE;
	}
	// App was launched with /Register or /Regserver switch.
	if (cmdInfo.m_nShellCommand == CCommandLineInfo::AppRegister)
	{
		_AtlModule.UpdateRegistryAppId(TRUE);
		_AtlModule.RegisterServer(TRUE);
		return FALSE;
	}

	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	CSplashDlg splash;
	splash.DoModal();

	mManager.Init();
	mManager.LoadConfig();

	CArticleSubmitterDlg dlg;
	m_pMainWnd = &dlg;
	mDialog = &dlg;
	INT_PTR nResponse = dlg.DoModal();
	if (nResponse == IDOK)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with OK
	}
	else if (nResponse == IDCANCEL)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with Cancel
	}

	return FALSE;
}

BOOL CArticleSubmitterApp::ExitInstance(void)
{
	_AtlModule.RevokeClassObjects();
	return CWinApp::ExitInstance();
}


void CArticleSubmitterApp::StartAuto()
{
	mDialog->StartAuto();
}

void CArticleSubmitterApp::SetCurArticle( CArticle* article )
{
	mCurArticle = article;
	mDialog->SetCurArticle( article );
}
